import archspec.cpu

archs = archspec.cpu.TARGETS

levels = {}

name_mapping = {
  "x86_64": 1,
  "x86_64_v2": 2,
  "x86_64_v3": 3,
  "x86_64_v4": 4,

  "ppc64le": 8,
  "power8le": 8,
  "power9le": 9,
  "power10le": 10,
}

for arch_name, arch in archs.items():
    if arch.family.name not in ("x86_64", "ppc64le"):
        continue
    levels[(arch_name, arch.family.name)] = max(
        1,
        name_mapping.get(arch_name, 0),
        *(name_mapping.get(parent.name, 0) for parent in (arch.ancestors or ()))
    )

levels = {arch: level for arch, level in sorted(
    levels.items(), key=lambda kv: kv[1])}

print(f"# This file is auto-generated by recipe/gen.py with archspec={archspec.__version__}")
print("microarchitecture:")
for arch, _ in levels.keys():
    print(f"- {arch}")
print()
print("level:")
for level in levels.values():
    print(f"- {level}")
print()
print("family:")
for _, family in levels.keys():
    print(f"- {family}")
print("""
zip_keys:
  - - microarchitecture
    - level
    - family""")
