# -*- coding: utf-8 -*-
# -----------------------------------------------------------------------------
# Copyright (c) 2016, Anaconda, Inc. All rights reserved.
#
# Licensed under the terms of the BSD 3-Clause License.
# The full license is in the file LICENSE.txt, distributed with this software.
# -----------------------------------------------------------------------------
"""The Status type."""
from __future__ import absolute_import

from abc import ABCMeta, abstractmethod

from anaconda_project.internal.metaclass import with_metaclass


class Status(with_metaclass(ABCMeta)):
    """Class describing a failure or success status, with logs.

    Values of this class evaluate to True in a boolean context
    if the status is successful.

    Values of this class are immutable.

    """
    def __init__(self):
        """Construct an abstract Status."""

    @property
    @abstractmethod
    def status_description(self):
        """Get a one-line-ish description of the status."""
        pass  # pragma: no cover

    @property
    @abstractmethod
    def errors(self):
        """Get error logs relevant to the status.

        A rule of thumb for this field is that anything in here should also have been
        logged to a ``Frontend`` instance, so this field is kind of just a cache
        of error messages generated by a particular operation for the convenience
        of the caller.
        """
        pass  # pragma: no cover
