

set -ex



check-glibc 2>&1 | grep -q "Usage:" || true
export c_stdlib_version="99.99.99"
check-glibc /nonexistent/file || echo "Script handled non-existent file correctly"
if ls "${CONDA_PREFIX}"/lib/*.so.* 1> /dev/null 2>&1; then
  check-glibc "${CONDA_PREFIX}"/lib/*.so.*
else
  echo "No shared libraries found to check"
fi

export c_stdlib_version="0.0.1"
if ls "${CONDA_PREFIX}"/lib/*.so.* 1> /dev/null 2>&1; then
  if check-glibc ${CONDA_PREFIX}/lib/*.so.* &>/dev/null; then
    echo "Script should have failed with old glibc version"
    exit 1
  else
    echo "Script correctly failed with old glibc version"
  fi
else
  echo "No shared libraries found to check"
fi

exit 0
