from typing import Any, Union

from pandas_profiling.report.presentation.core.item_renderer import ItemRenderer
from pandas_profiling.report.presentation.core.renderable import Renderable


class Variable(ItemRenderer):
    def __init__(
        self,
        top: Renderable,
        bottom: Union[Renderable, None] = None,
        ignore: bool = False,
        **kwargs,
    ):
        super().__init__(
            "variable", {"top": top, "bottom": bottom, "ignore": ignore}, **kwargs
        )

    def __str__(self):
        top_text = str(self.content["top"]).replace("\n", "\n\t")
        bottom_text = str(self.content["bottom"]).replace("\n", "\n\t")

        text = "Variable\n"
        text += f"- top: {top_text}"
        text += f"- bottom: {bottom_text}"
        return text

    def __repr__(self):
        return "Variable"

    def render(self) -> Any:
        raise NotImplementedError()

    @classmethod
    def convert_to_class(cls, obj, flv):
        obj.__class__ = cls
        if "top" in obj.content and obj.content["top"] is not None:
            flv(obj.content["top"])
        if "bottom" in obj.content and obj.content["bottom"] is not None:
            flv(obj.content["bottom"])
