import base64
import sys


def get_app_icon():
    from PyQt5.QtGui import QIcon, QPixmap

    base64_data = b"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"
    pm = QPixmap()
    pm.loadFromData(base64.b64decode(base64_data))
    icon = QIcon()
    icon.addPixmap(pm)
    return icon


def get_app(app, title, widgets):
    from PyQt5.QtWidgets import QMainWindow, QVBoxLayout

    class Application(QMainWindow):
        def __init__(self, title, widgets):
            super().__init__()
            self.layout = QVBoxLayout(self)

            self.resize(1200, 900)
            self.setWindowTitle(title)
            self.setWindowIcon(get_app_icon())
            self.setCentralWidget(widgets)
            self.show()

    ex = Application(title, widgets)
    sys.exit(app.exec_())
