import base64

from PyQt5.QtGui import QImage, QPixmap
from PyQt5.QtWidgets import QLabel, QPushButton, QWidget

from pandas_profiling.report.presentation.core import Image


class QtImage(Image):
    def render(self):
        widget = QWidget()
        pic = QLabel(widget)
        if self.content["image_format"] == "svg":
            svg_bytes = bytearray(self.content["image"], encoding="utf-8")
            img = QImage.fromData(svg_bytes)
        else:
            # img_bytes = bytearray(self.content['image'], encoding='utf-8')
            img_bytes = bytearray(self.content["image"].split(",")[1], encoding="utf-8")
            # content = b'PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0idXRmLTgiIHN0YW5kYWxvbmU9Im5vIj8%2BDQo8IURPQ1RZUEUgc3ZnIFBVQkxJQyAiLS8vVzNDLy9EVEQgU1ZHIDEuMS8vRU4iDQogICJodHRwOi8vd3d3LnczLm9yZy9HcmFwaGljcy9TVkcvMS4xL0RURC9zdmcxMS5kdGQiPg0KPCEtLSBDcmVhdGVkIHdpdGggbWF0cGxvdGxpYiAoaHR0cHM6Ly9tYXRwbG90bGliLm9yZy8pIC0tPg0KPHN2ZyBoZWlnaHQ9IjI4OHB0IiB2ZXJzaW9uPSIxLjEiIHZpZXdCb3g9IjAgMCA0MzIgMjg4IiB3aWR0aD0iNDMycHQiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgeG1sbnM6eGxpbms9Imh0dHA6Ly93d3cudzMub3JnLzE5OTkveGxpbmsiPg0KIDxkZWZzPg0KICA8c3R5bGUgdHlwZT0idGV4dC9jc3MiPg0KKntzdHJva2UtbGluZWNhcDpidXR0O3N0cm9rZS1saW5lam9pbjpyb3VuZDt9DQogIDwvc3R5bGU%2BDQogPC9kZWZzPg0KIDxnIGlkPSJmaWd1cmVfMSI%2BDQogIDxnIGlkPSJwYXRjaF8xIj4NCiAgIDxwYXRoIGQ9Ik0gMCAyODggDQpMIDQzMiAyODggDQpMIDQzMiAwIA0KTCAwIDAgDQp6DQoiIHN0eWxlPSJmaWxsOiNmZmZmZmY7Ii8%2BDQogIDwvZz4NCiAgPGcgaWQ9ImF4ZXNfMSI%2BDQogICA8ZyBpZD0icGF0Y2hfMiI%2BDQogICAgPHBhdGggZD0iTSA1Mi4xMiAyNDguNzUzNjMgDQpMIDQyMS4yIDI0OC43NTM2MyANCkwgNDIxLjIgMTAuOCANCkwgNTIuMTIgMTAuOCANCnoNCiIgc3R5bGU9ImZpbGw6I2VhZWFmMjsiLz4NCiAgIDwvZz4NCiAgIDxnIGlkPSJtYXRwbG90bGliLmF4aXNfMSI%2BDQogICAgPGcgaWQ9Inh0aWNrXzEiPg0KICAgICA8ZyBpZD0ibGluZTJkXzEiPg0KICAgICAgPHBhdGggY2xpcC1wYXRoPSJ1cmwoI3BlMjQxZmViOGM2KSIgZD0iTSA2OC44OTYzNjQgMjQ4Ljc1MzYzIA0KTCA2OC44OTYzNjQgMTAuOCANCiIgc3R5bGU9ImZpbGw6bm9uZTtzdHJva2U6I2ZmZmZmZjtzdHJva2UtbGluZWNhcDpyb3VuZDsiLz4NCiAgICAgPC9nPg0KICAgICA8ZyBpZD0ibGluZTJkXzIiPg0KICAgICAgPGRlZnM%2BDQogICAgICAgPHBhdGggZD0iTSAwIDAgDQpMIDAgMy41IA0KIiBpZD0ibWRlNjQ1MGI1OTkiIHN0eWxlPSJzdHJva2U6IzI2MjYyNjsiLz4NCiAgICAgIDwvZGVmcz4NCiAgICAgIDxnPg0KICAgICAgIDx1c2Ugc3R5bGU9ImZpbGw6IzI2MjYyNjtzdHJva2U6IzI2MjYyNjsiIHg9IjY4Ljg5NjM2NCIgeGxpbms6aHJlZj0iI21kZTY0NTBiNTk5IiB5PSIyNDguNzUzNjMiLz4NCiAgICAgIDwvZz4NCiAgICAgPC9nPg0KICAgICA8ZyBpZD0idGV4dF8xIj4NCiAgICAgIDwhLS0gMCAtLT4NCiAgICAgIDxkZWZzPg0KICAgICAgIDxwYXRoIGQ9Ik0gNC4xNTYyNSAzNS4yOTY4NzUgDQpRIDQuMTU2MjUgNDggNi43NjU2MjUgNTUuNzM0Mzc1IA0KUSA5LjM3NSA2My40ODQzNzUgMTQuNTE1NjI1IDY3LjY3MTg3NSANClEgMTkuNjcxODc1IDcxLjg3NSAyNy40ODQzNzUgNzEuODc1IA0KUSAzMy4yNSA3MS44NzUgMzcuNTkzNzUgNjkuNTQ2ODc1IA0KUSA0MS45Mzc1IDY3LjIzNDM3NSA0NC43NjU2MjUgNjIuODU5Mzc1IA0KUSA0Ny42MDkzNzUgNTguNSA0OS4yMTg3NSA1Mi4yMTg3NSANClEgNTAuODI4MTI1IDQ1Ljk1MzEyNSA1MC44MjgxMjUgMzUuMjk2ODc1IA0KUSA1MC44MjgxMjUgMjIuNzAzMTI1IDQ4LjIzNDM3NSAxNC45Njg3NSANClEgNDUuNjU2MjUgNy4yMzQzNzUgNDAuNSAzIA0KUSAzNS4zNTkzNzUgLTEuMjE4NzUgMjcuNDg0Mzc1IC0xLjIxODc1IA0KUSAxNy4xNDA2MjUgLTEuMjE4NzUgMTEuMjM0Mzc1IDYuMjAzMTI1IA0KUSA0LjE1NjI1IDE1LjE0MDYyNSA0LjE1NjI1IDM1LjI5Njg3NSANCnoNCk0gMTMuMTg3NSAzNS4yOTY4NzUgDQpRIDEzLjE4NzUgMTcuNjcxODc1IDE3LjMxMjUgMTEuODI4MTI1IA0KUSAyMS40Mzc1IDYgMjcuNDg0Mzc1IDYgDQpRIDMzLjU0Njg3NSA2IDM3LjY3MTg3NSAxMS44NTkzNzUgDQpRIDQxLjc5Njg3NSAxNy43MTg3NSA0MS43OTY4NzUgMzUuMjk2ODc1IA0KUSA0MS43OTY4NzUgNTIuOTg0Mzc1IDM3LjY3MTg3NSA1OC43ODEyNSANClEgMzMuNTQ2ODc1IDY0LjU5Mzc1IDI3LjM5MDYyNSA2NC41OTM3NSANClEgMjEuMzQzNzUgNjQuNTkzNzUgMTcuNzE4NzUgNTkuNDY4NzUgDQpRIDEzLjE4NzUgNTIuOTM3NSAxMy4xODc1IDM1LjI5Njg3NSANCnoNCiIgaWQ9IkFyaWFsTVQtNDgiLz4NCiAgICAgIDwvZGVmcz4NCiAgICAgIDxnIHN0eWxlPSJmaWxsOiMyNjI2MjY7IiB0cmFuc2Zvcm09InRyYW5zbGF0ZSg2OC43NTgyNTcgMjY4LjI0NzE0NClyb3RhdGUoLTQ1KXNjYWxlKDAuMSAtMC4xKSI%2BDQogICAgICAgPHVzZSB4bGluazpocmVmPSIjQXJpYWxNVC00OCIvPg0KICAgICAgPC9nPg0KICAgICA8L2c%2BDQogICAgPC9nPg0KICAgIDxnIGlkPSJ4dGlja18yIj4NCiAgICAgPGcgaWQ9ImxpbmUyZF8zIj4NCiAgICAgIDxwYXRoIGNsaXAtcGF0aD0idXJsKCNwZTI0MWZlYjhjNikiIGQ9Ik0gMTM0LjY4NjAyNSAyNDguNzUzNjMgDQpMIDEzNC42ODYwMjUgMTAuOCANCiIgc3R5bGU9ImZpbGw6bm9uZTtzdHJva2U6I2ZmZmZmZjtzdHJva2UtbGluZWNhcDpyb3VuZDsiLz4NCiAgICAgPC9nPg0KICAgICA8ZyBpZD0ibGluZTJkXzQiPg0KICAgICAgPGc%2BDQogICAgICAgPHVzZSBzdHlsZT0iZmlsbDojMjYyNjI2O3N0cm9rZTojMjYyNjI2OyIgeD0iMTM0LjY4NjAyNSIgeGxpbms6aHJlZj0iI21kZTY0NTBiNTk5IiB5PSIyNDguNzUzNjMiLz4NCiAgICAgIDwvZz4NCiAgICAgPC9nPg0KICAgICA8ZyBpZD0idGV4dF8yIj4NCiAgICAgIDwhLS0gNTAgLS0%2BDQogICAgICA8ZGVmcz4NCiAgICAgICA8cGF0aCBkPSJNIDQuMTU2MjUgMTguNzUgDQpMIDEzLjM3NSAxOS41MzEyNSANClEgMTQuNDA2MjUgMTIuNzk2ODc1IDE4LjE0MDYyNSA5LjM5MDYyNSANClEgMjEuODc1IDYgMjcuMTU2MjUgNiANClEgMzMuNSA2IDM3Ljg5MDYyNSAxMC43ODEyNSANClEgNDIuMjgxMjUgMTUuNTc4MTI1IDQyLjI4MTI1IDIzLjQ4NDM3NSANClEgNDIuMjgxMjUgMzEgMzguMDYyNSAzNS4zNDM3NSANClEgMzMuODQzNzUgMzkuNzAzMTI1IDI3IDM5LjcwMzEyNSANClEgMjIuNzUgMzkuNzAzMTI1IDE5LjMyODEyNSAzNy43NjU2MjUgDQpRIDE1LjkyMTg3NSAzNS44NDM3NSAxMy45Njg3NSAzMi43NjU2MjUgDQpMIDUuNzE4NzUgMzMuODQzNzUgDQpMIDEyLjY0MDYyNSA3MC42MDkzNzUgDQpMIDQ4LjI1IDcwLjYwOTM3NSANCkwgNDguMjUgNjIuMjAzMTI1IA0KTCAxOS42NzE4NzUgNjIuMjAzMTI1IA0KTCAxNS44MjgxMjUgNDIuOTY4NzUgDQpRIDIyLjI2NTYyNSA0Ny40Njg3NSAyOS4zNDM3NSA0Ny40Njg3NSANClEgMzguNzE4NzUgNDcuNDY4NzUgNDUuMTU2MjUgNDAuOTY4NzUgDQpRIDUxLjYwOTM3NSAzNC40Njg3NSA1MS42MDkzNzUgMjQuMjY1NjI1IA0KUSA1MS42MDkzNzUgMTQuNTQ2ODc1IDQ1Ljk1MzEyNSA3LjQ2ODc1IA0KUSAzOS4wNjI1IC0xLjIxODc1IDI3LjE1NjI1IC0xLjIxODc1IA0KUSAxNy4zOTA2MjUgLTEuMjE4NzUgMTEuMjAzMTI1IDQuMjUgDQpRIDUuMDMxMjUgOS43MTg3NSA0LjE1NjI1IDE4Ljc1IA0Keg0KIiBpZD0iQXJpYWxNVC01MyIvPg0KICAgICAgPC9kZWZzPg0KICAgICAgPGcgc3R5bGU9ImZpbGw6IzI2MjYyNjsiIHRyYW5zZm9ybT0idHJhbnNsYXRlKDEzMi41ODE4MyAyNzIuMTc5MzIxKXJvdGF0ZSgtNDUpc2NhbGUoMC4xIC0wLjEpIj4NCiAgICAgICA8dXNlIHhsaW5rOmhyZWY9IiNBcmlhbE1ULTUzIi8%2BDQogICAgICAgPHVzZSB4PSI1NS42MTUyMzQiIHhsaW5rOmhyZWY9IiNBcmlhbE1ULTQ4Ii8%2BDQogICAgICA8L2c%2BDQogICAgIDwvZz4NCiAgICA8L2c%2BDQogICAgPGcgaWQ9Inh0aWNrXzMiPg0KICAgICA8ZyBpZD0ibGluZTJkXzUiPg0KICAgICAgPHBhdGggY2xpcC1wYXRoPSJ1cmwoI3BlMjQxZmViOGM2KSIgZD0iTSAyMDAuNDc1Njg2IDI0OC43NTM2MyANCkwgMjAwLjQ3NTY4NiAxMC44IA0KIiBzdHlsZT0iZmlsbDpub25lO3N0cm9rZTojZmZmZmZmO3N0cm9rZS1saW5lY2FwOnJvdW5kOyIvPg0KICAgICA8L2c%2BDQogICAgIDxnIGlkPSJsaW5lMmRfNiI%2BDQogICAgICA8Zz4NCiAgICAgICA8dXNlIHN0eWxlPSJmaWxsOiMyNjI2MjY7c3Ryb2tlOiMyNjI2MjY7IiB4PSIyMDAuNDc1Njg2IiB4bGluazpocmVmPSIjbWRlNjQ1MGI1OTkiIHk9IjI0OC43NTM2MyIvPg0KICAgICAgPC9nPg0KICAgICA8L2c%2BDQogICAgIDxnIGlkPSJ0ZXh0XzMiPg0KICAgICAgPCEtLSAxMDAgLS0%2BDQogICAgICA8ZGVmcz4NCiAgICAgICA8cGF0aCBkPSJNIDM3LjI1IDAgDQpMIDI4LjQ2ODc1IDAgDQpMIDI4LjQ2ODc1IDU2IA0KUSAyNS4yOTY4NzUgNTIuOTg0Mzc1IDIwLjE0MDYyNSA0OS45NTMxMjUgDQpRIDE0Ljk4NDM3NSA0Ni45MjE4NzUgMTAuODkwNjI1IDQ1LjQwNjI1IA0KTCAxMC44OTA2MjUgNTMuOTA2MjUgDQpRIDE4LjI2NTYyNSA1Ny4zNzUgMjMuNzgxMjUgNjIuMjk2ODc1IA0KUSAyOS4yOTY4NzUgNjcuMjM0Mzc1IDMxLjU5Mzc1IDcxLjg3NSANCkwgMzcuMjUgNzEuODc1IA0Keg0KIiBpZD0iQXJpYWxNVC00OSIvPg0KICAgICAgPC9kZWZzPg0KICAgICAgPGcgc3R5bGU9ImZpbGw6IzI2MjYyNjsiIHRyYW5zZm9ybT0idHJhbnNsYXRlKDE5Ni40MDU0MDMgMjc2LjExMTQ5Nylyb3RhdGUoLTQ1KXNjYWxlKDAuMSAtMC4xKSI%2BDQogICAgICAgPHVzZSB4bGluazpocmVmPSIjQXJpYWxNVC00OSIvPg0KICAgICAgIDx1c2UgeD0iNTUuNjE1MjM0IiB4bGluazpocmVmPSIjQXJpYWxNVC00OCIvPg0KICAgICAgIDx1c2UgeD0iMTExLjIzMDQ2OSIgeGxpbms6aHJlZj0iI0FyaWFsTVQtNDgiLz4NCiAgICAgIDwvZz4NCiAgICAgPC9nPg0KICAgIDwvZz4NCiAgICA8ZyBpZD0ieHRpY2tfNCI%2BDQogICAgIDxnIGlkPSJsaW5lMmRfNyI%2BDQogICAgICA8cGF0aCBjbGlwLXBhdGg9InVybCgjcGUyNDFmZWI4YzYpIiBkPSJNIDI2Ni4yNjUzNDggMjQ4Ljc1MzYzIA0KTCAyNjYuMjY1MzQ4IDEwLjggDQoiIHN0eWxlPSJmaWxsOm5vbmU7c3Ryb2tlOiNmZmZmZmY7c3Ryb2tlLWxpbmVjYXA6cm91bmQ7Ii8%2BDQogICAgIDwvZz4NCiAgICAgPGcgaWQ9ImxpbmUyZF84Ij4NCiAgICAgIDxnPg0KICAgICAgIDx1c2Ugc3R5bGU9ImZpbGw6IzI2MjYyNjtzdHJva2U6IzI2MjYyNjsiIHg9IjI2Ni4yNjUzNDgiIHhsaW5rOmhyZWY9IiNtZGU2NDUwYjU5OSIgeT0iMjQ4Ljc1MzYzIi8%2BDQogICAgICA8L2c%2BDQogICAgIDwvZz4NCiAgICAgPGcgaWQ9InRleHRfNCI%2BDQogICAgICA8IS0tIDE1MCAtLT4NCiAgICAgIDxnIHN0eWxlPSJmaWxsOiMyNjI2MjY7IiB0cmFuc2Zvcm09InRyYW5zbGF0ZSgyNjIuMTk1MDY0IDI3Ni4xMTE0OTcpcm90YXRlKC00NSlzY2FsZSgwLjEgLTAuMSkiPg0KICAgICAgIDx1c2UgeGxpbms6aHJlZj0iI0FyaWFsTVQtNDkiLz4NCiAgICAgICA8dXNlIHg9IjU1LjYxNTIzNCIgeGxpbms6aHJlZj0iI0FyaWFsTVQtNTMiLz4NCiAgICAgICA8dXNlIHg9IjExMS4yMzA0NjkiIHhsaW5rOmhyZWY9IiNBcmlhbE1ULTQ4Ii8%2BDQogICAgICA8L2c%2BDQogICAgIDwvZz4NCiAgICA8L2c%2BDQogICAgPGcgaWQ9Inh0aWNrXzUiPg0KICAgICA8ZyBpZD0ibGluZTJkXzkiPg0KICAgICAgPHBhdGggY2xpcC1wYXRoPSJ1cmwoI3BlMjQxZmViOGM2KSIgZD0iTSAzMzIuMDU1MDA5IDI0OC43NTM2MyANCkwgMzMyLjA1NTAwOSAxMC44IA0KIiBzdHlsZT0iZmlsbDpub25lO3N0cm9rZTojZmZmZmZmO3N0cm9rZS1saW5lY2FwOnJvdW5kOyIvPg0KICAgICA8L2c%2BDQogICAgIDxnIGlkPSJsaW5lMmRfMTAiPg0KICAgICAgPGc%2BDQogICAgICAgPHVzZSBzdHlsZT0iZmlsbDojMjYyNjI2O3N0cm9rZTojMjYyNjI2OyIgeD0iMzMyLjA1NTAwOSIgeGxpbms6aHJlZj0iI21kZTY0NTBiNTk5IiB5PSIyNDguNzUzNjMiLz4NCiAgICAgIDwvZz4NCiAgICAgPC9nPg0KICAgICA8ZyBpZD0idGV4dF81Ij4NCiAgICAgIDwhLS0gMjAwIC0tPg0KICAgICAgPGRlZnM%2BDQogICAgICAgPHBhdGggZD0iTSA1MC4zNDM3NSA4LjQ1MzEyNSANCkwgNTAuMzQzNzUgMCANCkwgMy4wMzEyNSAwIA0KUSAyLjkzNzUgMy4xNzE4NzUgNC4wNDY4NzUgNi4xMDkzNzUgDQpRIDUuODU5Mzc1IDEwLjkzNzUgOS44MjgxMjUgMTUuNjI1IA0KUSAxMy44MTI1IDIwLjMxMjUgMjEuMzQzNzUgMjYuNDY4NzUgDQpRIDMzLjAxNTYyNSAzNi4wMzEyNSAzNy4xMDkzNzUgNDEuNjI1IA0KUSA0MS4yMTg3NSA0Ny4yMTg3NSA0MS4yMTg3NSA1Mi4yMDMxMjUgDQpRIDQxLjIxODc1IDU3LjQyMTg3NSAzNy40Njg3NSA2MSANClEgMzMuNzM0Mzc1IDY0LjU5Mzc1IDI3LjczNDM3NSA2NC41OTM3NSANClEgMjEuMzkwNjI1IDY0LjU5Mzc1IDE3LjU3ODEyNSA2MC43ODEyNSANClEgMTMuNzY1NjI1IDU2Ljk4NDM3NSAxMy43MTg3NSA1MC4yNSANCkwgNC42ODc1IDUxLjE3MTg3NSANClEgNS42MDkzNzUgNjEuMjgxMjUgMTEuNjU2MjUgNjYuNTc4MTI1IA0KUSAxNy43MTg3NSA3MS44NzUgMjcuOTM3NSA3MS44NzUgDQpRIDM4LjIzNDM3NSA3MS44NzUgNDQuMjM0Mzc1IDY2LjE1NjI1IA0KUSA1MC4yNSA2MC40NTMxMjUgNTAuMjUgNTIgDQpRIDUwLjI1IDQ3LjcwMzEyNSA0OC40ODQzNzUgNDMuNTQ2ODc1IA0KUSA0Ni43MzQzNzUgMzkuNDA2MjUgNDIuNjU2MjUgMzQuODEyNSANClEgMzguNTc4MTI1IDMwLjIxODc1IDI5LjEwOTM3NSAyMi4yMTg3NSANClEgMjEuMTg3NSAxNS41NzgxMjUgMTguOTM3NSAxMy4yMDMxMjUgDQpRIDE2LjcwMzEyNSAxMC44NDM3NSAxNS4yMzQzNzUgOC40NTMxMjUgDQp6DQoiIGlkPSJBcmlhbE1ULTUwIi8%2BDQogICAgICA8L2RlZnM%2BDQogICAgICA8ZyBzdHlsZT0iZmlsbDojMjYyNjI2OyIgdHJhbnNmb3JtPSJ0cmFuc2xhdGUoMzI3Ljk4NDcyNiAyNzYuMTExNDk3KXJvdGF0ZSgtNDUpc2NhbGUoMC4xIC0wLjEpIj4NCiAgICAgICA8dXNlIHhsaW5rOmhyZWY9IiNBcmlhbE1ULTUwIi8%2BDQogICAgICAgPHVzZSB4PSI1NS42MTUyMzQiIHhsaW5rOmhyZWY9IiNBcmlhbE1ULTQ4Ii8%2BDQogICAgICAgPHVzZSB4PSIxMTEuMjMwNDY5IiB4bGluazpocmVmPSIjQXJpYWxNVC00OCIvPg0KICAgICAgPC9nPg0KICAgICA8L2c%2BDQogICAgPC9nPg0KICAgIDxnIGlkPSJ4dGlja182Ij4NCiAgICAgPGcgaWQ9ImxpbmUyZF8xMSI%2BDQogICAgICA8cGF0aCBjbGlwLXBhdGg9InVybCgjcGUyNDFmZWI4YzYpIiBkPSJNIDM5Ny44NDQ2NyAyNDguNzUzNjMgDQpMIDM5Ny44NDQ2NyAxMC44IA0KIiBzdHlsZT0iZmlsbDpub25lO3N0cm9rZTojZmZmZmZmO3N0cm9rZS1saW5lY2FwOnJvdW5kOyIvPg0KICAgICA8L2c%2BDQogICAgIDxnIGlkPSJsaW5lMmRfMTIiPg0KICAgICAgPGc%2BDQogICAgICAgPHVzZSBzdHlsZT0iZmlsbDojMjYyNjI2O3N0cm9rZTojMjYyNjI2OyIgeD0iMzk3Ljg0NDY3IiB4bGluazpocmVmPSIjbWRlNjQ1MGI1OTkiIHk9IjI0OC43NTM2MyIvPg0KICAgICAgPC9nPg0KICAgICA8L2c%2BDQogICAgIDxnIGlkPSJ0ZXh0XzYiPg0KICAgICAgPCEtLSAyNTAgLS0%2BDQogICAgICA8ZyBzdHlsZT0iZmlsbDojMjYyNjI2OyIgdHJhbnNmb3JtPSJ0cmFuc2xhdGUoMzkzLjc3NDM4NyAyNzYuMTExNDk3KXJvdGF0ZSgtNDUpc2NhbGUoMC4xIC0wLjEpIj4NCiAgICAgICA8dXNlIHhsaW5rOmhyZWY9IiNBcmlhbE1ULTUwIi8%2BDQogICAgICAgPHVzZSB4PSI1NS42MTUyMzQiIHhsaW5rOmhyZWY9IiNBcmlhbE1ULTUzIi8%2BDQogICAgICAgPHVzZSB4PSIxMTEuMjMwNDY5IiB4bGluazpocmVmPSIjQXJpYWxNVC00OCIvPg0KICAgICAgPC9nPg0KICAgICA8L2c%2BDQogICAgPC9nPg0KICAgPC9nPg0KICAgPGcgaWQ9Im1hdHBsb3RsaWIuYXhpc18yIj4NCiAgICA8ZyBpZD0ieXRpY2tfMSI%2BDQogICAgIDxnIGlkPSJsaW5lMmRfMTMiPg0KICAgICAgPHBhdGggY2xpcC1wYXRoPSJ1cmwoI3BlMjQxZmViOGM2KSIgZD0iTSA1Mi4xMiAyNDguNzUzNjMgDQpMIDQyMS4yIDI0OC43NTM2MyANCiIgc3R5bGU9ImZpbGw6bm9uZTtzdHJva2U6I2ZmZmZmZjtzdHJva2UtbGluZWNhcDpyb3VuZDsiLz4NCiAgICAgPC9nPg0KICAgICA8ZyBpZD0ibGluZTJkXzE0Ij4NCiAgICAgIDxkZWZzPg0KICAgICAgIDxwYXRoIGQ9Ik0gMCAwIA0KTCAtMy41IDAgDQoiIGlkPSJtMzZkOWVhNDdmYiIgc3R5bGU9InN0cm9rZTojMjYyNjI2OyIvPg0KICAgICAgPC9kZWZzPg0KICAgICAgPGc%2BDQogICAgICAgPHVzZSBzdHlsZT0iZmlsbDojMjYyNjI2O3N0cm9rZTojMjYyNjI2OyIgeD0iNTIuMTIiIHhsaW5rOmhyZWY9IiNtMzZkOWVhNDdmYiIgeT0iMjQ4Ljc1MzYzIi8%2BDQogICAgICA8L2c%2BDQogICAgIDwvZz4NCiAgICAgPGcgaWQ9InRleHRfNyI%2BDQogICAgICA8IS0tIDAgLS0%2BDQogICAgICA8ZyBzdHlsZT0iZmlsbDojMjYyNjI2OyIgdHJhbnNmb3JtPSJ0cmFuc2xhdGUoMzYuMDU5MDYzIDI1Mi4zMzI1MzYpc2NhbGUoMC4xIC0wLjEpIj4NCiAgICAgICA8dXNlIHhsaW5rOmhyZWY9IiNBcmlhbE1ULTQ4Ii8%2BDQogICAgICA8L2c%2BDQogICAgIDwvZz4NCiAgICA8L2c%2BDQogICAgPGcgaWQ9Inl0aWNrXzIiPg0KICAgICA8ZyBpZD0ibGluZTJkXzE1Ij4NCiAgICAgIDxwYXRoIGNsaXAtcGF0aD0idXJsKCNwZTI0MWZlYjhjNikiIGQ9Ik0gNTIuMTIgMjEzLjA2NTA0NiANCkwgNDIxLjIgMjEzLjA2NTA0NiANCiIgc3R5bGU9ImZpbGw6bm9uZTtzdHJva2U6I2ZmZmZmZjtzdHJva2UtbGluZWNhcDpyb3VuZDsiLz4NCiAgICAgPC9nPg0KICAgICA8ZyBpZD0ibGluZTJkXzE2Ij4NCiAgICAgIDxnPg0KICAgICAgIDx1c2Ugc3R5bGU9ImZpbGw6IzI2MjYyNjtzdHJva2U6IzI2MjYyNjsiIHg9IjUyLjEyIiB4bGluazpocmVmPSIjbTM2ZDllYTQ3ZmIiIHk9IjIxMy4wNjUwNDYiLz4NCiAgICAgIDwvZz4NCiAgICAgPC9nPg0KICAgICA8ZyBpZD0idGV4dF84Ij4NCiAgICAgIDwhLS0gMjAgLS0%2BDQogICAgICA8ZyBzdHlsZT0iZmlsbDojMjYyNjI2OyIgdHJhbnNmb3JtPSJ0cmFuc2xhdGUoMzAuNDk4MTI1IDIxNi42NDM5NTMpc2NhbGUoMC4xIC0wLjEpIj4NCiAgICAgICA8dXNlIHhsaW5rOmhyZWY9IiNBcmlhbE1ULTUwIi8%2BDQogICAgICAgPHVzZSB4PSI1NS42MTUyMzQiIHhsaW5rOmhyZWY9IiNBcmlhbE1ULTQ4Ii8%2BDQogICAgICA8L2c%2BDQogICAgIDwvZz4NCiAgICA8L2c%2BDQogICAgPGcgaWQ9Inl0aWNrXzMiPg0KICAgICA8ZyBpZD0ibGluZTJkXzE3Ij4NCiAgICAgIDxwYXRoIGNsaXAtcGF0aD0idXJsKCNwZTI0MWZlYjhjNikiIGQ9Ik0gNTIuMTIgMTc3LjM3NjQ2MyANCkwgNDIxLjIgMTc3LjM3NjQ2MyANCiIgc3R5bGU9ImZpbGw6bm9uZTtzdHJva2U6I2ZmZmZmZjtzdHJva2UtbGluZWNhcDpyb3VuZDsiLz4NCiAgICAgPC9nPg0KICAgICA8ZyBpZD0ibGluZTJkXzE4Ij4NCiAgICAgIDxnPg0KICAgICAgIDx1c2Ugc3R5bGU9ImZpbGw6IzI2MjYyNjtzdHJva2U6IzI2MjYyNjsiIHg9IjUyLjEyIiB4bGluazpocmVmPSIjbTM2ZDllYTQ3ZmIiIHk9IjE3Ny4zNzY0NjMiLz4NCiAgICAgIDwvZz4NCiAgICAgPC9nPg0KICAgICA8ZyBpZD0idGV4dF85Ij4NCiAgICAgIDwhLS0gNDAgLS0%2BDQogICAgICA8ZGVmcz4NCiAgICAgICA8cGF0aCBkPSJNIDMyLjMyODEyNSAwIA0KTCAzMi4zMjgxMjUgMTcuMTQwNjI1IA0KTCAxLjI2NTYyNSAxNy4xNDA2MjUgDQpMIDEuMjY1NjI1IDI1LjIwMzEyNSANCkwgMzMuOTM3NSA3MS41NzgxMjUgDQpMIDQxLjEwOTM3NSA3MS41NzgxMjUgDQpMIDQxLjEwOTM3NSAyNS4yMDMxMjUgDQpMIDUwLjc4MTI1IDI1LjIwMzEyNSANCkwgNTAuNzgxMjUgMTcuMTQwNjI1IA0KTCA0MS4xMDkzNzUgMTcuMTQwNjI1IA0KTCA0MS4xMDkzNzUgMCANCnoNCk0gMzIuMzI4MTI1IDI1LjIwMzEyNSANCkwgMzIuMzI4MTI1IDU3LjQ2ODc1IA0KTCA5LjkwNjI1IDI1LjIwMzEyNSANCnoNCiIgaWQ9IkFyaWFsTVQtNTIiLz4NCiAgICAgIDwvZGVmcz4NCiAgICAgIDxnIHN0eWxlPSJmaWxsOiMyNjI2MjY7IiB0cmFuc2Zvcm09InRyYW5zbGF0ZSgzMC40OTgxMjUgMTgwLjk1NTM2OSlzY2FsZSgwLjEgLTAuMSkiPg0KICAgICAgIDx1c2UgeGxpbms6aHJlZj0iI0FyaWFsTVQtNTIiLz4NCiAgICAgICA8dXNlIHg9IjU1LjYxNTIzNCIgeGxpbms6aHJlZj0iI0FyaWFsTVQtNDgiLz4NCiAgICAgIDwvZz4NCiAgICAgPC9nPg0KICAgIDwvZz4NCiAgICA8ZyBpZD0ieXRpY2tfNCI%2BDQogICAgIDxnIGlkPSJsaW5lMmRfMTkiPg0KICAgICAgPHBhdGggY2xpcC1wYXRoPSJ1cmwoI3BlMjQxZmViOGM2KSIgZD0iTSA1Mi4xMiAxNDEuNjg3ODggDQpMIDQyMS4yIDE0MS42ODc4OCANCiIgc3R5bGU9ImZpbGw6bm9uZTtzdHJva2U6I2ZmZmZmZjtzdHJva2UtbGluZWNhcDpyb3VuZDsiLz4NCiAgICAgPC9nPg0KICAgICA8ZyBpZD0ibGluZTJkXzIwIj4NCiAgICAgIDxnPg0KICAgICAgIDx1c2Ugc3R5bGU9ImZpbGw6IzI2MjYyNjtzdHJva2U6IzI2MjYyNjsiIHg9IjUyLjEyIiB4bGluazpocmVmPSIjbTM2ZDllYTQ3ZmIiIHk9IjE0MS42ODc4OCIvPg0KICAgICAgPC9nPg0KICAgICA8L2c%2BDQogICAgIDxnIGlkPSJ0ZXh0XzEwIj4NCiAgICAgIDwhLS0gNjAgLS0%2BDQogICAgICA8ZGVmcz4NCiAgICAgICA8cGF0aCBkPSJNIDQ5Ljc1IDU0LjA0Njg3NSANCkwgNDEuMDE1NjI1IDUzLjM3NSANClEgMzkuODQzNzUgNTguNTQ2ODc1IDM3LjcwMzEyNSA2MC44OTA2MjUgDQpRIDM0LjEyNSA2NC42NTYyNSAyOC45MDYyNSA2NC42NTYyNSANClEgMjQuNzAzMTI1IDY0LjY1NjI1IDIxLjUzMTI1IDYyLjMxMjUgDQpRIDE3LjM5MDYyNSA1OS4yODEyNSAxNC45ODQzNzUgNTMuNDY4NzUgDQpRIDEyLjU5Mzc1IDQ3LjY1NjI1IDEyLjUgMzYuOTIxODc1IA0KUSAxNS42NzE4NzUgNDEuNzUgMjAuMjY1NjI1IDQ0LjA5Mzc1IA0KUSAyNC44NTkzNzUgNDYuNDM3NSAyOS44OTA2MjUgNDYuNDM3NSANClEgMzguNjcxODc1IDQ2LjQzNzUgNDQuODQzNzUgMzkuOTY4NzUgDQpRIDUxLjAzMTI1IDMzLjUgNTEuMDMxMjUgMjMuMjUgDQpRIDUxLjAzMTI1IDE2LjUgNDguMTI1IDEwLjcxODc1IA0KUSA0NS4yMTg3NSA0LjkzNzUgNDAuMTQwNjI1IDEuODU5Mzc1IA0KUSAzNS4wNjI1IC0xLjIxODc1IDI4LjYwOTM3NSAtMS4yMTg3NSANClEgMTcuNjI1IC0xLjIxODc1IDEwLjY4NzUgNi44NTkzNzUgDQpRIDMuNzY1NjI1IDE0LjkzNzUgMy43NjU2MjUgMzMuNSANClEgMy43NjU2MjUgNTQuMjUgMTEuNDIxODc1IDYzLjY3MTg3NSANClEgMTguMTA5Mzc1IDcxLjg3NSAyOS40Mzc1IDcxLjg3NSANClEgMzcuODkwNjI1IDcxLjg3NSA0My4yODEyNSA2Ny4xNDA2MjUgDQpRIDQ4LjY4NzUgNjIuNDA2MjUgNDkuNzUgNTQuMDQ2ODc1IA0Keg0KTSAxMy44NzUgMjMuMTg3NSANClEgMTMuODc1IDE4LjY1NjI1IDE1Ljc5Njg3NSAxNC41IA0KUSAxNy43MTg3NSAxMC4zNTkzNzUgMjEuMTg3NSA4LjE3MTg3NSANClEgMjQuNjU2MjUgNiAyOC40Njg3NSA2IA0KUSAzNC4wMzEyNSA2IDM4LjAzMTI1IDEwLjQ4NDM3NSANClEgNDIuMDQ2ODc1IDE0Ljk4NDM3NSA0Mi4wNDY4NzUgMjIuNzAzMTI1IA0KUSA0Mi4wNDY4NzUgMzAuMTI1IDM4LjA3ODEyNSAzNC4zOTA2MjUgDQpRIDM0LjEyNSAzOC42NzE4NzUgMjguMTI1IDM4LjY3MTg3NSANClEgMjIuMTcxODc1IDM4LjY3MTg3NSAxOC4wMTU2MjUgMzQuMzkwNjI1IA0KUSAxMy44NzUgMzAuMTI1IDEzLjg3NSAyMy4xODc1IA0Keg0KIiBpZD0iQXJpYWxNVC01NCIvPg0KICAgICAgPC9kZWZzPg0KICAgICAgPGcgc3R5bGU9ImZpbGw6IzI2MjYyNjsiIHRyYW5zZm9ybT0idHJhbnNsYXRlKDMwLjQ5ODEyNSAxNDUuMjY2Nzg2KXNjYWxlKDAuMSAtMC4xKSI%2BDQogICAgICAgPHVzZSB4bGluazpocmVmPSIjQXJpYWxNVC01NCIvPg0KICAgICAgIDx1c2UgeD0iNTUuNjE1MjM0IiB4bGluazpocmVmPSIjQXJpYWxNVC00OCIvPg0KICAgICAgPC9nPg0KICAgICA8L2c%2BDQogICAgPC9nPg0KICAgIDxnIGlkPSJ5dGlja181Ij4NCiAgICAgPGcgaWQ9ImxpbmUyZF8yMSI%2BDQogICAgICA8cGF0aCBjbGlwLXBhdGg9InVybCgjcGUyNDFmZWI4YzYpIiBkPSJNIDUyLjEyIDEwNS45OTkyOTYgDQpMIDQyMS4yIDEwNS45OTkyOTYgDQoiIHN0eWxlPSJmaWxsOm5vbmU7c3Ryb2tlOiNmZmZmZmY7c3Ryb2tlLWxpbmVjYXA6cm91bmQ7Ii8%2BDQogICAgIDwvZz4NCiAgICAgPGcgaWQ9ImxpbmUyZF8yMiI%2BDQogICAgICA8Zz4NCiAgICAgICA8dXNlIHN0eWxlPSJmaWxsOiMyNjI2MjY7c3Ryb2tlOiMyNjI2MjY7IiB4PSI1Mi4xMiIgeGxpbms6aHJlZj0iI20zNmQ5ZWE0N2ZiIiB5PSIxMDUuOTk5Mjk2Ii8%2BDQogICAgICA8L2c%2BDQogICAgIDwvZz4NCiAgICAgPGcgaWQ9InRleHRfMTEiPg0KICAgICAgPCEtLSA4MCAtLT4NCiAgICAgIDxkZWZzPg0KICAgICAgIDxwYXRoIGQ9Ik0gMTcuNjcxODc1IDM4LjgxMjUgDQpRIDEyLjIwMzEyNSA0MC44MjgxMjUgOS41NjI1IDQ0LjUzMTI1IA0KUSA2LjkzNzUgNDguMjUgNi45Mzc1IDUzLjQyMTg3NSANClEgNi45Mzc1IDYxLjIzNDM3NSAxMi41NDY4NzUgNjYuNTQ2ODc1IA0KUSAxOC4xNzE4NzUgNzEuODc1IDI3LjQ4NDM3NSA3MS44NzUgDQpRIDM2Ljg1OTM3NSA3MS44NzUgNDIuNTc4MTI1IDY2LjQyMTg3NSANClEgNDguMjk2ODc1IDYwLjk4NDM3NSA0OC4yOTY4NzUgNTMuMTcxODc1IA0KUSA0OC4yOTY4NzUgNDguMTg3NSA0NS42NzE4NzUgNDQuNSANClEgNDMuMDYyNSA0MC44MjgxMjUgMzcuNzUgMzguODEyNSANClEgNDQuMzQzNzUgMzYuNjcxODc1IDQ3Ljc4MTI1IDMxLjg3NSANClEgNTEuMjE4NzUgMjcuMDkzNzUgNTEuMjE4NzUgMjAuNDUzMTI1IA0KUSA1MS4yMTg3NSAxMS4yODEyNSA0NC43MTg3NSA1LjAzMTI1IA0KUSAzOC4yMzQzNzUgLTEuMjE4NzUgMjcuNjQwNjI1IC0xLjIxODc1IA0KUSAxNy4wNDY4NzUgLTEuMjE4NzUgMTAuNTQ2ODc1IDUuMDQ2ODc1IA0KUSA0LjA0Njg3NSAxMS4zMjgxMjUgNC4wNDY4NzUgMjAuNzAzMTI1IA0KUSA0LjA0Njg3NSAyNy42ODc1IDcuNTkzNzUgMzIuMzkwNjI1IA0KUSAxMS4xNDA2MjUgMzcuMTA5Mzc1IDE3LjY3MTg3NSAzOC44MTI1IA0Keg0KTSAxNS45MjE4NzUgNTMuNzE4NzUgDQpRIDE1LjkyMTg3NSA0OC42NDA2MjUgMTkuMTg3NSA0NS40MDYyNSANClEgMjIuNDY4NzUgNDIuMTg3NSAyNy42ODc1IDQyLjE4NzUgDQpRIDMyLjc2NTYyNSA0Mi4xODc1IDM2LjAxNTYyNSA0NS4zNzUgDQpRIDM5LjI2NTYyNSA0OC41NzgxMjUgMzkuMjY1NjI1IDUzLjIxODc1IA0KUSAzOS4yNjU2MjUgNTguMDYyNSAzNS45MDYyNSA2MS4zNTkzNzUgDQpRIDMyLjU2MjUgNjQuNjU2MjUgMjcuNTkzNzUgNjQuNjU2MjUgDQpRIDIyLjU2MjUgNjQuNjU2MjUgMTkuMjM0Mzc1IDYxLjQyMTg3NSANClEgMTUuOTIxODc1IDU4LjIwMzEyNSAxNS45MjE4NzUgNTMuNzE4NzUgDQp6DQpNIDEzLjA5Mzc1IDIwLjY1NjI1IA0KUSAxMy4wOTM3NSAxNi44OTA2MjUgMTQuODc1IDEzLjM3NSANClEgMTYuNjU2MjUgOS44NTkzNzUgMjAuMTcxODc1IDcuOTIxODc1IA0KUSAyMy42ODc1IDYgMjcuNzM0Mzc1IDYgDQpRIDM0LjAzMTI1IDYgMzguMTI1IDEwLjA0Njg3NSANClEgNDIuMjM0Mzc1IDE0LjEwOTM3NSA0Mi4yMzQzNzUgMjAuMzU5Mzc1IA0KUSA0Mi4yMzQzNzUgMjYuNzAzMTI1IDM4LjAxNTYyNSAzMC44NTkzNzUgDQpRIDMzLjc5Njg3NSAzNS4wMTU2MjUgMjcuNDM3NSAzNS4wMTU2MjUgDQpRIDIxLjIzNDM3NSAzNS4wMTU2MjUgMTcuMTU2MjUgMzAuOTA2MjUgDQpRIDEzLjA5Mzc1IDI2LjgxMjUgMTMuMDkzNzUgMjAuNjU2MjUgDQp6DQoiIGlkPSJBcmlhbE1ULTU2Ii8%2BDQogICAgICA8L2RlZnM%2BDQogICAgICA8ZyBzdHlsZT0iZmlsbDojMjYyNjI2OyIgdHJhbnNmb3JtPSJ0cmFuc2xhdGUoMzAuNDk4MTI1IDEwOS41NzgyMDIpc2NhbGUoMC4xIC0wLjEpIj4NCiAgICAgICA8dXNlIHhsaW5rOmhyZWY9IiNBcmlhbE1ULTU2Ii8%2BDQogICAgICAgPHVzZSB4PSI1NS42MTUyMzQiIHhsaW5rOmhyZWY9IiNBcmlhbE1ULTQ4Ii8%2BDQogICAgICA8L2c%2BDQogICAgIDwvZz4NCiAgICA8L2c%2BDQogICAgPGcgaWQ9Inl0aWNrXzYiPg0KICAgICA8ZyBpZD0ibGluZTJkXzIzIj4NCiAgICAgIDxwYXRoIGNsaXAtcGF0aD0idXJsKCNwZTI0MWZlYjhjNikiIGQ9Ik0gNTIuMTIgNzAuMzEwNzEzIA0KTCA0MjEuMiA3MC4zMTA3MTMgDQoiIHN0eWxlPSJmaWxsOm5vbmU7c3Ryb2tlOiNmZmZmZmY7c3Ryb2tlLWxpbmVjYXA6cm91bmQ7Ii8%2BDQogICAgIDwvZz4NCiAgICAgPGcgaWQ9ImxpbmUyZF8yNCI%2BDQogICAgICA8Zz4NCiAgICAgICA8dXNlIHN0eWxlPSJmaWxsOiMyNjI2MjY7c3Ryb2tlOiMyNjI2MjY7IiB4PSI1Mi4xMiIgeGxpbms6aHJlZj0iI20zNmQ5ZWE0N2ZiIiB5PSI3MC4zMTA3MTMiLz4NCiAgICAgIDwvZz4NCiAgICAgPC9nPg0KICAgICA8ZyBpZD0idGV4dF8xMiI%2BDQogICAgICA8IS0tIDEwMCAtLT4NCiAgICAgIDxnIHN0eWxlPSJmaWxsOiMyNjI2MjY7IiB0cmFuc2Zvcm09InRyYW5zbGF0ZSgyNC45MzcxODggNzMuODg5NjE5KXNjYWxlKDAuMSAtMC4xKSI%2BDQogICAgICAgPHVzZSB4bGluazpocmVmPSIjQXJpYWxNVC00OSIvPg0KICAgICAgIDx1c2UgeD0iNTUuNjE1MjM0IiB4bGluazpocmVmPSIjQXJpYWxNVC00OCIvPg0KICAgICAgIDx1c2UgeD0iMTExLjIzMDQ2OSIgeGxpbms6aHJlZj0iI0FyaWFsTVQtNDgiLz4NCiAgICAgIDwvZz4NCiAgICAgPC9nPg0KICAgIDwvZz4NCiAgICA8ZyBpZD0ieXRpY2tfNyI%2BDQogICAgIDxnIGlkPSJsaW5lMmRfMjUiPg0KICAgICAgPHBhdGggY2xpcC1wYXRoPSJ1cmwoI3BlMjQxZmViOGM2KSIgZD0iTSA1Mi4xMiAzNC42MjIxMjkgDQpMIDQyMS4yIDM0LjYyMjEyOSANCiIgc3R5bGU9ImZpbGw6bm9uZTtzdHJva2U6I2ZmZmZmZjtzdHJva2UtbGluZWNhcDpyb3VuZDsiLz4NCiAgICAgPC9nPg0KICAgICA8ZyBpZD0ibGluZTJkXzI2Ij4NCiAgICAgIDxnPg0KICAgICAgIDx1c2Ugc3R5bGU9ImZpbGw6IzI2MjYyNjtzdHJva2U6IzI2MjYyNjsiIHg9IjUyLjEyIiB4bGluazpocmVmPSIjbTM2ZDllYTQ3ZmIiIHk9IjM0LjYyMjEyOSIvPg0KICAgICAgPC9nPg0KICAgICA8L2c%2BDQogICAgIDxnIGlkPSJ0ZXh0XzEzIj4NCiAgICAgIDwhLS0gMTIwIC0tPg0KICAgICAgPGcgc3R5bGU9ImZpbGw6IzI2MjYyNjsiIHRyYW5zZm9ybT0idHJhbnNsYXRlKDI0LjkzNzE4OCAzOC4yMDEwMzYpc2NhbGUoMC4xIC0wLjEpIj4NCiAgICAgICA8dXNlIHhsaW5rOmhyZWY9IiNBcmlhbE1ULTQ5Ii8%2BDQogICAgICAgPHVzZSB4PSI1NS42MTUyMzQiIHhsaW5rOmhyZWY9IiNBcmlhbE1ULTUwIi8%2BDQogICAgICAgPHVzZSB4PSIxMTEuMjMwNDY5IiB4bGluazpocmVmPSIjQXJpYWxNVC00OCIvPg0KICAgICAgPC9nPg0KICAgICA8L2c%2BDQogICAgPC9nPg0KICAgIDxnIGlkPSJ0ZXh0XzE0Ij4NCiAgICAgPCEtLSBGcmVxdWVuY3kgLS0%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%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%2BDQogICAgICA8cGF0aCBkPSJNIDQwLjQzNzUgMTkgDQpMIDQ5LjA3ODEyNSAxNy44NzUgDQpRIDQ3LjY1NjI1IDguOTM3NSA0MS44MTI1IDMuODc1IA0KUSAzNS45ODQzNzUgLTEuMTcxODc1IDI3LjQ4NDM3NSAtMS4xNzE4NzUgDQpRIDE2Ljg0Mzc1IC0xLjE3MTg3NSAxMC4zNzUgNS43ODEyNSANClEgMy45MDYyNSAxMi43NSAzLjkwNjI1IDI1LjczNDM3NSANClEgMy45MDYyNSAzNC4xMjUgNi42ODc1IDQwLjQyMTg3NSANClEgOS40Njg3NSA0Ni43MzQzNzUgMTUuMTU2MjUgNDkuODc1IA0KUSAyMC44NDM3NSA1My4wMzEyNSAyNy41NDY4NzUgNTMuMDMxMjUgDQpRIDM1Ljk4NDM3NSA1My4wMzEyNSA0MS4zNTkzNzUgNDguNzUgDQpRIDQ2LjczNDM3NSA0NC40ODQzNzUgNDguMjUgMzYuNjI1IA0KTCAzOS43MDMxMjUgMzUuMjk2ODc1IA0KUSAzOC40ODQzNzUgNDAuNTMxMjUgMzUuMzc1IDQzLjE1NjI1IA0KUSAzMi4yODEyNSA0NS43OTY4NzUgMjcuODc1IDQ1Ljc5Njg3NSANClEgMjEuMjM0Mzc1IDQ1Ljc5Njg3NSAxNy4wNzgxMjUgNDEuMDMxMjUgDQpRIDEyLjkzNzUgMzYuMjgxMjUgMTIuOTM3NSAyNS45ODQzNzUgDQpRIDEyLjkzNzUgMTUuNTMxMjUgMTYuOTM3NSAxMC43OTY4NzUgDQpRIDIwLjk1MzEyNSA2LjA2MjUgMjcuMzkwNjI1IDYuMDYyNSANClEgMzIuNTYyNSA2LjA2MjUgMzYuMDMxMjUgOS4yMzQzNzUgDQpRIDM5LjUgMTIuNDA2MjUgNDAuNDM3NSAxOSANCnoNCiIgaWQ9IkFyaWFsTVQtOTkiLz4NCiAgICAgIDxwYXRoIGQ9Ik0gNi4yMDMxMjUgLTE5Ljk2ODc1IA0KTCA1LjIxODc1IC0xMS43MTg3NSANClEgOC4xMDkzNzUgLTEyLjUgMTAuMjUgLTEyLjUgDQpRIDEzLjE4NzUgLTEyLjUgMTQuOTM3NSAtMTEuNTE1NjI1IA0KUSAxNi43MDMxMjUgLTEwLjU0Njg3NSAxNy44MjgxMjUgLTguNzk2ODc1IA0KUSAxOC42NTYyNSAtNy40Njg3NSAyMC41MTU2MjUgLTIuMjUgDQpRIDIwLjc1IC0xLjUxNTYyNSAyMS4yOTY4NzUgLTAuMDkzNzUgDQpMIDEuNjA5Mzc1IDUxLjg1OTM3NSANCkwgMTEuMDc4MTI1IDUxLjg1OTM3NSANCkwgMjEuODc1IDIxLjgyODEyNSANClEgMjMuOTY4NzUgMTYuMTA5Mzc1IDI1LjY0MDYyNSA5LjgxMjUgDQpRIDI3LjE1NjI1IDE1Ljg3NSAyOS4yNSAyMS42MjUgDQpMIDQwLjMyODEyNSA1MS44NTkzNzUgDQpMIDQ5LjEyNSA1MS44NTkzNzUgDQpMIDI5LjM5MDYyNSAtMC44NzUgDQpRIDI2LjIxODc1IC05LjQyMTg3NSAyNC40Njg3NSAtMTIuNjQwNjI1IA0KUSAyMi4xMjUgLTE3IDE5LjA5Mzc1IC0xOS4wMTU2MjUgDQpRIDE2LjA2MjUgLTIxLjA0Njg3NSAxMS44NTkzNzUgLTIxLjA0Njg3NSANClEgOS4zMjgxMjUgLTIxLjA0Njg3NSA2LjIwMzEyNSAtMTkuOTY4NzUgDQp6DQoiIGlkPSJBcmlhbE1ULTEyMSIvPg0KICAgICA8L2RlZnM%2BDQogICAgIDxnIHN0eWxlPSJmaWxsOiMyNjI2MjY7IiB0cmFuc2Zvcm09InRyYW5zbGF0ZSgxOC42MjIwMzEgMTU1Ljc2MDAxOClyb3RhdGUoLTkwKXNjYWxlKDAuMTEgLTAuMTEpIj4NCiAgICAgIDx1c2UgeGxpbms6aHJlZj0iI0FyaWFsTVQtNzAiLz4NCiAgICAgIDx1c2UgeD0iNjEuMDgzOTg0IiB4bGluazpocmVmPSIjQXJpYWxNVC0xMTQiLz4NCiAgICAgIDx1c2UgeD0iOTQuMzg0NzY2IiB4bGluazpocmVmPSIjQXJpYWxNVC0xMDEiLz4NCiAgICAgIDx1c2UgeD0iMTUwIiB4bGluazpocmVmPSIjQXJpYWxNVC0xMTMiLz4NCiAgICAgIDx1c2UgeD0iMjA1LjYxNTIzNCIgeGxpbms6aHJlZj0iI0FyaWFsTVQtMTE3Ii8%2BDQogICAgICA8dXNlIHg9IjI2MS4yMzA0NjkiIHhsaW5rOmhyZWY9IiNBcmlhbE1ULTEwMSIvPg0KICAgICAgPHVzZSB4PSIzMTYuODQ1NzAzIiB4bGluazpocmVmPSIjQXJpYWxNVC0xMTAiLz4NCiAgICAgIDx1c2UgeD0iMzcyLjQ2MDkzOCIgeGxpbms6aHJlZj0iI0FyaWFsTVQtOTkiLz4NCiAgICAgIDx1c2UgeD0iNDIyLjQ2MDkzOCIgeGxpbms6aHJlZj0iI0FyaWFsTVQtMTIxIi8%2BDQogICAgIDwvZz4NCiAgICA8L2c%2BDQogICA8L2c%2BDQogICA8ZyBpZD0icGF0Y2hfMyI%2BDQogICAgPHBhdGggY2xpcC1wYXRoPSJ1cmwoI3BlMjQxZmViOGM2KSIgZD0iTSA2OC44OTYzNjQgMjQ4Ljc1MzYzIA0KTCAxMDIuNDQ5MDkxIDI0OC43NTM2MyANCkwgMTAyLjQ0OTA5MSAyMi4xMzExMjUgDQpMIDY4Ljg5NjM2NCAyMi4xMzExMjUgDQp6DQoiIHN0eWxlPSJmaWxsOiMzMzdhYjc7Ii8%2BDQogICA8L2c%2BDQogICA8ZyBpZD0icGF0Y2hfNCI%2BDQogICAgPHBhdGggY2xpcC1wYXRoPSJ1cmwoI3BlMjQxZmViOGM2KSIgZD0iTSAxMDIuNDQ5MDkxIDI0OC43NTM2MyANCkwgMTM2LjAwMTgxOCAyNDguNzUzNjMgDQpMIDEzNi4wMDE4MTggMTEzLjEzNzAxMyANCkwgMTAyLjQ0OTA5MSAxMTMuMTM3MDEzIA0Keg0KIiBzdHlsZT0iZmlsbDojMzM3YWI3OyIvPg0KICAgPC9nPg0KICAgPGcgaWQ9InBhdGNoXzUiPg0KICAgIDxwYXRoIGNsaXAtcGF0aD0idXJsKCNwZTI0MWZlYjhjNikiIGQ9Ik0gMTM2LjAwMTgxOCAyNDguNzUzNjMgDQpMIDE2OS41NTQ1NDUgMjQ4Ljc1MzYzIA0KTCAxNjkuNTU0NTQ1IDgxLjAxNzI4OCANCkwgMTM2LjAwMTgxOCA4MS4wMTcyODggDQp6DQoiIHN0eWxlPSJmaWxsOiMzMzdhYjc7Ii8%2BDQogICA8L2c%2BDQogICA8ZyBpZD0icGF0Y2hfNiI%2BDQogICAgPHBhdGggY2xpcC1wYXRoPSJ1cmwoI3BlMjQxZmViOGM2KSIgZD0iTSAxNjkuNTU0NTQ1IDI0OC43NTM2MyANCkwgMjAzLjEwNzI3MyAyNDguNzUzNjMgDQpMIDIwMy4xMDcyNzMgMTAyLjQzMDQzOCANCkwgMTY5LjU1NDU0NSAxMDIuNDMwNDM4IA0Keg0KIiBzdHlsZT0iZmlsbDojMzM3YWI3OyIvPg0KICAgPC9nPg0KICAgPGcgaWQ9InBhdGNoXzciPg0KICAgIDxwYXRoIGNsaXAtcGF0aD0idXJsKCNwZTI0MWZlYjhjNikiIGQ9Ik0gMjAzLjEwNzI3MyAyNDguNzUzNjMgDQpMIDIzNi42NiAyNDguNzUzNjMgDQpMIDIzNi42NiA4Ni4zNzA1NzUgDQpMIDIwMy4xMDcyNzMgODYuMzcwNTc1IA0Keg0KIiBzdHlsZT0iZmlsbDojMzM3YWI3OyIvPg0KICAgPC9nPg0KICAgPGcgaWQ9InBhdGNoXzgiPg0KICAgIDxwYXRoIGNsaXAtcGF0aD0idXJsKCNwZTI0MWZlYjhjNikiIGQ9Ik0gMjM2LjY2IDI0OC43NTM2MyANCkwgMjcwLjIxMjcyNyAyNDguNzUzNjMgDQpMIDI3MC4yMTI3MjcgOTcuMDc3MTUgDQpMIDIzNi42NiA5Ny4wNzcxNSANCnoNCiIgc3R5bGU9ImZpbGw6IzMzN2FiNzsiLz4NCiAgIDwvZz4NCiAgIDxnIGlkPSJwYXRjaF85Ij4NCiAgICA8cGF0aCBjbGlwLXBhdGg9InVybCgjcGUyNDFmZWI4YzYpIiBkPSJNIDI3MC4yMTI3MjcgMjQ4Ljc1MzYzIA0KTCAzMDMuNzY1NDU1IDI0OC43NTM2MyANCkwgMzAzLjc2NTQ1NSAxMDkuNTY4MTU1IA0KTCAyNzAuMjEyNzI3IDEwOS41NjgxNTUgDQp6DQoiIHN0eWxlPSJmaWxsOiMzMzdhYjc7Ii8%2BDQogICA8L2c%2BDQogICA8ZyBpZD0icGF0Y2hfMTAiPg0KICAgIDxwYXRoIGNsaXAtcGF0aD0idXJsKCNwZTI0MWZlYjhjNikiIGQ9Ik0gMzAzLjc2NTQ1NSAyNDguNzUzNjMgDQpMIDMzNy4zMTgxODIgMjQ4Ljc1MzYzIA0KTCAzMzcuMzE4MTgyIDE0MS42ODc4OCANCkwgMzAzLjc2NTQ1NSAxNDEuNjg3ODggDQp6DQoiIHN0eWxlPSJmaWxsOiMzMzdhYjc7Ii8%2BDQogICA8L2c%2BDQogICA8ZyBpZD0icGF0Y2hfMTEiPg0KICAgIDxwYXRoIGNsaXAtcGF0aD0idXJsKCNwZTI0MWZlYjhjNikiIGQ9Ik0gMzM3LjMxODE4MiAyNDguNzUzNjMgDQpMIDM3MC44NzA5MDkgMjQ4Ljc1MzYzIA0KTCAzNzAuODcwOTA5IDEwNy43ODM3MjUgDQpMIDMzNy4zMTgxODIgMTA3Ljc4MzcyNSANCnoNCiIgc3R5bGU9ImZpbGw6IzMzN2FiNzsiLz4NCiAgIDwvZz4NCiAgIDxnIGlkPSJwYXRjaF8xMiI%2BDQogICAgPHBhdGggY2xpcC1wYXRoPSJ1cmwoI3BlMjQxZmViOGM2KSIgZD0iTSAzNzAuODcwOTA5IDI0OC43NTM2MyANCkwgNDA0LjQyMzYzNiAyNDguNzUzNjMgDQpMIDQwNC40MjM2MzYgODIuODAxNzE3IA0KTCAzNzAuODcwOTA5IDgyLjgwMTcxNyANCnoNCiIgc3R5bGU9ImZpbGw6IzMzN2FiNzsiLz4NCiAgIDwvZz4NCiAgIDxnIGlkPSJwYXRjaF8xMyI%2BDQogICAgPHBhdGggZD0iTSA1Mi4xMiAyNDguNzUzNjMgDQpMIDUyLjEyIDEwLjggDQoiIHN0eWxlPSJmaWxsOm5vbmU7Ii8%2BDQogICA8L2c%2BDQogICA8ZyBpZD0icGF0Y2hfMTQiPg0KICAgIDxwYXRoIGQ9Ik0gNDIxLjIgMjQ4Ljc1MzYzIA0KTCA0MjEuMiAxMC44IA0KIiBzdHlsZT0iZmlsbDpub25lOyIvPg0KICAgPC9nPg0KICAgPGcgaWQ9InBhdGNoXzE1Ij4NCiAgICA8cGF0aCBkPSJNIDUyLjEyIDI0OC43NTM2MyANCkwgNDIxLjIgMjQ4Ljc1MzYzIA0KIiBzdHlsZT0iZmlsbDpub25lOyIvPg0KICAgPC9nPg0KICAgPGcgaWQ9InBhdGNoXzE2Ij4NCiAgICA8cGF0aCBkPSJNIDUyLjEyIDEwLjggDQpMIDQyMS4yIDEwLjggDQoiIHN0eWxlPSJmaWxsOm5vbmU7Ii8%2BDQogICA8L2c%2BDQogIDwvZz4NCiA8L2c%2BDQogPGRlZnM%2BDQogIDxjbGlwUGF0aCBpZD0icGUyNDFmZWI4YzYiPg0KICAgPHJlY3QgaGVpZ2h0PSIyMzcuOTUzNjMiIHdpZHRoPSIzNjkuMDgiIHg9IjUyLjEyIiB5PSIxMC44Ii8%2BDQogIDwvY2xpcFBhdGg%2BDQogPC9kZWZzPg0KPC9zdmc%2BDQo%3D'
            # content = b"iVBORw0KGgoAAAANSUhEUgAAAAUAAAAFCAYAAACNbyblAAAAHElEQVQI12P4//8/w38GIAXDIBKE0DHxgljNBAAO9TXL0Y4OHwAAAABJRU5ErkJggg=="
            img = QImage.fromData(base64.b64decode(img_bytes))
        pm = QPixmap(img)
        pm = pm.scaledToWidth(1200)
        pic.setScaledContents(True)
        pic.setPixmap(pm)
        pic.show()

        return widget
