import contextlib
import errno
import os
import sys
import tempfile


MS_WINDOWS = (sys.platform == 'win32')


@contextlib.contextmanager
def temporary_file():
    tmp_filename = tempfile.mktemp()
    try:
        yield tmp_filename
    finally:
        try:
            os.unlink(tmp_filename)
        except OSError as exc:
            if exc.errno != errno.ENOENT:
                raise
