### Details: https://spacy.io/models/fi#fi_core_news_sm

Finnish pipeline optimized for CPU. Components: tok2vec, tagger, morphologizer, parser, lemmatizer (trainable_lemmatizer), senter, ner.

| Feature | Description |
| --- | --- |
| **Name** | `fi_core_news_sm` |
| **Version** | `3.8.0` |
| **spaCy** | `>=3.8.0,<3.9.0` |
| **Default Pipeline** | `tok2vec`, `tagger`, `morphologizer`, `parser`, `lemmatizer`, `attribute_ruler`, `ner` |
| **Components** | `tok2vec`, `tagger`, `morphologizer`, `parser`, `lemmatizer`, `senter`, `attribute_ruler`, `ner` |
| **Vectors** | 0 keys, 0 unique vectors (0 dimensions) |
| **Sources** | [UD Finnish TDT v2.8](https://github.com/UniversalDependencies/UD_Finnish-TDT) (Ginter, Filip; Kanerva, Jenna; Laippala, Veronika; Miekka, Niko; Missilä, Anna; Ojala, Stina; Pyysalo, Sampo)<br />[TurkuONE (ffe2040e)](https://github.com/TurkuNLP/turku-one) (Jouni Luoma, Li-Hsin Chang, Filip Ginter, Sampo Pyysalo) |
| **License** | `CC BY-SA 4.0` |
| **Author** | [Explosion](https://explosion.ai) |

### Label Scheme

<details>

<summary>View label scheme (2145 labels for 4 components)</summary>

| Component | Labels |
| --- | --- |
| **`tagger`** | `A`, `Adj`, `Adp`, `Adv`, `Adv_V`, `C`, `C_V`, `Foreign`, `Interj`, `N`, `Num`, `Pron`, `Punct`, `Symb`, `V`, `V_Pron`, `_SP` |
| **`morphologizer`** | `Case=Nom\|Number=Sing\|POS=NOUN`, `NumType=Ord\|POS=ADJ`, `Case=Ade\|Number=Sing\|POS=NOUN`, `Case=Nom\|Derivation=U\|Number=Sing\|POS=NOUN`, `Mood=Ind\|Number=Sing\|POS=VERB\|Person=3\|Tense=Pres\|VerbForm=Fin\|Voice=Act`, `POS=ADV`, `Case=Par\|Degree=Pos\|Number=Plur\|POS=ADJ`, `POS=CCONJ`, `Case=Par\|Degree=Pos\|Derivation=Inen\|Number=Plur\|POS=ADJ`, `Case=Par\|Number=Plur\|POS=NOUN`, `Case=Ill\|Number=Sing\|POS=NOUN`, `POS=PUNCT`, `Case=Nom\|Degree=Pos\|Derivation=Lainen\|Number=Sing\|POS=ADJ`, `POS=SCONJ`, `Case=Nom\|Number=Sing\|Number[psor]=Plur\|POS=NOUN\|Person[psor]=1`, `Mood=Ind\|Number=Sing\|POS=VERB\|Person=3\|Tense=Past\|VerbForm=Fin\|Voice=Act`, `Case=Acc\|Number=Plur\|POS=PRON\|Person=1\|PronType=Prs`, `Case=Gen\|Number=Sing\|POS=NOUN`, `Case=Abl\|Degree=Pos\|Derivation=Lainen\|Number=Sing\|POS=ADJ`, `Clitic=Kaan\|Mood=Ind\|Number=Sing\|POS=VERB\|Person=3\|Tense=Past\|VerbForm=Fin\|Voice=Act`, `Mood=Ind\|Number=Sing\|POS=VERB\|Person=0\|Tense=Past\|VerbForm=Fin\|Voice=Act`, `Case=Nom\|Derivation=Lainen\|Number=Sing\|POS=ADJ`, `Case=Nom\|Number=Sing\|POS=PROPN`, `Mood=Ind\|Number=Sing\|POS=AUX\|Person=3\|Tense=Pres\|VerbForm=Fin\|Voice=Act`, `Case=Nom\|Number=Sing\|POS=PRON\|PronType=Dem`, `Clitic=Kin\|POS=ADV`, `Case=Gen\|Number=Plur\|POS=PROPN`, `Case=Ess\|Number=Sing\|POS=NOUN`, `Case=Ill\|Number=Sing\|POS=PRON\|Person=1\|PronType=Prs`, `Case=Gen\|Degree=Pos\|Number=Sing\|POS=ADJ`, `Mood=Ind\|Number=Sing\|POS=VERB\|Person=1\|Tense=Pres\|VerbForm=Fin\|Voice=Act`, `Case=Gen\|Number=Sing\|POS=PRON\|PronType=Dem`, `Case=Ela\|Derivation=Llinen,Vs\|Number=Sing\|POS=NOUN`, `POS=ADJ`, `Case=Gen\|Number=Plur\|POS=NOUN`, `Case=Par\|Number=Sing\|POS=PRON\|PronType=Dem`, `Number=Sing\|POS=AUX\|Person=3\|Polarity=Neg\|VerbForm=Fin\|Voice=Act`, `Case=Ine\|Number=Sing\|POS=PRON\|PronType=Ind`, `Case=Ine\|Number=Sing\|POS=NOUN`, `Case=Nom\|Degree=Pos\|Number=Sing\|POS=VERB\|PartForm=Past\|VerbForm=Part\|Voice=Pass`, `Case=Ade\|Number=Sing\|POS=PRON\|PronType=Ind`, `Case=Ins\|Number=Plur\|POS=NOUN`, `Case=Gen\|Number=Sing\|POS=PROPN`, `Case=Par\|Number=Sing\|POS=NOUN`, `Mood=Ind\|Number=Sing\|POS=AUX\|Person=3\|Tense=Past\|VerbForm=Fin\|Voice=Act`, `Case=Nom\|Degree=Pos\|Number=Sing\|POS=ADJ`, `Case=Nom\|Number=Plur\|POS=NOUN`, `Mood=Ind\|Number=Plur\|POS=VERB\|Person=3\|Tense=Past\|VerbForm=Fin\|Voice=Act`, `Case=All\|Number=Sing\|POS=PRON\|PronType=Dem`, `Case=Ill\|InfForm=3\|Number=Sing\|POS=VERB\|VerbForm=Inf\|Voice=Act`, `Case=Nom\|Clitic=Kin\|Number=Plur\|POS=PRON\|Person=1\|PronType=Prs`, `Mood=Ind\|Number=Plur\|POS=VERB\|Person=1\|Tense=Past\|VerbForm=Fin\|Voice=Act`, `Case=Gen\|Number=Sing\|POS=NOUN\|Style=Coll`, `Case=All\|Derivation=U\|Number=Sing\|POS=NOUN`, `AdpType=Post\|POS=ADP`, `Case=Nom\|Degree=Pos\|Derivation=Llinen\|Number=Sing\|POS=ADJ`, `Case=Gen\|Number=Sing\|POS=PRON\|PronType=Rcp`, `Case=Abl\|Number=Sing\|POS=NOUN`, `Case=All\|Number=Sing\|POS=PRON\|PronType=Rcp`, `Case=Ine\|InfForm=3\|Number=Sing\|POS=VERB\|VerbForm=Inf\|Voice=Act`, `Case=Par\|Number=Plur\|POS=PRON\|PronType=Ind`, `Case=Par\|Derivation=Ja\|Number=Plur\|POS=NOUN`, `Case=Gen\|Derivation=Vs\|Number=Sing\|POS=NOUN`, `Case=Par\|Number=Sing\|POS=PRON\|PronType=Ind`, `Case=Par\|Derivation=Ja\|Number=Sing\|POS=NOUN`, `Case=Nom\|Degree=Pos\|Derivation=Inen\|Number=Sing\|POS=ADJ`, `Case=Tra\|Number=Sing\|POS=NOUN`, `Case=Ela\|Number=Sing\|POS=NOUN`, `Case=Nom\|Degree=Pos\|Number=Sing\|POS=VERB\|PartForm=Past\|VerbForm=Part\|Voice=Act`, `Case=Par\|Degree=Pos\|Number=Sing\|POS=ADJ`, `Case=Par\|Clitic=Kin\|Number=Sing\|POS=NOUN`, `InfForm=1\|Number=Sing\|POS=VERB\|VerbForm=Inf\|Voice=Act`, `Case=Nom\|Derivation=Ja\|Number=Sing\|POS=NOUN`, `Case=Ela\|Number=Sing\|Number[psor]=Sing\|POS=NOUN\|Person[psor]=1`, `Case=Ine\|Number=Sing\|POS=NOUN\|Person[psor]=3`, `InfForm=1\|Number=Sing\|POS=AUX\|VerbForm=Inf\|Voice=Act`, `Derivation=Sti\|POS=ADV`, `Mood=Cnd\|Number=Sing\|POS=AUX\|Person=3\|VerbForm=Fin\|Voice=Act`, `Case=Ill\|Number=Sing\|POS=PRON\|PronType=Int`, `Mood=Ind\|Number=Sing\|POS=VERB\|Person=0\|Tense=Pres\|VerbForm=Fin\|Voice=Act`, `Case=Ill\|Number=Plur\|POS=NOUN`, `Case=Par\|Degree=Pos\|Number=Plur\|POS=VERB\|PartForm=Pres\|VerbForm=Part\|Voice=Act`, `Case=Nom\|Degree=Pos\|Number=Sing\|POS=VERB\|PartForm=Agt\|VerbForm=Part\|Voice=Act`, `Case=Nom\|Number=Plur\|POS=NOUN\|Person[psor]=3`, `Case=Par\|Number=Sing\|POS=PRON\|PronType=Rel`, `Case=Ine\|Clitic=Kin\|Number=Plur\|POS=NOUN`, `Mood=Ind\|POS=VERB\|Tense=Pres\|VerbForm=Fin\|Voice=Pass`, `Case=Gen\|Number=Sing\|POS=PRON\|PronType=Ind`, `Case=Gen\|NumType=Card\|Number=Sing\|POS=NUM`, `Case=All\|Number=Sing\|POS=NOUN`, `Case=Nom\|Number=Sing\|POS=PRON\|PronType=Ind`, `Case=Nom\|Number=Sing\|POS=PRON\|PronType=Rel`, `Case=Ill\|Number=Sing\|POS=NOUN\|Person[psor]=3`, `Case=Par\|Degree=Pos\|Derivation=Inen\|Number=Sing\|POS=ADJ`, `Case=Gen\|Degree=Pos\|Derivation=Lainen\|Number=Sing\|POS=ADJ`, `Case=Gen\|Derivation=Inen\|NumType=Ord\|Number=Sing\|POS=ADJ`, `Case=Nom\|Degree=Pos\|Number=Sing\|POS=VERB\|PartForm=Pres\|VerbForm=Part\|Voice=Act`, `Case=Gen\|Degree=Pos\|Number=Sing\|POS=AUX\|PartForm=Pres\|VerbForm=Part\|Voice=Act`, `Case=Nom\|Derivation=Ja\|Number=Plur\|POS=NOUN\|Typo=Yes`, `Mood=Ind\|Number=Plur\|POS=AUX\|Person=3\|Tense=Pres\|VerbForm=Fin\|Voice=Act`, `Case=Par\|Number=Sing\|POS=PRON\|Person[psor]=3\|Reflex=Yes`, `Case=All\|Degree=Pos\|Derivation=Inen\|Number=Plur\|POS=ADJ`, `Case=All\|Degree=Pos\|Number=Plur\|POS=ADJ`, `Case=All\|Number=Plur\|POS=NOUN`, `Case=Ela\|Derivation=U\|Number=Plur\|POS=NOUN`, `Case=Nom\|Degree=Pos\|Number=Sing\|POS=VERB\|PartForm=Pres\|VerbForm=Part\|Voice=Pass`, `Case=Nom\|Degree=Pos\|Number=Sing\|POS=VERB\|PartForm=Past\|Typo=Yes\|VerbForm=Part\|Voice=Act`, `Case=Nom\|Clitic=Kaan\|Number=Sing\|POS=NOUN`, `Foreign=Yes\|POS=X`, `Clitic=Ka\|Number=Sing\|POS=AUX\|Person=3\|Polarity=Neg\|VerbForm=Fin\|Voice=Act`, `Case=Ela\|Degree=Pos\|Number=Sing\|POS=ADJ`, `Connegative=Yes\|Mood=Ind\|POS=VERB\|Tense=Pres\|VerbForm=Fin`, `Case=Tra\|Degree=Pos\|Derivation=Inen\|Number=Sing\|POS=ADJ`, `Mood=Cnd\|Number=Sing\|POS=AUX\|Person=0\|VerbForm=Fin\|Voice=Act`, `Case=Nom\|Degree=Cmp\|Number=Sing\|POS=ADJ`, `Case=Nom\|Number=Sing\|POS=PRON\|Person=1\|PronType=Prs`, `Mood=Ind\|Number=Sing\|POS=AUX\|Person=1\|Tense=Pres\|VerbForm=Fin\|Voice=Act`, `Mood=Ind\|Number=Sing\|POS=VERB\|Person=1\|Tense=Past\|VerbForm=Fin\|Voice=Act`, `Case=Ade\|Number=Sing\|POS=PRON\|PronType=Rel`, `Mood=Ind\|POS=VERB\|Tense=Past\|VerbForm=Fin\|Voice=Pass`, `Case=All\|Number=Sing\|POS=PRON\|PronType=Ind`, `Case=All\|Number=Plur\|Number[psor]=Sing\|POS=NOUN\|Person[psor]=1`, `Case=Nom\|Number=Plur\|POS=PRON\|PronType=Ind`, `Mood=Ind\|Number=Plur\|POS=AUX\|Person=3\|Tense=Past\|VerbForm=Fin\|Voice=Act`, `Case=Nom\|Number=Plur\|POS=PRON\|Person=3\|PronType=Prs`, `Clitic=Kin\|Mood=Ind\|Number=Plur\|POS=AUX\|Person=3\|Tense=Past\|VerbForm=Fin\|Voice=Act`, `Case=Nom\|Degree=Pos\|Number=Plur\|POS=VERB\|PartForm=Past\|VerbForm=Part\|Voice=Act`, `Case=Par\|Derivation=Vs\|Number=Sing\|POS=NOUN`, `Case=Gen\|Number=Sing\|Number[psor]=Sing\|POS=NOUN\|Person[psor]=1`, `Case=Gen\|Degree=Pos\|Number=Sing\|POS=VERB\|PartForm=Pres\|VerbForm=Part\|Voice=Act`, `Case=Nom\|Number=Sing\|Number[psor]=Sing\|POS=NOUN\|Person[psor]=1`, `Case=Ill\|Derivation=Ja\|Number=Sing\|Number[psor]=Sing\|POS=NOUN\|Person[psor]=1`, `Mood=Cnd\|Number=Plur\|POS=AUX\|Person=3\|VerbForm=Fin\|Voice=Act`, `Case=Ine\|Number=Sing\|POS=PRON\|PronType=Dem`, `Case=Ine\|Number=Sing\|POS=PROPN`, `Mood=Ind\|Number=Sing\|POS=AUX\|Person=0\|Tense=Pres\|VerbForm=Fin\|Voice=Act`, `Case=Nom\|Number=Sing\|POS=PRON`, `Case=Nom\|Derivation=Inen\|NumType=Ord\|Number=Sing\|POS=ADJ`, `Case=Nom\|Number=Sing\|POS=PRON\|Person=3\|PronType=Prs`, `Case=Ess\|Degree=Pos\|Number=Sing\|POS=VERB\|PartForm=Past\|VerbForm=Part\|Voice=Act`, `Clitic=Ko\|Mood=Cnd\|Number=Plur\|POS=AUX\|Person=1\|VerbForm=Fin\|Voice=Act`, `Case=Par\|Number=Plur\|POS=PRON\|Person=3\|PronType=Prs`, `Clitic=Ko\|Mood=Ind\|Number=Sing\|POS=VERB\|Person=0\|Tense=Pres\|VerbForm=Fin\|Voice=Act`, `Case=Gen\|Number=Plur\|POS=PRON\|Person=1\|PronType=Prs`, `Case=Ine\|Degree=Pos\|Number=Sing\|POS=ADJ`, `Case=Ine\|Number=Sing\|Number[psor]=Plur\|POS=NOUN\|Person[psor]=1\|Style=Coll`, `Case=Ade\|Number=Sing\|POS=NOUN\|Person[psor]=3`, `Derivation=Ttain\|POS=ADV`, `Case=Nom\|Degree=Pos\|Number=Sing\|POS=VERB\|PartForm=Pres\|Typo=Yes\|VerbForm=Part\|Voice=Act`, `Case=Nom\|Clitic=Kin\|Degree=Pos\|Number=Sing\|POS=ADJ`, `Case=Ine\|InfForm=2\|Number=Sing\|Number[psor]=Sing\|POS=VERB\|Person[psor]=1\|VerbForm=Inf\|Voice=Act`, `Case=All\|Number=Sing\|POS=PRON\|Person=3\|PronType=Prs`, `Case=Ela\|Degree=Pos\|Number=Plur\|POS=ADJ`, `Case=Ela\|Number=Plur\|Number[psor]=Sing\|POS=NOUN\|Person[psor]=1`, `Case=Ine\|Number=Plur\|POS=NOUN`, `Case=Com\|POS=NOUN\|Person[psor]=3`, `Case=Com\|POS=PRON\|Person[psor]=3\|PronType=Ind`, `Number[psor]=Sing\|POS=ADV\|Person[psor]=1`, `Case=Par\|Number=Sing\|Number[psor]=Sing\|POS=PRON\|Person[psor]=1\|Reflex=Yes`, `Case=Par\|Number=Sing\|POS=PRON\|PronType=Int`, `Clitic=Ko\|Mood=Ind\|Number=Sing\|POS=AUX\|Person=1\|Tense=Pres\|VerbForm=Fin\|Voice=Act`, `Clitic=Ko\|Mood=Cnd\|Number=Sing\|POS=AUX\|Person=3\|VerbForm=Fin\|Voice=Act`, `POS=SPACE`, `Case=Ine\|Number=Sing\|POS=PRON\|PronType=Rel`, `Case=Gen\|Number=Sing\|POS=PRON\|Person=3\|PronType=Prs`, `Case=Gen\|Derivation=Vs\|Number=Sing\|POS=NOUN\|Person[psor]=3`, `Case=Par\|Derivation=Minen\|Number=Sing\|POS=NOUN`, `Case=Nom\|Degree=Pos\|Derivation=Lainen\|Number=Plur\|POS=ADJ`, `Case=Ade\|Degree=Pos\|Derivation=Inen\|Number=Sing\|POS=ADJ`, `Connegative=Yes\|Mood=Ind\|POS=VERB\|Tense=Pres\|VerbForm=Fin\|Voice=Pass`, `Case=Ill\|Degree=Cmp\|Number=Sing\|POS=ADJ`, `Number=Sing\|POS=SCONJ\|Person=1\|Polarity=Neg\|VerbForm=Fin\|Voice=Act`, `Case=Par\|Number=Sing\|Number[psor]=Sing\|POS=NOUN\|Person[psor]=1`, `Case=Par\|Number=Sing\|POS=NOUN\|Person[psor]=3`, `AdpType=Post\|POS=ADP\|Person[psor]=3`, `Mood=Ind\|Number=Plur\|POS=VERB\|Person=3\|Tense=Pres\|VerbForm=Fin\|Voice=Act`, `Mood=Cnd\|Number=Sing\|POS=VERB\|Person=3\|VerbForm=Fin\|Voice=Act`, `Case=Nom\|Derivation=Vs\|Number=Sing\|POS=NOUN`, `Case=Ill\|Degree=Pos\|Derivation=Ton\|Number=Plur\|POS=ADJ`, `Case=Ill\|Derivation=U\|Number=Sing\|POS=NOUN`, `Case=Nom\|Derivation=Minen\|Number=Sing\|POS=NOUN`, `Case=Ill\|Degree=Pos\|Number=Plur\|POS=ADJ`, `Case=All\|Number=Sing\|Number[psor]=Sing\|POS=NOUN\|Person[psor]=1`, `Abbr=Yes\|Case=Ine\|Number=Sing\|POS=NOUN`, `Case=Ine\|InfForm=2\|Number=Sing\|Number[psor]=Sing\|POS=AUX\|Person[psor]=1\|VerbForm=Inf\|Voice=Act`, `Number=Sing\|POS=AUX\|Person=1\|Polarity=Neg\|VerbForm=Fin\|Voice=Act`, `Case=Ela\|Number=Plur\|POS=NOUN`, `Case=Nom\|NumType=Card\|Number=Sing\|POS=NUM`, `Case=Par\|Degree=Cmp\|Number=Plur\|POS=ADJ`, `Case=Ine\|Number=Sing\|POS=PROPN\|Style=Coll`, `Abbr=Yes\|Case=Par\|Number=Sing\|POS=NOUN`, `Case=Ess\|Degree=Pos\|Number=Plur\|POS=ADJ`, `Case=Ess\|Number=Plur\|POS=NOUN`, `Case=Nom\|Degree=Pos\|Number=Sing\|POS=AUX\|PartForm=Past\|VerbForm=Part\|Voice=Act`, `Case=Ill\|Number=Sing\|POS=PROPN`, `Case=Par\|Degree=Pos\|Derivation=Llinen\|Number=Sing\|POS=ADJ`, `Case=Ine\|InfForm=2\|Number=Sing\|POS=VERB\|Person[psor]=3\|VerbForm=Inf\|Voice=Act`, `NumType=Card\|POS=NUM`, `Case=Tra\|Degree=Pos\|Number=Sing\|POS=ADJ`, `Case=Ill\|Degree=Pos\|Derivation=Inen\|Number=Plur\|POS=ADJ`, `Case=Ill\|NumType=Card\|Number=Sing\|POS=NUM`, `Case=Ins\|InfForm=2\|Number=Sing\|POS=VERB\|VerbForm=Inf\|Voice=Act`, `Case=Gen\|Derivation=Lainen\|Number=Plur\|POS=NOUN`, `Case=Ela\|Derivation=Vs\|Number=Plur\|POS=NOUN`, `Case=Ade\|Number=Plur\|POS=NOUN`, `Case=Gen\|Number=Sing\|POS=NOUN\|Typo=Yes`, `Case=Ade\|InfForm=3\|Number=Sing\|POS=VERB\|VerbForm=Inf\|Voice=Act`, `Mood=Ind\|Number=Sing\|POS=AUX\|Person=1\|Tense=Past\|VerbForm=Fin\|Voice=Act`, `Mood=Ind\|Number=Plur\|POS=VERB\|Person=3\|Style=Coll\|Tense=Past\|VerbForm=Fin\|Voice=Act`, `Case=Abl\|Number=Sing\|POS=PRON\|Person=1\|PronType=Prs`, `Case=Ade\|Number=Plur\|POS=PRON\|Person=1\|PronType=Prs`, `Case=Ill\|Degree=Pos\|Number=Sing\|POS=ADJ`, `Case=Ela\|Number=Sing\|POS=PRON\|PronType=Int`, `Case=Ess\|Degree=Pos\|Number=Sing\|POS=ADJ`, `Case=Ess\|Number=Sing\|POS=PRON\|Person[psor]=3\|Reflex=Yes`, `Case=Ade\|Number=Sing\|POS=PRON\|PronType=Dem`, `Connegative=Yes\|Mood=Ind\|POS=AUX\|Tense=Pres\|VerbForm=Fin`, `Clitic=Ko\|Number=Sing\|POS=SCONJ\|Person=3\|Polarity=Neg\|VerbForm=Fin\|Voice=Act`, `Case=Par\|Number=Plur\|POS=PRON\|PronType=Dem`, `Connegative=Yes\|Mood=Cnd\|POS=AUX\|VerbForm=Fin`, `Case=Ela\|Derivation=U\|Number=Sing\|POS=NOUN`, `Case=Par\|Degree=Cmp\|Number=Sing\|POS=ADJ`, `Case=Nom\|Number=Sing\|POS=NOUN\|Person[psor]=3`, `Case=Par\|Derivation=Llinen,Vs\|Number=Plur\|POS=NOUN`, `Case=Gen\|Number=Plur\|POS=PRON\|PronType=Rel`, `Case=Gen\|Derivation=Ja\|Number=Sing\|POS=NOUN`, `Case=Par\|Degree=Pos\|Number=Sing\|POS=VERB\|PartForm=Agt\|VerbForm=Part\|Voice=Act`, `Mood=Imp\|Number=Sing\|POS=AUX\|Person=2\|VerbForm=Fin\|Voice=Act`, `Mood=Imp\|Number=Sing\|POS=VERB\|Person=2\|VerbForm=Fin\|Voice=Act`, `POS=SYM`, `Mood=Ind\|Number=Plur\|POS=AUX\|Person=1\|Tense=Pres\|VerbForm=Fin\|Voice=Act`, `Case=Nom\|Number=Plur\|POS=PRON\|PronType=Dem`, `Case=Nom\|Number=Plur\|POS=PRON\|PronType=Rel`, `Clitic=Ka\|Number=Plur\|POS=AUX\|Person=3\|Polarity=Neg\|VerbForm=Fin\|Voice=Act`, `Case=Gen\|Number=Sing\|POS=NOUN\|Person[psor]=3`, `Case=Ela\|Number=Sing\|POS=PRON\|PronType=Dem`, `Mood=Cnd\|Number=Sing\|POS=VERB\|Person=0\|VerbForm=Fin\|Voice=Act`, `Case=Ess\|Clitic=Kaan\|Number=Sing\|POS=PRON\|PronType=Dem`, `Case=Ess\|Derivation=U\|Number=Sing\|POS=NOUN`, `Case=Gen\|Number=Plur\|POS=PRON\|PronType=Dem`, `Case=Gen\|Number=Plur\|POS=PRON\|Person=3\|PronType=Prs`, `Number=Sing\|POS=SCONJ\|Person=3\|Polarity=Neg\|VerbForm=Fin\|Voice=Act`, `Clitic=Kaan\|POS=ADV`, `Clitic=Pa\|Mood=Ind\|Number=Sing\|POS=VERB\|Person=1\|Tense=Pres\|VerbForm=Fin\|Voice=Act`, `Case=Ade\|Degree=Pos\|Number=Sing\|POS=ADJ`, `Case=Par\|Degree=Pos\|Derivation=Lainen\|Number=Sing\|POS=ADJ`, `Case=Ine\|Number=Sing\|Number[psor]=Sing\|POS=NOUN\|Person[psor]=1`, `Case=Gen\|Number=Sing\|POS=PRON\|PronType=Rel`, `Case=Ade\|Derivation=U\|Number=Sing\|POS=NOUN`, `Abbr=Yes\|POS=ADV`, `Case=Ine\|Degree=Pos\|Derivation=Ton\|Number=Sing\|POS=ADJ`, `Case=Par\|Degree=Pos\|Number=Plur\|Number[psor]=Sing\|POS=ADJ\|Person[psor]=1`, `Case=All\|Number=Sing\|POS=PRON\|Person=1\|PronType=Prs`, `Case=Nom\|Clitic=Kin\|Number=Sing\|POS=NOUN`, `POS=ADV\|Typo=Yes`, `Mood=Cnd\|Number=Sing\|POS=VERB\|Person=1\|VerbForm=Fin\|Voice=Act`, `Case=Gen\|Degree=Pos\|Derivation=Inen\|Number=Plur\|POS=ADJ`, `Case=Ela\|Derivation=Minen\|Number=Sing\|POS=NOUN`, `Case=Gen\|Degree=Pos\|Number=Plur\|POS=ADJ`, `Case=Nom\|Degree=Pos\|Number=Plur\|POS=ADJ`, `Case=Ela\|Number=Sing\|POS=PRON\|PronType=Ind`, `Case=Ela\|Degree=Pos\|Derivation=Llinen\|Number=Sing\|POS=ADJ`, `Case=Gen\|Degree=Pos\|Derivation=Inen\|Number=Sing\|POS=ADJ`, `Case=Gen\|Degree=Pos\|Derivation=Llinen\|Number=Sing\|POS=ADJ`, `Case=All\|Degree=Pos\|Number=Sing\|POS=ADJ`, `Case=Ine\|Number=Plur\|POS=NOUN\|Person[psor]=3`, `Case=Par\|Derivation=U\|Number=Plur\|POS=NOUN`, `Case=Ela\|Degree=Pos\|Derivation=Inen\|Number=Sing\|POS=ADJ`, `Clitic=Ko\|Mood=Cnd\|Number=Sing\|POS=VERB\|Person=3\|VerbForm=Fin\|Voice=Act`, `Case=Par\|Degree=Pos\|Number=Sing\|POS=VERB\|PartForm=Pres\|VerbForm=Part\|Voice=Pass`, `Mood=Ind\|Number=Plur\|POS=VERB\|Person=1\|Tense=Pres\|VerbForm=Fin\|Voice=Act`, `Case=Ine\|Degree=Pos\|Derivation=Inen\|Number=Plur\|POS=ADJ`, `Mood=Cnd\|Number=Plur\|POS=VERB\|Person=1\|VerbForm=Fin\|Voice=Act`, `Case=Gen\|Derivation=U\|Number=Sing\|POS=NOUN`, `Case=All\|Clitic=Kin\|Number=Sing\|POS=PROPN`, `Clitic=Kin\|Mood=Ind\|Number=Sing\|POS=AUX\|Person=3\|Tense=Pres\|VerbForm=Fin\|Voice=Act`, `Case=Ine\|Derivation=Vs\|Number=Plur\|POS=NOUN\|Person[psor]=3`, `Case=All\|Number=Sing\|POS=PRON\|Person[psor]=3\|Reflex=Yes`, `AdpType=Prep\|POS=ADP`, `Case=Par\|Derivation=U\|Number=Sing\|POS=NOUN`, `Case=Ine\|Number=Sing\|POS=PRON\|PronType=Int`, `Case=Nom\|Number=Sing\|POS=PRON\|Person=2\|PronType=Prs\|Style=Coll`, `Mood=Ind\|Number=Sing\|POS=AUX\|Person=2\|Tense=Pres\|VerbForm=Fin\|Voice=Act`, `Case=Nom\|Number=Sing\|POS=PRON\|PronType=Rcp`, `Clitic=Ko\|Mood=Ind\|Number=Sing\|POS=AUX\|Person=3\|Tense=Pres\|VerbForm=Fin\|Voice=Act`, `Case=Nom\|Derivation=Vs\|Number=Sing\|Number[psor]=Sing\|POS=NOUN\|Person[psor]=1`, `Case=Nom\|Number=Sing\|POS=PRON\|Person=1\|PronType=Prs\|Style=Coll`, `Case=Acc\|Number=Sing\|POS=PRON\|Person=2\|PronType=Prs\|Style=Coll`, `POS=INTJ`, `Case=Nom\|Derivation=Ja\|Number=Plur\|POS=NOUN`, `Case=Par\|Number=Plur\|POS=PRON\|Person=1\|PronType=Prs`, `Case=Ess\|Degree=Pos\|Derivation=Inen\|Number=Sing\|POS=ADJ`, `Case=Ade\|Number=Sing\|POS=PRON\|Person=2\|PronType=Prs\|Style=Coll`, `Case=Ine\|InfForm=3\|Number=Sing\|POS=AUX\|VerbForm=Inf\|Voice=Act`, `Case=Gen\|Degree=Pos\|Number=Sing\|Number[psor]=Sing\|POS=VERB\|PartForm=Pres\|Person[psor]=1\|VerbForm=Part\|Voice=Act`, `Case=Ela\|Clitic=Kin\|Number=Sing\|POS=PRON\|PronType=Dem`, `Clitic=Kin\|Mood=Ind\|Number=Sing\|POS=AUX\|Person=1\|Tense=Past\|VerbForm=Fin\|Voice=Act`, `Case=Gen\|Degree=Pos\|Number=Sing\|POS=VERB\|PartForm=Past\|VerbForm=Part\|Voice=Pass`, `Case=Gen\|Number=Sing\|POS=PRON\|Person=1\|PronType=Prs`, `Case=Ela\|Number=Plur\|POS=PRON\|PronType=Ind`, `Mood=Cnd\|Number=Sing\|POS=AUX\|Person=1\|VerbForm=Fin\|Voice=Act`, `Case=Ill\|Derivation=Inen,Vs\|Number=Sing\|POS=NOUN`, `Case=Ine\|Number=Plur\|POS=PRON\|PronType=Ind`, `Case=Nom\|Clitic=Kin\|Number=Sing\|POS=PRON\|PronType=Rcp`, `Case=Par\|Derivation=Lainen\|Number=Sing\|POS=ADJ`, `Case=Ela\|Number=Plur\|POS=PRON\|PronType=Dem`, `Case=Nom\|Number=Sing\|POS=NOUN\|Style=Coll`, `Case=Ine\|Number=Plur\|POS=PRON\|PronType=Rel`, `Case=Ela\|Degree=Sup\|Number=Sing\|POS=ADJ`, `Case=Nom\|Clitic=Kin\|Number=Sing\|POS=PRON\|PronType=Dem`, `Case=Abl\|Derivation=U\|Number=Sing\|POS=NOUN`, `Case=Ill\|Degree=Pos\|Number=Plur\|Number[psor]=Sing\|POS=VERB\|PartForm=Agt\|Person[psor]=1\|VerbForm=Part\|Voice=Act`, `Case=Abl\|Number=Sing\|POS=PRON\|PronType=Ind`, `Case=Abl\|Derivation=Ja\|Number=Sing\|POS=NOUN`, `Case=Tra\|Derivation=U\|Number=Sing\|POS=NOUN`, `Case=Ill\|Number=Sing\|POS=PRON\|PronType=Dem`, `Case=Abe\|InfForm=3\|Number=Sing\|POS=VERB\|VerbForm=Inf\|Voice=Act`, `Case=Ade\|Number=Sing\|POS=PRON\|Person=1\|PronType=Prs`, `Case=Tra\|Derivation=Ja\|Number=Sing\|POS=NOUN`, `Case=Ela\|Number=Sing\|POS=PRON\|Person=1\|PronType=Prs`, `Case=Ade\|Number=Sing\|POS=NOUN\|Person[psor]=3\|Typo=Yes`, `Case=Ela\|Number=Sing\|POS=PRON\|PronType=Rel`, `Case=Nom\|Degree=Sup\|Number=Sing\|POS=ADJ`, `Clitic=Kin\|Mood=Ind\|Number=Sing\|POS=VERB\|Person=1\|Tense=Past\|VerbForm=Fin\|Voice=Act`, `Case=Ine\|Degree=Pos\|Derivation=Lainen\|Number=Plur\|POS=ADJ`, `Case=All\|Derivation=Ja\|Number=Sing\|POS=NOUN`, `Case=Gen\|Number=Plur\|Number[psor]=Sing\|POS=NOUN\|Person[psor]=1`, `Case=Nom\|Degree=Pos\|Derivation=Ton\|Number=Plur\|POS=ADJ`, `Case=All\|Number=Plur\|POS=PRON\|Person=2\|PronType=Prs`, `Case=Abl\|Number=Sing\|POS=NOUN\|Person[psor]=3`, `Case=Gen\|Derivation=Lainen\|Number=Sing\|POS=NOUN`, `Mood=Imp\|Number=Plur\|POS=VERB\|Person=2\|VerbForm=Fin\|Voice=Act`, `Abbr=Yes\|Case=Nom\|Number=Sing\|POS=NOUN`, `Case=Nom\|Derivation=Vs\|Number=Plur\|POS=NOUN`, `Case=Par\|Number=Sing\|POS=PRON\|Person=1\|PronType=Prs`, `Case=Gen\|Number=Sing\|Number[psor]=Plur\|POS=NOUN\|Person[psor]=1`, `Clitic=Kin\|Mood=Cnd\|POS=AUX\|VerbForm=Fin\|Voice=Pass`, `Clitic=Han\|Mood=Ind\|Number=Plur\|POS=VERB\|Person=2\|Tense=Pres\|VerbForm=Fin\|Voice=Act`, `Case=Ela\|Degree=Sup\|Number=Plur\|POS=ADJ`, `Case=Par\|Degree=Pos\|Number=Sing\|POS=VERB\|PartForm=Past\|VerbForm=Part\|Voice=Pass`, `Case=Gen\|Number=Plur\|POS=PRON\|PronType=Ind`, `Mood=Ind\|Number=Plur\|POS=AUX\|Person=2\|Tense=Pres\|VerbForm=Fin\|Voice=Act`, `Case=Ela\|Derivation=U\|Number=Sing\|Number[psor]=Plur\|POS=NOUN\|Person[psor]=1`, `Case=Nom\|Clitic=Han\|Number=Sing\|POS=PRON\|PronType=Ind`, `Abbr=Yes\|Case=Gen\|Number=Sing\|POS=PROPN`, `Clitic=Kin\|Mood=Ind\|Number=Sing\|POS=AUX\|Person=3\|Tense=Past\|VerbForm=Fin\|Voice=Act`, `Case=All\|Derivation=Ja\|Number=Plur\|POS=NOUN`, `Clitic=Han\|Mood=Ind\|Number=Sing\|POS=AUX\|Person=0\|Tense=Past\|VerbForm=Fin\|Voice=Act`, `Derivation=Sti\|POS=ADV\|Typo=Yes`, `Case=All\|Number=Plur\|POS=PRON\|PronType=Ind`, `Case=Ill\|Number=Sing\|Number[psor]=Sing\|POS=NOUN\|Person[psor]=1`, `Case=Gen\|Derivation=Minen\|Number=Sing\|POS=NOUN`, `Case=Nom\|Derivation=Tar\|Number=Sing\|POS=NOUN`, `Clitic=Ko\|Mood=Ind\|Number=Sing\|POS=VERB\|Person=3\|Tense=Pres\|VerbForm=Fin\|Voice=Act`, `Case=Par\|Derivation=Minen\|Number=Plur\|POS=NOUN`, `Case=Ill\|Number=Plur\|Number[psor]=Sing\|POS=NOUN\|Person[psor]=1`, `Case=Nom\|Clitic=Kin\|Number=Sing\|Number[psor]=Sing\|POS=NOUN\|Person[psor]=1`, `Case=Ess\|Degree=Pos\|Number=Sing\|POS=VERB\|PartForm=Past\|VerbForm=Part\|Voice=Pass`, `Case=Ill\|Degree=Pos\|Derivation=Inen\|Number=Sing\|POS=ADJ\|Style=Coll`, `Case=Par\|Number=Plur\|POS=NOUN\|Person[psor]=3`, `Case=Nom\|Clitic=Kin\|Number=Sing\|POS=NOUN\|Style=Coll`, `Case=Ade\|Number=Sing\|POS=PROPN`, `Case=Nom\|Clitic=Han\|Number=Sing\|POS=PRON\|PronType=Dem`, `Case=Ess\|Derivation=Inen\|NumType=Ord\|Number=Sing\|POS=ADJ`, `Clitic=Ka\|Number=Sing\|POS=AUX\|Person=1\|Polarity=Neg\|VerbForm=Fin\|Voice=Act`, `Case=Nom\|Derivation=U\|Number=Sing\|Number[psor]=Sing\|POS=NOUN\|Person[psor]=1`, `Case=Gen\|Degree=Pos\|Number=Sing\|POS=VERB\|PartForm=Pres\|VerbForm=Part\|Voice=Pass`, `Case=Nom\|Degree=Pos\|Derivation=Inen\|Number=Plur\|POS=ADJ`, `Case=Nom\|Number=Plur\|POS=NOUN\|Style=Coll`, `Case=Ill\|Degree=Cmp\|Number=Plur\|POS=ADJ`, `Case=Nom\|Clitic=Kaan\|Degree=Pos\|Number=Sing\|POS=AUX\|PartForm=Past\|VerbForm=Part\|Voice=Act`, `Case=Par\|Number=Plur\|Number[psor]=Sing\|POS=NOUN\|Person[psor]=1`, `Case=Nom\|Degree=Pos\|Derivation=Llinen\|Number=Plur\|POS=ADJ`, `Case=Par\|Number=Sing\|POS=PROPN`, `Number=Sing\|POS=VERB\|Person=0\|Polarity=Neg\|VerbForm=Fin\|Voice=Act`, `Mood=Ind\|Number=Sing\|POS=VERB\|Person=2\|Tense=Pres\|VerbForm=Fin\|Voice=Act`, `Case=Ela\|Number=Sing\|POS=PRON\|PronType=Prs\|Style=Coll`, `Case=Ela\|Number=Sing\|POS=PROPN`, `Case=Nom\|Clitic=Pa\|Number=Sing\|POS=PRON\|Person=1\|PronType=Prs`, `Case=Ade\|Number=Sing\|Number[psor]=Sing\|POS=NOUN\|Person[psor]=1`, `Case=Par\|Degree=Pos\|Number=Plur\|POS=ADJ\|Typo=Yes`, `POS=ADV\|Style=Coll`, `Case=All\|Number=Sing\|Number[psor]=Sing\|POS=PRON\|Person[psor]=1\|Reflex=Yes`, `Case=Tra\|Degree=Pos\|Derivation=Llinen\|Number=Sing\|POS=ADJ`, `Case=Nom\|Degree=Pos\|Number=Plur\|Number[psor]=Sing\|POS=VERB\|PartForm=Agt\|Person[psor]=1\|VerbForm=Part\|Voice=Act`, `Case=Nom\|Number=Plur\|Number[psor]=Sing\|POS=NOUN\|Person[psor]=1`, `Case=Gen\|Degree=Pos\|Number=Sing\|POS=ADJ\|Person[psor]=3`, `Case=Par\|Degree=Pos\|Derivation=Llinen\|Number=Plur\|POS=ADJ`, `Mood=Ind\|POS=AUX\|Tense=Pres\|VerbForm=Fin\|Voice=Pass`, `Mood=Ind\|Number=Sing\|POS=AUX\|Person=0\|Tense=Past\|VerbForm=Fin\|Voice=Act`, `Case=All\|Number=Sing\|POS=NOUN\|Style=Coll`, `Clitic=Han\|Mood=Ind\|Number=Sing\|POS=AUX\|Person=3\|Tense=Pres\|VerbForm=Fin\|Voice=Act`, `Case=Gen\|Number=Sing\|POS=PRON\|PronType=Dem\|Typo=Yes`, `Case=Ine\|Derivation=Vs\|Number=Sing\|POS=NOUN\|Person[psor]=3`, `Case=Gen\|Degree=Sup\|Number=Sing\|POS=ADJ`, `Case=Par\|Degree=Pos\|Number=Plur\|POS=PRON\|PronType=Ind`, `Case=Par\|Degree=Pos\|Derivation=Ton\|Number=Plur\|POS=ADJ`, `Case=Ine\|Number=Plur\|POS=PRON\|PronType=Dem`, `Number=Plur\|POS=AUX\|Person=3\|Polarity=Neg\|VerbForm=Fin\|Voice=Act`, `Case=Nom\|Degree=Pos\|Number=Plur\|POS=AUX\|PartForm=Past\|VerbForm=Part\|Voice=Act`, `Case=Gen\|Number=Sing\|Number[psor]=Plur\|POS=NOUN\|Person[psor]=2`, `Mood=Ind\|Number=Plur\|POS=VERB\|Person=2\|Tense=Past\|VerbForm=Fin\|Voice=Act`, `Clitic=Kin\|Mood=Ind\|Number=Sing\|POS=VERB\|Person=3\|Tense=Pres\|VerbForm=Fin\|Voice=Act`, `Case=Gen\|Clitic=Kin\|Degree=Pos\|Number=Sing\|POS=ADJ`, `Case=Ade\|Number=Plur\|POS=NOUN\|Person[psor]=3`, `Case=All\|Derivation=Vs\|Number=Plur\|POS=NOUN`, `Case=Par\|NumType=Card\|Number=Plur\|POS=NUM\|Typo=Yes`, `Clitic=Ko\|Number=Sing\|POS=AUX\|Person=3\|Polarity=Neg\|VerbForm=Fin\|Voice=Act`, `Clitic=Kin\|Connegative=Yes\|Mood=Ind\|POS=AUX\|Tense=Pres\|VerbForm=Fin`, `Case=Ill\|NumType=Card\|Number=Plur\|POS=NUM`, `Case=Ela\|Number=Plur\|POS=PRON\|PronType=Rel`, `Case=Nom\|Number=Plur\|POS=PRON\|PronType=Rcp`, `Abbr=Yes\|Case=Abl\|Number=Sing\|POS=PROPN`, `Case=Abl\|Number=Sing\|POS=PROPN`, `Mood=Ind\|Number=Plur\|POS=VERB\|Person=2\|Tense=Pres\|VerbForm=Fin\|Voice=Act`, `Case=Ine\|Degree=Pos\|Derivation=Inen\|Number=Sing\|POS=ADJ`, `Case=Nom\|Clitic=Kin\|Number=Plur\|POS=NOUN`, `Case=Nom\|Degree=Pos\|Number=Plur\|POS=ADJ\|Typo=Yes`, `Case=Ade\|Clitic=Kin\|Number=Sing\|POS=NOUN`, `Case=Ade\|Degree=Cmp\|Derivation=Inen\|Number=Plur\|POS=ADJ`, `Case=Gen\|Degree=Cmp\|Number=Sing\|POS=ADJ`, `Case=Ine\|Degree=Pos\|Number=Plur\|POS=ADJ`, `Case=Nom\|Number=Sing\|POS=PRON\|PronType=Int`, `Case=Par\|Number=Plur\|POS=PRON\|Person=2\|PronType=Prs`, `Clitic=Kin\|Mood=Ind\|Number=Sing\|POS=AUX\|Person=1\|Tense=Pres\|VerbForm=Fin\|Voice=Act`, `Clitic=Kin\|Mood=Cnd\|Number=Sing\|POS=VERB\|Person=1\|VerbForm=Fin\|Voice=Act`, `Case=Nom\|NumType=Card\|Number=Plur\|POS=NUM\|Typo=Yes`, `Case=Ess\|Number=Sing\|POS=PRON\|PronType=Dem`, `Clitic=Han\|POS=ADV`, `Case=Par\|Derivation=Llinen\|Number=Sing\|POS=ADJ`, `Case=Gen\|Number=Sing\|Number[psor]=Sing\|POS=PRON\|Person[psor]=1\|Reflex=Yes`, `Case=Nom\|Clitic=Kin\|Degree=Pos\|Number=Sing\|POS=VERB\|PartForm=Past\|VerbForm=Part\|Voice=Act`, `Case=Par\|Derivation=Llinen\|Number=Sing\|POS=NOUN`, `Case=Nom\|Degree=Pos\|Number=Sing\|Number[psor]=Sing\|POS=VERB\|PartForm=Pres\|Person[psor]=1\|VerbForm=Part\|Voice=Act`, `Case=Abl\|Number=Plur\|POS=NOUN`, `Case=Abl\|Derivation=Lainen\|Number=Plur\|POS=NOUN`, `Case=Nom\|Degree=Pos\|Number=Plur\|POS=VERB\|PartForm=Past\|VerbForm=Part\|Voice=Pass`, `Case=All\|Number=Plur\|POS=PRON\|Person=1\|PronType=Prs`, `Case=Par\|Derivation=Llinen,Vs\|Number=Sing\|POS=NOUN`, `Case=Ine\|Number=Plur\|Number[psor]=Plur\|POS=NOUN\|Person[psor]=1`, `Case=Ela\|Number=Sing\|Number[psor]=Plur\|POS=NOUN\|Person[psor]=1`, `Case=Nom\|Degree=Pos\|Derivation=Ton\|Number=Sing\|POS=ADJ`, `Case=Par\|Derivation=Ton,Vs\|Number=Sing\|POS=NOUN`, `Number=Plur\|POS=AUX\|Person=1\|Polarity=Neg\|VerbForm=Fin\|Voice=Act`, `Case=Ill\|Number=Plur\|POS=PRON\|PronType=Rel`, `Case=Ela\|InfForm=3\|Number=Sing\|POS=VERB\|VerbForm=Inf\|Voice=Act`, `Case=Gen\|Derivation=Inen,Vs\|Number=Sing\|POS=NOUN`, `Case=All\|Number=Plur\|POS=PRON\|PronType=Dem`, `Case=Gen\|Derivation=Llinen,Vs\|Number=Sing\|POS=NOUN`, `Case=Par\|Number=Sing\|Number[psor]=Plur\|POS=NOUN\|Person[psor]=1`, `Case=Par\|Degree=Pos\|Derivation=Ton\|Number=Sing\|POS=ADJ`, `Case=Tra\|InfForm=1\|Number=Sing\|POS=VERB\|Person[psor]=3\|VerbForm=Inf\|Voice=Act`, `Number=Sing\|POS=AUX\|Person=2\|Polarity=Neg\|VerbForm=Fin\|Voice=Act`, `Case=Ill\|Degree=Pos\|Derivation=Inen\|Number=Sing\|POS=ADJ`, `Case=All\|Derivation=Minen\|Number=Sing\|POS=NOUN`, `Abbr=Yes\|Case=Ade\|Number=Sing\|POS=NOUN`, `Case=Gen\|Degree=Pos\|Number=Sing\|POS=VERB\|PartForm=Past\|Person[psor]=3\|VerbForm=Part\|Voice=Act`, `Case=Par\|Degree=Sup\|Number=Plur\|POS=ADJ`, `Case=Nom\|Degree=Pos\|Derivation=Inen\|Number=Plur\|Number[psor]=Sing\|POS=ADJ\|Person[psor]=1`, `Case=Nom\|Clitic=Kin\|Degree=Cmp\|Number=Plur\|POS=ADJ`, `Clitic=Kaan\|Mood=Ind\|Number=Sing\|POS=AUX\|Person=3\|Tense=Pres\|VerbForm=Fin\|Voice=Act`, `Case=Ine\|InfForm=2\|Number=Sing\|POS=VERB\|VerbForm=Inf\|Voice=Act`, `Case=Ill\|Derivation=Vs\|Number=Plur\|POS=NOUN`, `Case=Par\|Derivation=Vs\|Number=Plur\|POS=NOUN`, `Case=Ill\|Degree=Pos\|Number=Sing\|POS=VERB\|PartForm=Past\|VerbForm=Part\|Voice=Act`, `Case=All\|Number=Sing\|Number[psor]=Plur\|POS=PRON\|Person[psor]=1\|Reflex=Yes`, `Case=Nom\|Derivation=Llinen,Vs\|Number=Sing\|POS=NOUN`, `Number=Plur\|POS=SCONJ\|Person=1\|Polarity=Neg\|VerbForm=Fin\|Voice=Act`, `Case=Nom\|Number=Plur\|POS=PRON\|Person=1\|PronType=Prs`, `Case=Nom\|Number=Plur\|Number[psor]=Plur\|POS=NOUN\|Person[psor]=1`, `Case=Ela\|Degree=Pos\|Derivation=Lainen\|Number=Plur\|POS=ADJ`, `Case=Ill\|Number=Sing\|Number[psor]=Plur\|POS=PRON\|Person[psor]=1\|Reflex=Yes`, `Case=Ill\|Number=Plur\|Number[psor]=Plur\|POS=NOUN\|Person[psor]=1`, `Case=Ela\|NumType=Card\|Number=Sing\|POS=NUM`, `Case=All\|Number=Sing\|POS=PRON\|Person=2\|PronType=Prs`, `Case=Nom\|Clitic=Kin\|Number=Sing\|POS=PRON\|Person=1\|PronType=Prs`, `Case=Gen\|Clitic=Kin\|Number=Sing\|POS=NOUN`, `Case=Nom\|Degree=Pos\|Number=Plur\|POS=VERB\|PartForm=Past\|Typo=Yes\|VerbForm=Part\|Voice=Act`, `Case=Nom\|Clitic=Kin\|Number=Plur\|POS=PRON\|Person=3\|PronType=Prs`, `Case=Gen\|Derivation=U\|Number=Sing\|Number[psor]=Sing\|POS=NOUN\|Person[psor]=1`, `Case=Abl\|Degree=Pos\|Number=Sing\|POS=ADJ`, `Case=Ess\|Number=Sing\|POS=PRON\|PronType=Ind`, `Case=Ela\|Number=Plur\|POS=PRON\|Person=1\|PronType=Prs`, `Case=Ela\|Number=Sing\|Number[psor]=Plur\|POS=PRON\|Person[psor]=1\|Reflex=Yes`, `Case=Gen\|Derivation=Minen\|Number=Plur\|POS=NOUN`, `Case=Gen\|Degree=Pos\|Number=Plur\|POS=VERB\|PartForm=Past\|VerbForm=Part\|Voice=Act`, `Case=Par\|Degree=Pos\|Number=Plur\|POS=VERB\|PartForm=Pres\|VerbForm=Part\|Voice=Pass`, `Clitic=Ko\|Number=Sing\|POS=VERB\|Person=0\|Polarity=Neg\|VerbForm=Fin\|Voice=Act`, `Case=Ade\|InfForm=3\|Number=Sing\|POS=AUX\|VerbForm=Inf\|Voice=Act`, `Case=Gen\|Clitic=Han\|Number=Sing\|POS=NOUN`, `Case=Ill\|Number=Plur\|POS=PRON\|PronType=Dem`, `Case=Ess\|Degree=Pos\|Derivation=Inen\|Number=Plur\|POS=ADJ`, `Case=Ela\|Derivation=Vs\|Number=Sing\|POS=NOUN`, `Case=Nom\|Number=Sing\|POS=PRON\|Reflex=Yes`, `Case=Par\|Degree=Pos\|Number=Sing\|POS=VERB\|PartForm=Past\|VerbForm=Part\|Voice=Act`, `Clitic=Kaan\|Connegative=Yes\|Mood=Ind\|POS=AUX\|Tense=Pres\|VerbForm=Fin`, `Degree=Sup\|Derivation=Sti\|POS=ADV`, `Case=Ine\|Derivation=Llinen,Vs\|Number=Sing\|POS=NOUN`, `Case=Tra\|Degree=Pos\|Number=Plur\|POS=VERB\|PartForm=Past\|VerbForm=Part\|Voice=Pass`, `Case=Par\|Derivation=Inen,Vs\|Number=Plur\|POS=NOUN`, _(truncated: full list in pipeline meta)_ |
| **`parser`** | `ROOT`, `acl`, `acl:relcl`, `advcl`, `advmod`, `amod`, `appos`, `aux`, `aux:pass`, `case`, `cc`, `cc:preconj`, `ccomp`, `compound`, `compound:nn`, `compound:prt`, `conj`, `cop`, `cop:own`, `csubj`, `csubj:cop`, `dep`, `det`, `discourse`, `fixed`, `flat`, `flat:foreign`, `flat:name`, `mark`, `nmod`, `nmod:gobj`, `nmod:gsubj`, `nmod:poss`, `nsubj`, `nsubj:cop`, `nummod`, `obj`, `obl`, `orphan`, `parataxis`, `punct`, `vocative`, `xcomp`, `xcomp:ds` |
| **`ner`** | `CARDINAL`, `DATE`, `EVENT`, `FAC`, `GPE`, `LANGUAGE`, `LAW`, `LOC`, `MONEY`, `NORP`, `ORDINAL`, `ORG`, `PERCENT`, `PERSON`, `PRODUCT`, `QUANTITY`, `TIME`, `WORK_OF_ART` |

</details>

### Accuracy

| Type | Score |
| --- | --- |
| `TOKEN_ACC` | 100.00 |
| `TOKEN_P` | 99.79 |
| `TOKEN_R` | 99.90 |
| `TOKEN_F` | 99.85 |
| `TAG_ACC` | 93.37 |
| `POS_ACC` | 92.57 |
| `MORPH_ACC` | 86.11 |
| `MORPH_MICRO_P` | 91.95 |
| `MORPH_MICRO_R` | 90.24 |
| `MORPH_MICRO_F` | 91.09 |
| `SENTS_P` | 91.29 |
| `SENTS_R` | 89.88 |
| `SENTS_F` | 90.58 |
| `DEP_UAS` | 79.52 |
| `DEP_LAS` | 72.48 |
| `LEMMA_ACC` | 82.78 |
| `ENTS_P` | 78.67 |
| `ENTS_R` | 73.42 |
| `ENTS_F` | 75.96 |