### Details: https://spacy.io/models/uk#uk_core_news_sm

Ukrainian pipeline optimized for CPU. Components: tok2vec, morphologizer, parser, senter, ner, attribute_ruler, lemmatizer.

| Feature | Description |
| --- | --- |
| **Name** | `uk_core_news_sm` |
| **Version** | `3.5.0` |
| **spaCy** | `>=3.5.0,<3.6.0` |
| **Default Pipeline** | `tok2vec`, `morphologizer`, `parser`, `attribute_ruler`, `lemmatizer`, `ner` |
| **Components** | `tok2vec`, `morphologizer`, `parser`, `senter`, `attribute_ruler`, `lemmatizer`, `ner` |
| **Vectors** | 0 keys, 0 unique vectors (0 dimensions) |
| **Sources** | [Ukr-Synth (e5d9eaf3)](https://huggingface.co/datasets/ukr-models/Ukr-Synth) (Volodymyr Kurnosov) |
| **License** | `MIT` |
| **Author** | [Explosion](https://explosion.ai) |

### Label Scheme

<details>

<summary>View label scheme (1211 labels for 3 components)</summary>

| Component | Labels |
| --- | --- |
| **`morphologizer`** | `POS=CCONJ`, `Degree=Cmp\|POS=ADV`, `Aspect=Imp\|Mood=Ind\|Number=Plur\|POS=VERB\|Person=3\|Tense=Pres\|VerbForm=Fin`, `Animacy=Inan\|Case=Nom\|Gender=Fem\|Number=Plur\|POS=NOUN`, `Animacy=Inan\|Case=Gen\|Gender=Masc\|Number=Sing\|POS=NOUN`, `Animacy=Inan\|Case=Ins\|Gender=Fem\|Number=Sing\|POS=NOUN`, `POS=PUNCT`, `Case=Gen\|Number=Plur\|POS=DET\|PronType=Dem`, `Animacy=Inan\|Case=Gen\|Gender=Fem\|Number=Plur\|POS=NOUN`, `POS=ADV\|PronType=Rel`, `POS=PART`, `Aspect=Imp\|Mood=Ind\|Number=Plur\|POS=VERB\|Tense=Past\|VerbForm=Fin`, `Aspect=Imp\|POS=VERB\|VerbForm=Inf`, `Animacy=Inan\|Case=Nom\|Gender=Masc\|Number=Plur\|POS=NOUN`, `Animacy=Anim\|Case=Nom\|Gender=Masc\|Number=Plur\|POS=NOUN`, `Animacy=Inan\|Case=Acc\|Gender=Masc\|Number=Plur\|POS=NOUN`, `Case=Loc\|POS=ADP`, `Case=Loc\|Gender=Masc\|Number=Sing\|POS=ADJ`, `Animacy=Inan\|Case=Loc\|Gender=Masc\|Number=Sing\|POS=NOUN`, `Animacy=Anim\|Case=Nom\|Gender=Masc\|Number=Sing\|POS=NOUN`, `Animacy=Anim\|Case=Nom\|Gender=Masc\|NameType=Giv\|Number=Sing\|POS=PROPN`, `Animacy=Anim\|Case=Nom\|Gender=Masc\|NameType=Sur\|Number=Sing\|POS=PROPN`, `POS=ADV`, `Aspect=Imp\|Gender=Masc\|Mood=Ind\|Number=Sing\|POS=VERB\|Tense=Past\|VerbForm=Fin`, `Animacy=Inan\|Case=Loc\|Gender=Masc\|Number=Plur\|POS=NOUN`, `Case=Gen\|POS=ADP`, `Animacy=Inan\|Case=Gen\|Gender=Neut\|Number=Sing\|POS=PRON\|PronType=Dem`, `Case=Loc\|Gender=Masc\|NumType=Ord\|Number=Sing\|POS=ADJ\|Uninflect=Yes`, `Abbr=Yes\|Animacy=Inan\|Case=Loc\|Gender=Masc\|Number=Sing\|POS=NOUN\|Uninflect=Yes`, `Case=Nom\|NumType=Card\|POS=DET\|PronType=Ind`, `Animacy=Anim\|Case=Gen\|Gender=Masc\|Number=Plur\|POS=NOUN`, `Animacy=Inan\|Case=Acc\|Gender=Neut\|Number=Sing\|POS=NOUN`, `Case=Gen\|Number=Plur\|POS=ADJ`, `Animacy=Inan\|Case=Gen\|Gender=Neut\|Number=Plur\|POS=NOUN`, `Case=Loc\|Number=Plur\|POS=ADJ`, `POS=SCONJ`, `Aspect=Imp\|Mood=Ind\|Number=Sing\|POS=VERB\|Person=3\|Tense=Pres\|VerbForm=Fin`, `Aspect=Perf\|POS=VERB\|VerbForm=Inf`, `Degree=Pos\|POS=ADV`, `Aspect=Imp\|Mood=Ind\|Number=Sing\|POS=VERB\|Person=1\|Tense=Pres\|VerbForm=Fin`, `Animacy=Anim\|Case=Nom\|Number=Plur\|POS=PRON\|Person=2\|PronType=Prs`, `Aspect=Perf\|Mood=Ind\|Number=Plur\|POS=VERB\|Person=2\|Tense=Fut\|VerbForm=Fin`, `Animacy=Inan\|Case=Acc\|Gender=Masc\|Number=Sing\|POS=DET\|Poss=Yes\|PronType=Prs\|Reflex=Yes`, `Animacy=Inan\|Case=Acc\|Gender=Masc\|Number=Sing\|POS=NOUN`, `Case=Loc\|Gender=Neut\|Number=Sing\|POS=DET\|PronType=Dem`, `Animacy=Inan\|Case=Loc\|Gender=Neut\|Number=Sing\|POS=NOUN`, `Animacy=Inan\|Case=Acc\|Gender=Masc\|Number=Sing\|POS=DET\|PronType=Dem`, `Animacy=Inan\|Case=Acc\|Degree=Pos\|Gender=Masc\|Number=Sing\|POS=ADJ`, `Animacy=Inan\|Case=Acc\|Gender=Masc\|Number=Sing\|POS=ADJ`, `Aspect=Perf\|Mood=Ind\|POS=VERB\|Person=0\|VerbForm=Fin`, `Case=Gen\|Gender=Masc\|NumType=Ord\|Number=Sing\|POS=ADJ\|Uninflect=Yes`, `Animacy=Inan\|Case=Loc\|Gender=Fem\|Number=Sing\|POS=PROPN`, `Aspect=Imp\|Mood=Ind\|Number=Plur\|POS=VERB\|Person=1\|Tense=Pres\|VerbForm=Fin`, `Animacy=Anim\|Case=Acc\|Number=Plur\|POS=DET\|PronType=Tot`, `POS=PART\|Polarity=Neg`, `Animacy=Inan\|Case=Gen\|Gender=Neut\|Number=Plur\|POS=NOUN\|Uninflect=Yes`, `Animacy=Inan\|Case=Gen\|Gender=Fem\|Number=Sing\|POS=NOUN`, `POS=PUNCT\|PunctType=Quot`, `POS=PUNCT\|PunctType=Dash`, `Aspect=Perf\|Gender=Masc\|Mood=Ind\|Number=Sing\|POS=VERB\|Tense=Past\|VerbForm=Fin`, `POS=ADV\|PronType=Dem`, `Animacy=Inan\|Case=Nom\|Gender=Fem\|Number=Sing\|POS=NOUN`, `Animacy=Inan\|Case=Gen\|Gender=Fem\|Number=Sing\|POS=PROPN`, `Case=Acc\|POS=ADP`, `Animacy=Inan\|Case=Acc\|Gender=Fem\|Number=Sing\|POS=NOUN`, `Case=Gen\|Gender=Masc\|Number=Sing\|POS=DET\|PronType=Ind`, `Aspect=Perf\|Case=Gen\|Gender=Masc\|Number=Sing\|POS=ADJ\|VerbForm=Part\|Voice=Pass`, `Animacy=Inan\|Case=Gen\|Gender=Neut\|Number=Sing\|POS=NOUN`, `Foreign=Yes\|POS=X`, `Aspect=Perf\|Mood=Ind\|Number=Plur\|POS=VERB\|Tense=Past\|VerbForm=Fin`, `Case=Ins\|POS=ADP`, `Animacy=Inan\|Case=Ins\|Gender=Fem\|Number=Plur\|POS=NOUN`, `Animacy=Inan\|Case=Acc\|Gender=Neut\|Number=Sing\|POS=PRON\|PronType=Dem`, `Case=Nom\|Number=Plur\|POS=ADJ`, `Animacy=Anim\|Case=Nom\|Gender=Fem\|Number=Plur\|POS=NOUN`, `Abbr=Yes\|Animacy=Inan\|Case=Gen\|Gender=Neut\|Number=Sing\|POS=NOUN\|Uninflect=Yes`, `Animacy=Inan\|Case=Nom\|Gender=Masc\|Number=Sing\|POS=NOUN`, `Animacy=Inan\|Case=Nom\|Gender=Fem\|Number=Sing\|POS=PROPN`, `Animacy=Inan\|Case=Acc\|Number=Ptan\|POS=NOUN`, `Case=Nom\|Number=Plur\|POS=DET\|PronType=Rel`, `Case=Ins\|Number=Plur\|POS=PRON\|Person=3\|PronType=Prs`, `Aspect=Imp\|Mood=Ind\|Number=Plur\|POS=AUX\|Tense=Past\|VerbForm=Fin`, `Aspect=Perf\|Case=Nom\|Number=Plur\|POS=ADJ\|VerbForm=Part\|Voice=Pass`, `Aspect=Perf\|Case=Nom\|Gender=Masc\|Number=Sing\|POS=ADJ\|VerbForm=Part\|Voice=Pass`, `Case=Nom\|Number=Plur\|POS=DET\|Person=3\|Poss=Yes\|PronType=Prs\|Uninflect=Yes`, `Animacy=Inan\|Case=Nom\|Gender=Neut\|Number=Plur\|POS=NOUN`, `Aspect=Imp\|Gender=Masc\|Mood=Ind\|Number=Sing\|POS=AUX\|Tense=Past\|VerbForm=Fin`, `Case=Ins\|Degree=Pos\|Gender=Masc\|Number=Sing\|POS=ADJ`, `Animacy=Inan\|Case=Dat\|POS=PRON\|PronType=Neg`, `Case=Nom\|Degree=Pos\|Number=Plur\|POS=ADJ`, `Animacy=Anim\|Case=Acc\|Gender=Masc\|Number=Plur\|POS=NOUN`, `POS=SPACE`, `Case=Nom\|Gender=Fem\|Number=Sing\|POS=DET\|PronType=Tot`, `Case=Ins\|Gender=Fem\|Number=Sing\|POS=ADJ`, `Animacy=Inan\|Case=Ins\|Gender=Masc\|Number=Sing\|POS=NOUN`, `Animacy=Inan\|Case=Nom\|Gender=Neut\|Number=Sing\|POS=PRON\|PronType=Dem`, `Case=Nom\|Gender=Masc\|Number=Sing\|POS=ADJ`, `Case=Gen\|Degree=Pos\|Number=Plur\|POS=ADJ`, `Aspect=Perf\|Mood=Ind\|Number=Sing\|POS=VERB\|Person=3\|Tense=Fut\|VerbForm=Fin`, `Case=Ins\|Gender=Masc\|Number=Sing\|POS=ADJ`, `Aspect=Perf\|POS=VERB\|Tense=Past\|VerbForm=Conv`, `Animacy=Inan\|Case=Acc\|Gender=Fem\|Number=Plur\|POS=NOUN`, `Aspect=Imp\|Case=Gen\|Gender=Neut\|Number=Sing\|POS=ADJ\|VerbForm=Part\|Voice=Pass`, `Aspect=Perf\|Mood=Ind\|Number=Plur\|POS=VERB\|Person=3\|Tense=Fut\|VerbForm=Fin`, `Case=Acc\|Degree=Cmp\|Gender=Fem\|Number=Sing\|POS=ADJ`, `Animacy=Inan\|Case=Loc\|Gender=Fem\|Number=Sing\|POS=NOUN`, `Animacy=Inan\|Case=Acc\|Degree=Pos\|Number=Plur\|POS=ADJ`, `Case=Loc\|Degree=Pos\|Gender=Fem\|Number=Sing\|POS=ADJ`, `Animacy=Anim\|Case=Gen\|Number=Plur\|POS=PRON\|Person=2\|PronType=Prs`, `Case=Nom\|NumType=Card\|POS=DET\|PronType=Dem`, `Animacy=Anim\|Case=Gen\|Number=Ptan\|POS=NOUN`, `Animacy=Inan\|Case=Loc\|Gender=Masc\|Number=Sing\|POS=PROPN`, `Case=Gen\|Gender=Masc\|Number=Sing\|POS=ADJ`, `Animacy=Anim\|Case=Acc\|Gender=Fem\|Number=Sing\|POS=NOUN`, `Aspect=Perf\|Case=Gen\|Number=Plur\|POS=ADJ\|VerbForm=Part\|Voice=Pass`, `Case=Nom\|Gender=Fem\|Number=Sing\|POS=PRON\|Person=3\|PronType=Prs`, `Aspect=Perf\|Gender=Fem\|Mood=Ind\|Number=Sing\|POS=VERB\|Tense=Past\|VerbForm=Fin`, `Animacy=Inan\|Case=Gen\|Number=Ptan\|POS=NOUN`, `Abbr=Yes\|Animacy=Anim\|Case=Nom\|Gender=Masc\|NameType=Giv\|Number=Sing\|POS=PROPN\|Uninflect=Yes`, `Abbr=Yes\|Animacy=Anim\|Case=Nom\|Gender=Masc\|NameType=Sur\|Number=Sing\|POS=PROPN\|Uninflect=Yes`, `Animacy=Anim\|Case=Nom\|Gender=Masc\|Number=Sing\|POS=PRON\|PronType=Int`, `Animacy=Inan\|Case=Nom\|Gender=Neut\|Number=Sing\|POS=PRON\|PronType=Int`, `Case=Acc\|Gender=Neut\|Number=Sing\|POS=ADJ`, `Case=Nom\|Gender=Fem\|Number=Sing\|POS=ADJ`, `Animacy=Anim\|Case=Nom\|Number=Plur\|POS=PRON\|Person=1\|PronType=Prs`, `Animacy=Inan\|Case=Acc\|Number=Plur\|POS=ADJ`, `Animacy=Inan\|Case=Nom\|Gender=Masc\|Number=Sing\|POS=PROPN\|Uninflect=Yes`, `Aspect=Perf\|Mood=Ind\|Number=Plur\|POS=VERB\|Person=1\|Tense=Fut\|VerbForm=Fin`, `Case=Gen\|Gender=Fem\|Number=Sing\|POS=ADJ`, `Case=Acc\|Gender=Neut\|NumType=Ord\|Number=Sing\|POS=ADJ\|Uninflect=Yes`, `Animacy=Inan\|Case=Dat\|Gender=Neut\|Number=Sing\|POS=NOUN`, `Case=Nom\|Gender=Fem\|Number=Sing\|POS=DET\|PronType=Rel`, `Animacy=Anim\|Case=Gen\|Gender=Fem\|Number=Sing\|POS=NOUN`, `Aspect=Perf\|Case=Loc\|Degree=Pos\|Gender=Masc\|Number=Sing\|POS=ADJ\|VerbForm=Part\|Voice=Pass`, `Animacy=Anim\|Case=Gen\|Gender=Masc\|Number=Sing\|POS=NOUN`, `Case=Gen\|Degree=Pos\|Gender=Masc\|Number=Sing\|POS=ADJ`, `Case=Nom\|NumType=Card\|POS=NUM\|Uninflect=Yes`, `Case=Nom\|Degree=Pos\|Gender=Neut\|Number=Sing\|POS=ADJ`, `Animacy=Inan\|Case=Nom\|Gender=Neut\|Number=Sing\|POS=NOUN`, `Animacy=Inan\|Case=Acc\|Number=Plur\|POS=DET\|PronType=Tot`, `Case=Ins\|Gender=Masc\|Number=Sing\|POS=DET\|PronType=Dem`, `Animacy=Inan\|Case=Gen\|Gender=Masc\|Number=Sing\|POS=PROPN`, `Abbr=Yes\|Animacy=Inan\|Case=Acc\|Gender=Masc\|Number=Sing\|POS=PROPN\|Uninflect=Yes`, `Animacy=Anim\|Case=Nom\|Gender=Fem\|Number=Sing\|POS=NOUN`, `Animacy=Anim\|Case=Nom\|Gender=Fem\|NameType=Giv\|Number=Sing\|POS=PROPN`, `Animacy=Anim\|Case=Nom\|Gender=Fem\|NameType=Sur\|Number=Sing\|POS=PROPN`, `Animacy=Anim\|Case=Dat\|Gender=Masc\|Number=Sing\|POS=NOUN`, `Animacy=Anim\|Case=Acc\|Gender=Fem\|NameType=Giv\|Number=Sing\|POS=PROPN`, `Animacy=Anim\|Case=Acc\|Gender=Fem\|NameType=Sur\|Number=Sing\|POS=PROPN`, `Case=Acc\|Gender=Masc\|Number=Sing\|POS=DET\|Person=3\|Poss=Yes\|PronType=Prs\|Uninflect=Yes`, `Animacy=Anim\|Case=Nom\|Number=Sing\|POS=PRON\|Person=1\|PronType=Prs`, `Animacy=Inan\|Case=Acc\|Gender=Fem\|Number=Sing\|POS=PROPN`, `Case=Acc\|Degree=Pos\|Gender=Fem\|Number=Sing\|POS=ADJ`, `Animacy=Anim\|Case=Ins\|Gender=Masc\|Number=Sing\|POS=NOUN`, `Animacy=Inan\|Case=Gen\|Gender=Masc\|Number=Plur\|POS=NOUN`, `Animacy=Inan\|Case=Nom\|Gender=Neut\|Number=Sing\|POS=NOUN\|Uninflect=Yes`, `Animacy=Inan\|Case=Gen\|Gender=Neut\|Number=Sing\|POS=NOUN\|Uninflect=Yes`, `Case=Loc\|Number=Plur\|POS=DET\|PronType=Ind`, `Animacy=Inan\|Case=Loc\|Gender=Neut\|Number=Sing\|POS=NOUN\|Uninflect=Yes`, `Animacy=Inan\|Case=Loc\|Gender=Fem\|Number=Plur\|POS=NOUN`, `Case=Ins\|Number=Plur\|POS=ADJ`, `Case=Gen\|NumType=Card\|POS=NUM\|Uninflect=Yes`, `Animacy=Anim\|Case=Gen\|Gender=Fem\|Number=Plur\|POS=NOUN`, `Case=Ins\|Gender=Masc\|Number=Sing\|POS=PRON\|Person=3\|PronType=Prs`, `Animacy=Anim\|Case=Dat\|Gender=Fem\|NameType=Giv\|Number=Sing\|POS=PROPN`, `Animacy=Anim\|Case=Nom\|Gender=Fem\|NameType=Sur\|Number=Sing\|POS=PROPN\|Uninflect=Yes`, `Abbr=Yes\|Animacy=Inan\|Case=Nom\|Gender=Neut\|Number=Sing\|POS=PROPN\|Uninflect=Yes`, `Animacy=Anim\|Case=Ins\|Gender=Masc\|Number=Plur\|POS=NOUN`, `Aspect=Perf\|Case=Acc\|Gender=Neut\|Number=Sing\|POS=ADJ\|VerbForm=Part\|Voice=Pass`, `Aspect=Imp\|Mood=Imp\|Number=Plur\|POS=VERB\|Person=2\|VerbForm=Fin`, `Case=Loc\|Gender=Neut\|NumType=Ord\|Number=Sing\|POS=ADJ\|Uninflect=Yes`, `Abbr=Yes\|Animacy=Inan\|Case=Loc\|Gender=Neut\|Number=Sing\|POS=NOUN\|Uninflect=Yes`, `Case=Acc\|NumType=Card\|POS=DET\|PronType=Ind`, `Case=Nom\|Gender=Masc\|Number=Sing\|POS=PRON\|Person=3\|PronType=Prs`, `Abbr=Yes\|Animacy=Inan\|Case=Ins\|Gender=Masc\|Number=Sing\|POS=NOUN\|Uninflect=Yes`, `Animacy=Inan\|Case=Ins\|Gender=Masc\|Number=Plur\|POS=NOUN`, `Case=Ins\|Gender=Masc\|Number=Sing\|POS=DET\|PronType=Tot`, `Case=Nom\|Degree=Pos\|Gender=Fem\|Number=Sing\|POS=ADJ`, `Case=Acc\|NumType=Card\|POS=NUM\|Uninflect=Yes`, `Animacy=Inan\|Case=Acc\|Gender=Fem\|NumType=Card\|Number=Plur\|POS=NOUN`, `Case=Gen\|Degree=Cmp\|Number=Plur\|POS=ADJ`, `Case=Acc\|Gender=Fem\|Number=Sing\|POS=DET\|Person=1\|Poss=Yes\|PronType=Prs`, `Case=Gen\|Number=Plur\|POS=DET\|Person=3\|Poss=Yes\|PronType=Prs`, `Animacy=Inan\|Case=Acc\|Degree=Pos\|Gender=Masc\|NumType=Ord\|Number=Sing\|POS=ADJ`, `Case=Ins\|Gender=Masc\|Number=Sing\|POS=DET\|PronType=Rel`, `Case=Acc\|Gender=Fem\|Number=Sing\|POS=DET\|PronType=Tot`, `Case=Acc\|Gender=Fem\|Number=Sing\|POS=ADJ`, `Case=Nom\|Number=Plur\|POS=DET\|PronType=Dem`, `Animacy=Anim\|Case=Nom\|Gender=Masc\|Number=Sing\|POS=PRON\|PronType=Rel`, `Degree=Abs\|POS=ADV`, `Animacy=Anim\|Case=Acc\|Gender=Masc\|Number=Sing\|POS=NOUN`, `Case=Nom\|Gender=Masc\|Number=Sing\|POS=DET\|PronType=Tot\|Variant=Short`, `Case=Dat\|Gender=Masc\|Number=Sing\|POS=PRON\|Person=3\|PronType=Prs`, `Case=Acc\|Gender=Fem\|Number=Sing\|POS=DET\|PronType=Dem`, `Hyph=Yes\|POS=ADJ\|Variant=Short`, `Case=Nom\|Degree=Sup\|Gender=Fem\|Number=Sing\|POS=ADJ`, `Degree=Sup\|POS=ADV`, `Case=Gen\|Gender=Masc\|Number=Sing\|POS=DET\|PronType=Dem`, `Case=Nom\|Gender=Fem\|Number=Sing\|POS=DET\|PronType=Dem`, `Animacy=Inan\|Case=Ins\|Gender=Neut\|Number=Sing\|POS=PRON\|PronType=Dem`, `Case=Acc\|Gender=Fem\|Number=Sing\|POS=PRON\|Person=3\|PronType=Prs`, `Case=Nom\|Gender=Neut\|Number=Sing\|POS=ADJ`, `Abbr=Yes\|Animacy=Inan\|Case=Nom\|Gender=Masc\|Number=Sing\|POS=PROPN\|Uninflect=Yes`, `Animacy=Inan\|Case=Acc\|Number=Plur\|POS=DET\|PronType=Rel`, `Abbr=Yes\|Animacy=Inan\|Case=Gen\|Gender=Fem\|Number=Sing\|POS=PROPN\|Uninflect=Yes`, `Case=Loc\|Gender=Fem\|Number=Sing\|POS=ADJ`, `Abbr=Yes\|Animacy=Anim\|Case=Ins\|Gender=Fem\|Number=Sing\|POS=PROPN\|Uninflect=Yes`, `Case=Acc\|Gender=Fem\|Number=Sing\|POS=DET\|Poss=Yes\|PronType=Prs\|Reflex=Yes`, `Case=Loc\|Degree=Pos\|Number=Plur\|POS=ADJ`, `Case=Gen\|Degree=Pos\|Gender=Fem\|Number=Sing\|POS=ADJ`, `Abbr=Yes\|Animacy=Inan\|Case=Gen\|Gender=Fem\|Number=Sing\|POS=NOUN\|Uninflect=Yes`, `Animacy=Inan\|Case=Nom\|Gender=Masc\|Number=Sing\|POS=PROPN`, `Animacy=Inan\|Case=Gen\|Number=Ptan\|POS=PROPN`, `Aspect=Imp\|Mood=Ind\|Number=Sing\|POS=VERB\|Person=3\|Polarity=Neg\|Tense=Pres\|VerbForm=Fin`, `Aspect=Imp\|POS=AUX\|VerbForm=Inf`, `Aspect=Imp\|Gender=Neut\|Mood=Ind\|Number=Sing\|POS=VERB\|Tense=Past\|VerbForm=Fin`, `Animacy=Inan\|Case=Nom\|Number=Plur\|POS=PROPN\|Uninflect=Yes`, `Case=Dat\|Gender=Masc\|Number=Sing\|POS=DET\|PronType=Dem`, `Case=Dat\|Degree=Pos\|Gender=Masc\|Number=Sing\|POS=ADJ`, `Animacy=Inan\|Case=Dat\|Gender=Masc\|Number=Sing\|POS=NOUN`, `POS=INTJ`, `Case=Acc\|Gender=Fem\|NumType=Ord\|Number=Sing\|POS=ADJ`, `Aspect=Imp\|Case=Acc\|Gender=Fem\|Number=Sing\|POS=ADJ\|VerbForm=Part\|Voice=Pass`, `Case=Loc\|Gender=Fem\|NumType=Ord\|Number=Sing\|POS=ADJ`, `Aspect=Imp\|Mood=Ind\|Number=Sing\|POS=AUX\|Person=3\|Tense=Fut\|VerbForm=Fin`, `Case=Acc\|Gender=Neut\|Number=Sing\|POS=DET\|PronType=Rel`, `Aspect=Perf\|Gender=Neut\|Mood=Ind\|Number=Sing\|POS=VERB\|Tense=Past\|VerbForm=Fin`, `Case=Dat\|Number=Plur\|POS=ADJ`, `Animacy=Inan\|Case=Dat\|Gender=Fem\|Number=Plur\|POS=NOUN`, `Abbr=Yes\|Animacy=Inan\|Case=Nom\|Gender=Neut\|Number=Sing\|POS=NOUN\|Uninflect=Yes`, `Case=Dat\|Gender=Fem\|Number=Sing\|POS=ADJ`, `Animacy=Inan\|Case=Dat\|Gender=Fem\|Number=Sing\|POS=NOUN`, `Case=Acc\|Number=Plur\|POS=PRON\|Person=3\|PronType=Prs`, `Animacy=Inan\|Case=Gen\|Foreign=Yes\|Gender=Masc\|Number=Sing\|POS=X\|Uninflect=Yes`, `Aspect=Imp\|Gender=Neut\|Mood=Ind\|Number=Sing\|POS=AUX\|Tense=Past\|VerbForm=Fin`, `Case=Acc\|Gender=Fem\|NumType=Card\|POS=NUM\|Uninflect=Yes`, `Animacy=Inan\|Case=Acc\|Gender=Neut\|Number=Plur\|POS=NOUN\|Uninflect=Yes`, `Case=Loc\|NumType=Card\|POS=NUM\|Uninflect=Yes`, `Aspect=Perf\|Case=Loc\|Number=Plur\|POS=ADJ\|VerbForm=Part\|Voice=Pass`, `Animacy=Anim\|Case=Dat\|Gender=Masc\|Number=Plur\|POS=NOUN`, `Animacy=Anim\|Case=Gen\|Number=Plur\|POS=PRON\|Person=1\|PronType=Prs`, `Case=Ins\|Gender=Fem\|Number=Sing\|POS=DET\|PronType=Ind`, `Animacy=Inan\|Case=Gen\|Gender=Neut\|Number=Sing\|POS=PRON\|PronType=Ind`, `Animacy=Inan\|Case=Nom\|Gender=Neut\|Number=Sing\|POS=PRON\|PronType=Rel`, `Animacy=Anim\|Case=Ins\|Number=Plur\|POS=PRON\|Person=1\|PronType=Prs`, `Case=Nom\|Gender=Masc\|Number=Sing\|POS=DET\|PronType=Rel`, `Animacy=Anim\|Case=Dat\|Gender=Fem\|Number=Plur\|POS=NOUN`, `Animacy=Anim\|Case=Gen\|Gender=Masc\|NameType=Giv\|Number=Sing\|POS=PROPN`, `Animacy=Anim\|Case=Gen\|Gender=Masc\|NameType=Sur\|Number=Sing\|POS=PROPN`, `Animacy=Anim\|Case=Acc\|Gender=Masc\|Number=Sing\|POS=DET\|Poss=Yes\|PronType=Prs\|Reflex=Yes`, `Animacy=Anim\|Case=Acc\|Gender=Masc\|NameType=Giv\|Number=Sing\|POS=PROPN`, `Animacy=Anim\|Case=Acc\|Gender=Masc\|NameType=Sur\|Number=Sing\|POS=PROPN`, `Animacy=Inan\|Case=Loc\|Number=Ptan\|POS=NOUN`, `Case=Gen\|Gender=Neut\|NumType=Ord\|Number=Sing\|POS=ADJ\|Uninflect=Yes`, `Case=Nom\|NumType=Card\|POS=NUM`, `POS=SYM`, `Case=Loc\|Gender=Neut\|NumType=Ord\|Number=Sing\|POS=ADJ`, `Case=Ins\|NumType=Card\|POS=NUM\|Uninflect=Yes`, `Case=Loc\|Gender=Masc\|Number=Sing\|POS=DET\|Poss=Yes\|PronType=Prs\|Reflex=Yes`, `Animacy=Inan\|Case=Ins\|Gender=Neut\|Number=Sing\|POS=NOUN`, `Case=Acc\|NumType=Card\|POS=NUM`, `Case=Gen\|Gender=Neut\|Number=Sing\|POS=ADJ`, `Abbr=Yes\|Animacy=Inan\|Case=Nom\|Gender=Fem\|Number=Sing\|POS=NOUN\|Uninflect=Yes`, `Case=Gen\|POS=PRON\|PronType=Prs\|Reflex=Yes`, `Animacy=Inan\|Case=Nom\|Gender=Neut\|Number=Sing\|POS=PRON\|PronType=Tot`, `Aspect=Imp\|Mood=Ind\|Number=Sing\|POS=VERB\|Person=3\|Tense=Fut\|VerbForm=Fin`, `Aspect=Imp\|Mood=Ind\|Number=Plur\|POS=VERB\|Person=1\|Tense=Fut\|VerbForm=Fin`, `Aspect=Perf\|Case=Ins\|Number=Plur\|POS=ADJ\|VerbForm=Part\|Voice=Pass`, `Case=Ins\|Degree=Pos\|Gender=Neut\|Number=Sing\|POS=ADJ`, `Aspect=Imp\|POS=VERB\|Tense=Pres\|VerbForm=Conv`, `Animacy=Inan\|Case=Acc\|Gender=Neut\|Number=Sing\|POS=PRON\|PronType=Tot`, `Abbr=Yes\|Animacy=Inan\|Case=Nom\|Gender=Masc\|Number=Sing\|POS=NOUN\|Uninflect=Yes`, `Abbr=Yes\|Animacy=Inan\|Case=Gen\|Gender=Masc\|Number=Sing\|POS=NOUN\|Uninflect=Yes`, `Case=Dat\|Number=Plur\|POS=PRON\|Person=3\|PronType=Prs`, `Animacy=Inan\|Case=Acc\|Number=Plur\|POS=DET\|Poss=Yes\|PronType=Prs\|Reflex=Yes`, `Animacy=Inan\|Case=Acc\|Gender=Neut\|Number=Plur\|POS=NOUN`, `Animacy=Anim\|Case=Acc\|Gender=Masc\|Number=Sing\|POS=ADJ`, `Case=Ins\|Degree=Pos\|Gender=Fem\|Number=Sing\|POS=ADJ`, `Aspect=Perf\|Mood=Imp\|Number=Plur\|POS=VERB\|Person=2\|VerbForm=Fin`, `Case=Dat\|POS=PRON\|PronType=Prs\|Reflex=Yes`, `Case=Nom\|Gender=Fem\|Number=Sing\|POS=DET\|PronType=Ind`, `Case=Loc\|Gender=Masc\|Number=Sing\|POS=DET\|PronType=Dem`, `Animacy=Inan\|Case=Acc\|Gender=Masc\|NumType=Card\|POS=NUM`, `Animacy=Inan\|Case=Acc\|Gender=Masc\|Number=Sing\|POS=PROPN\|Uninflect=Yes`, `Case=Nom\|Degree=Pos\|Gender=Masc\|NumType=Ord\|Number=Sing\|POS=ADJ`, `Animacy=Anim\|Case=Nom\|Gender=Fem\|NameType=Giv\|Number=Sing\|POS=PROPN\|Uninflect=Yes`, `Case=Gen\|NumType=Card\|POS=NUM`, `Case=Ins\|Number=Plur\|POS=DET\|PronType=Rel`, `Case=Nom\|Gender=Fem\|Number=Sing\|POS=DET\|Person=2\|Poss=Yes\|PronType=Prs`, `Animacy=Anim\|Case=Nom\|Gender=Masc\|NameType=Sur\|Number=Sing\|POS=PROPN\|Uninflect=Yes`, `Animacy=Inan\|Case=Dat\|Gender=Fem\|Number=Sing\|POS=PROPN`, `Case=Nom\|Gender=Fem\|NumType=Ord\|Number=Sing\|POS=ADJ`, `Animacy=Inan\|Case=Nom\|Gender=Fem\|Number=Sing\|POS=PROPN\|Uninflect=Yes`, `Case=Loc\|Gender=Masc\|Number=Sing\|POS=DET\|PronType=Prs\|Reflex=Yes`, `Animacy=Inan\|Case=Ins\|Gender=Fem\|Number=Sing\|POS=PROPN`, `Case=Ins\|Gender=Fem\|Number=Sing\|POS=DET\|Poss=Yes\|PronType=Prs\|Reflex=Yes`, `Case=Gen\|Number=Plur\|POS=DET\|PronType=Tot`, `Animacy=Anim\|Case=Acc\|Gender=Fem\|Number=Plur\|POS=NOUN`, `Case=Gen\|Number=Plur\|POS=PRON\|Person=3\|PronType=Prs`, `Case=Gen\|Number=Plur\|POS=DET\|PronType=Prs\|Reflex=Yes`, `Case=Dat\|Gender=Masc\|Number=Sing\|POS=DET\|PronType=Tot`, `Aspect=Imp\|Mood=Ind\|Number=Plur\|POS=VERB\|Person=2\|Tense=Pres\|VerbForm=Fin`, `Case=Gen\|Gender=Fem\|Number=Sing\|POS=DET\|PronType=Rel`, `Aspect=Perf\|Case=Ins\|Gender=Masc\|Number=Sing\|POS=ADJ\|VerbForm=Part\|Voice=Pass`, `Aspect=Imp\|Mood=Ind\|Number=Sing\|POS=VERB\|Person=1\|Tense=Fut\|VerbForm=Fin`, `Animacy=Inan\|Case=Acc\|Gender=Neut\|Number=Sing\|POS=NOUN\|Uninflect=Yes`, `Animacy=Anim\|Case=Gen\|Gender=Masc\|NameType=Sur\|Number=Sing\|POS=PROPN\|Uninflect=Yes`, `Animacy=Anim\|Case=Gen\|Gender=Fem\|NameType=Sur\|Number=Sing\|POS=PROPN\|Uninflect=Yes`, `Case=Acc\|Gender=Fem\|Number=Sing\|POS=DET\|PronType=Rel`, `Aspect=Perf\|Case=Nom\|Gender=Neut\|Number=Sing\|POS=ADJ\|VerbForm=Part\|Voice=Pass`, `Case=Nom\|Gender=Neut\|Number=Sing\|POS=DET\|Person=1\|Poss=Yes\|PronType=Prs`, `Case=Gen\|Gender=Neut\|Number=Sing\|POS=DET\|PronType=Dem`, `Animacy=Inan\|Case=Ins\|Gender=Neut\|Number=Plur\|POS=NOUN`, `Animacy=Anim\|Case=Acc\|Number=Plur\|POS=DET\|PronType=Rel`, `Case=Loc\|Number=Plur\|POS=DET\|Poss=Yes\|PronType=Prs\|Reflex=Yes`, `Case=Ins\|Number=Plur\|POS=DET\|Person=3\|Poss=Yes\|PronType=Prs\|Uninflect=Yes`, `Case=Acc\|Degree=Pos\|Gender=Neut\|Number=Sing\|POS=ADJ`, `Case=Acc\|Gender=Masc\|Number=Sing\|POS=PRON\|Person=3\|PronType=Prs`, `Animacy=Anim\|Case=Dat\|Number=Plur\|POS=PRON\|Person=2\|PronType=Prs`, `Abbr=Yes\|Animacy=Inan\|Case=Acc\|Gender=Neut\|Number=Sing\|POS=NOUN\|Uninflect=Yes`, `Animacy=Anim\|Case=Gen\|Gender=Fem\|NameType=Giv\|Number=Sing\|POS=PROPN`, `Hyph=Yes\|POS=ADJ`, `POS=ADV\|PronType=Ind`, `Case=Nom\|Gender=Masc\|Number=Sing\|POS=DET\|PronType=Prs\|Reflex=Yes`, `Case=Gen\|Gender=Fem\|NumType=Ord\|Number=Sing\|POS=ADJ`, `Animacy=Anim\|Case=Voc\|Gender=Fem\|NameType=Giv\|Number=Sing\|POS=PROPN`, `Abbr=Yes\|Animacy=Inan\|Case=Gen\|Gender=Fem\|NumType=Card\|Number=Plur\|POS=NOUN\|Uninflect=Yes`, `Abbr=Yes\|Animacy=Inan\|Case=Gen\|Gender=Fem\|Number=Plur\|POS=NOUN\|Uninflect=Yes`, `Animacy=Inan\|Case=Gen\|Gender=Fem\|NumType=Card\|Number=Sing\|POS=NOUN`, `Aspect=Imp\|Mood=Ind\|Number=Plur\|POS=AUX\|Person=3\|Tense=Pres\|VerbForm=Fin`, `Case=Nom\|Number=Plur\|POS=DET\|PronType=Ind`, `Case=Nom\|Degree=Cmp\|Number=Plur\|POS=ADJ`, `POS=ADV\|PronType=Neg`, `Case=Nom\|Number=Plur\|POS=DET\|PronType=Tot`, `Case=Gen\|Number=Plur\|POS=DET\|PronType=Rel`, `Animacy=Anim\|Case=Dat\|Number=Plur\|POS=PRON\|Person=1\|PronType=Prs`, `Animacy=Anim\|Case=Acc\|Number=Plur\|POS=DET\|PronType=Dem`, `Case=Nom\|Degree=Pos\|Gender=Masc\|Number=Sing\|POS=ADJ`, `Case=Ins\|Number=Plur\|POS=DET\|PronType=Tot`, `Case=Ins\|Degree=Pos\|Number=Plur\|POS=ADJ`, `Case=Loc\|Gender=Fem\|Number=Sing\|POS=PRON\|Person=3\|PronType=Prs`, `Aspect=Imp\|Mood=Ind\|Number=Sing\|POS=AUX\|Person=3\|Tense=Pres\|VerbForm=Fin`, `Case=Nom\|Number=Plur\|POS=PRON\|Person=3\|PronType=Prs`, `Animacy=Inan\|Case=Acc\|Gender=Neut\|Number=Sing\|POS=PRON\|PronType=Ind`, `Case=Nom\|Gender=Masc\|Number=Sing\|POS=ADJ\|Variant=Short`, `Animacy=Inan\|Case=Gen\|Gender=Masc\|Number=Plur\|POS=NOUN\|Uninflect=Yes`, `Abbr=Yes\|Animacy=Inan\|Case=Gen\|Gender=Masc\|NumType=Card\|Number=Plur\|POS=NOUN\|Uninflect=Yes`, `Case=Nom\|Gender=Masc\|Number=Sing\|POS=DET\|PronType=Ind`, `Case=Loc\|Gender=Masc\|Number=Sing\|POS=DET\|PronType=Rel`, `Animacy=Inan\|Case=Loc\|Gender=Neut\|Number=Sing\|POS=PROPN`, `Abbr=Yes\|Animacy=Inan\|Case=Gen\|Gender=Neut\|Number=Sing\|POS=PROPN\|Uninflect=Yes`, `Animacy=Anim\|Case=Acc\|Number=Plur\|POS=ADJ`, `Case=Gen\|Gender=Fem\|Number=Sing\|POS=DET\|PronType=Tot`, `Case=Ins\|Gender=Masc\|Number=Sing\|POS=DET\|PronType=Ind`, `Aspect=Imp\|Gender=Fem\|Mood=Ind\|Number=Sing\|POS=VERB\|Tense=Past\|VerbForm=Fin`, `Animacy=Anim\|Case=Gen\|Number=Sing\|POS=PRON\|Person=1\|PronType=Prs`, `Case=Loc\|Degree=Pos\|Gender=Masc\|Number=Sing\|POS=ADJ`, `Case=Gen\|Gender=Neut\|Number=Sing\|POS=DET\|Person=1\|Poss=Yes\|PronType=Prs`, `POS=PART\|PartType=Conseq`, `Animacy=Inan\|Case=Acc\|Gender=Masc\|Number=Sing\|POS=DET\|PronType=Prs\|Reflex=Yes`, `Case=Nom\|Degree=Cmp\|Gender=Masc\|Number=Sing\|POS=ADJ`, `Animacy=Anim\|Case=Nom\|Gender=Masc\|Number=Sing\|POS=PROPN`, `Animacy=Inan\|Case=Gen\|Gender=Neut\|Number=Sing\|POS=PROPN\|Uninflect=Yes`, `Case=Nom\|Gender=Neut\|Number=Sing\|POS=DET\|PronType=Dem`, `Case=Gen\|Gender=Masc\|Number=Sing\|POS=DET\|Poss=Yes\|PronType=Prs\|Reflex=Yes`, `Case=Gen\|Gender=Fem\|Number=Sing\|POS=DET\|PronType=Dem`, `Case=Gen\|Degree=Pos\|Gender=Neut\|Number=Sing\|POS=ADJ`, `Aspect=Perf\|Case=Nom\|Gender=Fem\|Number=Sing\|POS=ADJ\|VerbForm=Part\|Voice=Pass`, `Animacy=Anim\|Case=Ins\|Number=Sing\|POS=PRON\|Person=1\|PronType=Prs`, `Case=Gen\|Degree=Cmp\|Gender=Neut\|Number=Sing\|POS=ADJ`, `Case=Gen\|NumType=Card\|POS=DET\|PronType=Ind`, `Mood=Cnd\|POS=AUX`, `Abbr=Yes\|Animacy=Inan\|Case=Acc\|Gender=Masc\|Number=Sing\|POS=NOUN\|Uninflect=Yes`, `Animacy=Inan\|Case=Acc\|Gender=Masc\|NumType=Ord\|Number=Sing\|POS=ADJ`, `Aspect=Imp\|Case=Gen\|Number=Plur\|POS=ADJ\|VerbForm=Part\|Voice=Pass`, `Aspect=Perf\|Case=Loc\|Gender=Masc\|Number=Sing\|POS=ADJ\|VerbForm=Part\|Voice=Pass`, `Case=Loc\|Gender=Fem\|Number=Sing\|POS=DET\|PronType=Ind`, `Animacy=Inan\|Case=Acc\|Number=Plur\|POS=DET\|PronType=Dem`, `Abbr=Yes\|Animacy=Inan\|Case=Nom\|Gender=Fem\|Number=Sing\|POS=PROPN\|Uninflect=Yes`, `POS=ADJ`, `Case=Loc\|Gender=Masc\|Number=Sing\|POS=DET\|PronType=Ind`, `Case=Gen\|Degree=Sup\|Number=Plur\|POS=ADJ`, `Animacy=Inan\|Case=Nom\|Gender=Masc\|Number=Sing\|POS=NOUN\|Uninflect=Yes`, `Animacy=Inan\|Case=Nom\|Number=Ptan\|POS=NOUN`, `Aspect=Perf\|Case=Acc\|Gender=Fem\|Number=Sing\|POS=ADJ\|VerbForm=Part\|Voice=Pass`, `Case=Ins\|Gender=Fem\|Number=Sing\|POS=DET\|PronType=Rel`, `Case=Gen\|Gender=Fem\|Number=Sing\|POS=DET\|Person=1\|Poss=Yes\|PronType=Prs`, `Animacy=Inan\|Case=Nom\|Gender=Masc\|Number=Plur\|POS=NOUN\|Uninflect=Yes`, `Case=Dat\|POS=ADP`, `Animacy=Inan\|Case=Loc\|Gender=Neut\|Number=Sing\|POS=PRON\|PronType=Rel`, `Animacy=Inan\|Case=Acc\|Gender=Masc\|Number=Sing\|POS=PROPN`, `Case=Nom\|Gender=Neut\|Number=Sing\|POS=DET\|PronType=Ind`, `Case=Gen\|Gender=Neut\|NumType=Card\|POS=NUM`, `Animacy=Anim\|Case=Ins\|Gender=Fem\|Number=Sing\|POS=NOUN`, `Case=Gen\|Gender=Fem\|NumType=Ord\|Number=Sing\|POS=ADJ\|Uninflect=Yes`, `Case=Loc\|Degree=Pos\|Gender=Masc\|NumType=Ord\|Number=Sing\|POS=ADJ`, `Case=Ins\|Gender=Neut\|Number=Sing\|POS=ADJ`, `Animacy=Inan\|Case=Gen\|Gender=Fem\|NumType=Card\|Number=Plur\|POS=NOUN`, `Animacy=Anim\|Case=Nom\|POS=PRON\|PronType=Ind`, `Abbr=Yes\|Animacy=Inan\|Case=Gen\|Number=Ptan\|POS=NOUN\|Uninflect=Yes`, `Case=Nom\|Gender=Masc\|Number=Sing\|POS=DET\|PronType=Neg\|Variant=Short`, `Case=Loc\|Gender=Neut\|Number=Sing\|POS=ADJ`, `Aspect=Imp\|Mood=Ind\|Number=Plur\|POS=AUX\|Person=3\|Tense=Fut\|VerbForm=Fin`, `Case=Gen\|Gender=Masc\|Number=Sing\|POS=PRON\|Person=3\|PronType=Prs`, `POS=X`, `Case=Nom\|Gender=Masc\|NumType=Card\|POS=NUM\|Uninflect=Yes`, `Animacy=Inan\|Case=Acc\|Gender=Masc\|Number=Sing\|POS=DET\|PronType=Rel`, `Aspect=Imp\|Gender=Fem\|Mood=Ind\|Number=Sing\|POS=AUX\|Tense=Past\|VerbForm=Fin`, `Animacy=Inan\|Case=Gen\|Gender=Neut\|Number=Sing\|POS=PRON\|PronType=Rel`, `Animacy=Inan\|Case=Ins\|Number=Ptan\|POS=NOUN`, `Case=Dat\|Gender=Fem\|Number=Sing\|POS=PRON\|Person=3\|PronType=Prs`, `Case=Loc\|Gender=Masc\|Number=Sing\|POS=PRON\|Person=3\|PronType=Prs`, `Animacy=Inan\|Case=Gen\|Number=Ptan\|POS=NOUN\|Uninflect=Yes`, `POS=ADV\|PronType=Int`, `Aspect=Imp\|POS=VERB\|Polarity=Neg\|Tense=Pres\|VerbForm=Conv`, `Aspect=Imp\|Mood=Ind\|Number=Sing\|POS=VERB\|Person=2\|Tense=Pres\|VerbForm=Fin`, `Animacy=Inan\|Case=Loc\|Gender=Fem\|Number=Sing\|POS=PROPN\|Uninflect=Yes`, `Case=Acc\|NumType=Card\|Number=Plur\|POS=NUM\|Uninflect=Yes`, `Animacy=Inan\|Case=Gen\|Number=Ptan\|POS=PROPN\|Uninflect=Yes`, `Case=Nom\|Degree=Sup\|Gender=Neut\|Number=Sing\|POS=ADJ`, `Aspect=Perf\|Case=Gen\|Gender=Masc\|Number=Sing\|POS=ADJ\|VerbForm=Part\|Voice=Act`, `Case=Gen\|Gender=Fem\|Number=Sing\|POS=PRON\|Person=3\|PronType=Prs`, `Animacy=Inan\|Case=Nom\|Number=Ptan\|POS=PROPN\|Uninflect=Yes`, `Animacy=Inan\|Case=Loc\|Gender=Neut\|Number=Sing\|POS=PRON\|PronType=Dem`, `Case=Loc\|Gender=Masc\|NumType=Card\|POS=NUM`, `Animacy=Inan\|Case=Loc\|Gender=Neut\|Number=Plur\|POS=NOUN`, `Animacy=Inan\|Aspect=Perf\|Case=Acc\|Number=Plur\|POS=ADJ\|VerbForm=Part\|Voice=Pass`, `Case=Dat\|Gender=Masc\|Number=Sing\|POS=DET\|PronType=Rel`, `Case=Gen\|Gender=Masc\|NumType=Card\|POS=NUM`, `Animacy=Inan\|Case=Dat\|Gender=Masc\|Number=Plur\|POS=NOUN`, `Animacy=Inan\|Aspect=Perf\|Case=Acc\|Gender=Masc\|Number=Sing\|POS=ADJ\|VerbForm=Part\|Voice=Pass`, `Case=Gen\|Gender=Fem\|Number=Sing\|POS=DET\|Poss=Yes\|PronType=Prs\|Reflex=Yes`, `Case=Gen\|Gender=Fem\|Number=Sing\|POS=DET\|PronType=Ind`, `Animacy=Anim\|Case=Nom\|POS=PRON\|PronType=Neg`, `Animacy=Anim\|Case=Ins\|Gender=Masc\|NameType=Giv\|Number=Sing\|POS=PROPN`, `Animacy=Anim\|Case=Ins\|Gender=Masc\|NameType=Sur\|Number=Sing\|POS=PROPN`, `Case=Nom\|Gender=Fem\|NumType=Card\|POS=NUM\|Uninflect=Yes`, `Case=Gen\|Gender=Fem\|Number=Sing\|POS=DET\|Person=3\|Poss=Yes\|PronType=Prs\|Uninflect=Yes`, `Aspect=Imp\|Case=Nom\|Gender=Masc\|Number=Sing\|POS=ADJ\|VerbForm=Part\|Voice=Pass`, `Animacy=Inan\|Case=Loc\|Number=Ptan\|POS=PROPN\|Uninflect=Yes`, `Aspect=Imp\|Case=Ins\|Number=Plur\|POS=ADJ\|Tense=Pres\|VerbForm=Part\|Voice=Act`, `Case=Acc\|Number=Plur\|POS=DET\|Person=3\|Poss=Yes\|PronType=Prs\|Uninflect=Yes`, `Animacy=Anim\|Case=Acc\|Number=Ptan\|POS=NOUN`, `Animacy=Anim\|Case=Gen\|Gender=Fem\|NameType=Sur\|Number=Sing\|POS=PROPN`, `Case=Gen\|Gender=Neut\|Number=Sing\|POS=PRON\|Person=3\|PronType=Prs`, `Case=Dat\|Number=Plur\|POS=DET\|Person=1\|Poss=Yes\|PronType=Prs`, `Case=Gen\|Degree=Sup\|Gender=Fem\|Number=Sing\|POS=ADJ`, `Case=Gen\|Gender=Masc\|Number=Sing\|POS=DET\|PronType=Tot`, `Case=Gen\|Degree=Sup\|Gender=Masc\|Number=Sing\|POS=ADJ`, `Animacy=Inan\|Case=Acc\|Number=Plur\|POS=DET\|PronType=Prs\|Reflex=Yes`, `Case=Loc\|NumType=Card\|POS=NUM`, `Case=Ins\|Gender=Masc\|NumType=Card\|POS=NUM`, `Case=Acc\|Gender=Masc\|NumType=Card\|POS=NUM`, `Case=Acc\|Gender=Fem\|Number=Sing\|POS=DET\|Person=3\|Poss=Yes\|PronType=Prs\|Uninflect=Yes`, `Case=Loc\|Gender=Masc\|Number=Sing\|POS=DET\|Person=1\|Poss=Yes\|PronType=Prs`, `Case=Loc\|Degree=Pos\|Gender=Neut\|NumType=Ord\|Number=Sing\|POS=ADJ`, `Aspect=Perf\|Case=Ins\|Degree=Pos\|Number=Plur\|POS=ADJ\|VerbForm=Part\|Voice=Pass`, `Case=Ins\|Number=Plur\|POS=DET\|Poss=Yes\|PronType=Prs\|Reflex=Yes`, `Case=Loc\|Number=Plur\|POS=DET\|PronType=Dem`, `Case=Nom\|Gender=Fem\|Number=Sing\|POS=DET\|Person=3\|Poss=Yes\|PronType=Prs\|Uninflect=Yes`, `Case=Nom\|Gender=Masc\|Number=Sing\|POS=DET\|PronType=Dem`, `Abbr=Yes\|Animacy=Inan\|Case=Loc\|Gender=Fem\|Number=Sing\|POS=NOUN\|Uninflect=Yes`, `Animacy=Anim\|Animacy[gram]=Inan\|Case=Acc\|Gender=Fem\|Number=Plur\|POS=NOUN`, `Case=Loc\|Gender=Fem\|Number=Sing\|POS=DET\|PronType=Tot`, `Case=Ins\|Degree=Pos\|Gender=Masc\|NumType=Ord\|Number=Sing\|POS=ADJ`, `Animacy=Anim\|Case=Gen\|Gender=Masc\|NameType=Giv\|Number=Sing\|POS=PROPN\|Uninflect=Yes`, `Case=Gen\|Gender=Masc\|NumType=Ord\|Number=Sing\|POS=ADJ`, `Case=Gen\|Gender=Masc\|Number=Sing\|POS=DET\|PronType=Rel`, `Animacy=Inan\|Case=Loc\|Number=Ptan\|POS=PROPN`, `Aspect=Imp\|Case=Nom\|Gender=Masc\|Number=Sing\|POS=ADJ\|Tense=Pres\|VerbForm=Part\|Voice=Act`, `Case=Acc\|Gender=Neut\|Number=Sing\|POS=DET\|Poss=Yes\|PronType=Prs\|Reflex=Yes`, `Case=Gen\|Number=Plur\|POS=DET\|PronType=Neg`, `Animacy=Inan\|Case=Acc\|Gender=Neut\|Number=Sing\|POS=PRON\|PronType=Rel`, `Aspect=Imp\|Case=Nom\|Number=Plur\|POS=ADJ\|VerbForm=Part\|Voice=Pass`, `Case=Dat\|Degree=Pos\|Number=Plur\|POS=ADJ`, `Case=Loc\|Gender=Neut\|Number=Sing\|POS=DET\|Person=3\|Poss=Yes\|PronType=Prs\|Uninflect=Yes`, `Case=Nom\|Gender=Masc\|NumType=Ord\|Number=Sing\|POS=ADJ`, `Animacy=Anim\|Case=Acc\|Gender=Masc\|NameType=Giv\|Number=Sing\|POS=PROPN\|Uninflect=Yes`, `Case=Acc\|Gender=Neut\|Number=Sing\|POS=DET\|PronType=Dem`, `Case=Acc\|Gender=Fem\|Number=Sing\|POS=DET\|PronType=Ind`, `Abbr=Yes\|Animacy=Inan\|Case=Nom\|Gender=Fem\|Number=Plur\|POS=NOUN\|Uninflect=Yes`, `Case=Acc\|Gender=Neut\|Number=Sing\|POS=DET\|Person=3\|Poss=Yes\|PronType=Prs\|Uninflect=Yes`, `Aspect=Perf\|Case=Gen\|Gender=Fem\|Number=Sing\|POS=ADJ\|VerbForm=Part\|Voice=Pass`, `Case=Gen\|Number=Plur\|POS=DET\|Person=1\|Poss=Yes\|PronType=Prs`, `Animacy=Inan\|Case=Gen\|POS=PRON\|PronType=Neg`, `Case=Nom\|Gender=Masc\|Number=Sing\|POS=DET\|PronType=Tot`, `Animacy=Inan\|Case=Acc\|Number=Plur\|POS=DET\|Person=1\|Poss=Yes\|PronType=Prs`, `Case=Gen\|Gender=Fem\|NumType=Card\|POS=NUM\|Uninflect=Yes`, `Animacy=Inan\|Case=Gen\|Gender=Masc\|Number=Sing\|POS=NOUN\|Uninflect=Yes`, `Case=Ins\|Gender=Neut\|Number=Sing\|POS=DET\|Poss=Yes\|PronType=Prs\|Reflex=Yes`, `Aspect=Imp\|Case=Acc\|Gender=Fem\|Number=Sing\|POS=ADJ\|Tense=Pres\|VerbForm=Part\|Voice=Act`, `Abbr=Yes\|Animacy=Anim\|Case=Gen\|Gender=Masc\|Number=Sing\|POS=NOUN\|Uninflect=Yes`, `Case=Dat\|Number=Plur\|POS=DET\|PronType=Dem`, `Case=Ins\|Degree=Sup\|Gender=Fem\|Number=Sing\|POS=ADJ`, `Case=Nom\|Gender=Masc\|Number=Sing\|POS=DET\|Person=3\|Poss=Yes\|PronType=Prs\|Uninflect=Yes`, `Case=Gen\|Number=Plur\|POS=DET\|Poss=Yes\|PronType=Prs\|Reflex=Yes`, `Animacy=Inan\|Case=Acc\|Gender=Masc\|Number=Sing\|POS=DET\|PronType=Ind`, `Animacy=Anim\|Case=Dat\|Gender=Masc\|NameType=Giv\|Number=Sing\|POS=PROPN`, `Animacy=Anim\|Case=Dat\|Gender=Masc\|NameType=Sur\|Number=Sing\|POS=PROPN`, `Case=Gen\|Number=Plur\|POS=DET\|PronType=Ind`, _(truncated: full list in pipeline meta)_ |
| **`parser`** | `ROOT`, `acl`, `acl:relcl`, `advcl`, `advcl:sp`, `advcl:svc`, `advmod`, `advmod:det`, `amod`, `appos`, `aux`, `case`, `cc`, `ccomp`, `compound`, `conj`, `cop`, `csubj`, `dep`, `det`, `det:numgov`, `discourse`, `expl`, `fixed`, `flat:abs`, `flat:foreign`, `flat:name`, `flat:range`, `flat:repeat`, `flat:sibl`, `flat:title`, `iobj`, `mark`, `nmod`, `nsubj`, `nummod`, `nummod:gov`, `obj`, `obl`, `orphan`, `parataxis`, `parataxis:discourse`, `punct`, `vocative`, `xcomp`, `xcomp:sp` |
| **`ner`** | `LOC`, `ORG`, `PER` |

</details>

### Accuracy

| Type | Score |
| --- | --- |
| `TOKEN_ACC` | 99.99 |
| `TOKEN_P` | 99.99 |
| `TOKEN_R` | 99.97 |
| `TOKEN_F` | 99.98 |
| `POS_ACC` | 98.13 |
| `MORPH_ACC` | 94.65 |
| `MORPH_MICRO_P` | 97.59 |
| `MORPH_MICRO_R` | 96.79 |
| `MORPH_MICRO_F` | 97.19 |
| `SENTS_P` | 94.12 |
| `SENTS_R` | 90.47 |
| `SENTS_F` | 92.26 |
| `DEP_UAS` | 93.44 |
| `DEP_LAS` | 91.20 |
| `TAG_ACC` | 98.13 |
| `LEMMA_ACC` | 0.00 |
| `ENTS_P` | 85.97 |
| `ENTS_R` | 86.63 |
| `ENTS_F` | 86.30 |