#!/usr/bin/env bash

# These all get copied into a "usr" subdir to mimic the typical installation prefix of the package via yum or dnf.
mkdir -p ${PREFIX}/${target_machine}-${ctng_vendor}-linux-gnu/sysroot
pushd ${PREFIX}/${target_machine}-${ctng_vendor}-linux-gnu/sysroot > /dev/null 2>&1
cp -Rf "${SRC_DIR}"/binary-glibc/* .
mkdir -p usr/include
cp -Rf "${SRC_DIR}"/binary-glibc-headers/include/* usr/include/
cp -Rf "${SRC_DIR}"/binary-glibc-devel/* usr/
cp -Rf "${SRC_DIR}"/binary-glibc-static/* usr/
cp -Rf "${SRC_DIR}"/binary-glibc-common/* usr/
cp -Rf "${SRC_DIR}"/binary-glibc-gconv-extra/* usr/
cp -Rf "${SRC_DIR}"/binary-glibc-all-langpacks/* usr/

mkdir -p usr/lib64
if [[ $(compgen -G 'usr/lib/*') != "" ]]; then
    mv usr/lib/* usr/lib64/
fi
rm -rf usr/lib
ln -s $PWD/usr/lib64 $PWD/usr/lib

if [ -d "lib" ]; then
    # Only move libs if they don't already exists to avoid errors.
    for lib_file in lib/*; do
        if [ ! -f lib64/$(basename -- "${lib_file}") ]; then
            mv ${lib_file} lib64/
        fi
    done
    rm -rf lib
fi
ln -s $PWD/lib64 $PWD/lib

## Linking or building against libsnsl produces binaries that don't run on recent Linux distributions.
## Libraries and headers removed here to prevent this. See
## https://github.com/conda-forge/rasterio-feedstock/issues/220
rm -f lib64/libnsl*.so*
rm -f usr/lib64/libnsl.{a,so}
rm -f usr/include/rpcsvc/ypclnt.h
rm -f usr/include/rpcsvc/yp.h
rm -f usr/include/rpcsvc/yppasswd.h
rm -f usr/include/rpcsvc/yppasswd.x
rm -f usr/include/rpcsvc/yp_prot.h
rm -f usr/include/rpcsvc/ypupd.h
rm -f usr/include/rpcsvc/yp.x

if [[ "$target_machine" == "s390x" ]]; then
   rm -rf $PWD/lib64/ld64.so.1
   ln -s $PWD/lib64/ld-* $PWD/lib64/ld64.so.1
fi

# Create sysroot/usr/share/zoneinfo and link it to the install location for the tzdata package.
mkdir -p usr/share
ln -sf ${PREFIX}/share/zoneinfo usr/share/zoneinfo

# we don't need these
rm -rf usr/share/man
rm -rf usr/lib/systemd
rm -rf usr/share/doc

popd

mkdir -p ${PREFIX}/bin
echo "--sysroot=${PREFIX}/${target_machine}-${ctng_vendor}-linux-gnu/sysroot" >> ${PREFIX}/bin/${target_machine}-${ctng_vendor}-linux-gnu.cfg
