# Generated by ariadne-codegen
# Source: queries.graphql

from datetime import datetime
from typing import Annotated, Any, List, Literal, Optional, Union

from pydantic import Field

from .base_model import BaseModel


class InvalidInputSelection(BaseModel):
    errors: List["InvalidInputSelectionErrors"]


class InvalidInputSelectionErrors(BaseModel):
    path: Optional[str]
    message: str
    name: str
    context: Optional[Any]


class ManagedRoleSelection(BaseModel):
    id: str
    name: str
    arn: str


class OperationErrorSelection(BaseModel):
    message: str
    name: str
    context: Optional[Any]


class UnmanagedRoleSelection(BaseModel):
    id: str
    name: str
    arn: str


class UserSelection(BaseModel):
    name: str
    email: str
    date_joined: datetime = Field(alias="dateJoined")
    last_login: datetime = Field(alias="lastLogin")
    is_active: bool = Field(alias="isActive")
    is_admin: bool = Field(alias="isAdmin")
    is_sso_only: bool = Field(alias="isSsoOnly")
    is_service: bool = Field(alias="isService")
    role: Optional[
        Annotated[
            Union["UserSelectionRoleUnmanagedRole", "UserSelectionRoleManagedRole"],
            Field(discriminator="typename__"),
        ]
    ]
    extra_roles: List[
        Annotated[
            Union[
                "UserSelectionExtraRolesUnmanagedRole",
                "UserSelectionExtraRolesManagedRole",
            ],
            Field(discriminator="typename__"),
        ]
    ] = Field(alias="extraRoles")


class UserSelectionRoleUnmanagedRole(UnmanagedRoleSelection):
    typename__: Literal["UnmanagedRole"] = Field(alias="__typename")


class UserSelectionRoleManagedRole(ManagedRoleSelection):
    typename__: Literal["ManagedRole"] = Field(alias="__typename")


class UserSelectionExtraRolesUnmanagedRole(UnmanagedRoleSelection):
    typename__: Literal["UnmanagedRole"] = Field(alias="__typename")


class UserSelectionExtraRolesManagedRole(ManagedRoleSelection):
    typename__: Literal["ManagedRole"] = Field(alias="__typename")


class SsoConfigSelection(BaseModel):
    text: str
    timestamp: datetime
    uploader: "SsoConfigSelectionUploader"


class SsoConfigSelectionUploader(UserSelection):
    pass


InvalidInputSelection.model_rebuild()
ManagedRoleSelection.model_rebuild()
OperationErrorSelection.model_rebuild()
UnmanagedRoleSelection.model_rebuild()
UserSelection.model_rebuild()
SsoConfigSelection.model_rebuild()
