# coding: utf-8
"""
    Snowflake Alert API.

    The Snowflake Alert API is a REST API that you can use to access, update, and perform certain actions on Alert resource in a Snowflake database.  # noqa: E501

    The version of the OpenAPI document: 0.0.1
    Contact: support@snowflake.com
    Generated by: https://openapi-generator.tech

    Do not edit this file manually.
"""

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from typing import Union

from snowflake.core.alert._generated.models.schedule import Schedule

from datetime import datetime

from pydantic import BaseModel, ConfigDict, StrictStr

from typing import Any, ClassVar, Dict, List, Optional


class Alert(BaseModel):
    """A model object representing the Alert resource.

    Constructs an object of type Alert with the provided properties.

    Parameters
    __________
    name : str
        Name of the alert
    schedule : Schedule

    condition : str
        The SQL statement that must be evaluated to determine whether to trigger the alert
    action : str
        The SQL statement to execute when the alert is triggered
    comment : str, optional
        user comment associated to an object in the dictionary
    warehouse : str, optional
        The warehouse the alert runs in
    created_on : datetime, optional
        Date and time when the alert was created.
    database_name : str, optional
        Database in which the alert is stored
    schema_name : str, optional
        Schema in which the alert is stored
    owner : str, optional
        Role that owns the alert
    owner_role_type : str, optional
        The type of role that owns the alert
    state : str, optional
        The current state of the alert
    """

    name: StrictStr

    comment: Optional[StrictStr] = None

    schedule: Schedule

    warehouse: Optional[StrictStr] = None

    condition: StrictStr

    action: StrictStr

    created_on: Optional[datetime] = None

    database_name: Optional[StrictStr] = None

    schema_name: Optional[StrictStr] = None

    owner: Optional[StrictStr] = None

    owner_role_type: Optional[StrictStr] = None

    state: Optional[StrictStr] = None

    __properties = [
        "name", "comment", "schedule", "warehouse", "condition", "action",
        "created_on", "database_name", "schema_name", "owner",
        "owner_role_type", "state"
    ]

    class Config:
        populate_by_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Alert:
        """Create an instance of Alert from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""

        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({
                "created_on",
                "database_name",
                "schema_name",
                "owner",
                "owner_role_type",
                "state",
            })

        _dict = dict(
            self._iter(to_dict=True,
                       by_alias=True,
                       exclude=exclude_properties,
                       exclude_none=True))

        # override the default output from pydantic by calling `to_dict()` of schedule
        if self.schedule:
            _dict['schedule'] = self.schedule.to_dict()

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> Alert:
        """Create an instance of Alert from a dict."""

        if obj is None:
            return None

        if type(obj) is not dict:
            return Alert.parse_obj(obj)

        _obj = Alert.parse_obj({
            "name":
            obj.get("name"),
            "comment":
            obj.get("comment"),
            "schedule":
            Schedule.from_dict(obj.get("schedule"))
            if obj.get("schedule") is not None else None,
            "warehouse":
            obj.get("warehouse"),
            "condition":
            obj.get("condition"),
            "action":
            obj.get("action"),
            "created_on":
            obj.get("created_on"),
            "database_name":
            obj.get("database_name"),
            "schema_name":
            obj.get("schema_name"),
            "owner":
            obj.get("owner"),
            "owner_role_type":
            obj.get("owner_role_type"),
            "state":
            obj.get("state"),
        })

        return _obj


from typing import Optional, List, Dict

from snowflake.core.alert._generated.models.schedule import Schedule


class AlertModel():

    def __init__(
        self,
        name: str,
        schedule: Schedule,
        condition: str,
        action: str,
        # optional properties
        comment: Optional[str] = None,
        warehouse: Optional[str] = None,
        created_on: Optional[datetime] = None,
        database_name: Optional[str] = None,
        schema_name: Optional[str] = None,
        owner: Optional[str] = None,
        owner_role_type: Optional[str] = None,
        state: Optional[str] = None,
    ):
        """A model object representing the Alert resource.

        Constructs an object of type Alert with the provided properties.

        Parameters
        __________
        name : str
            Name of the alert
        schedule : Schedule

        condition : str
            The SQL statement that must be evaluated to determine whether to trigger the alert
        action : str
            The SQL statement to execute when the alert is triggered
        comment : str, optional
            user comment associated to an object in the dictionary
        warehouse : str, optional
            The warehouse the alert runs in
        created_on : datetime, optional
            Date and time when the alert was created.
        database_name : str, optional
            Database in which the alert is stored
        schema_name : str, optional
            Schema in which the alert is stored
        owner : str, optional
            Role that owns the alert
        owner_role_type : str, optional
            The type of role that owns the alert
        state : str, optional
            The current state of the alert
        """

        self.name = name
        self.comment = comment
        self.schedule = schedule
        self.warehouse = warehouse
        self.condition = condition
        self.action = action
        self.created_on = created_on
        self.database_name = database_name
        self.schema_name = schema_name
        self.owner = owner
        self.owner_role_type = owner_role_type
        self.state = state

    __properties = [
        "name", "comment", "schedule", "warehouse", "condition", "action",
        "created_on", "database_name", "schema_name", "owner",
        "owner_role_type", "state"
    ]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return Alert(
            name=self.name,
            comment=self.comment,
            schedule=self.schedule._to_model()
            if self.schedule is not None else None,
            warehouse=self.warehouse,
            condition=self.condition,
            action=self.action,
            created_on=self.created_on,
            database_name=self.database_name,
            schema_name=self.schema_name,
            owner=self.owner,
            owner_role_type=self.owner_role_type,
            state=self.state,
        )

    @classmethod
    def _from_model(cls, model) -> AlertModel:
        return AlertModel(
            name=model.name,
            comment=model.comment,
            schedule=ScheduleModel._from_model(model.schedule)
            if model.schedule is not None else None,
            warehouse=model.warehouse,
            condition=model.condition,
            action=model.action,
            created_on=model.created_on,
            database_name=model.database_name,
            schema_name=model.schema_name,
            owner=model.owner,
            owner_role_type=model.owner_role_type,
            state=model.state,
        )

    def to_dict(self):
        """Creates a dictionary of the properties from a Alert.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the Alert object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> AlertModel:
        """Creates an instance of Alert from a dict.

        This method constructs a Alert object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        Alert
            A Alert object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(Alert.from_dict(obj))


Alert._model_class = AlertModel
