# coding: utf-8
"""
    Snowflake Alert API.

    The Snowflake Alert API is a REST API that you can use to access, update, and perform certain actions on Alert resource in a Snowflake database.  # noqa: E501

    The version of the OpenAPI document: 0.0.1
    Contact: support@snowflake.com
    Generated by: https://openapi-generator.tech

    Do not edit this file manually.
"""

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from typing import Union

from snowflake.core.alert._generated.models.schedule import Schedule

from pydantic import ConfigDict, StrictInt

from typing import Any, ClassVar, Dict, List


class MinutesSchedule(Schedule):
    """A model object representing the MinutesSchedule resource.

    Constructs an object of type MinutesSchedule with the provided properties.

    Parameters
    __________
    minutes : int
    """

    minutes: StrictInt

    __properties = ["schedule_type"]

    class Config:
        populate_by_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> MinutesSchedule:
        """Create an instance of MinutesSchedule from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""

        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = dict(
            self._iter(to_dict=True,
                       by_alias=True,
                       exclude=exclude_properties,
                       exclude_none=True))

        _dict['schedule_type'] = Schedule.get_child_model_discriminator_value(
            'MinutesSchedule')

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> MinutesSchedule:
        """Create an instance of MinutesSchedule from a dict."""

        if obj is None:
            return None

        if type(obj) is not dict:
            return MinutesSchedule.parse_obj(obj)

        _obj = MinutesSchedule.parse_obj({
            "minutes": obj.get("minutes"),
        })

        return _obj


from typing import Optional, List, Dict

from snowflake.core.alert._generated.models.schedule import Schedule


class MinutesScheduleModel(Schedule):

    def __init__(
        self,
        minutes: int,
        # optional properties
    ):
        """A model object representing the MinutesSchedule resource.

        Constructs an object of type MinutesSchedule with the provided properties.

        Parameters
        __________
        minutes : int
        """

        super().__init__()
        self.minutes = minutes

    __properties = ["schedule_type"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return MinutesSchedule(minutes=self.minutes, )

    @classmethod
    def _from_model(cls, model) -> MinutesScheduleModel:
        return MinutesScheduleModel(minutes=model.minutes, )

    def to_dict(self):
        """Creates a dictionary of the properties from a MinutesSchedule.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the MinutesSchedule object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> MinutesScheduleModel:
        """Creates an instance of MinutesSchedule from a dict.

        This method constructs a MinutesSchedule object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        MinutesSchedule
            A MinutesSchedule object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(MinutesSchedule.from_dict(obj))


MinutesSchedule._model_class = MinutesScheduleModel
