# coding: utf-8
"""
    Snowflake Catalog Integration API.

    The Snowflake Catalog Integration API is a REST API that you can use to access, update, and perform certain actions on Catalog Integration resource in a Snowflake database.  # noqa: E501

    The version of the OpenAPI document: 0.0.1
    Contact: support@snowflake.com
    Generated by: https://openapi-generator.tech

    Do not edit this file manually.
"""

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from typing import Union

from snowflake.core.catalog_integration._generated.models.catalog import Catalog

from pydantic import ConfigDict, StrictStr

from typing import Any, ClassVar, Dict, List, Optional


class Glue(Catalog):
    """A model object representing the Glue resource.

    Constructs an object of type Glue with the provided properties.

    Parameters
    __________
    glue_aws_role_arn : str
        ARN for AWS role to assume
    glue_catalog_id : str
        Glue catalog id
    catalog_namespace : str
        default AWS Glue catalog namespace for all Iceberg table that use this catalog integration
    glue_region : str, optional
        AWS region of the Glue catalog. Must be specified if the Snowflake account is not hosted on AWS.
    """

    glue_aws_role_arn: StrictStr

    glue_catalog_id: StrictStr

    glue_region: Optional[StrictStr] = None

    catalog_namespace: StrictStr

    __properties = ["catalog_source"]

    class Config:
        populate_by_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Glue:
        """Create an instance of Glue from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""

        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = dict(
            self._iter(to_dict=True,
                       by_alias=True,
                       exclude=exclude_properties,
                       exclude_none=True))

        _dict['catalog_source'] = Catalog.get_child_model_discriminator_value(
            'Glue')

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> Glue:
        """Create an instance of Glue from a dict."""

        if obj is None:
            return None

        if type(obj) is not dict:
            return Glue.parse_obj(obj)

        _obj = Glue.parse_obj({
            "glue_aws_role_arn":
            obj.get("glue_aws_role_arn"),
            "glue_catalog_id":
            obj.get("glue_catalog_id"),
            "glue_region":
            obj.get("glue_region"),
            "catalog_namespace":
            obj.get("catalog_namespace"),
        })

        return _obj


from typing import Optional, List, Dict

from snowflake.core.catalog_integration._generated.models.catalog import Catalog


class GlueModel(Catalog):

    def __init__(
        self,
        glue_aws_role_arn: str,
        glue_catalog_id: str,
        catalog_namespace: str,
        # optional properties
        glue_region: Optional[str] = None,
    ):
        """A model object representing the Glue resource.

        Constructs an object of type Glue with the provided properties.

        Parameters
        __________
        glue_aws_role_arn : str
            ARN for AWS role to assume
        glue_catalog_id : str
            Glue catalog id
        catalog_namespace : str
            default AWS Glue catalog namespace for all Iceberg table that use this catalog integration
        glue_region : str, optional
            AWS region of the Glue catalog. Must be specified if the Snowflake account is not hosted on AWS.
        """

        super().__init__()
        self.glue_aws_role_arn = glue_aws_role_arn
        self.glue_catalog_id = glue_catalog_id
        self.glue_region = glue_region
        self.catalog_namespace = catalog_namespace

    __properties = ["catalog_source"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return Glue(
            glue_aws_role_arn=self.glue_aws_role_arn,
            glue_catalog_id=self.glue_catalog_id,
            glue_region=self.glue_region,
            catalog_namespace=self.catalog_namespace,
        )

    @classmethod
    def _from_model(cls, model) -> GlueModel:
        return GlueModel(
            glue_aws_role_arn=model.glue_aws_role_arn,
            glue_catalog_id=model.glue_catalog_id,
            glue_region=model.glue_region,
            catalog_namespace=model.catalog_namespace,
        )

    def to_dict(self):
        """Creates a dictionary of the properties from a Glue.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the Glue object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> GlueModel:
        """Creates an instance of Glue from a dict.

        This method constructs a Glue object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        Glue
            A Glue object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(Glue.from_dict(obj))


Glue._model_class = GlueModel
