# coding: utf-8
"""
    Snowflake Compute Pools API.

    The Snowflake Compute Pools API is a REST API that you can use to access, update, and perform common actions on Compute Pool resources.  # noqa: E501

    The version of the OpenAPI document: 0.0.1
    Contact: support@snowflake.com
    Generated by: https://openapi-generator.tech

    Do not edit this file manually.
"""

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from typing import Union

from datetime import datetime

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr, field_validator

from typing import Any, ClassVar, Dict, List, Optional

from typing_extensions import Annotated


class ComputePool(BaseModel):
    """A model object representing the ComputePool resource.

    Constructs an object of type ComputePool with the provided properties.

    Parameters
    __________
    name : str
        A Snowflake object identifier.
    min_nodes : int
        Minimum number of nodes for the compute pool.
    max_nodes : int
        Maximum number of nodes for the compute pool.
    instance_family : str
        Instance family for the compute pool.
    auto_resume : bool, optional
        Whether Snowflake automatically resumes the compute pool when any statement that requires the compute pool is submitted.
    comment : str, optional
        Comment describing the compute pool.
    state : str, optional
        Current state of the compute pool. Possible values include UNKNOWN, STARTING, IDLE, ACTIVE, STOPPING, SUSPENDED, and RESIZING.
    num_services : int, optional
        Number of services on the compute pool.
    num_jobs : int, optional
        Number of jobs on the compute pool.
    auto_suspend_secs : int, optional
        Number of seconds until the compute pool automatically suspends.
    active_nodes : int, optional
        Number of currently active nodes on the compute pool.
    idle_nodes : int, optional
        Number of currently idle nodes on the compute pool.
    target_nodes : int, optional
        Number of target nodes on the compute pool.
    created_on : datetime, optional
        Time the compute pool was created.
    resumed_on : datetime, optional
        Time the compute pool was last resumed.
    updated_on : datetime, optional
        Time the compute pool was last updated.
    owner : str, optional
        Identifier for the current owner of the compute pool.
    is_exclusive : bool, optional
        Whether a compute pool is created exclusively for a Snowflake Native App.
    application : str, optional
        Name of the Snowflake Native App if the compute pool is created exclusively for the app.
    budget : str, optional
        The name of the budget monitoring the credit usage of the compute pool.
    error_code : str, optional
        Current error the compute pool hit if any.
    status_message : str, optional
        Current status of the compute pool if any.
    """

    name: Annotated[str, Field(strict=True)]

    min_nodes: StrictInt

    max_nodes: StrictInt

    instance_family: StrictStr

    auto_resume: Optional[StrictBool] = None

    comment: Optional[StrictStr] = None

    state: Optional[StrictStr] = None

    num_services: Optional[StrictInt] = None

    num_jobs: Optional[StrictInt] = None

    auto_suspend_secs: Optional[StrictInt] = None

    active_nodes: Optional[StrictInt] = None

    idle_nodes: Optional[StrictInt] = None

    target_nodes: Optional[StrictInt] = None

    created_on: Optional[datetime] = None

    resumed_on: Optional[datetime] = None

    updated_on: Optional[datetime] = None

    owner: Optional[StrictStr] = None

    is_exclusive: Optional[StrictBool] = None

    application: Optional[StrictStr] = None

    budget: Optional[StrictStr] = None

    error_code: Optional[StrictStr] = None

    status_message: Optional[StrictStr] = None

    __properties = [
        "name", "min_nodes", "max_nodes", "instance_family", "auto_resume",
        "comment", "state", "num_services", "num_jobs", "auto_suspend_secs",
        "active_nodes", "idle_nodes", "target_nodes", "created_on",
        "resumed_on", "updated_on", "owner", "is_exclusive", "application",
        "budget", "error_code", "status_message"
    ]

    @field_validator('name')
    def name_validate_regular_expression(cls, v):

        if not re.match(r"""^\"([^\"]|\"\")+\"|[a-zA-Z_][a-zA-Z0-9_$]*$""", v):
            raise ValueError(
                r"""must validate the regular expression /^"([^"]|"")+"|[a-zA-Z_][a-zA-Z0-9_$]*$/"""
            )
        return v

    @field_validator('state')
    def state_validate_enum(cls, v):

        if v is None:
            return v
        if v not in ('UNKNOWN', 'STARTING', 'IDLE', 'ACTIVE', 'STOPPING',
                     'SUSPENDED', 'RESIZING'):
            raise ValueError(
                "must validate the enum values ('UNKNOWN','STARTING','IDLE','ACTIVE','STOPPING','SUSPENDED','RESIZING')"
            )
        return v

    class Config:
        populate_by_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ComputePool:
        """Create an instance of ComputePool from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""

        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({
                "state",
                "num_services",
                "num_jobs",
                "active_nodes",
                "idle_nodes",
                "target_nodes",
                "created_on",
                "resumed_on",
                "updated_on",
                "owner",
                "is_exclusive",
                "application",
                "budget",
                "error_code",
                "status_message",
            })

        _dict = dict(
            self._iter(to_dict=True,
                       by_alias=True,
                       exclude=exclude_properties,
                       exclude_none=True))

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> ComputePool:
        """Create an instance of ComputePool from a dict."""

        if obj is None:
            return None

        if type(obj) is not dict:
            return ComputePool.parse_obj(obj)

        _obj = ComputePool.parse_obj({
            "name":
            obj.get("name"),
            "min_nodes":
            obj.get("min_nodes"),
            "max_nodes":
            obj.get("max_nodes"),
            "instance_family":
            obj.get("instance_family"),
            "auto_resume":
            obj.get("auto_resume"),
            "comment":
            obj.get("comment"),
            "state":
            obj.get("state"),
            "num_services":
            obj.get("num_services"),
            "num_jobs":
            obj.get("num_jobs"),
            "auto_suspend_secs":
            obj.get("auto_suspend_secs"),
            "active_nodes":
            obj.get("active_nodes"),
            "idle_nodes":
            obj.get("idle_nodes"),
            "target_nodes":
            obj.get("target_nodes"),
            "created_on":
            obj.get("created_on"),
            "resumed_on":
            obj.get("resumed_on"),
            "updated_on":
            obj.get("updated_on"),
            "owner":
            obj.get("owner"),
            "is_exclusive":
            obj.get("is_exclusive"),
            "application":
            obj.get("application"),
            "budget":
            obj.get("budget"),
            "error_code":
            obj.get("error_code"),
            "status_message":
            obj.get("status_message"),
        })

        return _obj


from typing import Optional, List, Dict


class ComputePoolModel():

    def __init__(
        self,
        name: str,
        min_nodes: int,
        max_nodes: int,
        instance_family: str,
        # optional properties
        auto_resume: Optional[bool] = None,
        comment: Optional[str] = None,
        state: Optional[str] = None,
        num_services: Optional[int] = None,
        num_jobs: Optional[int] = None,
        auto_suspend_secs: Optional[int] = None,
        active_nodes: Optional[int] = None,
        idle_nodes: Optional[int] = None,
        target_nodes: Optional[int] = None,
        created_on: Optional[datetime] = None,
        resumed_on: Optional[datetime] = None,
        updated_on: Optional[datetime] = None,
        owner: Optional[str] = None,
        is_exclusive: Optional[bool] = None,
        application: Optional[str] = None,
        budget: Optional[str] = None,
        error_code: Optional[str] = None,
        status_message: Optional[str] = None,
    ):
        """A model object representing the ComputePool resource.

        Constructs an object of type ComputePool with the provided properties.

        Parameters
        __________
        name : str
            A Snowflake object identifier.
        min_nodes : int
            Minimum number of nodes for the compute pool.
        max_nodes : int
            Maximum number of nodes for the compute pool.
        instance_family : str
            Instance family for the compute pool.
        auto_resume : bool, optional
            Whether Snowflake automatically resumes the compute pool when any statement that requires the compute pool is submitted.
        comment : str, optional
            Comment describing the compute pool.
        state : str, optional
            Current state of the compute pool. Possible values include UNKNOWN, STARTING, IDLE, ACTIVE, STOPPING, SUSPENDED, and RESIZING.
        num_services : int, optional
            Number of services on the compute pool.
        num_jobs : int, optional
            Number of jobs on the compute pool.
        auto_suspend_secs : int, optional
            Number of seconds until the compute pool automatically suspends.
        active_nodes : int, optional
            Number of currently active nodes on the compute pool.
        idle_nodes : int, optional
            Number of currently idle nodes on the compute pool.
        target_nodes : int, optional
            Number of target nodes on the compute pool.
        created_on : datetime, optional
            Time the compute pool was created.
        resumed_on : datetime, optional
            Time the compute pool was last resumed.
        updated_on : datetime, optional
            Time the compute pool was last updated.
        owner : str, optional
            Identifier for the current owner of the compute pool.
        is_exclusive : bool, optional
            Whether a compute pool is created exclusively for a Snowflake Native App.
        application : str, optional
            Name of the Snowflake Native App if the compute pool is created exclusively for the app.
        budget : str, optional
            The name of the budget monitoring the credit usage of the compute pool.
        error_code : str, optional
            Current error the compute pool hit if any.
        status_message : str, optional
            Current status of the compute pool if any.
        """

        self.name = name
        self.min_nodes = min_nodes
        self.max_nodes = max_nodes
        self.instance_family = instance_family
        self.auto_resume = auto_resume
        self.comment = comment
        self.state = state
        self.num_services = num_services
        self.num_jobs = num_jobs
        self.auto_suspend_secs = auto_suspend_secs
        self.active_nodes = active_nodes
        self.idle_nodes = idle_nodes
        self.target_nodes = target_nodes
        self.created_on = created_on
        self.resumed_on = resumed_on
        self.updated_on = updated_on
        self.owner = owner
        self.is_exclusive = is_exclusive
        self.application = application
        self.budget = budget
        self.error_code = error_code
        self.status_message = status_message

    __properties = [
        "name", "min_nodes", "max_nodes", "instance_family", "auto_resume",
        "comment", "state", "num_services", "num_jobs", "auto_suspend_secs",
        "active_nodes", "idle_nodes", "target_nodes", "created_on",
        "resumed_on", "updated_on", "owner", "is_exclusive", "application",
        "budget", "error_code", "status_message"
    ]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return ComputePool(
            name=self.name,
            min_nodes=self.min_nodes,
            max_nodes=self.max_nodes,
            instance_family=self.instance_family,
            auto_resume=self.auto_resume,
            comment=self.comment,
            state=self.state,
            num_services=self.num_services,
            num_jobs=self.num_jobs,
            auto_suspend_secs=self.auto_suspend_secs,
            active_nodes=self.active_nodes,
            idle_nodes=self.idle_nodes,
            target_nodes=self.target_nodes,
            created_on=self.created_on,
            resumed_on=self.resumed_on,
            updated_on=self.updated_on,
            owner=self.owner,
            is_exclusive=self.is_exclusive,
            application=self.application,
            budget=self.budget,
            error_code=self.error_code,
            status_message=self.status_message,
        )

    @classmethod
    def _from_model(cls, model) -> ComputePoolModel:
        return ComputePoolModel(
            name=model.name,
            min_nodes=model.min_nodes,
            max_nodes=model.max_nodes,
            instance_family=model.instance_family,
            auto_resume=model.auto_resume,
            comment=model.comment,
            state=model.state,
            num_services=model.num_services,
            num_jobs=model.num_jobs,
            auto_suspend_secs=model.auto_suspend_secs,
            active_nodes=model.active_nodes,
            idle_nodes=model.idle_nodes,
            target_nodes=model.target_nodes,
            created_on=model.created_on,
            resumed_on=model.resumed_on,
            updated_on=model.updated_on,
            owner=model.owner,
            is_exclusive=model.is_exclusive,
            application=model.application,
            budget=model.budget,
            error_code=model.error_code,
            status_message=model.status_message,
        )

    def to_dict(self):
        """Creates a dictionary of the properties from a ComputePool.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the ComputePool object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> ComputePoolModel:
        """Creates an instance of ComputePool from a dict.

        This method constructs a ComputePool object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        ComputePool
            A ComputePool object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(ComputePool.from_dict(obj))


ComputePool._model_class = ComputePoolModel
