# coding: utf-8
"""
    Cortex Embed API.

    OpenAPI 3.0 specification for the Cortex Embed REST API  # noqa: E501

    The version of the OpenAPI document: 0.1.0
    Contact: support@snowflake.com
    Generated by: https://openapi-generator.tech

    Do not edit this file manually.
"""

from __future__ import absolute_import

import logging
from pydantic import Field
from typing_extensions import Annotated
from snowflake.core.cortex.embed_service._generated.models.embed_request import EmbedRequest
from snowflake.core.cortex.embed_service._generated.models.embed_response import EmbedResponse
from typing import Iterable

from snowflake.core.cortex.embed_service._generated.api_client import ApiClient

from concurrent.futures import Future
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Literal, Optional, Tuple, Union, overload
from typing_extensions import Annotated

from snowflake.core._internal.utils import is_running_inside_stored_procedure

from snowflake.core.exceptions import (  # noqa: F401
    _APITypeError, _APIValueError)

logger = logging.getLogger(__name__)


class CortexEmbedApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech.

    Do not edit the class manually.
    """

    def __init__(self, root, resource_class, sproc_client):
        self._root = root
        self._resource_name = 'embed_service'
        self._resource_class = resource_class

        if is_running_inside_stored_procedure():
            self._api_client = sproc_client
        else:
            self._api_client = ApiClient.get_default(self._root)

    @property
    def api_client(self):
        return self._api_client

    @overload
    def embed(
            self,
            embed_request: Annotated[
                EmbedRequest,
                Field(
                    description=
                    "Request payload containing model identifier and input text."
                )],
            async_req: Literal[False] = False,
            **kwargs) -> EmbedResponse:
        ...

    @overload
    def embed(
            self,
            embed_request: Annotated[
                EmbedRequest,
                Field(
                    description=
                    "Request payload containing model identifier and input text."
                )],
            async_req: Literal[True] = True,
            **kwargs) -> Future[EmbedResponse]:
        ...

    @overload
    def embed(
            self,
            embed_request: Annotated[
                EmbedRequest,
                Field(
                    description=
                    "Request payload containing model identifier and input text."
                )],
            async_req: bool = False,
            **kwargs) -> Union[EmbedResponse, Future[EmbedResponse]]:
        ...

    @validate_call
    def embed(self, embed_request: Annotated[
        EmbedRequest,
        Field(description=
              "Request payload containing model identifier and input text.")],
              **kwargs
              ) -> Union[EmbedResponse, Future[EmbedResponse]]:  # noqa: E501
        """Perform LLM embed  # noqa: E501.

        Perform LLM embedding for input text, similar to the Snowflake Cortex `EMBED_TEXT` functions. For more details on available functions, see: - [EMBED_TEXT_768](https://docs.snowflake.com/en/sql-reference/functions/embed_text-snowflake-cortex) - [EMBED_TEXT_1024](https://docs.snowflake.com/en/sql-reference/functions/embed_text_1024-snowflake-cortex)   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.embed(embed_request, async_req=True)
        >>> result = future.result()
        :param embed_request: Request payload containing model identifier and input text. (required)
        :type embed_request: EmbedRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: Union[EmbedResponse, Future[EmbedResponse]]
        """
        kwargs['_return_http_data_only'] = True
        return self.embed_with_http_info(embed_request, **kwargs)  # noqa: E501

    @validate_call
    def embed_with_http_info(self, embed_request: Annotated[
        EmbedRequest,
        Field(description=
              "Request payload containing model identifier and input text.")],
                             **kwargs):  # noqa: E501
        """Perform LLM embed  # noqa: E501.

        Perform LLM embedding for input text, similar to the Snowflake Cortex `EMBED_TEXT` functions. For more details on available functions, see: - [EMBED_TEXT_768](https://docs.snowflake.com/en/sql-reference/functions/embed_text-snowflake-cortex) - [EMBED_TEXT_1024](https://docs.snowflake.com/en/sql-reference/functions/embed_text_1024-snowflake-cortex)   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.embed_with_http_info(embed_request, async_req=True)
        >>> result = future.result()
        :param embed_request: Request payload containing model identifier and input text. (required)
        :type embed_request: EmbedRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: tuple(Union[EmbedResponse, Future[EmbedResponse]], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ['embed_request']
        _all_params.extend([
            'async_req', '_return_http_data_only', '_preload_content',
            '_request_timeout', '_request_auth', '_content_type', '_headers'
        ])

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise _APITypeError("Got an unexpected keyword argument '%s'"
                                    " to method embed" % _key)
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        if _params['embed_request']:
            _body_params = _params['embed_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            '_content_type',
            self.api_client.select_header_content_type(['application/json']))
        if _content_types_list:
            _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = []  # noqa: E501

        _response_types_map = {
            '200': "EmbedResponse",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '404': "ErrorResponse",
            '405': "ErrorResponse",
            '500': "ErrorResponse",
            '503': "ErrorResponse",
            '504': "ErrorResponse",
        }

        return self.api_client.call_api(
            self._root,
            '/api/v2/cortex/inference:embed',
            'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get(
                '_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
