# coding: utf-8
"""
    Cortex Embed API.

    OpenAPI 3.0 specification for the Cortex Embed REST API  # noqa: E501

    The version of the OpenAPI document: 0.1.0
    Contact: support@snowflake.com
    Generated by: https://openapi-generator.tech

    Do not edit this file manually.
"""

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from typing import Union

from pydantic import BaseModel, ConfigDict, Field, StrictStr

from typing import Any, ClassVar, Dict, List

from typing_extensions import Annotated


class EmbedRequest(BaseModel):
    """A model object representing the EmbedRequest resource.

    Constructs an object of type EmbedRequest with the provided properties.

    Parameters
    __________
    model : str
        Identifier of the model to use for generating embeddings.
        Refer to Snowflake documentation for the list of supported models.

        Examples:
          - `snowflake-arctic-embed-m`
          - `snowflake-arctic-embed-m-v1.5`
    text : List[str]
        An array of input texts for which vector embeddings will be calculated.
        Example: ["Hello world", "Machine learning is fascinating"]
    """

    model: StrictStr

    text: Annotated[List[StrictStr], Field(min_length=1)]

    __properties = ["model", "text"]

    class Config:
        populate_by_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> EmbedRequest:
        """Create an instance of EmbedRequest from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""

        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = dict(
            self._iter(to_dict=True,
                       by_alias=True,
                       exclude=exclude_properties,
                       exclude_none=True))

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> EmbedRequest:
        """Create an instance of EmbedRequest from a dict."""

        if obj is None:
            return None

        if type(obj) is not dict:
            return EmbedRequest.parse_obj(obj)

        _obj = EmbedRequest.parse_obj({
            "model": obj.get("model"),
            "text": obj.get("text"),
        })

        return _obj


from typing import Optional, List, Dict


class EmbedRequestModel():

    def __init__(
        self,
        model: str,
        text: List[str],
        # optional properties
    ):
        """A model object representing the EmbedRequest resource.

        Constructs an object of type EmbedRequest with the provided properties.

        Parameters
        __________
        model : str
            Identifier of the model to use for generating embeddings.
Refer to Snowflake documentation for the list of supported models.

Examples:
  - `snowflake-arctic-embed-m`
  - `snowflake-arctic-embed-m-v1.5`

        text : List[str]
            An array of input texts for which vector embeddings will be calculated.
Example: ["Hello world", "Machine learning is fascinating"]
        """

        self.model = model
        self.text = text

    __properties = ["model", "text"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return EmbedRequest(
            model=self.model,
            text=self.text,
        )

    @classmethod
    def _from_model(cls, model) -> EmbedRequestModel:
        return EmbedRequestModel(
            model=model.model,
            text=model.text,
        )

    def to_dict(self):
        """Creates a dictionary of the properties from a EmbedRequest.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the EmbedRequest object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> EmbedRequestModel:
        """Creates an instance of EmbedRequest from a dict.

        This method constructs a EmbedRequest object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        EmbedRequest
            A EmbedRequest object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(EmbedRequest.from_dict(obj))


EmbedRequest._model_class = EmbedRequestModel
