# coding: utf-8
"""
    Cortex Embed API.

    OpenAPI 3.0 specification for the Cortex Embed REST API  # noqa: E501

    The version of the OpenAPI document: 0.1.0
    Contact: support@snowflake.com
    Generated by: https://openapi-generator.tech

    Do not edit this file manually.
"""

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from typing import Union

from snowflake.core.cortex.embed_service._generated.models.embed_response_data_inner import EmbedResponseDataInner

from snowflake.core.cortex.embed_service._generated.models.embed_response_usage import EmbedResponseUsage

from pydantic import BaseModel, ConfigDict, StrictStr, field_validator

from typing import Any, ClassVar, Dict, List


class EmbedResponse(BaseModel):
    """A model object representing the EmbedResponse resource.

    Constructs an object of type EmbedResponse with the provided properties.

    Parameters
    __________
    object : str
        Type of the response object
    data : List[EmbedResponseDataInner]
        List of embedding objects
    model : str
        Name of the embedding model used
    usage : EmbedResponseUsage
    """

    object: StrictStr

    data: List[EmbedResponseDataInner]

    model: StrictStr

    usage: EmbedResponseUsage

    __properties = ["object", "data", "model", "usage"]

    @field_validator('object')
    def object_validate_enum(cls, v):

        if v not in ('list'):
            raise ValueError("must validate the enum values ('list')")
        return v

    class Config:
        populate_by_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> EmbedResponse:
        """Create an instance of EmbedResponse from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""

        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = dict(
            self._iter(to_dict=True,
                       by_alias=True,
                       exclude=exclude_properties,
                       exclude_none=True))

        # override the default output from pydantic by calling `to_dict()` of each item in data (list)
        _items = []
        if self.data:
            for _item in self.data:
                if _item:
                    _items.append(_item.to_dict())
            _dict['data'] = _items

        # override the default output from pydantic by calling `to_dict()` of usage
        if self.usage:
            _dict['usage'] = self.usage.to_dict()

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> EmbedResponse:
        """Create an instance of EmbedResponse from a dict."""

        if obj is None:
            return None

        if type(obj) is not dict:
            return EmbedResponse.parse_obj(obj)

        _obj = EmbedResponse.parse_obj({
            "object":
            obj.get("object"),
            "data": [
                EmbedResponseDataInner.from_dict(_item)
                for _item in obj.get("data")
            ] if obj.get("data") is not None else None,
            "model":
            obj.get("model"),
            "usage":
            EmbedResponseUsage.from_dict(obj.get("usage"))
            if obj.get("usage") is not None else None,
        })

        return _obj


from typing import Optional, List, Dict

from snowflake.core.cortex.embed_service._generated.models.embed_response_data_inner import EmbedResponseDataInner

from snowflake.core.cortex.embed_service._generated.models.embed_response_usage import EmbedResponseUsage


class EmbedResponseModel():

    def __init__(
        self,
        object: str,
        data: List[EmbedResponseDataInner],
        model: str,
        usage: EmbedResponseUsage,
        # optional properties
    ):
        """A model object representing the EmbedResponse resource.

        Constructs an object of type EmbedResponse with the provided properties.

        Parameters
        __________
        object : str
            Type of the response object
        data : List[EmbedResponseDataInner]
            List of embedding objects
        model : str
            Name of the embedding model used
        usage : EmbedResponseUsage
        """

        self.object = object
        self.data = data
        self.model = model
        self.usage = usage

    __properties = ["object", "data", "model", "usage"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return EmbedResponse(
            object=self.object,
            data=[x._to_model()
                  for x in self.data] if self.data is not None else None,
            model=self.model,
            usage=self.usage._to_model() if self.usage is not None else None,
        )

    @classmethod
    def _from_model(cls, model) -> EmbedResponseModel:
        return EmbedResponseModel(
            object=model.object,
            data=[
                EmbedResponseDataInnerModel._from_model(x) for x in model.data
            ] if model.data is not None else None,
            model=model.model,
            usage=EmbedResponseUsageModel._from_model(model.usage)
            if model.usage is not None else None,
        )

    def to_dict(self):
        """Creates a dictionary of the properties from a EmbedResponse.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the EmbedResponse object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> EmbedResponseModel:
        """Creates an instance of EmbedResponse from a dict.

        This method constructs a EmbedResponse object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        EmbedResponse
            A EmbedResponse object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(EmbedResponse.from_dict(obj))


EmbedResponse._model_class = EmbedResponseModel
