# coding: utf-8
"""
    Cortex Inference API.

    OpenAPI 3.0 specification for the Cortex REST API  # noqa: E501

    The version of the OpenAPI document: 0.1.0
    Contact: support@snowflake.com
    Generated by: https://openapi-generator.tech

    Do not edit this file manually.
"""

from __future__ import absolute_import

import logging
from typing import Any, Dict, Optional
from snowflake.core.cortex.inference_service._generated.models.complete_request import CompleteRequest
from typing import Iterable

from snowflake.core.cortex.inference_service._generated.api_client import ApiClient

from concurrent.futures import Future
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Literal, Optional, Tuple, Union, overload
from typing_extensions import Annotated

from snowflake.core._internal.utils import is_running_inside_stored_procedure

from snowflake.core.exceptions import (  # noqa: F401
    _APITypeError, _APIValueError)

logger = logging.getLogger(__name__)


class CortexInferenceApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech.

    Do not edit the class manually.
    """

    def __init__(self, root, resource_class, sproc_client):
        self._root = root
        self._resource_name = 'inference_service'
        self._resource_class = resource_class

        if is_running_inside_stored_procedure():
            self._api_client = sproc_client
        else:
            self._api_client = ApiClient.get_default(self._root)

    @property
    def api_client(self):
        return self._api_client

    @overload
    def cortex_llm_inference_complete(
            self,
            complete_request: Optional[CompleteRequest] = None,
            async_req: Literal[False] = False,
            **kwargs) -> object:
        ...

    @overload
    def cortex_llm_inference_complete(
            self,
            complete_request: Optional[CompleteRequest] = None,
            async_req: Literal[True] = True,
            **kwargs) -> Future[object]:
        ...

    @overload
    def cortex_llm_inference_complete(
            self,
            complete_request: Optional[CompleteRequest] = None,
            async_req: bool = False,
            **kwargs) -> Union[object, Future[object]]:
        ...

    @validate_call
    def cortex_llm_inference_complete(
            self,
            complete_request: Optional[CompleteRequest] = None,
            **kwargs) -> Union[object, Future[object]]:  # noqa: E501
        """Perform LLM text completion inference.  # noqa: E501.

        Perform LLM text completion inference, similar to snowflake.cortex.Complete.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.cortex_llm_inference_complete(complete_request, async_req=True)
        >>> result = future.result()
        :param complete_request:
        :type complete_request: CompleteRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: Union[object, Future[object]]
        """
        kwargs['_return_http_data_only'] = True
        return self.cortex_llm_inference_complete_with_http_info(
            complete_request, **kwargs)  # noqa: E501

    @validate_call
    def cortex_llm_inference_complete_with_http_info(
            self,
            complete_request: Optional[CompleteRequest] = None,
            **kwargs):  # noqa: E501
        """Perform LLM text completion inference.  # noqa: E501.

        Perform LLM text completion inference, similar to snowflake.cortex.Complete.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.cortex_llm_inference_complete_with_http_info(complete_request, async_req=True)
        >>> result = future.result()
        :param complete_request:
        :type complete_request: CompleteRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: tuple(Union[object, Future[object]], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ['complete_request']
        _all_params.extend([
            'async_req', '_return_http_data_only', '_preload_content',
            '_request_timeout', '_request_auth', '_content_type', '_headers'
        ])

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise _APITypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cortex_llm_inference_complete" % _key)
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        if _params['complete_request']:
            _body_params = _params['complete_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/event-stream', 'application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            '_content_type',
            self.api_client.select_header_content_type(['application/json']))
        if _content_types_list:
            _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ExternalOAuth', 'KeyPair',
                          'SnowflakeOAuth']  # noqa: E501

        _response_types_map = {
            '200': "object",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '404': "ErrorResponse",
            '405': "ErrorResponse",
            '500': "ErrorResponse",
            '503': "ErrorResponse",
            '504': "ErrorResponse",
        }

        return self.api_client.call_api(
            self._root,
            '/api/v2/cortex/inference:complete',
            'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get(
                '_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
