# coding: utf-8
"""
    Cortex Inference API.

    OpenAPI 3.0 specification for the Cortex REST API  # noqa: E501

    The version of the OpenAPI document: 0.1.0
    Contact: support@snowflake.com
    Generated by: https://openapi-generator.tech

    Do not edit this file manually.
"""

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from typing import Union

from pydantic import BaseModel, ConfigDict, StrictBool, StrictStr

from typing import Any, ClassVar, Dict, List, Optional


class GuardrailsConfig(BaseModel):
    """A model object representing the GuardrailsConfig resource.

    Constructs an object of type GuardrailsConfig with the provided properties.

    Parameters
    __________
    enabled : bool, optional
        Controls whether guardrails are enabled
    response_when_unsafe : str, optional
        The response when the guardrails model marks the completion as unsafe
    """

    enabled: Optional[StrictBool] = None

    response_when_unsafe: Optional[StrictStr] = None

    __properties = ["enabled", "response_when_unsafe"]

    class Config:
        populate_by_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> GuardrailsConfig:
        """Create an instance of GuardrailsConfig from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""

        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = dict(
            self._iter(to_dict=True,
                       by_alias=True,
                       exclude=exclude_properties,
                       exclude_none=True))

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> GuardrailsConfig:
        """Create an instance of GuardrailsConfig from a dict."""

        if obj is None:
            return None

        if type(obj) is not dict:
            return GuardrailsConfig.parse_obj(obj)

        _obj = GuardrailsConfig.parse_obj({
            "enabled":
            obj.get("enabled"),
            "response_when_unsafe":
            obj.get("response_when_unsafe"),
        })

        return _obj


from typing import Optional, List, Dict


class GuardrailsConfigModel():

    def __init__(
        self,  # optional properties
        enabled: Optional[bool] = None,
        response_when_unsafe: Optional[str] = None,
    ):
        """A model object representing the GuardrailsConfig resource.

        Constructs an object of type GuardrailsConfig with the provided properties.

        Parameters
        __________
        enabled : bool, optional
            Controls whether guardrails are enabled
        response_when_unsafe : str, optional
            The response when the guardrails model marks the completion as unsafe
        """

        self.enabled = enabled
        self.response_when_unsafe = response_when_unsafe

    __properties = ["enabled", "response_when_unsafe"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return GuardrailsConfig(
            enabled=self.enabled,
            response_when_unsafe=self.response_when_unsafe,
        )

    @classmethod
    def _from_model(cls, model) -> GuardrailsConfigModel:
        return GuardrailsConfigModel(
            enabled=model.enabled,
            response_when_unsafe=model.response_when_unsafe,
        )

    def to_dict(self):
        """Creates a dictionary of the properties from a GuardrailsConfig.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the GuardrailsConfig object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> GuardrailsConfigModel:
        """Creates an instance of GuardrailsConfig from a dict.

        This method constructs a GuardrailsConfig object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        GuardrailsConfig
            A GuardrailsConfig object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(GuardrailsConfig.from_dict(obj))


GuardrailsConfig._model_class = GuardrailsConfigModel
