# coding: utf-8
"""
    Cortex Inference API.

    OpenAPI 3.0 specification for the Cortex REST API  # noqa: E501

    The version of the OpenAPI document: 0.1.0
    Contact: support@snowflake.com
    Generated by: https://openapi-generator.tech

    Do not edit this file manually.
"""

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from typing import Union

from snowflake.core.cortex.inference_service._generated.models.non_streaming_complete_response_choices_inner_message import NonStreamingCompleteResponseChoicesInnerMessage

from pydantic import BaseModel, ConfigDict

from typing import Any, ClassVar, Dict, List, Optional


class NonStreamingCompleteResponseChoicesInner(BaseModel):
    """A model object representing the NonStreamingCompleteResponseChoicesInner resource.

    Constructs an object of type NonStreamingCompleteResponseChoicesInner with the provided properties.

    Parameters
    __________
    message : NonStreamingCompleteResponseChoicesInnerMessage, optional
    """

    message: Optional[NonStreamingCompleteResponseChoicesInnerMessage] = None

    __properties = ["message"]

    class Config:
        populate_by_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls,
                  json_str: str) -> NonStreamingCompleteResponseChoicesInner:
        """Create an instance of NonStreamingCompleteResponseChoicesInner from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""

        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = dict(
            self._iter(to_dict=True,
                       by_alias=True,
                       exclude=exclude_properties,
                       exclude_none=True))

        # override the default output from pydantic by calling `to_dict()` of message
        if self.message:
            _dict['message'] = self.message.to_dict()

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> NonStreamingCompleteResponseChoicesInner:
        """Create an instance of NonStreamingCompleteResponseChoicesInner from a dict."""

        if obj is None:
            return None

        if type(obj) is not dict:
            return NonStreamingCompleteResponseChoicesInner.parse_obj(obj)

        _obj = NonStreamingCompleteResponseChoicesInner.parse_obj({
            "message":
            NonStreamingCompleteResponseChoicesInnerMessage.from_dict(
                obj.get("message"))
            if obj.get("message") is not None else None,
        })

        return _obj


from typing import Optional, List, Dict

from snowflake.core.cortex.inference_service._generated.models.non_streaming_complete_response_choices_inner_message import NonStreamingCompleteResponseChoicesInnerMessage


class NonStreamingCompleteResponseChoicesInnerModel():

    def __init__(
        self,  # optional properties
        message: Optional[
            NonStreamingCompleteResponseChoicesInnerMessage] = None,
    ):
        """A model object representing the NonStreamingCompleteResponseChoicesInner resource.

        Constructs an object of type NonStreamingCompleteResponseChoicesInner with the provided properties.

        Parameters
        __________
        message : NonStreamingCompleteResponseChoicesInnerMessage, optional
        """

        self.message = message

    __properties = ["message"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return NonStreamingCompleteResponseChoicesInner(
            message=self.message._to_model()
            if self.message is not None else None, )

    @classmethod
    def _from_model(cls,
                    model) -> NonStreamingCompleteResponseChoicesInnerModel:
        return NonStreamingCompleteResponseChoicesInnerModel(
            message=NonStreamingCompleteResponseChoicesInnerMessageModel.
            _from_model(model.message)
            if model.message is not None else None, )

    def to_dict(self):
        """Creates a dictionary of the properties from a NonStreamingCompleteResponseChoicesInner.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the NonStreamingCompleteResponseChoicesInner object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls,
                  obj: dict) -> NonStreamingCompleteResponseChoicesInnerModel:
        """Creates an instance of NonStreamingCompleteResponseChoicesInner from a dict.

        This method constructs a NonStreamingCompleteResponseChoicesInner object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        NonStreamingCompleteResponseChoicesInner
            A NonStreamingCompleteResponseChoicesInner object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(
            NonStreamingCompleteResponseChoicesInner.from_dict(obj))


NonStreamingCompleteResponseChoicesInner._model_class = NonStreamingCompleteResponseChoicesInnerModel
