# coding: utf-8
"""
    Cortex Inference API.

    OpenAPI 3.0 specification for the Cortex REST API  # noqa: E501

    The version of the OpenAPI document: 0.1.0
    Contact: support@snowflake.com
    Generated by: https://openapi-generator.tech

    Do not edit this file manually.
"""

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from typing import Union

from pydantic import BaseModel, ConfigDict, StrictStr

from typing import Any, ClassVar, Dict, List, Optional


class StreamingToolUse(BaseModel):
    """A model object representing the StreamingToolUse resource.

    Constructs an object of type StreamingToolUse with the provided properties.

    Parameters
    __________
    tool_use_id : str, optional
        Unique identifier for this tool use request
    name : str, optional
        Name of the tool to execute. Must match a tool name from the tools array
    input : str, optional
    """

    tool_use_id: Optional[StrictStr] = None

    name: Optional[StrictStr] = None

    input: Optional[StrictStr] = None

    __properties = ["tool_use_id", "name", "input"]

    class Config:
        populate_by_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> StreamingToolUse:
        """Create an instance of StreamingToolUse from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""

        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = dict(
            self._iter(to_dict=True,
                       by_alias=True,
                       exclude=exclude_properties,
                       exclude_none=True))

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> StreamingToolUse:
        """Create an instance of StreamingToolUse from a dict."""

        if obj is None:
            return None

        if type(obj) is not dict:
            return StreamingToolUse.parse_obj(obj)

        _obj = StreamingToolUse.parse_obj({
            "tool_use_id": obj.get("tool_use_id"),
            "name": obj.get("name"),
            "input": obj.get("input"),
        })

        return _obj


from typing import Optional, List, Dict


class StreamingToolUseModel():

    def __init__(
        self,  # optional properties
        tool_use_id: Optional[str] = None,
        name: Optional[str] = None,
        input: Optional[str] = None,
    ):
        """A model object representing the StreamingToolUse resource.

        Constructs an object of type StreamingToolUse with the provided properties.

        Parameters
        __________
        tool_use_id : str, optional
            Unique identifier for this tool use request
        name : str, optional
            Name of the tool to execute. Must match a tool name from the tools array
        input : str, optional
        """

        self.tool_use_id = tool_use_id
        self.name = name
        self.input = input

    __properties = ["tool_use_id", "name", "input"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return StreamingToolUse(
            tool_use_id=self.tool_use_id,
            name=self.name,
            input=self.input,
        )

    @classmethod
    def _from_model(cls, model) -> StreamingToolUseModel:
        return StreamingToolUseModel(
            tool_use_id=model.tool_use_id,
            name=model.name,
            input=model.input,
        )

    def to_dict(self):
        """Creates a dictionary of the properties from a StreamingToolUse.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the StreamingToolUse object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> StreamingToolUseModel:
        """Creates an instance of StreamingToolUse from a dict.

        This method constructs a StreamingToolUse object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        StreamingToolUse
            A StreamingToolUse object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(StreamingToolUse.from_dict(obj))


StreamingToolUse._model_class = StreamingToolUseModel
