# coding: utf-8
"""
    Cortex Agent API.

    OpenAPI 3.0 specification for the Cortex Agent API  # noqa: E501

    The version of the OpenAPI document: 0.1.0
    Contact: support@snowflake.com
    Generated by: https://openapi-generator.tech

    Do not edit this file manually.
"""

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from typing import Union

from snowflake.core.cortex.lite_agent_service._generated.models.message import Message

from pydantic import BaseModel, ConfigDict

from typing import Any, ClassVar, Dict, List


class AgentRunResponse(BaseModel):
    """A model object representing the AgentRunResponse resource.

    Constructs an object of type AgentRunResponse with the provided properties.

    Parameters
    __________
    messages : List[Message]
        The messages produced by the assistant in response.
        Usually contains tool results followed by a natural language summary.
    """

    messages: List[Message]

    __properties = ["messages"]

    class Config:
        populate_by_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> AgentRunResponse:
        """Create an instance of AgentRunResponse from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""

        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = dict(
            self._iter(to_dict=True,
                       by_alias=True,
                       exclude=exclude_properties,
                       exclude_none=True))

        # override the default output from pydantic by calling `to_dict()` of each item in messages (list)
        _items = []
        if self.messages:
            for _item in self.messages:
                if _item:
                    _items.append(_item.to_dict())
            _dict['messages'] = _items

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> AgentRunResponse:
        """Create an instance of AgentRunResponse from a dict."""

        if obj is None:
            return None

        if type(obj) is not dict:
            return AgentRunResponse.parse_obj(obj)

        _obj = AgentRunResponse.parse_obj({
            "messages":
            [Message.from_dict(_item) for _item in obj.get("messages")]
            if obj.get("messages") is not None else None,
        })

        return _obj


from typing import Optional, List, Dict

from snowflake.core.cortex.lite_agent_service._generated.models.message import Message


class AgentRunResponseModel():

    def __init__(
        self,
        messages: List[Message],
        # optional properties
    ):
        """A model object representing the AgentRunResponse resource.

        Constructs an object of type AgentRunResponse with the provided properties.

        Parameters
        __________
        messages : List[Message]
            The messages produced by the assistant in response.
Usually contains tool results followed by a natural language summary.
        """

        self.messages = messages

    __properties = ["messages"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return AgentRunResponse(
            messages=[x._to_model() for x in self.messages]
            if self.messages is not None else None, )

    @classmethod
    def _from_model(cls, model) -> AgentRunResponseModel:
        return AgentRunResponseModel(
            messages=[MessageModel._from_model(x) for x in model.messages]
            if model.messages is not None else None, )

    def to_dict(self):
        """Creates a dictionary of the properties from a AgentRunResponse.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the AgentRunResponse object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> AgentRunResponseModel:
        """Creates an instance of AgentRunResponse from a dict.

        This method constructs a AgentRunResponse object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        AgentRunResponse
            A AgentRunResponse object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(AgentRunResponse.from_dict(obj))


AgentRunResponse._model_class = AgentRunResponseModel
