# coding: utf-8
"""
    Cortex Agent API.

    OpenAPI 3.0 specification for the Cortex Agent API  # noqa: E501

    The version of the OpenAPI document: 0.1.0
    Contact: support@snowflake.com
    Generated by: https://openapi-generator.tech

    Do not edit this file manually.
"""

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from typing import Union

from pydantic import BaseModel, ConfigDict, StrictInt, StrictStr

from typing import Any, ClassVar, Dict, List, Optional


class SearchResource(BaseModel):
    """A model object representing the SearchResource resource.

    Constructs an object of type SearchResource with the provided properties.

    Parameters
    __________
    search_service : str, optional
        The name of the search service.
        Must in format: database.schema.service_name
    name : str, optional
        reserved
    max_results : int, optional
        The number of search results used in LLM prompt.
    title_column : str, optional
        The title column of the document.
    id_column : str, optional
        The ID column of the document.
    filter : object, optional
        Filter query for search results.
    experimental : object, optional
        reserved
    """

    search_service: Optional[StrictStr] = None

    name: Optional[StrictStr] = None

    max_results: Optional[StrictInt] = None

    title_column: Optional[StrictStr] = None

    id_column: Optional[StrictStr] = None

    filter: Optional[Dict[str, Any]] = None

    experimental: Optional[Dict[str, Any]] = None

    additional_properties: dict[str, Any] = {}

    __properties = [
        "search_service", "name", "max_results", "title_column", "id_column",
        "filter", "experimental"
    ]

    class Config:
        populate_by_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> SearchResource:
        """Create an instance of SearchResource from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""

        exclude_properties = {"additional_properties"}

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = dict(
            self._iter(to_dict=True,
                       by_alias=True,
                       exclude=exclude_properties,
                       exclude_none=True))

        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> SearchResource:
        """Create an instance of SearchResource from a dict."""

        if obj is None:
            return None

        if type(obj) is not dict:
            return SearchResource.parse_obj(obj)

        _obj = SearchResource.parse_obj({
            "search_service":
            obj.get("search_service"),
            "name":
            obj.get("name"),
            "max_results":
            obj.get("max_results"),
            "title_column":
            obj.get("title_column"),
            "id_column":
            obj.get("id_column"),
            "filter":
            obj.get("filter"),
            "experimental":
            obj.get("experimental"),
        })

        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


from typing import Optional, List, Dict


class SearchResourceModel():

    def __init__(
        self,  # optional properties
        search_service: Optional[str] = None,
        name: Optional[str] = None,
        max_results: Optional[int] = None,
        title_column: Optional[str] = None,
        id_column: Optional[str] = None,
        filter: Optional[object] = None,
        experimental: Optional[object] = None,
    ):
        """A model object representing the SearchResource resource.

        Constructs an object of type SearchResource with the provided properties.

        Parameters
        __________
        search_service : str, optional
            The name of the search service.
Must in format: database.schema.service_name

        name : str, optional
            reserved
        max_results : int, optional
            The number of search results used in LLM prompt.

        title_column : str, optional
            The title column of the document.

        id_column : str, optional
            The ID column of the document.

        filter : object, optional
            Filter query for search results.

        experimental : object, optional
            reserved
        """

        self.search_service = search_service
        self.name = name
        self.max_results = max_results
        self.title_column = title_column
        self.id_column = id_column
        self.filter = filter
        self.experimental = experimental

    additional_properties: dict[str, Any] = {}

    __properties = [
        "search_service", "name", "max_results", "title_column", "id_column",
        "filter", "experimental"
    ]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return SearchResource(
            search_service=self.search_service,
            name=self.name,
            max_results=self.max_results,
            title_column=self.title_column,
            id_column=self.id_column,
            filter=self.filter,
            experimental=self.experimental,
        )

    @classmethod
    def _from_model(cls, model) -> SearchResourceModel:
        return SearchResourceModel(
            search_service=model.search_service,
            name=model.name,
            max_results=model.max_results,
            title_column=model.title_column,
            id_column=model.id_column,
            filter=model.filter,
            experimental=model.experimental,
        )

    def to_dict(self):
        """Creates a dictionary of the properties from a SearchResource.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the SearchResource object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> SearchResourceModel:
        """Creates an instance of SearchResource from a dict.

        This method constructs a SearchResource object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        SearchResource
            A SearchResource object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(SearchResource.from_dict(obj))


SearchResource._model_class = SearchResourceModel
