# coding: utf-8
"""
    Cortex Agent API.

    OpenAPI 3.0 specification for the Cortex Agent API  # noqa: E501

    The version of the OpenAPI document: 0.1.0
    Contact: support@snowflake.com
    Generated by: https://openapi-generator.tech

    Do not edit this file manually.
"""

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from typing import Union

from pydantic import BaseModel, ConfigDict, StrictStr

from typing import Any, ClassVar, Dict, List, Optional


class ToolChoice(BaseModel):
    """A model object representing the ToolChoice resource.

    Constructs an object of type ToolChoice with the provided properties.

    Parameters
    __________
    type : str
        Determines how tools are selected:
        * auto - Automatic tool selection (default)
        * required - Must use at least one tool
        * tool - Use specific named tools
    name : List[str], optional
        List of specific tool names to use when type is 'tool'
    """

    type: StrictStr

    name: Optional[List[StrictStr]] = None

    __properties = ["type", "name"]

    class Config:
        populate_by_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ToolChoice:
        """Create an instance of ToolChoice from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""

        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = dict(
            self._iter(to_dict=True,
                       by_alias=True,
                       exclude=exclude_properties,
                       exclude_none=True))

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> ToolChoice:
        """Create an instance of ToolChoice from a dict."""

        if obj is None:
            return None

        if type(obj) is not dict:
            return ToolChoice.parse_obj(obj)

        _obj = ToolChoice.parse_obj({
            "type": obj.get("type"),
            "name": obj.get("name"),
        })

        return _obj


from typing import Optional, List, Dict


class ToolChoiceModel():

    def __init__(
        self,
        type: str,
        # optional properties
        name: Optional[List[str]] = None,
    ):
        """A model object representing the ToolChoice resource.

        Constructs an object of type ToolChoice with the provided properties.

        Parameters
        __________
        type : str
            Determines how tools are selected:
* auto - Automatic tool selection (default)
* required - Must use at least one tool
* tool - Use specific named tools

        name : List[str], optional
            List of specific tool names to use when type is 'tool'
        """

        self.type = type
        self.name = name

    __properties = ["type", "name"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return ToolChoice(
            type=self.type,
            name=self.name,
        )

    @classmethod
    def _from_model(cls, model) -> ToolChoiceModel:
        return ToolChoiceModel(
            type=model.type,
            name=model.name,
        )

    def to_dict(self):
        """Creates a dictionary of the properties from a ToolChoice.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the ToolChoice object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> ToolChoiceModel:
        """Creates an instance of ToolChoice from a dict.

        This method constructs a ToolChoice object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        ToolChoice
            A ToolChoice object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(ToolChoice.from_dict(obj))


ToolChoice._model_class = ToolChoiceModel
