# coding: utf-8
"""
    Cortex Agent API.

    OpenAPI 3.0 specification for the Cortex Agent API  # noqa: E501

    The version of the OpenAPI document: 0.1.0
    Contact: support@snowflake.com
    Generated by: https://openapi-generator.tech

    Do not edit this file manually.
"""

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from typing import Union

from snowflake.core.cortex.lite_agent_service._generated.models.tool_use_tool_use import ToolUseToolUse

from pydantic import BaseModel, ConfigDict, StrictStr, field_validator

from typing import Any, ClassVar, Dict, List


class ToolUse(BaseModel):
    """A model object representing the ToolUse resource.

    Constructs an object of type ToolUse with the provided properties.

    Parameters
    __________
    type : str
        Identifies this as a tool use request
    tool_use : ToolUseToolUse
    """

    type: StrictStr

    tool_use: ToolUseToolUse

    __properties = ["type", "tool_use"]

    @field_validator('type')
    def type_validate_enum(cls, v):

        if v not in ('tool_use'):
            raise ValueError("must validate the enum values ('tool_use')")
        return v

    class Config:
        populate_by_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ToolUse:
        """Create an instance of ToolUse from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""

        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = dict(
            self._iter(to_dict=True,
                       by_alias=True,
                       exclude=exclude_properties,
                       exclude_none=True))

        # override the default output from pydantic by calling `to_dict()` of tool_use
        if self.tool_use:
            _dict['tool_use'] = self.tool_use.to_dict()

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> ToolUse:
        """Create an instance of ToolUse from a dict."""

        if obj is None:
            return None

        if type(obj) is not dict:
            return ToolUse.parse_obj(obj)

        _obj = ToolUse.parse_obj({
            "type":
            obj.get("type"),
            "tool_use":
            ToolUseToolUse.from_dict(obj.get("tool_use"))
            if obj.get("tool_use") is not None else None,
        })

        return _obj


from typing import Optional, List, Dict

from snowflake.core.cortex.lite_agent_service._generated.models.tool_use_tool_use import ToolUseToolUse


class ToolUseModel():

    def __init__(
        self,
        type: str,
        tool_use: ToolUseToolUse,
        # optional properties
    ):
        """A model object representing the ToolUse resource.

        Constructs an object of type ToolUse with the provided properties.

        Parameters
        __________
        type : str
            Identifies this as a tool use request
        tool_use : ToolUseToolUse
        """

        self.type = type
        self.tool_use = tool_use

    __properties = ["type", "tool_use"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return ToolUse(
            type=self.type,
            tool_use=self.tool_use._to_model()
            if self.tool_use is not None else None,
        )

    @classmethod
    def _from_model(cls, model) -> ToolUseModel:
        return ToolUseModel(
            type=model.type,
            tool_use=ToolUseToolUseModel._from_model(model.tool_use)
            if model.tool_use is not None else None,
        )

    def to_dict(self):
        """Creates a dictionary of the properties from a ToolUse.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the ToolUse object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> ToolUseModel:
        """Creates an instance of ToolUse from a dict.

        This method constructs a ToolUse object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        ToolUse
            A ToolUse object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(ToolUse.from_dict(obj))


ToolUse._model_class = ToolUseModel
