# coding: utf-8
"""
    Cortex Search REST API.

    OpenAPI 3.0 specification for the Cortex Search REST API  # noqa: E501

    The version of the OpenAPI document: 0.1.0
    Contact: support@snowflake.com
    Generated by: https://openapi-generator.tech

    Do not edit this file manually.
"""

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from typing import Union

from pydantic import BaseModel, ConfigDict, StrictFloat, StrictInt, StrictStr

from typing import Any, ClassVar, Dict, List, Optional, Union


class ColumnQuery(BaseModel):
    """A model object representing the ColumnQuery resource.

    Constructs an object of type ColumnQuery with the provided properties.

    Parameters
    __________
    text : str, optional
        Unstructured text query for querying a text index.
    vector : List[float], optional
        Query embedding vector. Must be computed using the same model as used for embedding the column being queried.
    """

    text: Optional[StrictStr] = None

    vector: Optional[List[Union[StrictFloat, StrictInt]]] = None

    __properties = ["text", "vector"]

    class Config:
        populate_by_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ColumnQuery:
        """Create an instance of ColumnQuery from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""

        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = dict(
            self._iter(to_dict=True,
                       by_alias=True,
                       exclude=exclude_properties,
                       exclude_none=True))

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> ColumnQuery:
        """Create an instance of ColumnQuery from a dict."""

        if obj is None:
            return None

        if type(obj) is not dict:
            return ColumnQuery.parse_obj(obj)

        _obj = ColumnQuery.parse_obj({
            "text": obj.get("text"),
            "vector": obj.get("vector"),
        })

        return _obj


from typing import Optional, List, Dict


class ColumnQueryModel():

    def __init__(
        self,  # optional properties
        text: Optional[str] = None,
        vector: Optional[List[float]] = None,
    ):
        """A model object representing the ColumnQuery resource.

        Constructs an object of type ColumnQuery with the provided properties.

        Parameters
        __________
        text : str, optional
            Unstructured text query for querying a text index.
        vector : List[float], optional
            Query embedding vector. Must be computed using the same model as used for embedding the column being queried.
        """

        self.text = text
        self.vector = vector

    __properties = ["text", "vector"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return ColumnQuery(
            text=self.text,
            vector=self.vector,
        )

    @classmethod
    def _from_model(cls, model) -> ColumnQueryModel:
        return ColumnQueryModel(
            text=model.text,
            vector=model.vector,
        )

    def to_dict(self):
        """Creates a dictionary of the properties from a ColumnQuery.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the ColumnQuery object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> ColumnQueryModel:
        """Creates an instance of ColumnQuery from a dict.

        This method constructs a ColumnQuery object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        ColumnQuery
            A ColumnQuery object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(ColumnQuery.from_dict(obj))


ColumnQuery._model_class = ColumnQueryModel
