# coding: utf-8
"""
    Cortex Analyst API.

    The Snowflake Cortex Analyst API is a REST API that allows end user to chat with their data leveraging semantic models to generate SQL queries.  # noqa: E501

    The version of the OpenAPI document: 0.0.1
    Contact: support@snowflake.com
    Generated by: https://openapi-generator.tech

    Do not edit this file manually.
"""

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from typing import Union

from snowflake.core.cortex_analyst._generated.models.message_content_delta import MessageContentDelta

from pydantic import ConfigDict, StrictStr

from typing import Any, ClassVar, Dict, List


class MessageContentDeltaTextObject(MessageContentDelta):
    """A model object representing the MessageContentDeltaTextObject resource.

    Constructs an object of type MessageContentDeltaTextObject with the provided properties.

    Parameters
    __________
    text_delta : str
        The delta of the text content, clients should concatenate all deltas for the same index

    index : int, optional
        The index of the content array this delta object represents
    """

    text_delta: StrictStr

    __properties = ["type", "index", "text_delta"]

    class Config:
        populate_by_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> MessageContentDeltaTextObject:
        """Create an instance of MessageContentDeltaTextObject from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""

        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = dict(
            self._iter(to_dict=True,
                       by_alias=True,
                       exclude=exclude_properties,
                       exclude_none=True))

        _dict[
            'type'] = MessageContentDelta.get_child_model_discriminator_value(
                'MessageContentDeltaTextObject')

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> MessageContentDeltaTextObject:
        """Create an instance of MessageContentDeltaTextObject from a dict."""

        if obj is None:
            return None

        if type(obj) is not dict:
            return MessageContentDeltaTextObject.parse_obj(obj)

        _obj = MessageContentDeltaTextObject.parse_obj({
            "index":
            obj.get("index"),
            "text_delta":
            obj.get("text_delta"),
        })

        return _obj


from typing import Optional, List, Dict

from snowflake.core.cortex_analyst._generated.models.message_content_delta import MessageContentDelta


class MessageContentDeltaTextObjectModel(MessageContentDelta):

    def __init__(
        self,
        text_delta: str,
        # optional properties
        index: Optional[int] = None,
    ):
        """A model object representing the MessageContentDeltaTextObject resource.

        Constructs an object of type MessageContentDeltaTextObject with the provided properties.

        Parameters
        __________
        text_delta : str
            The delta of the text content, clients should concatenate all deltas for the same index

        index : int, optional
            The index of the content array this delta object represents
        """

        super().__init__(index=index, )
        self.text_delta = text_delta

    __properties = ["type", "index", "text_delta"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return MessageContentDeltaTextObject(
            index=self.index,
            text_delta=self.text_delta,
        )

    @classmethod
    def _from_model(cls, model) -> MessageContentDeltaTextObjectModel:
        return MessageContentDeltaTextObjectModel(
            index=model.index,
            text_delta=model.text_delta,
        )

    def to_dict(self):
        """Creates a dictionary of the properties from a MessageContentDeltaTextObject.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the MessageContentDeltaTextObject object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> MessageContentDeltaTextObjectModel:
        """Creates an instance of MessageContentDeltaTextObject from a dict.

        This method constructs a MessageContentDeltaTextObject object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        MessageContentDeltaTextObject
            A MessageContentDeltaTextObject object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(MessageContentDeltaTextObject.from_dict(obj))


MessageContentDeltaTextObject._model_class = MessageContentDeltaTextObjectModel
