# coding: utf-8
"""
    Cortex Analyst API.

    The Snowflake Cortex Analyst API is a REST API that allows end user to chat with their data leveraging semantic models to generate SQL queries.  # noqa: E501

    The version of the OpenAPI document: 0.0.1
    Contact: support@snowflake.com
    Generated by: https://openapi-generator.tech

    Do not edit this file manually.
"""

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from typing import Union

from snowflake.core.cortex_analyst._generated.models.message_content import MessageContent

from pydantic import ConfigDict, StrictStr

from typing import Any, ClassVar, Dict, List


class MessageContentResultsObject(MessageContent):
    """A model object representing the MessageContentResultsObject resource.

    Constructs an object of type MessageContentResultsObject with the provided properties.

    Parameters
    __________
    query_id : str
    """

    query_id: StrictStr

    __properties = ["type", "query_id"]

    class Config:
        populate_by_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> MessageContentResultsObject:
        """Create an instance of MessageContentResultsObject from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""

        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = dict(
            self._iter(to_dict=True,
                       by_alias=True,
                       exclude=exclude_properties,
                       exclude_none=True))

        _dict['type'] = MessageContent.get_child_model_discriminator_value(
            'MessageContentResultsObject')

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> MessageContentResultsObject:
        """Create an instance of MessageContentResultsObject from a dict."""

        if obj is None:
            return None

        if type(obj) is not dict:
            return MessageContentResultsObject.parse_obj(obj)

        _obj = MessageContentResultsObject.parse_obj({
            "query_id":
            obj.get("query_id"),
        })

        return _obj


from typing import Optional, List, Dict

from snowflake.core.cortex_analyst._generated.models.message_content import MessageContent


class MessageContentResultsObjectModel(MessageContent):

    def __init__(
        self,
        query_id: str,
        # optional properties
    ):
        """A model object representing the MessageContentResultsObject resource.

        Constructs an object of type MessageContentResultsObject with the provided properties.

        Parameters
        __________
        query_id : str
        """

        super().__init__()
        self.query_id = query_id

    __properties = ["type", "query_id"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return MessageContentResultsObject(query_id=self.query_id, )

    @classmethod
    def _from_model(cls, model) -> MessageContentResultsObjectModel:
        return MessageContentResultsObjectModel(query_id=model.query_id, )

    def to_dict(self):
        """Creates a dictionary of the properties from a MessageContentResultsObject.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the MessageContentResultsObject object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> MessageContentResultsObjectModel:
        """Creates an instance of MessageContentResultsObject from a dict.

        This method constructs a MessageContentResultsObject object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        MessageContentResultsObject
            A MessageContentResultsObject object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(MessageContentResultsObject.from_dict(obj))


MessageContentResultsObject._model_class = MessageContentResultsObjectModel
