# coding: utf-8
"""
    Cortex Analyst API.

    The Snowflake Cortex Analyst API is a REST API that allows end user to chat with their data leveraging semantic models to generate SQL queries.  # noqa: E501

    The version of the OpenAPI document: 0.0.1
    Contact: support@snowflake.com
    Generated by: https://openapi-generator.tech

    Do not edit this file manually.
"""

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from typing import Union

from snowflake.core.cortex_analyst._generated.models.message_content import MessageContent

from pydantic import BaseModel, ConfigDict, StrictStr, field_validator

from typing import Any, ClassVar, Dict, List, Optional


class MessageObject(BaseModel):
    """A model object representing the MessageObject resource.

    Constructs an object of type MessageObject with the provided properties.

    Parameters
    __________
    content : List[MessageContent]
        The content of the message in array of text or SQL.
    role : str, optional
        The entity that produced the message. One of `user` or `analyst`.
    """

    role: Optional[StrictStr] = None

    content: List[MessageContent]

    __properties = ["role", "content"]

    @field_validator('role')
    def role_validate_enum(cls, v):

        if v is None:
            return v
        if v not in ('user', 'analyst'):
            raise ValueError(
                "must validate the enum values ('user','analyst')")
        return v

    class Config:
        populate_by_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> MessageObject:
        """Create an instance of MessageObject from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""

        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = dict(
            self._iter(to_dict=True,
                       by_alias=True,
                       exclude=exclude_properties,
                       exclude_none=True))

        # override the default output from pydantic by calling `to_dict()` of each item in content (list)
        _items = []
        if self.content:
            for _item in self.content:
                if _item:
                    _items.append(_item.to_dict())
            _dict['content'] = _items

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> MessageObject:
        """Create an instance of MessageObject from a dict."""

        if obj is None:
            return None

        if type(obj) is not dict:
            return MessageObject.parse_obj(obj)

        _obj = MessageObject.parse_obj({
            "role":
            obj.get("role"),
            "content":
            [MessageContent.from_dict(_item) for _item in obj.get("content")]
            if obj.get("content") is not None else None,
        })

        return _obj


from typing import Optional, List, Dict

from snowflake.core.cortex_analyst._generated.models.message_content import MessageContent


class MessageObjectModel():

    def __init__(
        self,
        content: List[MessageContent],
        # optional properties
        role: Optional[str] = None,
    ):
        """A model object representing the MessageObject resource.

        Constructs an object of type MessageObject with the provided properties.

        Parameters
        __________
        content : List[MessageContent]
            The content of the message in array of text or SQL.
        role : str, optional
            The entity that produced the message. One of `user` or `analyst`.
        """

        self.role = role
        self.content = content

    __properties = ["role", "content"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return MessageObject(
            role=self.role,
            content=[x._to_model() for x in self.content]
            if self.content is not None else None,
        )

    @classmethod
    def _from_model(cls, model) -> MessageObjectModel:
        return MessageObjectModel(
            role=model.role,
            content=[
                MessageContentModel._from_model(x) for x in model.content
            ] if model.content is not None else None,
        )

    def to_dict(self):
        """Creates a dictionary of the properties from a MessageObject.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the MessageObject object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> MessageObjectModel:
        """Creates an instance of MessageObject from a dict.

        This method constructs a MessageObject object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        MessageObject
            A MessageObject object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(MessageObject.from_dict(obj))


MessageObject._model_class = MessageObjectModel
