# coding: utf-8
"""
    Cortex Analyst API.

    The Snowflake Cortex Analyst API is a REST API that allows end user to chat with their data leveraging semantic models to generate SQL queries.  # noqa: E501

    The version of the OpenAPI document: 0.0.1
    Contact: support@snowflake.com
    Generated by: https://openapi-generator.tech

    Do not edit this file manually.
"""

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from typing import Union

from snowflake.core.cortex_analyst._generated.models.semantic_model_object import SemanticModelObject

from pydantic import BaseModel, ConfigDict, StrictInt

from typing import Any, ClassVar, Dict, List, Optional


class SemanticModelSelection(BaseModel):
    """A model object representing the SemanticModelSelection resource.

    Constructs an object of type SemanticModelSelection with the provided properties.

    Parameters
    __________
    index : int, optional
        The index of the selected semantic model
    identifier : SemanticModelObject, optional
    """

    index: Optional[StrictInt] = None

    identifier: Optional[SemanticModelObject] = None

    __properties = ["index", "identifier"]

    class Config:
        populate_by_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> SemanticModelSelection:
        """Create an instance of SemanticModelSelection from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""

        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = dict(
            self._iter(to_dict=True,
                       by_alias=True,
                       exclude=exclude_properties,
                       exclude_none=True))

        # override the default output from pydantic by calling `to_dict()` of identifier
        if self.identifier:
            _dict['identifier'] = self.identifier.to_dict()

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> SemanticModelSelection:
        """Create an instance of SemanticModelSelection from a dict."""

        if obj is None:
            return None

        if type(obj) is not dict:
            return SemanticModelSelection.parse_obj(obj)

        _obj = SemanticModelSelection.parse_obj({
            "index":
            obj.get("index"),
            "identifier":
            SemanticModelObject.from_dict(obj.get("identifier"))
            if obj.get("identifier") is not None else None,
        })

        return _obj


from typing import Optional, List, Dict

from snowflake.core.cortex_analyst._generated.models.semantic_model_object import SemanticModelObject


class SemanticModelSelectionModel():

    def __init__(
        self,  # optional properties
        index: Optional[int] = None,
        identifier: Optional[SemanticModelObject] = None,
    ):
        """A model object representing the SemanticModelSelection resource.

        Constructs an object of type SemanticModelSelection with the provided properties.

        Parameters
        __________
        index : int, optional
            The index of the selected semantic model
        identifier : SemanticModelObject, optional
        """

        self.index = index
        self.identifier = identifier

    __properties = ["index", "identifier"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return SemanticModelSelection(
            index=self.index,
            identifier=self.identifier._to_model()
            if self.identifier is not None else None,
        )

    @classmethod
    def _from_model(cls, model) -> SemanticModelSelectionModel:
        return SemanticModelSelectionModel(
            index=model.index,
            identifier=SemanticModelObjectModel._from_model(model.identifier)
            if model.identifier is not None else None,
        )

    def to_dict(self):
        """Creates a dictionary of the properties from a SemanticModelSelection.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the SemanticModelSelection object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> SemanticModelSelectionModel:
        """Creates an instance of SemanticModelSelection from a dict.

        This method constructs a SemanticModelSelection object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        SemanticModelSelection
            A SemanticModelSelection object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(SemanticModelSelection.from_dict(obj))


SemanticModelSelection._model_class = SemanticModelSelectionModel
