# coding: utf-8
"""
    Cortex Analyst API.

    The Snowflake Cortex Analyst API is a REST API that allows end user to chat with their data leveraging semantic models to generate SQL queries.  # noqa: E501

    The version of the OpenAPI document: 0.0.1
    Contact: support@snowflake.com
    Generated by: https://openapi-generator.tech

    Do not edit this file manually.
"""

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from typing import Union

from snowflake.core.cortex_analyst._generated.models.warning import Warning

from pydantic import BaseModel, ConfigDict

from typing import Any, ClassVar, Dict, List, Optional


class Warnings(BaseModel):
    """A model object representing the Warnings resource.

    Constructs an object of type Warnings with the provided properties.

    Parameters
    __________
    warnings : List[Warning], optional
    """

    warnings: Optional[List[Warning]] = None

    __properties = ["warnings"]

    class Config:
        populate_by_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Warnings:
        """Create an instance of Warnings from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""

        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = dict(
            self._iter(to_dict=True,
                       by_alias=True,
                       exclude=exclude_properties,
                       exclude_none=True))

        # override the default output from pydantic by calling `to_dict()` of each item in warnings (list)
        _items = []
        if self.warnings:
            for _item in self.warnings:
                if _item:
                    _items.append(_item.to_dict())
            _dict['warnings'] = _items

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> Warnings:
        """Create an instance of Warnings from a dict."""

        if obj is None:
            return None

        if type(obj) is not dict:
            return Warnings.parse_obj(obj)

        _obj = Warnings.parse_obj({
            "warnings":
            [Warning.from_dict(_item) for _item in obj.get("warnings")]
            if obj.get("warnings") is not None else None,
        })

        return _obj


from typing import Optional, List, Dict

from snowflake.core.cortex_analyst._generated.models.warning import Warning


class WarningsModel():

    def __init__(
        self,  # optional properties
        warnings: Optional[List[Warning]] = None,
    ):
        """A model object representing the Warnings resource.

        Constructs an object of type Warnings with the provided properties.

        Parameters
        __________
        warnings : List[Warning], optional
        """

        self.warnings = warnings

    __properties = ["warnings"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return Warnings(warnings=[x._to_model() for x in self.warnings]
                        if self.warnings is not None else None, )

    @classmethod
    def _from_model(cls, model) -> WarningsModel:
        return WarningsModel(
            warnings=[WarningModel._from_model(x) for x in model.warnings]
            if model.warnings is not None else None, )

    def to_dict(self):
        """Creates a dictionary of the properties from a Warnings.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the Warnings object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> WarningsModel:
        """Creates an instance of Warnings from a dict.

        This method constructs a Warnings object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        Warnings
            A Warnings object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(Warnings.from_dict(obj))


Warnings._model_class = WarningsModel
