# coding: utf-8
"""
    Snowflake Dynamic Table API.

    The Snowflake Dynamic Table API is a REST API that you can use to access, update, and perform certain actions on Dynamic Tables resource in a Snowflake database.  # noqa: E501

    The version of the OpenAPI document: 0.0.1
    Contact: support@snowflake.com
    Generated by: https://openapi-generator.tech

    Do not edit this file manually.
"""

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from typing import Union

from snowflake.core.dynamic_table._generated.models.point_of_time import PointOfTime

from snowflake.core.dynamic_table._generated.models.target_lag import TargetLag

from pydantic import BaseModel, ConfigDict, StrictStr

from typing import Any, ClassVar, Dict, List, Optional


class DynamicTableClone(BaseModel):
    """A model object representing the DynamicTableClone resource.

    Constructs an object of type DynamicTableClone with the provided properties.

    Parameters
    __________
    name : str
        Specifies the name for the dynamic table, must be unique for the schema in which the dynamic table is created
    target_lag : TargetLag, optional

    warehouse : str, optional
        Specifies the name of the warehouse that provides the compute resources for refreshing the dynamic table
    point_of_time : PointOfTime, optional
    """

    name: StrictStr

    target_lag: Optional[TargetLag] = None

    warehouse: Optional[StrictStr] = None

    point_of_time: Optional[PointOfTime] = None

    __properties = ["name", "target_lag", "warehouse", "point_of_time"]

    class Config:
        populate_by_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> DynamicTableClone:
        """Create an instance of DynamicTableClone from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""

        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = dict(
            self._iter(to_dict=True,
                       by_alias=True,
                       exclude=exclude_properties,
                       exclude_none=True))

        # override the default output from pydantic by calling `to_dict()` of target_lag
        if self.target_lag:
            _dict['target_lag'] = self.target_lag.to_dict()

        # override the default output from pydantic by calling `to_dict()` of point_of_time
        if self.point_of_time:
            _dict['point_of_time'] = self.point_of_time.to_dict()

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> DynamicTableClone:
        """Create an instance of DynamicTableClone from a dict."""

        if obj is None:
            return None

        if type(obj) is not dict:
            return DynamicTableClone.parse_obj(obj)

        _obj = DynamicTableClone.parse_obj({
            "name":
            obj.get("name"),
            "target_lag":
            TargetLag.from_dict(obj.get("target_lag"))
            if obj.get("target_lag") is not None else None,
            "warehouse":
            obj.get("warehouse"),
            "point_of_time":
            PointOfTime.from_dict(obj.get("point_of_time"))
            if obj.get("point_of_time") is not None else None,
        })

        return _obj


from typing import Optional, List, Dict

from snowflake.core.dynamic_table._generated.models.point_of_time import PointOfTime

from snowflake.core.dynamic_table._generated.models.target_lag import TargetLag


class DynamicTableCloneModel():

    def __init__(
        self,
        name: str,
        # optional properties
        target_lag: Optional[TargetLag] = None,
        warehouse: Optional[str] = None,
        point_of_time: Optional[PointOfTime] = None,
    ):
        """A model object representing the DynamicTableClone resource.

        Constructs an object of type DynamicTableClone with the provided properties.

        Parameters
        __________
        name : str
            Specifies the name for the dynamic table, must be unique for the schema in which the dynamic table is created
        target_lag : TargetLag, optional

        warehouse : str, optional
            Specifies the name of the warehouse that provides the compute resources for refreshing the dynamic table
        point_of_time : PointOfTime, optional
        """

        self.name = name
        self.target_lag = target_lag
        self.warehouse = warehouse
        self.point_of_time = point_of_time

    __properties = ["name", "target_lag", "warehouse", "point_of_time"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return DynamicTableClone(
            name=self.name,
            target_lag=self.target_lag._to_model()
            if self.target_lag is not None else None,
            warehouse=self.warehouse,
            point_of_time=self.point_of_time._to_model()
            if self.point_of_time is not None else None,
        )

    @classmethod
    def _from_model(cls, model) -> DynamicTableCloneModel:
        return DynamicTableCloneModel(
            name=model.name,
            target_lag=TargetLagModel._from_model(model.target_lag)
            if model.target_lag is not None else None,
            warehouse=model.warehouse,
            point_of_time=PointOfTimeModel._from_model(model.point_of_time)
            if model.point_of_time is not None else None,
        )

    def to_dict(self):
        """Creates a dictionary of the properties from a DynamicTableClone.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the DynamicTableClone object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> DynamicTableCloneModel:
        """Creates an instance of DynamicTableClone from a dict.

        This method constructs a DynamicTableClone object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        DynamicTableClone
            A DynamicTableClone object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(DynamicTableClone.from_dict(obj))


DynamicTableClone._model_class = DynamicTableCloneModel
