# coding: utf-8
"""
    Snowflake Event Table API.

    The Snowflake Event Table API is a REST API that you can use to access, update, and perform certain actions on Event Table resource in a Snowflake database.  # noqa: E501

    The version of the OpenAPI document: 0.0.1
    Contact: support@snowflake.com
    Generated by: https://openapi-generator.tech

    Do not edit this file manually.
"""

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from typing import Union

from snowflake.core.event_table._generated.models.event_table_column import EventTableColumn

from datetime import datetime

from pydantic import BaseModel, ConfigDict, StrictBool, StrictInt, StrictStr

from typing import Any, ClassVar, Dict, List, Optional


class EventTable(BaseModel):
    """A model object representing the EventTable resource.

    Constructs an object of type EventTable with the provided properties.

    Parameters
    __________
    name : str
        Name of the event table
    cluster_by : List[str], optional
        Cluster key column(s) or expression
    data_retention_time_in_days : int, optional
        number of days to retain the old version of deleted/updated data
    max_data_extension_time_in_days : int, optional
        Maximum number of days to extend data retention beyond the retention period to prevent a stream becoming stale.
    change_tracking : bool, optional
        True if change tracking is enabled, allowing streams and CHANGES to be used on the entity.
    default_ddl_collation : str, optional
        Collation that is used for all the new columns created by the DDL statements (if not specified)
    comment : str, optional
        user comment associated to an object in the dictionary
    created_on : datetime, optional
        Date and time when the event table was created.
    database_name : str, optional
        Database in which the event table is stored
    schema_name : str, optional
        Schema in which the event table is stored
    owner : str, optional
        Role that owns the event table
    owner_role_type : str, optional
        The type of role that owns the event table
    rows : int, optional
        Number of rows in the table.
    bytes : int, optional
        Number of bytes that will be scanned if the entire table is scanned in a query.Note that this number may be different than the number of actual physical bytes stored on-disk for the table
    automatic_clustering : bool, optional
        If Automatic Clustering is enabled for your account, specifies whether it is explicitly enabled or disabled for the table.
    search_optimization : bool, optional
        If ON, the table has the search optimization service enabled
    search_optimization_progress : int, optional
        Percentage of the table that has been optimized for search
    search_optimization_bytes : int, optional
        Number of additional bytes of storage that the search optimization service consumes for this table
    columns : List[EventTableColumn], optional
    """

    name: StrictStr

    cluster_by: Optional[List[StrictStr]] = None

    data_retention_time_in_days: Optional[StrictInt] = None

    max_data_extension_time_in_days: Optional[StrictInt] = None

    change_tracking: Optional[StrictBool] = None

    default_ddl_collation: Optional[StrictStr] = None

    comment: Optional[StrictStr] = None

    created_on: Optional[datetime] = None

    database_name: Optional[StrictStr] = None

    schema_name: Optional[StrictStr] = None

    owner: Optional[StrictStr] = None

    owner_role_type: Optional[StrictStr] = None

    rows: Optional[StrictInt] = None

    bytes: Optional[StrictInt] = None

    automatic_clustering: Optional[StrictBool] = None

    search_optimization: Optional[StrictBool] = None

    search_optimization_progress: Optional[StrictInt] = None

    search_optimization_bytes: Optional[StrictInt] = None

    columns: Optional[List[EventTableColumn]] = None

    __properties = [
        "name", "cluster_by", "data_retention_time_in_days",
        "max_data_extension_time_in_days", "change_tracking",
        "default_ddl_collation", "comment", "created_on", "database_name",
        "schema_name", "owner", "owner_role_type", "rows", "bytes",
        "automatic_clustering", "search_optimization",
        "search_optimization_progress", "search_optimization_bytes", "columns"
    ]

    class Config:
        populate_by_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> EventTable:
        """Create an instance of EventTable from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""

        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({
                "created_on",
                "database_name",
                "schema_name",
                "owner",
                "owner_role_type",
                "rows",
                "bytes",
                "automatic_clustering",
                "search_optimization",
                "search_optimization_progress",
                "search_optimization_bytes",
                "columns",
            })

        _dict = dict(
            self._iter(to_dict=True,
                       by_alias=True,
                       exclude=exclude_properties,
                       exclude_none=True))

        # override the default output from pydantic by calling `to_dict()` of each item in columns (list)
        _items = []
        if self.columns:
            for _item in self.columns:
                if _item:
                    _items.append(_item.to_dict())
            _dict['columns'] = _items

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> EventTable:
        """Create an instance of EventTable from a dict."""

        if obj is None:
            return None

        if type(obj) is not dict:
            return EventTable.parse_obj(obj)

        _obj = EventTable.parse_obj({
            "name":
            obj.get("name"),
            "cluster_by":
            obj.get("cluster_by"),
            "data_retention_time_in_days":
            obj.get("data_retention_time_in_days"),
            "max_data_extension_time_in_days":
            obj.get("max_data_extension_time_in_days"),
            "change_tracking":
            obj.get("change_tracking"),
            "default_ddl_collation":
            obj.get("default_ddl_collation"),
            "comment":
            obj.get("comment"),
            "created_on":
            obj.get("created_on"),
            "database_name":
            obj.get("database_name"),
            "schema_name":
            obj.get("schema_name"),
            "owner":
            obj.get("owner"),
            "owner_role_type":
            obj.get("owner_role_type"),
            "rows":
            obj.get("rows"),
            "bytes":
            obj.get("bytes"),
            "automatic_clustering":
            obj.get("automatic_clustering"),
            "search_optimization":
            obj.get("search_optimization"),
            "search_optimization_progress":
            obj.get("search_optimization_progress"),
            "search_optimization_bytes":
            obj.get("search_optimization_bytes"),
            "columns": [
                EventTableColumn.from_dict(_item)
                for _item in obj.get("columns")
            ] if obj.get("columns") is not None else None,
        })

        return _obj


from typing import Optional, List, Dict

from snowflake.core.event_table._generated.models.event_table_column import EventTableColumn


class EventTableModel():

    def __init__(
        self,
        name: str,
        # optional properties
        cluster_by: Optional[List[str]] = None,
        data_retention_time_in_days: Optional[int] = None,
        max_data_extension_time_in_days: Optional[int] = None,
        change_tracking: Optional[bool] = None,
        default_ddl_collation: Optional[str] = None,
        comment: Optional[str] = None,
        created_on: Optional[datetime] = None,
        database_name: Optional[str] = None,
        schema_name: Optional[str] = None,
        owner: Optional[str] = None,
        owner_role_type: Optional[str] = None,
        rows: Optional[int] = None,
        bytes: Optional[int] = None,
        automatic_clustering: Optional[bool] = None,
        search_optimization: Optional[bool] = None,
        search_optimization_progress: Optional[int] = None,
        search_optimization_bytes: Optional[int] = None,
        columns: Optional[List[EventTableColumn]] = None,
    ):
        """A model object representing the EventTable resource.

        Constructs an object of type EventTable with the provided properties.

        Parameters
        __________
        name : str
            Name of the event table
        cluster_by : List[str], optional
            Cluster key column(s) or expression
        data_retention_time_in_days : int, optional
            number of days to retain the old version of deleted/updated data
        max_data_extension_time_in_days : int, optional
            Maximum number of days to extend data retention beyond the retention period to prevent a stream becoming stale.
        change_tracking : bool, optional
            True if change tracking is enabled, allowing streams and CHANGES to be used on the entity.
        default_ddl_collation : str, optional
            Collation that is used for all the new columns created by the DDL statements (if not specified)
        comment : str, optional
            user comment associated to an object in the dictionary
        created_on : datetime, optional
            Date and time when the event table was created.
        database_name : str, optional
            Database in which the event table is stored
        schema_name : str, optional
            Schema in which the event table is stored
        owner : str, optional
            Role that owns the event table
        owner_role_type : str, optional
            The type of role that owns the event table
        rows : int, optional
            Number of rows in the table.
        bytes : int, optional
            Number of bytes that will be scanned if the entire table is scanned in a query.Note that this number may be different than the number of actual physical bytes stored on-disk for the table
        automatic_clustering : bool, optional
            If Automatic Clustering is enabled for your account, specifies whether it is explicitly enabled or disabled for the table.
        search_optimization : bool, optional
            If ON, the table has the search optimization service enabled
        search_optimization_progress : int, optional
            Percentage of the table that has been optimized for search
        search_optimization_bytes : int, optional
            Number of additional bytes of storage that the search optimization service consumes for this table
        columns : List[EventTableColumn], optional
        """

        self.name = name
        self.cluster_by = cluster_by
        self.data_retention_time_in_days = data_retention_time_in_days
        self.max_data_extension_time_in_days = max_data_extension_time_in_days
        self.change_tracking = change_tracking
        self.default_ddl_collation = default_ddl_collation
        self.comment = comment
        self.created_on = created_on
        self.database_name = database_name
        self.schema_name = schema_name
        self.owner = owner
        self.owner_role_type = owner_role_type
        self.rows = rows
        self.bytes = bytes
        self.automatic_clustering = automatic_clustering
        self.search_optimization = search_optimization
        self.search_optimization_progress = search_optimization_progress
        self.search_optimization_bytes = search_optimization_bytes
        self.columns = columns

    __properties = [
        "name", "cluster_by", "data_retention_time_in_days",
        "max_data_extension_time_in_days", "change_tracking",
        "default_ddl_collation", "comment", "created_on", "database_name",
        "schema_name", "owner", "owner_role_type", "rows", "bytes",
        "automatic_clustering", "search_optimization",
        "search_optimization_progress", "search_optimization_bytes", "columns"
    ]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return EventTable(
            name=self.name,
            cluster_by=self.cluster_by,
            data_retention_time_in_days=self.data_retention_time_in_days,
            max_data_extension_time_in_days=self.
            max_data_extension_time_in_days,
            change_tracking=self.change_tracking,
            default_ddl_collation=self.default_ddl_collation,
            comment=self.comment,
            created_on=self.created_on,
            database_name=self.database_name,
            schema_name=self.schema_name,
            owner=self.owner,
            owner_role_type=self.owner_role_type,
            rows=self.rows,
            bytes=self.bytes,
            automatic_clustering=self.automatic_clustering,
            search_optimization=self.search_optimization,
            search_optimization_progress=self.search_optimization_progress,
            search_optimization_bytes=self.search_optimization_bytes,
            columns=[x._to_model() for x in self.columns]
            if self.columns is not None else None,
        )

    @classmethod
    def _from_model(cls, model) -> EventTableModel:
        return EventTableModel(
            name=model.name,
            cluster_by=model.cluster_by,
            data_retention_time_in_days=model.data_retention_time_in_days,
            max_data_extension_time_in_days=model.
            max_data_extension_time_in_days,
            change_tracking=model.change_tracking,
            default_ddl_collation=model.default_ddl_collation,
            comment=model.comment,
            created_on=model.created_on,
            database_name=model.database_name,
            schema_name=model.schema_name,
            owner=model.owner,
            owner_role_type=model.owner_role_type,
            rows=model.rows,
            bytes=model.bytes,
            automatic_clustering=model.automatic_clustering,
            search_optimization=model.search_optimization,
            search_optimization_progress=model.search_optimization_progress,
            search_optimization_bytes=model.search_optimization_bytes,
            columns=[
                EventTableColumnModel._from_model(x) for x in model.columns
            ] if model.columns is not None else None,
        )

    def to_dict(self):
        """Creates a dictionary of the properties from a EventTable.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the EventTable object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> EventTableModel:
        """Creates an instance of EventTable from a dict.

        This method constructs a EventTable object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        EventTable
            A EventTable object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(EventTable.from_dict(obj))


EventTable._model_class = EventTableModel
