# coding: utf-8
"""
    Snowflake Function API.

    The Snowflake Function API is a REST API that allows caller to create, execute and drop functions in a Snowflake database.  # noqa: E501

    The version of the OpenAPI document: 0.0.1
    Contact: support@snowflake.com
    Generated by: https://openapi-generator.tech

    Do not edit this file manually.
"""

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from typing import Union

from snowflake.core.function._generated.models.function import Function

from snowflake.core.function._generated.models.function_argument import FunctionArgument

from pydantic import ConfigDict, Field, StrictStr, field_validator

from typing import Any, ClassVar, Dict, List, Optional

from typing_extensions import Annotated


class ServiceFunction(Function):
    """A model object representing the ServiceFunction resource.

    Constructs an object of type ServiceFunction with the provided properties.

    Parameters
    __________

    name : str
        Specifies the name for the function, must be unique for the schema in which the function is created

    arguments : List[FunctionArgument]

    service : str
        A Snowflake object identifier.
    endpoint : str
        Function's endpoint
    path : str
        Function's path

    returns : str,  default 'TEXT'
        Specifies the type for the function return value.

    max_batch_rows : int, optional
        Specifies the max rows for batch operation.

    created_on : datetime, optional
        Date and time when the function was created.

    signature : str, optional
        Function's arguments.

    language : str, optional
        Function's language.

    body : str, optional
        Function's body.

    service_database : str, optional
        A Snowflake object identifier.
    service_schema : str, optional
        A Snowflake object identifier.
    """

    service: Annotated[str, Field(strict=True)]

    service_database: Optional[Annotated[str, Field(strict=True)]] = None

    service_schema: Optional[Annotated[str, Field(strict=True)]] = None

    endpoint: StrictStr

    path: StrictStr

    __properties = [
        "function_type", "name", "arguments", "returns", "max_batch_rows",
        "created_on", "signature", "language", "body"
    ]

    @field_validator('service')
    def service_validate_regular_expression(cls, v):

        if not re.match(r"""^\"([^\"]|\"\")+\"|[a-zA-Z_][a-zA-Z0-9_$]*$""", v):
            raise ValueError(
                r"""must validate the regular expression /^"([^"]|"")+"|[a-zA-Z_][a-zA-Z0-9_$]*$/"""
            )
        return v

    @field_validator('service_database')
    def service_database_validate_regular_expression(cls, v):

        if v is None:
            return v
        if not re.match(r"""^\"([^\"]|\"\")+\"|[a-zA-Z_][a-zA-Z0-9_$]*$""", v):
            raise ValueError(
                r"""must validate the regular expression /^"([^"]|"")+"|[a-zA-Z_][a-zA-Z0-9_$]*$/"""
            )
        return v

    @field_validator('service_schema')
    def service_schema_validate_regular_expression(cls, v):

        if v is None:
            return v
        if not re.match(r"""^\"([^\"]|\"\")+\"|[a-zA-Z_][a-zA-Z0-9_$]*$""", v):
            raise ValueError(
                r"""must validate the regular expression /^"([^"]|"")+"|[a-zA-Z_][a-zA-Z0-9_$]*$/"""
            )
        return v

    class Config:
        populate_by_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ServiceFunction:
        """Create an instance of ServiceFunction from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""

        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = dict(
            self._iter(to_dict=True,
                       by_alias=True,
                       exclude=exclude_properties,
                       exclude_none=True))

        _dict['function_type'] = Function.get_child_model_discriminator_value(
            'ServiceFunction')

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> ServiceFunction:
        """Create an instance of ServiceFunction from a dict."""

        if obj is None:
            return None

        if type(obj) is not dict:
            return ServiceFunction.parse_obj(obj)

        _obj = ServiceFunction.parse_obj({
            "name":
            obj.get("name"),
            "arguments": [
                FunctionArgument.from_dict(_item)
                for _item in obj.get("arguments")
            ] if obj.get("arguments") is not None else None,
            "returns":
            obj.get("returns") if obj.get("returns") is not None else 'TEXT',
            "max_batch_rows":
            obj.get("max_batch_rows"),
            "created_on":
            obj.get("created_on"),
            "signature":
            obj.get("signature"),
            "language":
            obj.get("language"),
            "body":
            obj.get("body"),
            "service":
            obj.get("service"),
            "service_database":
            obj.get("service_database"),
            "service_schema":
            obj.get("service_schema"),
            "endpoint":
            obj.get("endpoint"),
            "path":
            obj.get("path"),
        })

        return _obj


from typing import Optional, List, Dict

from snowflake.core.function._generated.models.function import Function

from snowflake.core.function._generated.models.function_argument import FunctionArgument


class ServiceFunctionModel(Function):

    def __init__(
        self,
        name: str,
        arguments: List[FunctionArgument],
        service: str,
        endpoint: str,
        path: str,
        # optional properties
        returns: Optional[str] = 'TEXT',
        max_batch_rows: Optional[int] = None,
        created_on: Optional[datetime] = None,
        signature: Optional[str] = None,
        language: Optional[str] = None,
        body: Optional[str] = None,
        service_database: Optional[str] = None,
        service_schema: Optional[str] = None,
    ):
        """A model object representing the ServiceFunction resource.

        Constructs an object of type ServiceFunction with the provided properties.

        Parameters
        __________

        name : str
            Specifies the name for the function, must be unique for the schema in which the function is created

        arguments : List[FunctionArgument]

        service : str
            A Snowflake object identifier.
        endpoint : str
            Function's endpoint
        path : str
            Function's path

        returns : str,  default 'TEXT'
            Specifies the type for the function return value.

        max_batch_rows : int, optional
            Specifies the max rows for batch operation.

        created_on : datetime, optional
            Date and time when the function was created.

        signature : str, optional
            Function's arguments.

        language : str, optional
            Function's language.

        body : str, optional
            Function's body.

        service_database : str, optional
            A Snowflake object identifier.
        service_schema : str, optional
            A Snowflake object identifier.
        """

        super().__init__(
            name=name,
            arguments=arguments,
            returns=returns,
            max_batch_rows=max_batch_rows,
            created_on=created_on,
            signature=signature,
            language=language,
            body=body,
        )
        self.service = service
        self.service_database = service_database
        self.service_schema = service_schema
        self.endpoint = endpoint
        self.path = path

    __properties = [
        "function_type", "name", "arguments", "returns", "max_batch_rows",
        "created_on", "signature", "language", "body"
    ]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return ServiceFunction(
            name=self.name,
            arguments=[x._to_model() for x in self.arguments]
            if self.arguments is not None else None,
            returns=self.returns,
            max_batch_rows=self.max_batch_rows,
            created_on=self.created_on,
            signature=self.signature,
            language=self.language,
            body=self.body,
            service=self.service,
            service_database=self.service_database,
            service_schema=self.service_schema,
            endpoint=self.endpoint,
            path=self.path,
        )

    @classmethod
    def _from_model(cls, model) -> ServiceFunctionModel:
        return ServiceFunctionModel(
            name=model.name,
            arguments=[
                FunctionArgumentModel._from_model(x) for x in model.arguments
            ] if model.arguments is not None else None,
            returns=model.returns,
            max_batch_rows=model.max_batch_rows,
            created_on=model.created_on,
            signature=model.signature,
            language=model.language,
            body=model.body,
            service=model.service,
            service_database=model.service_database,
            service_schema=model.service_schema,
            endpoint=model.endpoint,
            path=model.path,
        )

    def to_dict(self):
        """Creates a dictionary of the properties from a ServiceFunction.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the ServiceFunction object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> ServiceFunctionModel:
        """Creates an instance of ServiceFunction from a dict.

        This method constructs a ServiceFunction object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        ServiceFunction
            A ServiceFunction object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(ServiceFunction.from_dict(obj))


ServiceFunction._model_class = ServiceFunctionModel
