# coding: utf-8
"""
    Snowflake Image Repository API.

    The Snowflake Image Repository API is a REST API that you can use to access, update, and perform common actions on Image Repository resource in Snowflake.  # noqa: E501

    The version of the OpenAPI document: 0.0.1
    Contact: support@snowflake.com
    Generated by: https://openapi-generator.tech

    Do not edit this file manually.
"""

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from typing import Union

from pydantic import BaseModel, ConfigDict, StrictStr

from typing import Any, ClassVar, Dict, List, Optional


class Image(BaseModel):
    """A model object representing the Image resource.

    Constructs an object of type Image with the provided properties.

    Parameters
    __________
    created_on : str, optional
        Date and time when the image was uploaded to the image repository.
    image_name : str, optional
        Image name.
    tags : str, optional
        Image tags.
    digest : str, optional
        SHA256 digest of the image.
    image_path : str, optional
        Image path (database_name/schema_name/repository_name/image_name:image_tag).
    """

    created_on: Optional[StrictStr] = None

    image_name: Optional[StrictStr] = None

    tags: Optional[StrictStr] = None

    digest: Optional[StrictStr] = None

    image_path: Optional[StrictStr] = None

    __properties = ["created_on", "image_name", "tags", "digest", "image_path"]

    class Config:
        populate_by_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Image:
        """Create an instance of Image from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""

        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({
                "created_on",
                "image_name",
                "tags",
                "digest",
                "image_path",
            })

        _dict = dict(
            self._iter(to_dict=True,
                       by_alias=True,
                       exclude=exclude_properties,
                       exclude_none=True))

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> Image:
        """Create an instance of Image from a dict."""

        if obj is None:
            return None

        if type(obj) is not dict:
            return Image.parse_obj(obj)

        _obj = Image.parse_obj({
            "created_on": obj.get("created_on"),
            "image_name": obj.get("image_name"),
            "tags": obj.get("tags"),
            "digest": obj.get("digest"),
            "image_path": obj.get("image_path"),
        })

        return _obj


from typing import Optional, List, Dict


class ImageModel():

    def __init__(
        self,  # optional properties
        created_on: Optional[str] = None,
        image_name: Optional[str] = None,
        tags: Optional[str] = None,
        digest: Optional[str] = None,
        image_path: Optional[str] = None,
    ):
        """A model object representing the Image resource.

        Constructs an object of type Image with the provided properties.

        Parameters
        __________
        created_on : str, optional
            Date and time when the image was uploaded to the image repository.
        image_name : str, optional
            Image name.
        tags : str, optional
            Image tags.
        digest : str, optional
            SHA256 digest of the image.
        image_path : str, optional
            Image path (database_name/schema_name/repository_name/image_name:image_tag).
        """

        self.created_on = created_on
        self.image_name = image_name
        self.tags = tags
        self.digest = digest
        self.image_path = image_path

    __properties = ["created_on", "image_name", "tags", "digest", "image_path"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return Image(
            created_on=self.created_on,
            image_name=self.image_name,
            tags=self.tags,
            digest=self.digest,
            image_path=self.image_path,
        )

    @classmethod
    def _from_model(cls, model) -> ImageModel:
        return ImageModel(
            created_on=model.created_on,
            image_name=model.image_name,
            tags=model.tags,
            digest=model.digest,
            image_path=model.image_path,
        )

    def to_dict(self):
        """Creates a dictionary of the properties from a Image.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the Image object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> ImageModel:
        """Creates an instance of Image from a dict.

        This method constructs a Image object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        Image
            A Image object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(Image.from_dict(obj))


Image._model_class = ImageModel
