# coding: utf-8
"""
    Snowflake Notebook API.

    The Snowflake Notebook API is a REST API that you can use to access, update, and perform certain actions on Notebook resource in a Snowflake database.  # noqa: E501

    The version of the OpenAPI document: 0.0.1
    Contact: support@snowflake.com
    Generated by: https://openapi-generator.tech

    Do not edit this file manually.
"""

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from typing import Union

from snowflake.core.notebook._generated.models.version_details import VersionDetails

from datetime import datetime

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator

from typing import Any, ClassVar, Dict, List, Optional

from typing_extensions import Annotated


class Notebook(BaseModel):
    """A model object representing the Notebook resource.

    Constructs an object of type Notebook with the provided properties.

    Parameters
    __________
    name : str
        Name of the notebook
    version : str, optional
        User specified version alias
    from_location : str, optional
        Location to copy the file from. This must be a Snowflake stage location.
    main_file : str, optional
        Name + path of the file for the Notebook
    comment : str, optional
        user comment associated to an object in the dictionary
    default_version : str, optional
        The default version name of a file based entity.
    query_warehouse : str, optional
        Warehouse against which the queries issued by the Streamlit app are run against
    created_on : datetime, optional
        Date and time when the notebook was created.
    database_name : str, optional
        Database in which the notebook is stored
    schema_name : str, optional
        Schema in which the notebook is stored
    owner : str, optional
        Role that owns the notebook
    owner_role_type : str, optional
        The type of role that owns the notebook
    url_id : str, optional
        Unique ID associated with the notebook object.
    title : str, optional
        User facing title of the Streamlit app or an Organization Profile
    default_packages : str, optional
        Default packages of the notebook
    user_packages : str, optional
        User packages of the notebook
    runtime_name : str, optional
        The runtime to run the Streamlit or Notebook on.  If this is not set, the warehouse is assumed
    compute_pool : str, optional
        Compute pool name where the snowservice runs
    import_urls : List[str], optional
        List of urls
    external_access_integrations : List[str], optional
        List of external access integrations attached to this function
    external_access_secrets : str, optional
        Secrets to be used with this function for external access
    idle_auto_shutdown_time_seconds : int, optional
        Sets the time in seconds for when to shutdown an idle Notebook.
    default_version_details : VersionDetails, optional

    last_version_details : VersionDetails, optional

    live_version_location_uri : str, optional
        The current version location
    budget : str, optional
        Name of the budget if the notebook is monitored by a budget
    """

    name: Annotated[str, Field(strict=True)]

    version: Optional[StrictStr] = None

    from_location: Optional[StrictStr] = Field(default=None,
                                               alias="fromLocation")

    main_file: Optional[StrictStr] = None

    comment: Optional[StrictStr] = None

    default_version: Optional[StrictStr] = None

    query_warehouse: Optional[StrictStr] = None

    created_on: Optional[datetime] = None

    database_name: Optional[Annotated[str, Field(strict=True)]] = None

    schema_name: Optional[Annotated[str, Field(strict=True)]] = None

    owner: Optional[Annotated[str, Field(strict=True)]] = None

    owner_role_type: Optional[Annotated[str, Field(strict=True)]] = None

    url_id: Optional[StrictStr] = None

    title: Optional[StrictStr] = None

    default_packages: Optional[StrictStr] = None

    user_packages: Optional[StrictStr] = None

    runtime_name: Optional[StrictStr] = None

    compute_pool: Optional[StrictStr] = None

    import_urls: Optional[List[StrictStr]] = None

    external_access_integrations: Optional[List[StrictStr]] = None

    external_access_secrets: Optional[StrictStr] = None

    idle_auto_shutdown_time_seconds: Optional[StrictInt] = None

    default_version_details: Optional[VersionDetails] = None

    last_version_details: Optional[VersionDetails] = None

    live_version_location_uri: Optional[StrictStr] = None

    budget: Optional[Annotated[str, Field(strict=True)]] = None

    __properties = [
        "name", "version", "fromLocation", "main_file", "comment",
        "default_version", "query_warehouse", "created_on", "database_name",
        "schema_name", "owner", "owner_role_type", "url_id", "title",
        "default_packages", "user_packages", "runtime_name", "compute_pool",
        "import_urls", "external_access_integrations",
        "external_access_secrets", "idle_auto_shutdown_time_seconds",
        "default_version_details", "last_version_details",
        "live_version_location_uri", "budget"
    ]

    @field_validator('name')
    def name_validate_regular_expression(cls, v):

        if not re.match(r"""^\"([^\"]|\"\")+\"|[a-zA-Z_][a-zA-Z0-9_$]*$""", v):
            raise ValueError(
                r"""must validate the regular expression /^"([^"]|"")+"|[a-zA-Z_][a-zA-Z0-9_$]*$/"""
            )
        return v

    @field_validator('database_name')
    def database_name_validate_regular_expression(cls, v):

        if v is None:
            return v
        if not re.match(r"""^\"([^\"]|\"\")+\"|[a-zA-Z_][a-zA-Z0-9_$]*$""", v):
            raise ValueError(
                r"""must validate the regular expression /^"([^"]|"")+"|[a-zA-Z_][a-zA-Z0-9_$]*$/"""
            )
        return v

    @field_validator('schema_name')
    def schema_name_validate_regular_expression(cls, v):

        if v is None:
            return v
        if not re.match(r"""^\"([^\"]|\"\")+\"|[a-zA-Z_][a-zA-Z0-9_$]*$""", v):
            raise ValueError(
                r"""must validate the regular expression /^"([^"]|"")+"|[a-zA-Z_][a-zA-Z0-9_$]*$/"""
            )
        return v

    @field_validator('owner')
    def owner_validate_regular_expression(cls, v):

        if v is None:
            return v
        if not re.match(r"""^\"([^\"]|\"\")+\"|[a-zA-Z_][a-zA-Z0-9_$]*$""", v):
            raise ValueError(
                r"""must validate the regular expression /^"([^"]|"")+"|[a-zA-Z_][a-zA-Z0-9_$]*$/"""
            )
        return v

    @field_validator('owner_role_type')
    def owner_role_type_validate_regular_expression(cls, v):

        if v is None:
            return v
        if not re.match(r"""^\"([^\"]|\"\")+\"|[a-zA-Z_][a-zA-Z0-9_$]*$""", v):
            raise ValueError(
                r"""must validate the regular expression /^"([^"]|"")+"|[a-zA-Z_][a-zA-Z0-9_$]*$/"""
            )
        return v

    @field_validator('budget')
    def budget_validate_regular_expression(cls, v):

        if v is None:
            return v
        if not re.match(r"""^\"([^\"]|\"\")+\"|[a-zA-Z_][a-zA-Z0-9_$]*$""", v):
            raise ValueError(
                r"""must validate the regular expression /^"([^"]|"")+"|[a-zA-Z_][a-zA-Z0-9_$]*$/"""
            )
        return v

    class Config:
        populate_by_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Notebook:
        """Create an instance of Notebook from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""

        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({
                "created_on",
                "database_name",
                "schema_name",
                "owner",
                "owner_role_type",
                "url_id",
                "title",
                "default_packages",
                "user_packages",
                "runtime_name",
                "compute_pool",
                "import_urls",
                "external_access_integrations",
                "external_access_secrets",
                "idle_auto_shutdown_time_seconds",
                "live_version_location_uri",
                "budget",
            })

        _dict = dict(
            self._iter(to_dict=True,
                       by_alias=True,
                       exclude=exclude_properties,
                       exclude_none=True))

        # override the default output from pydantic by calling `to_dict()` of default_version_details
        if self.default_version_details:
            _dict[
                'default_version_details'] = self.default_version_details.to_dict(
                )

        # override the default output from pydantic by calling `to_dict()` of last_version_details
        if self.last_version_details:
            _dict['last_version_details'] = self.last_version_details.to_dict()

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> Notebook:
        """Create an instance of Notebook from a dict."""

        if obj is None:
            return None

        if type(obj) is not dict:
            return Notebook.parse_obj(obj)

        _obj = Notebook.parse_obj({
            "name":
            obj.get("name"),
            "version":
            obj.get("version"),
            "from_location":
            obj.get("fromLocation"),
            "main_file":
            obj.get("main_file"),
            "comment":
            obj.get("comment"),
            "default_version":
            obj.get("default_version"),
            "query_warehouse":
            obj.get("query_warehouse"),
            "created_on":
            obj.get("created_on"),
            "database_name":
            obj.get("database_name"),
            "schema_name":
            obj.get("schema_name"),
            "owner":
            obj.get("owner"),
            "owner_role_type":
            obj.get("owner_role_type"),
            "url_id":
            obj.get("url_id"),
            "title":
            obj.get("title"),
            "default_packages":
            obj.get("default_packages"),
            "user_packages":
            obj.get("user_packages"),
            "runtime_name":
            obj.get("runtime_name"),
            "compute_pool":
            obj.get("compute_pool"),
            "import_urls":
            obj.get("import_urls"),
            "external_access_integrations":
            obj.get("external_access_integrations"),
            "external_access_secrets":
            obj.get("external_access_secrets"),
            "idle_auto_shutdown_time_seconds":
            obj.get("idle_auto_shutdown_time_seconds"),
            "default_version_details":
            VersionDetails.from_dict(obj.get("default_version_details"))
            if obj.get("default_version_details") is not None else None,
            "last_version_details":
            VersionDetails.from_dict(obj.get("last_version_details"))
            if obj.get("last_version_details") is not None else None,
            "live_version_location_uri":
            obj.get("live_version_location_uri"),
            "budget":
            obj.get("budget"),
        })

        return _obj


from typing import Optional, List, Dict

from snowflake.core.notebook._generated.models.version_details import VersionDetails


class NotebookModel():

    def __init__(
        self,
        name: str,
        # optional properties
        version: Optional[str] = None,
        from_location: Optional[str] = None,
        main_file: Optional[str] = None,
        comment: Optional[str] = None,
        default_version: Optional[str] = None,
        query_warehouse: Optional[str] = None,
        created_on: Optional[datetime] = None,
        database_name: Optional[str] = None,
        schema_name: Optional[str] = None,
        owner: Optional[str] = None,
        owner_role_type: Optional[str] = None,
        url_id: Optional[str] = None,
        title: Optional[str] = None,
        default_packages: Optional[str] = None,
        user_packages: Optional[str] = None,
        runtime_name: Optional[str] = None,
        compute_pool: Optional[str] = None,
        import_urls: Optional[List[str]] = None,
        external_access_integrations: Optional[List[str]] = None,
        external_access_secrets: Optional[str] = None,
        idle_auto_shutdown_time_seconds: Optional[int] = None,
        default_version_details: Optional[VersionDetails] = None,
        last_version_details: Optional[VersionDetails] = None,
        live_version_location_uri: Optional[str] = None,
        budget: Optional[str] = None,
    ):
        """A model object representing the Notebook resource.

        Constructs an object of type Notebook with the provided properties.

        Parameters
        __________
        name : str
            Name of the notebook
        version : str, optional
            User specified version alias
        from_location : str, optional
            Location to copy the file from. This must be a Snowflake stage location.
        main_file : str, optional
            Name + path of the file for the Notebook
        comment : str, optional
            user comment associated to an object in the dictionary
        default_version : str, optional
            The default version name of a file based entity.
        query_warehouse : str, optional
            Warehouse against which the queries issued by the Streamlit app are run against
        created_on : datetime, optional
            Date and time when the notebook was created.
        database_name : str, optional
            Database in which the notebook is stored
        schema_name : str, optional
            Schema in which the notebook is stored
        owner : str, optional
            Role that owns the notebook
        owner_role_type : str, optional
            The type of role that owns the notebook
        url_id : str, optional
            Unique ID associated with the notebook object.
        title : str, optional
            User facing title of the Streamlit app or an Organization Profile
        default_packages : str, optional
            Default packages of the notebook
        user_packages : str, optional
            User packages of the notebook
        runtime_name : str, optional
            The runtime to run the Streamlit or Notebook on.  If this is not set, the warehouse is assumed
        compute_pool : str, optional
            Compute pool name where the snowservice runs
        import_urls : List[str], optional
            List of urls
        external_access_integrations : List[str], optional
            List of external access integrations attached to this function
        external_access_secrets : str, optional
            Secrets to be used with this function for external access
        idle_auto_shutdown_time_seconds : int, optional
            Sets the time in seconds for when to shutdown an idle Notebook.
        default_version_details : VersionDetails, optional

        last_version_details : VersionDetails, optional

        live_version_location_uri : str, optional
            The current version location
        budget : str, optional
            Name of the budget if the notebook is monitored by a budget
        """

        self.name = name
        self.version = version
        self.from_location = from_location
        self.main_file = main_file
        self.comment = comment
        self.default_version = default_version
        self.query_warehouse = query_warehouse
        self.created_on = created_on
        self.database_name = database_name
        self.schema_name = schema_name
        self.owner = owner
        self.owner_role_type = owner_role_type
        self.url_id = url_id
        self.title = title
        self.default_packages = default_packages
        self.user_packages = user_packages
        self.runtime_name = runtime_name
        self.compute_pool = compute_pool
        self.import_urls = import_urls
        self.external_access_integrations = external_access_integrations
        self.external_access_secrets = external_access_secrets
        self.idle_auto_shutdown_time_seconds = idle_auto_shutdown_time_seconds
        self.default_version_details = default_version_details
        self.last_version_details = last_version_details
        self.live_version_location_uri = live_version_location_uri
        self.budget = budget

    __properties = [
        "name", "version", "fromLocation", "main_file", "comment",
        "default_version", "query_warehouse", "created_on", "database_name",
        "schema_name", "owner", "owner_role_type", "url_id", "title",
        "default_packages", "user_packages", "runtime_name", "compute_pool",
        "import_urls", "external_access_integrations",
        "external_access_secrets", "idle_auto_shutdown_time_seconds",
        "default_version_details", "last_version_details",
        "live_version_location_uri", "budget"
    ]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return Notebook(
            name=self.name,
            version=self.version,
            from_location=self.from_location,
            main_file=self.main_file,
            comment=self.comment,
            default_version=self.default_version,
            query_warehouse=self.query_warehouse,
            created_on=self.created_on,
            database_name=self.database_name,
            schema_name=self.schema_name,
            owner=self.owner,
            owner_role_type=self.owner_role_type,
            url_id=self.url_id,
            title=self.title,
            default_packages=self.default_packages,
            user_packages=self.user_packages,
            runtime_name=self.runtime_name,
            compute_pool=self.compute_pool,
            import_urls=self.import_urls,
            external_access_integrations=self.external_access_integrations,
            external_access_secrets=self.external_access_secrets,
            idle_auto_shutdown_time_seconds=self.
            idle_auto_shutdown_time_seconds,
            default_version_details=self.default_version_details._to_model()
            if self.default_version_details is not None else None,
            last_version_details=self.last_version_details._to_model()
            if self.last_version_details is not None else None,
            live_version_location_uri=self.live_version_location_uri,
            budget=self.budget,
        )

    @classmethod
    def _from_model(cls, model) -> NotebookModel:
        return NotebookModel(
            name=model.name,
            version=model.version,
            from_location=model.from_location,
            main_file=model.main_file,
            comment=model.comment,
            default_version=model.default_version,
            query_warehouse=model.query_warehouse,
            created_on=model.created_on,
            database_name=model.database_name,
            schema_name=model.schema_name,
            owner=model.owner,
            owner_role_type=model.owner_role_type,
            url_id=model.url_id,
            title=model.title,
            default_packages=model.default_packages,
            user_packages=model.user_packages,
            runtime_name=model.runtime_name,
            compute_pool=model.compute_pool,
            import_urls=model.import_urls,
            external_access_integrations=model.external_access_integrations,
            external_access_secrets=model.external_access_secrets,
            idle_auto_shutdown_time_seconds=model.
            idle_auto_shutdown_time_seconds,
            default_version_details=VersionDetailsModel._from_model(
                model.default_version_details)
            if model.default_version_details is not None else None,
            last_version_details=VersionDetailsModel._from_model(
                model.last_version_details)
            if model.last_version_details is not None else None,
            live_version_location_uri=model.live_version_location_uri,
            budget=model.budget,
        )

    def to_dict(self):
        """Creates a dictionary of the properties from a Notebook.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the Notebook object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> NotebookModel:
        """Creates an instance of Notebook from a dict.

        This method constructs a Notebook object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        Notebook
            A Notebook object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(Notebook.from_dict(obj))


Notebook._model_class = NotebookModel
