# coding: utf-8
"""
    Snowflake Notification Integration API.

    The Snowflake Notification Integration API is a REST API that you can use to access, update, and perform certain actions on Notification Integration resource in a Snowflake database.  # noqa: E501

    The version of the OpenAPI document: 0.0.1
    Contact: support@snowflake.com
    Generated by: https://openapi-generator.tech

    Do not edit this file manually.
"""

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

import snowflake.core.notification_integration._generated.models
from snowflake.core.notification_integration._generated.models import *

from typing import Union

from importlib import import_module

from pydantic import BaseModel, ConfigDict

from typing import Any, ClassVar, Dict, List, Union


class NotificationHook(BaseModel):
    """A model object representing the NotificationHook resource.

    Constructs an object of type NotificationHook with the provided properties.

    Parameters
    __________
    """

    __properties = ["type"]

    class Config:
        populate_by_name = True
        validate_assignment = True

    # JSON field name that stores the object type
    __discriminator_property_name: ClassVar[str] = 'type'

    # discriminator mappings
    __discriminator_value_class_map: ClassVar[Dict[str, str]] = {
        'EMAIL': 'NotificationEmail',
        'QUEUE_AWS_SNS_OUTBOUND': 'NotificationQueueAwsSnsOutbound',
        'QUEUE_AZURE_EVENT_GRID_INBOUND':
        'NotificationQueueAzureEventGridInbound',
        'QUEUE_AZURE_EVENT_GRID_OUTBOUND':
        'NotificationQueueAzureEventGridOutbound',
        'QUEUE_GCP_PUBSUB_INBOUND': 'NotificationQueueGcpPubsubInbound',
        'QUEUE_GCP_PUBSUB_OUTBOUND': 'NotificationQueueGcpPubsubOutbound',
        'WEBHOOK': 'NotificationWebhook'
    }

    @classmethod
    def get_discriminator_value(cls, obj: dict[str, Any]) -> Optional[str]:
        """Returns the discriminator value (object type) of the data."""
        discriminator_value = obj[cls.__discriminator_property_name]
        if discriminator_value:
            return cls.__discriminator_value_class_map.get(discriminator_value)
        else:
            return None

    __discriminator_value_to_type: ClassVar[Dict[str, str]] = {
        'NotificationEmail': 'EMAIL',
        'NotificationQueueAwsSnsOutbound': 'QUEUE_AWS_SNS_OUTBOUND',
        'NotificationQueueAzureEventGridInbound':
        'QUEUE_AZURE_EVENT_GRID_INBOUND',
        'NotificationQueueAzureEventGridOutbound':
        'QUEUE_AZURE_EVENT_GRID_OUTBOUND',
        'NotificationQueueGcpPubsubInbound': 'QUEUE_GCP_PUBSUB_INBOUND',
        'NotificationQueueGcpPubsubOutbound': 'QUEUE_GCP_PUBSUB_OUTBOUND',
        'NotificationWebhook': 'WEBHOOK',
    }

    @classmethod
    def get_child_model_discriminator_value(cls, child_model: str) -> str:
        return cls.__discriminator_value_to_type[child_model]

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(
        cls, json_str: str
    ) -> Union[NotificationEmail, NotificationQueueAwsSnsOutbound,
               NotificationQueueAzureEventGridInbound,
               NotificationQueueAzureEventGridOutbound,
               NotificationQueueGcpPubsubInbound,
               NotificationQueueGcpPubsubOutbound, NotificationWebhook]:
        """Create an instance of NotificationHook from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""

        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = dict(
            self._iter(to_dict=True,
                       by_alias=True,
                       exclude=exclude_properties,
                       exclude_none=True))

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(
        cls, obj: dict
    ) -> Union[NotificationEmail, NotificationQueueAwsSnsOutbound,
               NotificationQueueAzureEventGridInbound,
               NotificationQueueAzureEventGridOutbound,
               NotificationQueueGcpPubsubInbound,
               NotificationQueueGcpPubsubOutbound, NotificationWebhook]:
        """Create an instance of NotificationHook from a dict."""

        # look up the object type based on discriminator mapping
        object_type = cls.get_discriminator_value(obj)
        if object_type:
            klass = getattr(
                snowflake.core.notification_integration._generated.models,
                object_type)
            return klass.from_dict(obj)
        else:
            raise ValueError(
                "NotificationHook failed to lookup discriminator value from " +
                json.dumps(obj) + ". Discriminator property name: " +
                cls.__discriminator_property_name + ", mapping: " +
                json.dumps(cls.__discriminator_value_class_map))


from typing import Optional, List, Dict


class NotificationHookModel():

    def __init__(
            self,  # optional properties
    ):
        """A model object representing the NotificationHook resource.

        Constructs an object of type NotificationHook with the provided properties.

        Parameters
        __________
        """

        pass

    __properties = ["type"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return NotificationHook()

    @classmethod
    def _from_model(cls, model) -> NotificationHookModel:
        return model.__class__._model_class._from_model(model)

    def to_dict(self):
        """Creates a dictionary of the properties from a NotificationHook.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the NotificationHook object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(
        cls, obj: dict
    ) -> Union[NotificationEmailModel, NotificationQueueAwsSnsOutboundModel,
               NotificationQueueAzureEventGridInboundModel,
               NotificationQueueAzureEventGridOutboundModel,
               NotificationQueueGcpPubsubInboundModel,
               NotificationQueueGcpPubsubOutboundModel,
               NotificationWebhookModel]:
        """Creates an instance of NotificationHook from a dict.

        This method constructs a NotificationHook object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        NotificationHook
            A NotificationHook object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(NotificationHook.from_dict(obj))


NotificationHook._model_class = NotificationHookModel
