# coding: utf-8
"""
    Snowflake Notification Integration API.

    The Snowflake Notification Integration API is a REST API that you can use to access, update, and perform certain actions on Notification Integration resource in a Snowflake database.  # noqa: E501

    The version of the OpenAPI document: 0.0.1
    Contact: support@snowflake.com
    Generated by: https://openapi-generator.tech

    Do not edit this file manually.
"""

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from typing import Union

from snowflake.core.notification_integration._generated.models.notification_hook import NotificationHook

from pydantic import ConfigDict, StrictStr

from typing import Any, ClassVar, Dict, List, Optional


class NotificationQueueGcpPubsubOutbound(NotificationHook):
    """A model object representing the NotificationQueueGcpPubsubOutbound resource.

    Constructs an object of type NotificationQueueGcpPubsubOutbound with the provided properties.

    Parameters
    __________
    gcp_pubsub_topic_name : str, optional
        Identification of the Pub/Sub topic to which Snowpipe pushes notifications.
    gcp_pubsub_service_account : str, optional
        Google Cloud Platform (GCP) service account created for your account.
    """

    gcp_pubsub_topic_name: Optional[StrictStr] = None

    gcp_pubsub_service_account: Optional[StrictStr] = None

    __properties = ["type"]

    class Config:
        populate_by_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> NotificationQueueGcpPubsubOutbound:
        """Create an instance of NotificationQueueGcpPubsubOutbound from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""

        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({
                "gcp_pubsub_service_account",
            })

        _dict = dict(
            self._iter(to_dict=True,
                       by_alias=True,
                       exclude=exclude_properties,
                       exclude_none=True))

        _dict['type'] = NotificationHook.get_child_model_discriminator_value(
            'NotificationQueueGcpPubsubOutbound')

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> NotificationQueueGcpPubsubOutbound:
        """Create an instance of NotificationQueueGcpPubsubOutbound from a dict."""

        if obj is None:
            return None

        if type(obj) is not dict:
            return NotificationQueueGcpPubsubOutbound.parse_obj(obj)

        _obj = NotificationQueueGcpPubsubOutbound.parse_obj({
            "gcp_pubsub_topic_name":
            obj.get("gcp_pubsub_topic_name"),
            "gcp_pubsub_service_account":
            obj.get("gcp_pubsub_service_account"),
        })

        return _obj


from typing import Optional, List, Dict

from snowflake.core.notification_integration._generated.models.notification_hook import NotificationHook


class NotificationQueueGcpPubsubOutboundModel(NotificationHook):

    def __init__(
        self,  # optional properties
        gcp_pubsub_topic_name: Optional[str] = None,
        gcp_pubsub_service_account: Optional[str] = None,
    ):
        """A model object representing the NotificationQueueGcpPubsubOutbound resource.

        Constructs an object of type NotificationQueueGcpPubsubOutbound with the provided properties.

        Parameters
        __________
        gcp_pubsub_topic_name : str, optional
            Identification of the Pub/Sub topic to which Snowpipe pushes notifications.
        gcp_pubsub_service_account : str, optional
            Google Cloud Platform (GCP) service account created for your account.
        """

        super().__init__()
        self.gcp_pubsub_topic_name = gcp_pubsub_topic_name
        self.gcp_pubsub_service_account = gcp_pubsub_service_account

    __properties = ["type"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return NotificationQueueGcpPubsubOutbound(
            gcp_pubsub_topic_name=self.gcp_pubsub_topic_name,
            gcp_pubsub_service_account=self.gcp_pubsub_service_account,
        )

    @classmethod
    def _from_model(cls, model) -> NotificationQueueGcpPubsubOutboundModel:
        return NotificationQueueGcpPubsubOutboundModel(
            gcp_pubsub_topic_name=model.gcp_pubsub_topic_name,
            gcp_pubsub_service_account=model.gcp_pubsub_service_account,
        )

    def to_dict(self):
        """Creates a dictionary of the properties from a NotificationQueueGcpPubsubOutbound.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the NotificationQueueGcpPubsubOutbound object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> NotificationQueueGcpPubsubOutboundModel:
        """Creates an instance of NotificationQueueGcpPubsubOutbound from a dict.

        This method constructs a NotificationQueueGcpPubsubOutbound object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        NotificationQueueGcpPubsubOutbound
            A NotificationQueueGcpPubsubOutbound object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(
            NotificationQueueGcpPubsubOutbound.from_dict(obj))


NotificationQueueGcpPubsubOutbound._model_class = NotificationQueueGcpPubsubOutboundModel
