# coding: utf-8
"""
    Snowflake Services API.

    The Snowflake Services API is a REST API that you can use to access, update, and perform certain actions on Services resource in a Snowflake database.  # noqa: E501

    The version of the OpenAPI document: 0.0.1
    Contact: support@snowflake.com
    Generated by: https://openapi-generator.tech

    Do not edit this file manually.
"""

from __future__ import absolute_import

import logging
from pydantic import Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import List, Optional
from typing_extensions import Annotated
from snowflake.core.service._generated.models.fetch_service_logs200_response import FetchServiceLogs200Response
from snowflake.core.service._generated.models.fetch_service_status200_response import FetchServiceStatus200Response
from snowflake.core.service._generated.models.grant_of import GrantOf
from snowflake.core.service._generated.models.job_service import JobService
from snowflake.core.service._generated.models.service import Service
from snowflake.core.service._generated.models.service_container import ServiceContainer
from snowflake.core.service._generated.models.service_endpoint import ServiceEndpoint
from snowflake.core.service._generated.models.service_instance import ServiceInstance
from snowflake.core.service._generated.models.service_role import ServiceRole
from snowflake.core.service._generated.models.service_role_grant_to import ServiceRoleGrantTo
from snowflake.core.service._generated.models.success_response import SuccessResponse
from typing import Iterable

from snowflake.core.service._generated.api_client import ApiClient

from concurrent.futures import Future
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Literal, Optional, Tuple, Union, overload
from typing_extensions import Annotated

from snowflake.core._internal.utils import is_running_inside_stored_procedure

from snowflake.core.exceptions import (  # noqa: F401
    _APITypeError, _APIValueError)

logger = logging.getLogger(__name__)


class ServiceApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech.

    Do not edit the class manually.
    """

    def __init__(self, root, resource_class, sproc_client):
        self._root = root
        self._resource_name = 'service'
        self._resource_class = resource_class

        if is_running_inside_stored_procedure():
            self._api_client = sproc_client
        else:
            self._api_client = ApiClient.get_default(self._root)

    @property
    def api_client(self):
        return self._api_client

    @overload
    def create_or_alter_service(
            self,
            database:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
            var_schema:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )],
            name: Annotated[
                str,
                Field(strict=True,
                      description="Identifier (i.e. name) for the resource.")],
            service: Service,
            async_req: Literal[False] = False,
            **kwargs) -> SuccessResponse:
        ...

    @overload
    def create_or_alter_service(
            self,
            database:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
            var_schema:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )],
            name: Annotated[
                str,
                Field(strict=True,
                      description="Identifier (i.e. name) for the resource.")],
            service: Service,
            async_req: Literal[True] = True,
            **kwargs) -> Future[SuccessResponse]:
        ...

    @overload
    def create_or_alter_service(
            self,
            database:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
            var_schema:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )],
            name: Annotated[
                str,
                Field(strict=True,
                      description="Identifier (i.e. name) for the resource.")],
            service: Service,
            async_req: bool = False,
            **kwargs) -> Union[SuccessResponse, Future[SuccessResponse]]:
        ...

    @validate_call
    def create_or_alter_service(self, database: Annotated[
        str,
        Field(
            strict=True,
            description=
            "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
        )], var_schema: Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )], name: Annotated[
                str,
                Field(strict=True,
                      description="Identifier (i.e. name) for the resource.")],
                                service: Service, **kwargs) -> Union[
                                    SuccessResponse,
                                    Future[SuccessResponse]]:  # noqa: E501
        """Create a (or alter an existing) service.  # noqa: E501.

        Create a (or alter an existing) service. Even if the operation is just an alter, the full property set must be provided.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.create_or_alter_service(database, var_schema, name, service, async_req=True)
        >>> result = future.result()
        :param database: Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases. (required)
        :type database: str
        :param var_schema: Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database. (required)
        :type var_schema: str
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param service: (required)
        :type service: Service
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: Union[SuccessResponse, Future[SuccessResponse]]
        """
        kwargs['_return_http_data_only'] = True
        return self.create_or_alter_service_with_http_info(
            database, var_schema, name, service, **kwargs)  # noqa: E501

    @validate_call
    def create_or_alter_service_with_http_info(self, database: Annotated[
        str,
        Field(
            strict=True,
            description=
            "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
        )], var_schema: Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )], name: Annotated[
                str,
                Field(strict=True,
                      description="Identifier (i.e. name) for the resource.")],
                                               service: Service,
                                               **kwargs):  # noqa: E501
        """Create a (or alter an existing) service.  # noqa: E501.

        Create a (or alter an existing) service. Even if the operation is just an alter, the full property set must be provided.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.create_or_alter_service_with_http_info(database, var_schema, name, service, async_req=True)
        >>> result = future.result()
        :param database: Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases. (required)
        :type database: str
        :param var_schema: Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database. (required)
        :type var_schema: str
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param service: (required)
        :type service: Service
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: tuple(Union[SuccessResponse, Future[SuccessResponse]], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ['database', 'var_schema', 'name', 'service']
        _all_params.extend([
            'async_req', '_return_http_data_only', '_preload_content',
            '_request_timeout', '_request_auth', '_content_type', '_headers'
        ])

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise _APITypeError("Got an unexpected keyword argument '%s'"
                                    " to method create_or_alter_service" %
                                    _key)
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        if _params['database']:
            _path_params['database'] = _params['database']

        if _params['var_schema']:
            _path_params['schema'] = _params['var_schema']

        if _params['name']:
            _path_params['name'] = _params['name']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        if _params['service']:
            _body_params = _params['service']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            '_content_type',
            self.api_client.select_header_content_type(['application/json']))
        if _content_types_list:
            _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ExternalOAuth', 'KeyPair',
                          'SnowflakeOAuth']  # noqa: E501

        _response_types_map = {
            '200': "SuccessResponse",
            '202': "SuccessAcceptedResponse",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '404': "ErrorResponse",
            '405': "ErrorResponse",
            '500': "ErrorResponse",
            '503': "ErrorResponse",
            '504': "ErrorResponse",
        }

        return self.api_client.call_api(
            self._root,
            '/api/v2/databases/{database}/schemas/{schema}/services/{name}',
            'PUT',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get(
                '_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @overload
    def create_service(
            self,
            database:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
            var_schema:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )],
            service: Service,
            create_mode:
        Annotated[
            Optional[StrictStr],
            Field(
                description=
                "Query parameter allowing support for different modes of resource creation. Possible values include: - `errorIfExists`: Throws an error if you try to create a resource that already exists. - `ifNotExists`: Creates a new resource when an alter is requested for a non-existent resource."
            )] = None,
            async_req: Literal[False] = False,
            **kwargs) -> SuccessResponse:
        ...

    @overload
    def create_service(
            self,
            database:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
            var_schema:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )],
            service: Service,
            create_mode:
        Annotated[
            Optional[StrictStr],
            Field(
                description=
                "Query parameter allowing support for different modes of resource creation. Possible values include: - `errorIfExists`: Throws an error if you try to create a resource that already exists. - `ifNotExists`: Creates a new resource when an alter is requested for a non-existent resource."
            )] = None,
            async_req: Literal[True] = True,
            **kwargs) -> Future[SuccessResponse]:
        ...

    @overload
    def create_service(
            self,
            database:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
            var_schema:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )],
            service: Service,
            create_mode:
        Annotated[
            Optional[StrictStr],
            Field(
                description=
                "Query parameter allowing support for different modes of resource creation. Possible values include: - `errorIfExists`: Throws an error if you try to create a resource that already exists. - `ifNotExists`: Creates a new resource when an alter is requested for a non-existent resource."
            )] = None,
            async_req: bool = False,
            **kwargs) -> Union[SuccessResponse, Future[SuccessResponse]]:
        ...

    @validate_call
    def create_service(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )],
        service: Service,
        create_mode: Annotated[
            Optional[StrictStr],
            Field(
                description=
                "Query parameter allowing support for different modes of resource creation. Possible values include: - `errorIfExists`: Throws an error if you try to create a resource that already exists. - `ifNotExists`: Creates a new resource when an alter is requested for a non-existent resource."
            )] = None,
        **kwargs
    ) -> Union[SuccessResponse, Future[SuccessResponse]]:  # noqa: E501
        """Create a service  # noqa: E501.

        Create a service, with standard create modifiers as query parameters. See the Service component definition for what is required to be provided in the request body.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.create_service(database, var_schema, service, create_mode, async_req=True)
        >>> result = future.result()
        :param database: Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases. (required)
        :type database: str
        :param var_schema: Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database. (required)
        :type var_schema: str
        :param service: (required)
        :type service: Service
        :param create_mode: Query parameter allowing support for different modes of resource creation. Possible values include: - `errorIfExists`: Throws an error if you try to create a resource that already exists. - `ifNotExists`: Creates a new resource when an alter is requested for a non-existent resource.
        :type create_mode: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: Union[SuccessResponse, Future[SuccessResponse]]
        """
        kwargs['_return_http_data_only'] = True
        return self.create_service_with_http_info(database, var_schema,
                                                  service, create_mode,
                                                  **kwargs)  # noqa: E501

    @validate_call
    def create_service_with_http_info(
            self,
            database:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
            var_schema:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )],
            service: Service,
            create_mode:
        Annotated[
            Optional[StrictStr],
            Field(
                description=
                "Query parameter allowing support for different modes of resource creation. Possible values include: - `errorIfExists`: Throws an error if you try to create a resource that already exists. - `ifNotExists`: Creates a new resource when an alter is requested for a non-existent resource."
            )] = None,
            **kwargs):  # noqa: E501
        """Create a service  # noqa: E501.

        Create a service, with standard create modifiers as query parameters. See the Service component definition for what is required to be provided in the request body.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.create_service_with_http_info(database, var_schema, service, create_mode, async_req=True)
        >>> result = future.result()
        :param database: Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases. (required)
        :type database: str
        :param var_schema: Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database. (required)
        :type var_schema: str
        :param service: (required)
        :type service: Service
        :param create_mode: Query parameter allowing support for different modes of resource creation. Possible values include: - `errorIfExists`: Throws an error if you try to create a resource that already exists. - `ifNotExists`: Creates a new resource when an alter is requested for a non-existent resource.
        :type create_mode: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: tuple(Union[SuccessResponse, Future[SuccessResponse]], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ['database', 'var_schema', 'service', 'create_mode']
        _all_params.extend([
            'async_req', '_return_http_data_only', '_preload_content',
            '_request_timeout', '_request_auth', '_content_type', '_headers'
        ])

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise _APITypeError("Got an unexpected keyword argument '%s'"
                                    " to method create_service" % _key)
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        if _params['database']:
            _path_params['database'] = _params['database']

        if _params['var_schema']:
            _path_params['schema'] = _params['var_schema']

        # process the query parameters
        _query_params = []

        if _params.get('create_mode') is not None:  # noqa: E501
            _query_params.append(('createMode', _params['create_mode']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        if _params['service']:
            _body_params = _params['service']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            '_content_type',
            self.api_client.select_header_content_type(['application/json']))
        if _content_types_list:
            _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ExternalOAuth', 'KeyPair',
                          'SnowflakeOAuth']  # noqa: E501

        _response_types_map = {
            '200': "SuccessResponse",
            '202': "SuccessAcceptedResponse",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '404': "ErrorResponse",
            '405': "ErrorResponse",
            '408': "ErrorResponse",
            '409': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
            '503': "ErrorResponse",
            '504': "ErrorResponse",
        }

        return self.api_client.call_api(
            self._root,
            '/api/v2/databases/{database}/schemas/{schema}/services',
            'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get(
                '_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @overload
    def execute_job_service(
            self,
            database:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
            var_schema:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )],
            job_service: JobService,
            async_req: Literal[False] = False,
            **kwargs) -> SuccessResponse:
        ...

    @overload
    def execute_job_service(
            self,
            database:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
            var_schema:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )],
            job_service: JobService,
            async_req: Literal[True] = True,
            **kwargs) -> Future[SuccessResponse]:
        ...

    @overload
    def execute_job_service(
            self,
            database:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
            var_schema:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )],
            job_service: JobService,
            async_req: bool = False,
            **kwargs) -> Union[SuccessResponse, Future[SuccessResponse]]:
        ...

    @validate_call
    def execute_job_service(self, database: Annotated[
        str,
        Field(
            strict=True,
            description=
            "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
        )], var_schema: Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )], job_service: JobService, **kwargs) -> Union[
                SuccessResponse, Future[SuccessResponse]]:  # noqa: E501
        """Execute a job service  # noqa: E501.

        Create and execute a job service. See the JobService component definition for what is required to be provided in the request body.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.execute_job_service(database, var_schema, job_service, async_req=True)
        >>> result = future.result()
        :param database: Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases. (required)
        :type database: str
        :param var_schema: Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database. (required)
        :type var_schema: str
        :param job_service: (required)
        :type job_service: JobService
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: Union[SuccessResponse, Future[SuccessResponse]]
        """
        kwargs['_return_http_data_only'] = True
        return self.execute_job_service_with_http_info(database, var_schema,
                                                       job_service,
                                                       **kwargs)  # noqa: E501

    @validate_call
    def execute_job_service_with_http_info(self, database: Annotated[
        str,
        Field(
            strict=True,
            description=
            "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
        )], var_schema: Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )], job_service: JobService, **kwargs):  # noqa: E501
        """Execute a job service  # noqa: E501.

        Create and execute a job service. See the JobService component definition for what is required to be provided in the request body.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.execute_job_service_with_http_info(database, var_schema, job_service, async_req=True)
        >>> result = future.result()
        :param database: Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases. (required)
        :type database: str
        :param var_schema: Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database. (required)
        :type var_schema: str
        :param job_service: (required)
        :type job_service: JobService
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: tuple(Union[SuccessResponse, Future[SuccessResponse]], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ['database', 'var_schema', 'job_service']
        _all_params.extend([
            'async_req', '_return_http_data_only', '_preload_content',
            '_request_timeout', '_request_auth', '_content_type', '_headers'
        ])

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise _APITypeError("Got an unexpected keyword argument '%s'"
                                    " to method execute_job_service" % _key)
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        if _params['database']:
            _path_params['database'] = _params['database']

        if _params['var_schema']:
            _path_params['schema'] = _params['var_schema']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        if _params['job_service']:
            _body_params = _params['job_service']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            '_content_type',
            self.api_client.select_header_content_type(['application/json']))
        if _content_types_list:
            _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ExternalOAuth', 'KeyPair',
                          'SnowflakeOAuth']  # noqa: E501

        _response_types_map = {
            '200': "SuccessResponse",
            '202': "SuccessAcceptedResponse",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '404': "ErrorResponse",
            '405': "ErrorResponse",
            '409': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
            '503': "ErrorResponse",
            '504': "ErrorResponse",
        }

        return self.api_client.call_api(
            self._root,
            '/api/v2/databases/{database}/schemas/{schema}/services:execute-job',
            'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get(
                '_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @overload
    def fetch_service(
            self,
            database:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
            var_schema:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )],
            name: Annotated[
                str,
                Field(strict=True,
                      description="Identifier (i.e. name) for the resource.")],
            async_req: Literal[False] = False,
            **kwargs) -> Service:
        ...

    @overload
    def fetch_service(
            self,
            database:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
            var_schema:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )],
            name: Annotated[
                str,
                Field(strict=True,
                      description="Identifier (i.e. name) for the resource.")],
            async_req: Literal[True] = True,
            **kwargs) -> Future[Service]:
        ...

    @overload
    def fetch_service(
            self,
            database:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
            var_schema:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )],
            name: Annotated[
                str,
                Field(strict=True,
                      description="Identifier (i.e. name) for the resource.")],
            async_req: bool = False,
            **kwargs) -> Union[Service, Future[Service]]:
        ...

    @validate_call
    def fetch_service(self, database: Annotated[
        str,
        Field(
            strict=True,
            description=
            "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
        )], var_schema: Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )], name: Annotated[
                str,
                Field(strict=True,
                      description="Identifier (i.e. name) for the resource.")],
                      **kwargs
                      ) -> Union[Service, Future[Service]]:  # noqa: E501
        """Fetch_service  # noqa: E501.

        Fetch a service.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.fetch_service(database, var_schema, name, async_req=True)
        >>> result = future.result()
        :param database: Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases. (required)
        :type database: str
        :param var_schema: Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database. (required)
        :type var_schema: str
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: Union[Service, Future[Service]]
        """
        kwargs['_return_http_data_only'] = True
        return self.fetch_service_with_http_info(database, var_schema, name,
                                                 **kwargs)  # noqa: E501

    @validate_call
    def fetch_service_with_http_info(self, database: Annotated[
        str,
        Field(
            strict=True,
            description=
            "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
        )], var_schema: Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )], name: Annotated[
                str,
                Field(strict=True,
                      description="Identifier (i.e. name) for the resource.")],
                                     **kwargs):  # noqa: E501
        """Fetch_service  # noqa: E501.

        Fetch a service.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.fetch_service_with_http_info(database, var_schema, name, async_req=True)
        >>> result = future.result()
        :param database: Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases. (required)
        :type database: str
        :param var_schema: Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database. (required)
        :type var_schema: str
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: tuple(Union[Service, Future[Service]], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ['database', 'var_schema', 'name']
        _all_params.extend([
            'async_req', '_return_http_data_only', '_preload_content',
            '_request_timeout', '_request_auth', '_content_type', '_headers'
        ])

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise _APITypeError("Got an unexpected keyword argument '%s'"
                                    " to method fetch_service" % _key)
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        if _params['database']:
            _path_params['database'] = _params['database']

        if _params['var_schema']:
            _path_params['schema'] = _params['var_schema']

        if _params['name']:
            _path_params['name'] = _params['name']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ExternalOAuth', 'KeyPair',
                          'SnowflakeOAuth']  # noqa: E501

        _response_types_map = {
            '200': "Service",
            '202': "SuccessAcceptedResponse",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '404': "ErrorResponse",
            '405': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
            '503': "ErrorResponse",
            '504': "ErrorResponse",
        }

        return self.api_client.call_api(
            self._root,
            '/api/v2/databases/{database}/schemas/{schema}/services/{name}',
            'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get(
                '_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @overload
    def fetch_service_logs(
            self,
            database:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
            var_schema:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )],
            name: Annotated[
                str,
                Field(strict=True,
                      description="Identifier (i.e. name) for the resource.")],
            instance_id: Annotated[
                StrictInt,
                Field(
                    description="ID of the service instance, starting with 0."
                )],
            container_name:
        Annotated[
            StrictStr,
            Field(
                description=
                "Container name as specified in the service specification file."
            )],
            num_lines: Annotated[
                Optional[StrictInt],
                Field(description="Number of trailing log lines to retrieve."
                      )] = None,
            async_req: Literal[False] = False,
            **kwargs) -> FetchServiceLogs200Response:
        ...

    @overload
    def fetch_service_logs(
            self,
            database:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
            var_schema:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )],
            name: Annotated[
                str,
                Field(strict=True,
                      description="Identifier (i.e. name) for the resource.")],
            instance_id: Annotated[
                StrictInt,
                Field(
                    description="ID of the service instance, starting with 0."
                )],
            container_name:
        Annotated[
            StrictStr,
            Field(
                description=
                "Container name as specified in the service specification file."
            )],
            num_lines: Annotated[
                Optional[StrictInt],
                Field(description="Number of trailing log lines to retrieve."
                      )] = None,
            async_req: Literal[True] = True,
            **kwargs) -> Future[FetchServiceLogs200Response]:
        ...

    @overload
    def fetch_service_logs(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )],
        name: Annotated[
            str,
            Field(strict=True,
                  description="Identifier (i.e. name) for the resource.")],
        instance_id: Annotated[
            StrictInt,
            Field(description="ID of the service instance, starting with 0.")],
        container_name: Annotated[
            StrictStr,
            Field(
                description=
                "Container name as specified in the service specification file."
            )],
        num_lines: Annotated[
            Optional[StrictInt],
            Field(description="Number of trailing log lines to retrieve."
                  )] = None,
        async_req: bool = False,
        **kwargs
    ) -> Union[FetchServiceLogs200Response,
               Future[FetchServiceLogs200Response]]:
        ...

    @validate_call
    def fetch_service_logs(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )],
        name: Annotated[
            str,
            Field(strict=True,
                  description="Identifier (i.e. name) for the resource.")],
        instance_id: Annotated[
            StrictInt,
            Field(description="ID of the service instance, starting with 0.")],
        container_name: Annotated[
            StrictStr,
            Field(
                description=
                "Container name as specified in the service specification file."
            )],
        num_lines: Annotated[
            Optional[StrictInt],
            Field(description="Number of trailing log lines to retrieve."
                  )] = None,
        **kwargs
    ) -> Union[FetchServiceLogs200Response,
               Future[FetchServiceLogs200Response]]:  # noqa: E501
        """Fetch_service_logs  # noqa: E501.

        Fetch the logs for a given service.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.fetch_service_logs(database, var_schema, name, instance_id, container_name, num_lines, async_req=True)
        >>> result = future.result()
        :param database: Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases. (required)
        :type database: str
        :param var_schema: Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database. (required)
        :type var_schema: str
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param instance_id: ID of the service instance, starting with 0. (required)
        :type instance_id: int
        :param container_name: Container name as specified in the service specification file. (required)
        :type container_name: str
        :param num_lines: Number of trailing log lines to retrieve.
        :type num_lines: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: Union[FetchServiceLogs200Response, Future[FetchServiceLogs200Response]]
        """
        kwargs['_return_http_data_only'] = True
        return self.fetch_service_logs_with_http_info(database, var_schema,
                                                      name, instance_id,
                                                      container_name,
                                                      num_lines,
                                                      **kwargs)  # noqa: E501

    @validate_call
    def fetch_service_logs_with_http_info(
            self,
            database:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
            var_schema:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )],
            name: Annotated[
                str,
                Field(strict=True,
                      description="Identifier (i.e. name) for the resource.")],
            instance_id: Annotated[
                StrictInt,
                Field(
                    description="ID of the service instance, starting with 0."
                )],
            container_name:
        Annotated[
            StrictStr,
            Field(
                description=
                "Container name as specified in the service specification file."
            )],
            num_lines: Annotated[
                Optional[StrictInt],
                Field(description="Number of trailing log lines to retrieve."
                      )] = None,
            **kwargs):  # noqa: E501
        """Fetch_service_logs  # noqa: E501.

        Fetch the logs for a given service.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.fetch_service_logs_with_http_info(database, var_schema, name, instance_id, container_name, num_lines, async_req=True)
        >>> result = future.result()
        :param database: Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases. (required)
        :type database: str
        :param var_schema: Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database. (required)
        :type var_schema: str
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param instance_id: ID of the service instance, starting with 0. (required)
        :type instance_id: int
        :param container_name: Container name as specified in the service specification file. (required)
        :type container_name: str
        :param num_lines: Number of trailing log lines to retrieve.
        :type num_lines: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: tuple(Union[FetchServiceLogs200Response, Future[FetchServiceLogs200Response]], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'database', 'var_schema', 'name', 'instance_id', 'container_name',
            'num_lines'
        ]
        _all_params.extend([
            'async_req', '_return_http_data_only', '_preload_content',
            '_request_timeout', '_request_auth', '_content_type', '_headers'
        ])

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise _APITypeError("Got an unexpected keyword argument '%s'"
                                    " to method fetch_service_logs" % _key)
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        if _params['database']:
            _path_params['database'] = _params['database']

        if _params['var_schema']:
            _path_params['schema'] = _params['var_schema']

        if _params['name']:
            _path_params['name'] = _params['name']

        # process the query parameters
        _query_params = []

        if _params.get('instance_id') is not None:  # noqa: E501
            _query_params.append(('instanceId', _params['instance_id']))

        if _params.get('container_name') is not None:  # noqa: E501
            _query_params.append(('containerName', _params['container_name']))

        if _params.get('num_lines') is not None:  # noqa: E501
            _query_params.append(('numLines', _params['num_lines']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ExternalOAuth', 'KeyPair',
                          'SnowflakeOAuth']  # noqa: E501

        _response_types_map = {
            '200': "FetchServiceLogs200Response",
            '202': "SuccessAcceptedResponse",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '404': "ErrorResponse",
            '405': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
            '503': "ErrorResponse",
            '504': "ErrorResponse",
        }

        return self.api_client.call_api(
            self._root,
            '/api/v2/databases/{database}/schemas/{schema}/services/{name}/logs',
            'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get(
                '_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @overload
    def fetch_service_status(
            self,
            database:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
            var_schema:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )],
            name: Annotated[
                str,
                Field(strict=True,
                      description="Identifier (i.e. name) for the resource.")],
            timeout:
        Annotated[
            Optional[StrictInt],
            Field(
                description=
                "Number of seconds to wait for the service to reach a steady state (for example, READY) before returning the status. If the service does not reach a steady state within the specified time, Snowflake returns the current state."
            )] = None,
            async_req: Literal[False] = False,
            **kwargs) -> FetchServiceStatus200Response:
        ...

    @overload
    def fetch_service_status(
            self,
            database:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
            var_schema:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )],
            name: Annotated[
                str,
                Field(strict=True,
                      description="Identifier (i.e. name) for the resource.")],
            timeout:
        Annotated[
            Optional[StrictInt],
            Field(
                description=
                "Number of seconds to wait for the service to reach a steady state (for example, READY) before returning the status. If the service does not reach a steady state within the specified time, Snowflake returns the current state."
            )] = None,
            async_req: Literal[True] = True,
            **kwargs) -> Future[FetchServiceStatus200Response]:
        ...

    @overload
    def fetch_service_status(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )],
        name: Annotated[
            str,
            Field(strict=True,
                  description="Identifier (i.e. name) for the resource.")],
        timeout: Annotated[
            Optional[StrictInt],
            Field(
                description=
                "Number of seconds to wait for the service to reach a steady state (for example, READY) before returning the status. If the service does not reach a steady state within the specified time, Snowflake returns the current state."
            )] = None,
        async_req: bool = False,
        **kwargs
    ) -> Union[FetchServiceStatus200Response,
               Future[FetchServiceStatus200Response]]:
        ...

    @validate_call
    def fetch_service_status(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )],
        name: Annotated[
            str,
            Field(strict=True,
                  description="Identifier (i.e. name) for the resource.")],
        timeout: Annotated[
            Optional[StrictInt],
            Field(
                description=
                "Number of seconds to wait for the service to reach a steady state (for example, READY) before returning the status. If the service does not reach a steady state within the specified time, Snowflake returns the current state."
            )] = None,
        **kwargs
    ) -> Union[FetchServiceStatus200Response,
               Future[FetchServiceStatus200Response]]:  # noqa: E501
        """Fetch_service_status  # noqa: E501.

        Fetch the status for a given service.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.fetch_service_status(database, var_schema, name, timeout, async_req=True)
        >>> result = future.result()
        :param database: Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases. (required)
        :type database: str
        :param var_schema: Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database. (required)
        :type var_schema: str
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param timeout: Number of seconds to wait for the service to reach a steady state (for example, READY) before returning the status. If the service does not reach a steady state within the specified time, Snowflake returns the current state.
        :type timeout: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: Union[FetchServiceStatus200Response, Future[FetchServiceStatus200Response]]
        """
        kwargs['_return_http_data_only'] = True
        return self.fetch_service_status_with_http_info(
            database, var_schema, name, timeout, **kwargs)  # noqa: E501

    @validate_call
    def fetch_service_status_with_http_info(
            self,
            database:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
            var_schema:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )],
            name: Annotated[
                str,
                Field(strict=True,
                      description="Identifier (i.e. name) for the resource.")],
            timeout:
        Annotated[
            Optional[StrictInt],
            Field(
                description=
                "Number of seconds to wait for the service to reach a steady state (for example, READY) before returning the status. If the service does not reach a steady state within the specified time, Snowflake returns the current state."
            )] = None,
            **kwargs):  # noqa: E501
        """Fetch_service_status  # noqa: E501.

        Fetch the status for a given service.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.fetch_service_status_with_http_info(database, var_schema, name, timeout, async_req=True)
        >>> result = future.result()
        :param database: Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases. (required)
        :type database: str
        :param var_schema: Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database. (required)
        :type var_schema: str
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param timeout: Number of seconds to wait for the service to reach a steady state (for example, READY) before returning the status. If the service does not reach a steady state within the specified time, Snowflake returns the current state.
        :type timeout: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: tuple(Union[FetchServiceStatus200Response, Future[FetchServiceStatus200Response]], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ['database', 'var_schema', 'name', 'timeout']
        _all_params.extend([
            'async_req', '_return_http_data_only', '_preload_content',
            '_request_timeout', '_request_auth', '_content_type', '_headers'
        ])

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise _APITypeError("Got an unexpected keyword argument '%s'"
                                    " to method fetch_service_status" % _key)
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        if _params['database']:
            _path_params['database'] = _params['database']

        if _params['var_schema']:
            _path_params['schema'] = _params['var_schema']

        if _params['name']:
            _path_params['name'] = _params['name']

        # process the query parameters
        _query_params = []

        if _params.get('timeout') is not None:  # noqa: E501
            _query_params.append(('timeout', _params['timeout']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ExternalOAuth', 'KeyPair',
                          'SnowflakeOAuth']  # noqa: E501

        _response_types_map = {
            '200': "FetchServiceStatus200Response",
            '202': "SuccessAcceptedResponse",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '404': "ErrorResponse",
            '405': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
            '503': "ErrorResponse",
            '504': "ErrorResponse",
        }

        return self.api_client.call_api(
            self._root,
            '/api/v2/databases/{database}/schemas/{schema}/services/{name}/status',
            'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get(
                '_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @overload
    def list_service_containers(
            self,
            database:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
            var_schema:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )],
            name: Annotated[
                str,
                Field(strict=True,
                      description="Identifier (i.e. name) for the resource.")],
            async_req: Literal[False] = False,
            **kwargs) -> Iterable[ServiceContainer]:
        ...

    @overload
    def list_service_containers(
            self,
            database:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
            var_schema:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )],
            name: Annotated[
                str,
                Field(strict=True,
                      description="Identifier (i.e. name) for the resource.")],
            async_req: Literal[True] = True,
            **kwargs) -> Future[Iterable[ServiceContainer]]:
        ...

    @overload
    def list_service_containers(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )],
        name: Annotated[
            str,
            Field(strict=True,
                  description="Identifier (i.e. name) for the resource.")],
        async_req: bool = False,
        **kwargs
    ) -> Union[Iterable[ServiceContainer], Future[Iterable[ServiceContainer]]]:
        ...

    @validate_call
    def list_service_containers(self, database: Annotated[
        str,
        Field(
            strict=True,
            description=
            "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
        )], var_schema: Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )], name: Annotated[
                str,
                Field(strict=True,
                      description="Identifier (i.e. name) for the resource.")],
                                **kwargs
                                ) -> Union[Iterable[ServiceContainer], Future[
                                    Iterable[ServiceContainer]]]:  # noqa: E501
        """List_service_containers  # noqa: E501.

        List all the containers of the service  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.list_service_containers(database, var_schema, name, async_req=True)
        >>> result = future.result()
        :param database: Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases. (required)
        :type database: str
        :param var_schema: Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database. (required)
        :type var_schema: str
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: Union[Iterable[ServiceContainer], Future[Iterable[ServiceContainer]]]
        """
        kwargs['_return_http_data_only'] = True
        return self.list_service_containers_with_http_info(
            database, var_schema, name, **kwargs)  # noqa: E501

    @validate_call
    def list_service_containers_with_http_info(self, database: Annotated[
        str,
        Field(
            strict=True,
            description=
            "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
        )], var_schema: Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )], name: Annotated[
                str,
                Field(strict=True,
                      description="Identifier (i.e. name) for the resource.")],
                                               **kwargs):  # noqa: E501
        """List_service_containers  # noqa: E501.

        List all the containers of the service  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.list_service_containers_with_http_info(database, var_schema, name, async_req=True)
        >>> result = future.result()
        :param database: Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases. (required)
        :type database: str
        :param var_schema: Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database. (required)
        :type var_schema: str
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: tuple(Union[Iterable[ServiceContainer], Future[Iterable[ServiceContainer]]], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ['database', 'var_schema', 'name']
        _all_params.extend([
            'async_req', '_return_http_data_only', '_preload_content',
            '_request_timeout', '_request_auth', '_content_type', '_headers'
        ])

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise _APITypeError("Got an unexpected keyword argument '%s'"
                                    " to method list_service_containers" %
                                    _key)
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        if _params['database']:
            _path_params['database'] = _params['database']

        if _params['var_schema']:
            _path_params['schema'] = _params['var_schema']

        if _params['name']:
            _path_params['name'] = _params['name']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ExternalOAuth', 'KeyPair',
                          'SnowflakeOAuth']  # noqa: E501

        _response_types_map = {
            '200': "Iterable[ServiceContainer]",
            '202': "SuccessAcceptedResponse",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '404': "ErrorResponse",
            '405': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
            '503': "ErrorResponse",
            '504': "ErrorResponse",
        }

        return self.api_client.call_api(
            self._root,
            '/api/v2/databases/{database}/schemas/{schema}/services/{name}/containers',
            'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get(
                '_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @overload
    def list_service_instances(
            self,
            database:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
            var_schema:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )],
            name: Annotated[
                str,
                Field(strict=True,
                      description="Identifier (i.e. name) for the resource.")],
            async_req: Literal[False] = False,
            **kwargs) -> Iterable[ServiceInstance]:
        ...

    @overload
    def list_service_instances(
            self,
            database:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
            var_schema:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )],
            name: Annotated[
                str,
                Field(strict=True,
                      description="Identifier (i.e. name) for the resource.")],
            async_req: Literal[True] = True,
            **kwargs) -> Future[Iterable[ServiceInstance]]:
        ...

    @overload
    def list_service_instances(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )],
        name: Annotated[
            str,
            Field(strict=True,
                  description="Identifier (i.e. name) for the resource.")],
        async_req: bool = False,
        **kwargs
    ) -> Union[Iterable[ServiceInstance], Future[Iterable[ServiceInstance]]]:
        ...

    @validate_call
    def list_service_instances(self, database: Annotated[
        str,
        Field(
            strict=True,
            description=
            "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
        )], var_schema: Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )], name: Annotated[
                str,
                Field(strict=True,
                      description="Identifier (i.e. name) for the resource.")],
                               **kwargs
                               ) -> Union[Iterable[ServiceInstance], Future[
                                   Iterable[ServiceInstance]]]:  # noqa: E501
        """List_service_instances  # noqa: E501.

        List all the instances of the service  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.list_service_instances(database, var_schema, name, async_req=True)
        >>> result = future.result()
        :param database: Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases. (required)
        :type database: str
        :param var_schema: Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database. (required)
        :type var_schema: str
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: Union[Iterable[ServiceInstance], Future[Iterable[ServiceInstance]]]
        """
        kwargs['_return_http_data_only'] = True
        return self.list_service_instances_with_http_info(
            database, var_schema, name, **kwargs)  # noqa: E501

    @validate_call
    def list_service_instances_with_http_info(self, database: Annotated[
        str,
        Field(
            strict=True,
            description=
            "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
        )], var_schema: Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )], name: Annotated[
                str,
                Field(strict=True,
                      description="Identifier (i.e. name) for the resource.")],
                                              **kwargs):  # noqa: E501
        """List_service_instances  # noqa: E501.

        List all the instances of the service  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.list_service_instances_with_http_info(database, var_schema, name, async_req=True)
        >>> result = future.result()
        :param database: Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases. (required)
        :type database: str
        :param var_schema: Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database. (required)
        :type var_schema: str
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: tuple(Union[Iterable[ServiceInstance], Future[Iterable[ServiceInstance]]], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ['database', 'var_schema', 'name']
        _all_params.extend([
            'async_req', '_return_http_data_only', '_preload_content',
            '_request_timeout', '_request_auth', '_content_type', '_headers'
        ])

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise _APITypeError("Got an unexpected keyword argument '%s'"
                                    " to method list_service_instances" % _key)
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        if _params['database']:
            _path_params['database'] = _params['database']

        if _params['var_schema']:
            _path_params['schema'] = _params['var_schema']

        if _params['name']:
            _path_params['name'] = _params['name']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ExternalOAuth', 'KeyPair',
                          'SnowflakeOAuth']  # noqa: E501

        _response_types_map = {
            '200': "Iterable[ServiceInstance]",
            '202': "SuccessAcceptedResponse",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '404': "ErrorResponse",
            '405': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
            '503': "ErrorResponse",
            '504': "ErrorResponse",
        }

        return self.api_client.call_api(
            self._root,
            '/api/v2/databases/{database}/schemas/{schema}/services/{name}/instances',
            'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get(
                '_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @overload
    def list_service_role_grants_of(
            self,
            database:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
            var_schema:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )],
            service: Annotated[
                str,
                Field(strict=True,
                      description=
                      "Name of the service that contains the service role.")],
            name: Annotated[
                str,
                Field(strict=True,
                      description="Identifier (i.e. name) for the resource.")],
            async_req: Literal[False] = False,
            **kwargs) -> Iterable[GrantOf]:
        ...

    @overload
    def list_service_role_grants_of(
            self,
            database:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
            var_schema:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )],
            service: Annotated[
                str,
                Field(strict=True,
                      description=
                      "Name of the service that contains the service role.")],
            name: Annotated[
                str,
                Field(strict=True,
                      description="Identifier (i.e. name) for the resource.")],
            async_req: Literal[True] = True,
            **kwargs) -> Future[Iterable[GrantOf]]:
        ...

    @overload
    def list_service_role_grants_of(
            self,
            database:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
            var_schema:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )],
            service: Annotated[
                str,
                Field(strict=True,
                      description=
                      "Name of the service that contains the service role.")],
            name: Annotated[
                str,
                Field(strict=True,
                      description="Identifier (i.e. name) for the resource.")],
            async_req: bool = False,
            **kwargs) -> Union[Iterable[GrantOf], Future[Iterable[GrantOf]]]:
        ...

    @validate_call
    def list_service_role_grants_of(self, database: Annotated[
        str,
        Field(
            strict=True,
            description=
            "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
        )], var_schema: Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )], service: Annotated[
                str,
                Field(strict=True,
                      description=
                      "Name of the service that contains the service role."
                      )], name: Annotated[
                          str,
                          Field(strict=True,
                                description=
                                "Identifier (i.e. name) for the resource.")],
                                    **kwargs
                                    ) -> Union[Iterable[GrantOf], Future[
                                        Iterable[GrantOf]]]:  # noqa: E501
        """List_service_role_grants_of  # noqa: E501.

        List all the grants of the service role  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.list_service_role_grants_of(database, var_schema, service, name, async_req=True)
        >>> result = future.result()
        :param database: Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases. (required)
        :type database: str
        :param var_schema: Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database. (required)
        :type var_schema: str
        :param service: Name of the service that contains the service role. (required)
        :type service: str
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: Union[Iterable[GrantOf], Future[Iterable[GrantOf]]]
        """
        kwargs['_return_http_data_only'] = True
        return self.list_service_role_grants_of_with_http_info(
            database, var_schema, service, name, **kwargs)  # noqa: E501

    @validate_call
    def list_service_role_grants_of_with_http_info(self, database: Annotated[
        str,
        Field(
            strict=True,
            description=
            "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
        )], var_schema: Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )], service: Annotated[
                str,
                Field(strict=True,
                      description=
                      "Name of the service that contains the service role."
                      )], name: Annotated[
                          str,
                          Field(strict=True,
                                description=
                                "Identifier (i.e. name) for the resource.")],
                                                   **kwargs):  # noqa: E501
        """List_service_role_grants_of  # noqa: E501.

        List all the grants of the service role  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.list_service_role_grants_of_with_http_info(database, var_schema, service, name, async_req=True)
        >>> result = future.result()
        :param database: Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases. (required)
        :type database: str
        :param var_schema: Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database. (required)
        :type var_schema: str
        :param service: Name of the service that contains the service role. (required)
        :type service: str
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: tuple(Union[Iterable[GrantOf], Future[Iterable[GrantOf]]], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ['database', 'var_schema', 'service', 'name']
        _all_params.extend([
            'async_req', '_return_http_data_only', '_preload_content',
            '_request_timeout', '_request_auth', '_content_type', '_headers'
        ])

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise _APITypeError("Got an unexpected keyword argument '%s'"
                                    " to method list_service_role_grants_of" %
                                    _key)
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        if _params['database']:
            _path_params['database'] = _params['database']

        if _params['var_schema']:
            _path_params['schema'] = _params['var_schema']

        if _params['service']:
            _path_params['service'] = _params['service']

        if _params['name']:
            _path_params['name'] = _params['name']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ExternalOAuth', 'KeyPair',
                          'SnowflakeOAuth']  # noqa: E501

        _response_types_map = {
            '200': "Iterable[GrantOf]",
            '202': "SuccessAcceptedResponse",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '404': "ErrorResponse",
            '405': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
            '503': "ErrorResponse",
            '504': "ErrorResponse",
        }

        return self.api_client.call_api(
            self._root,
            '/api/v2/databases/{database}/schemas/{schema}/services/{service}/roles/{name}/grants-of',
            'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get(
                '_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @overload
    def list_service_role_grants_to(
            self,
            database:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
            var_schema:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )],
            service: Annotated[
                str,
                Field(strict=True,
                      description=
                      "Name of the service that contains the service role.")],
            name: Annotated[
                str,
                Field(strict=True,
                      description="Identifier (i.e. name) for the resource.")],
            async_req: Literal[False] = False,
            **kwargs) -> Iterable[ServiceRoleGrantTo]:
        ...

    @overload
    def list_service_role_grants_to(
            self,
            database:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
            var_schema:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )],
            service: Annotated[
                str,
                Field(strict=True,
                      description=
                      "Name of the service that contains the service role.")],
            name: Annotated[
                str,
                Field(strict=True,
                      description="Identifier (i.e. name) for the resource.")],
            async_req: Literal[True] = True,
            **kwargs) -> Future[Iterable[ServiceRoleGrantTo]]:
        ...

    @overload
    def list_service_role_grants_to(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )],
        service: Annotated[
            str,
            Field(strict=True,
                  description=
                  "Name of the service that contains the service role.")],
        name: Annotated[
            str,
            Field(strict=True,
                  description="Identifier (i.e. name) for the resource.")],
        async_req: bool = False,
        **kwargs
    ) -> Union[Iterable[ServiceRoleGrantTo],
               Future[Iterable[ServiceRoleGrantTo]]]:
        ...

    @validate_call
    def list_service_role_grants_to(self, database: Annotated[
        str,
        Field(
            strict=True,
            description=
            "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
        )], var_schema: Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )], service: Annotated[
                str,
                Field(
                    strict=True,
                    description=
                    "Name of the service that contains the service role."
                )], name: Annotated[
                    str,
                    Field(
                        strict=True,
                        description="Identifier (i.e. name) for the resource."
                    )], **kwargs) -> Union[
                        Iterable[ServiceRoleGrantTo],
                        Future[Iterable[ServiceRoleGrantTo]]]:  # noqa: E501
        """List_service_role_grants_to  # noqa: E501.

        List all the grants given to the service role  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.list_service_role_grants_to(database, var_schema, service, name, async_req=True)
        >>> result = future.result()
        :param database: Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases. (required)
        :type database: str
        :param var_schema: Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database. (required)
        :type var_schema: str
        :param service: Name of the service that contains the service role. (required)
        :type service: str
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: Union[Iterable[ServiceRoleGrantTo], Future[Iterable[ServiceRoleGrantTo]]]
        """
        kwargs['_return_http_data_only'] = True
        return self.list_service_role_grants_to_with_http_info(
            database, var_schema, service, name, **kwargs)  # noqa: E501

    @validate_call
    def list_service_role_grants_to_with_http_info(self, database: Annotated[
        str,
        Field(
            strict=True,
            description=
            "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
        )], var_schema: Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )], service: Annotated[
                str,
                Field(strict=True,
                      description=
                      "Name of the service that contains the service role."
                      )], name: Annotated[
                          str,
                          Field(strict=True,
                                description=
                                "Identifier (i.e. name) for the resource.")],
                                                   **kwargs):  # noqa: E501
        """List_service_role_grants_to  # noqa: E501.

        List all the grants given to the service role  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.list_service_role_grants_to_with_http_info(database, var_schema, service, name, async_req=True)
        >>> result = future.result()
        :param database: Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases. (required)
        :type database: str
        :param var_schema: Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database. (required)
        :type var_schema: str
        :param service: Name of the service that contains the service role. (required)
        :type service: str
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: tuple(Union[Iterable[ServiceRoleGrantTo], Future[Iterable[ServiceRoleGrantTo]]], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ['database', 'var_schema', 'service', 'name']
        _all_params.extend([
            'async_req', '_return_http_data_only', '_preload_content',
            '_request_timeout', '_request_auth', '_content_type', '_headers'
        ])

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise _APITypeError("Got an unexpected keyword argument '%s'"
                                    " to method list_service_role_grants_to" %
                                    _key)
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        if _params['database']:
            _path_params['database'] = _params['database']

        if _params['var_schema']:
            _path_params['schema'] = _params['var_schema']

        if _params['service']:
            _path_params['service'] = _params['service']

        if _params['name']:
            _path_params['name'] = _params['name']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ExternalOAuth', 'KeyPair',
                          'SnowflakeOAuth']  # noqa: E501

        _response_types_map = {
            '200': "Iterable[ServiceRoleGrantTo]",
            '202': "SuccessAcceptedResponse",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '404': "ErrorResponse",
            '405': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
            '503': "ErrorResponse",
            '504': "ErrorResponse",
        }

        return self.api_client.call_api(
            self._root,
            '/api/v2/databases/{database}/schemas/{schema}/services/{service}/roles/{name}/grants',
            'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get(
                '_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @overload
    def list_service_roles(
            self,
            database:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
            var_schema:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )],
            name: Annotated[
                str,
                Field(strict=True,
                      description="Identifier (i.e. name) for the resource.")],
            async_req: Literal[False] = False,
            **kwargs) -> Iterable[ServiceRole]:
        ...

    @overload
    def list_service_roles(
            self,
            database:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
            var_schema:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )],
            name: Annotated[
                str,
                Field(strict=True,
                      description="Identifier (i.e. name) for the resource.")],
            async_req: Literal[True] = True,
            **kwargs) -> Future[Iterable[ServiceRole]]:
        ...

    @overload
    def list_service_roles(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )],
        name: Annotated[
            str,
            Field(strict=True,
                  description="Identifier (i.e. name) for the resource.")],
        async_req: bool = False,
        **kwargs
    ) -> Union[Iterable[ServiceRole], Future[Iterable[ServiceRole]]]:
        ...

    @validate_call
    def list_service_roles(self, database: Annotated[
        str,
        Field(
            strict=True,
            description=
            "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
        )], var_schema: Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )], name: Annotated[
                str,
                Field(strict=True,
                      description="Identifier (i.e. name) for the resource.")],
                           **kwargs) -> Union[
                               Iterable[ServiceRole],
                               Future[Iterable[ServiceRole]]]:  # noqa: E501
        """List_service_roles  # noqa: E501.

        List all the service roles of the service  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.list_service_roles(database, var_schema, name, async_req=True)
        >>> result = future.result()
        :param database: Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases. (required)
        :type database: str
        :param var_schema: Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database. (required)
        :type var_schema: str
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: Union[Iterable[ServiceRole], Future[Iterable[ServiceRole]]]
        """
        kwargs['_return_http_data_only'] = True
        return self.list_service_roles_with_http_info(database, var_schema,
                                                      name,
                                                      **kwargs)  # noqa: E501

    @validate_call
    def list_service_roles_with_http_info(self, database: Annotated[
        str,
        Field(
            strict=True,
            description=
            "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
        )], var_schema: Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )], name: Annotated[
                str,
                Field(strict=True,
                      description="Identifier (i.e. name) for the resource.")],
                                          **kwargs):  # noqa: E501
        """List_service_roles  # noqa: E501.

        List all the service roles of the service  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.list_service_roles_with_http_info(database, var_schema, name, async_req=True)
        >>> result = future.result()
        :param database: Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases. (required)
        :type database: str
        :param var_schema: Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database. (required)
        :type var_schema: str
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: tuple(Union[Iterable[ServiceRole], Future[Iterable[ServiceRole]]], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ['database', 'var_schema', 'name']
        _all_params.extend([
            'async_req', '_return_http_data_only', '_preload_content',
            '_request_timeout', '_request_auth', '_content_type', '_headers'
        ])

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise _APITypeError("Got an unexpected keyword argument '%s'"
                                    " to method list_service_roles" % _key)
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        if _params['database']:
            _path_params['database'] = _params['database']

        if _params['var_schema']:
            _path_params['schema'] = _params['var_schema']

        if _params['name']:
            _path_params['name'] = _params['name']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ExternalOAuth', 'KeyPair',
                          'SnowflakeOAuth']  # noqa: E501

        _response_types_map = {
            '200': "Iterable[ServiceRole]",
            '202': "SuccessAcceptedResponse",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '404': "ErrorResponse",
            '405': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
            '503': "ErrorResponse",
            '504': "ErrorResponse",
        }

        return self.api_client.call_api(
            self._root,
            '/api/v2/databases/{database}/schemas/{schema}/services/{name}/roles',
            'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get(
                '_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @overload
    def list_services(
            self,
            database:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
            var_schema:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )],
            like:
        Annotated[
            Optional[StrictStr],
            Field(
                description=
                "Query parameter to filter the command output by resource name. Uses case-insensitive pattern matching, with support for SQL wildcard characters."
            )] = None,
            starts_with:
        Annotated[
            Optional[StrictStr],
            Field(
                description=
                "Query parameter to filter the command output based on the string of characters that appear at the beginning of the object name. Uses case-sensitive pattern matching."
            )] = None,
            show_limit:
        Annotated[
            Optional[Annotated[int, Field(le=10000, strict=True, ge=1)]],
            Field(
                description=
                "Query parameter to limit the maximum number of rows returned by a command."
            )] = None,
            from_name:
        Annotated[
            Optional[StrictStr],
            Field(
                description=
                "Query parameter to enable fetching rows only following the first row whose object name matches the specified string. Case-sensitive and does not have to be the full name."
            )] = None,
            async_req: Literal[False] = False,
            **kwargs) -> Iterable[Service]:
        ...

    @overload
    def list_services(
            self,
            database:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
            var_schema:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )],
            like:
        Annotated[
            Optional[StrictStr],
            Field(
                description=
                "Query parameter to filter the command output by resource name. Uses case-insensitive pattern matching, with support for SQL wildcard characters."
            )] = None,
            starts_with:
        Annotated[
            Optional[StrictStr],
            Field(
                description=
                "Query parameter to filter the command output based on the string of characters that appear at the beginning of the object name. Uses case-sensitive pattern matching."
            )] = None,
            show_limit:
        Annotated[
            Optional[Annotated[int, Field(le=10000, strict=True, ge=1)]],
            Field(
                description=
                "Query parameter to limit the maximum number of rows returned by a command."
            )] = None,
            from_name:
        Annotated[
            Optional[StrictStr],
            Field(
                description=
                "Query parameter to enable fetching rows only following the first row whose object name matches the specified string. Case-sensitive and does not have to be the full name."
            )] = None,
            async_req: Literal[True] = True,
            **kwargs) -> Future[Iterable[Service]]:
        ...

    @overload
    def list_services(
            self,
            database:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
            var_schema:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )],
            like:
        Annotated[
            Optional[StrictStr],
            Field(
                description=
                "Query parameter to filter the command output by resource name. Uses case-insensitive pattern matching, with support for SQL wildcard characters."
            )] = None,
            starts_with:
        Annotated[
            Optional[StrictStr],
            Field(
                description=
                "Query parameter to filter the command output based on the string of characters that appear at the beginning of the object name. Uses case-sensitive pattern matching."
            )] = None,
            show_limit:
        Annotated[
            Optional[Annotated[int, Field(le=10000, strict=True, ge=1)]],
            Field(
                description=
                "Query parameter to limit the maximum number of rows returned by a command."
            )] = None,
            from_name:
        Annotated[
            Optional[StrictStr],
            Field(
                description=
                "Query parameter to enable fetching rows only following the first row whose object name matches the specified string. Case-sensitive and does not have to be the full name."
            )] = None,
            async_req: bool = False,
            **kwargs) -> Union[Iterable[Service], Future[Iterable[Service]]]:
        ...

    @validate_call
    def list_services(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )],
        like: Annotated[
            Optional[StrictStr],
            Field(
                description=
                "Query parameter to filter the command output by resource name. Uses case-insensitive pattern matching, with support for SQL wildcard characters."
            )] = None,
        starts_with: Annotated[
            Optional[StrictStr],
            Field(
                description=
                "Query parameter to filter the command output based on the string of characters that appear at the beginning of the object name. Uses case-sensitive pattern matching."
            )] = None,
        show_limit: Annotated[
            Optional[Annotated[int, Field(le=10000, strict=True, ge=1)]],
            Field(
                description=
                "Query parameter to limit the maximum number of rows returned by a command."
            )] = None,
        from_name: Annotated[
            Optional[StrictStr],
            Field(
                description=
                "Query parameter to enable fetching rows only following the first row whose object name matches the specified string. Case-sensitive and does not have to be the full name."
            )] = None,
        **kwargs
    ) -> Union[Iterable[Service], Future[Iterable[Service]]]:  # noqa: E501
        """List services  # noqa: E501.

        Lists the services under the database and schema.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.list_services(database, var_schema, like, starts_with, show_limit, from_name, async_req=True)
        >>> result = future.result()
        :param database: Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases. (required)
        :type database: str
        :param var_schema: Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database. (required)
        :type var_schema: str
        :param like: Query parameter to filter the command output by resource name. Uses case-insensitive pattern matching, with support for SQL wildcard characters.
        :type like: str
        :param starts_with: Query parameter to filter the command output based on the string of characters that appear at the beginning of the object name. Uses case-sensitive pattern matching.
        :type starts_with: str
        :param show_limit: Query parameter to limit the maximum number of rows returned by a command.
        :type show_limit: int
        :param from_name: Query parameter to enable fetching rows only following the first row whose object name matches the specified string. Case-sensitive and does not have to be the full name.
        :type from_name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: Union[Iterable[Service], Future[Iterable[Service]]]
        """
        kwargs['_return_http_data_only'] = True
        return self.list_services_with_http_info(database, var_schema, like,
                                                 starts_with, show_limit,
                                                 from_name,
                                                 **kwargs)  # noqa: E501

    @validate_call
    def list_services_with_http_info(
            self,
            database:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
            var_schema:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )],
            like:
        Annotated[
            Optional[StrictStr],
            Field(
                description=
                "Query parameter to filter the command output by resource name. Uses case-insensitive pattern matching, with support for SQL wildcard characters."
            )] = None,
            starts_with:
        Annotated[
            Optional[StrictStr],
            Field(
                description=
                "Query parameter to filter the command output based on the string of characters that appear at the beginning of the object name. Uses case-sensitive pattern matching."
            )] = None,
            show_limit:
        Annotated[
            Optional[Annotated[int, Field(le=10000, strict=True, ge=1)]],
            Field(
                description=
                "Query parameter to limit the maximum number of rows returned by a command."
            )] = None,
            from_name:
        Annotated[
            Optional[StrictStr],
            Field(
                description=
                "Query parameter to enable fetching rows only following the first row whose object name matches the specified string. Case-sensitive and does not have to be the full name."
            )] = None,
            **kwargs):  # noqa: E501
        """List services  # noqa: E501.

        Lists the services under the database and schema.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.list_services_with_http_info(database, var_schema, like, starts_with, show_limit, from_name, async_req=True)
        >>> result = future.result()
        :param database: Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases. (required)
        :type database: str
        :param var_schema: Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database. (required)
        :type var_schema: str
        :param like: Query parameter to filter the command output by resource name. Uses case-insensitive pattern matching, with support for SQL wildcard characters.
        :type like: str
        :param starts_with: Query parameter to filter the command output based on the string of characters that appear at the beginning of the object name. Uses case-sensitive pattern matching.
        :type starts_with: str
        :param show_limit: Query parameter to limit the maximum number of rows returned by a command.
        :type show_limit: int
        :param from_name: Query parameter to enable fetching rows only following the first row whose object name matches the specified string. Case-sensitive and does not have to be the full name.
        :type from_name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: tuple(Union[Iterable[Service], Future[Iterable[Service]]], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'database', 'var_schema', 'like', 'starts_with', 'show_limit',
            'from_name'
        ]
        _all_params.extend([
            'async_req', '_return_http_data_only', '_preload_content',
            '_request_timeout', '_request_auth', '_content_type', '_headers'
        ])

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise _APITypeError("Got an unexpected keyword argument '%s'"
                                    " to method list_services" % _key)
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        if _params['database']:
            _path_params['database'] = _params['database']

        if _params['var_schema']:
            _path_params['schema'] = _params['var_schema']

        # process the query parameters
        _query_params = []

        if _params.get('like') is not None:  # noqa: E501
            _query_params.append(('like', _params['like']))

        if _params.get('starts_with') is not None:  # noqa: E501
            _query_params.append(('startsWith', _params['starts_with']))

        if _params.get('show_limit') is not None:  # noqa: E501
            _query_params.append(('showLimit', _params['show_limit']))

        if _params.get('from_name') is not None:  # noqa: E501
            _query_params.append(('fromName', _params['from_name']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ExternalOAuth', 'KeyPair',
                          'SnowflakeOAuth']  # noqa: E501

        _response_types_map = {
            '200': "Iterable[Service]",
            '202': "SuccessAcceptedResponse",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '404': "ErrorResponse",
            '405': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
            '503': "ErrorResponse",
            '504': "ErrorResponse",
        }

        return self.api_client.call_api(
            self._root,
            '/api/v2/databases/{database}/schemas/{schema}/services',
            'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get(
                '_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @overload
    def resume_service(
            self,
            database:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
            var_schema:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )],
            name: Annotated[
                str,
                Field(strict=True,
                      description="Identifier (i.e. name) for the resource.")],
            if_exists:
        Annotated[
            Optional[StrictBool],
            Field(
                description=
                "Query parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist."
            )] = None,
            async_req: Literal[False] = False,
            **kwargs) -> SuccessResponse:
        ...

    @overload
    def resume_service(
            self,
            database:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
            var_schema:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )],
            name: Annotated[
                str,
                Field(strict=True,
                      description="Identifier (i.e. name) for the resource.")],
            if_exists:
        Annotated[
            Optional[StrictBool],
            Field(
                description=
                "Query parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist."
            )] = None,
            async_req: Literal[True] = True,
            **kwargs) -> Future[SuccessResponse]:
        ...

    @overload
    def resume_service(
            self,
            database:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
            var_schema:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )],
            name: Annotated[
                str,
                Field(strict=True,
                      description="Identifier (i.e. name) for the resource.")],
            if_exists:
        Annotated[
            Optional[StrictBool],
            Field(
                description=
                "Query parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist."
            )] = None,
            async_req: bool = False,
            **kwargs) -> Union[SuccessResponse, Future[SuccessResponse]]:
        ...

    @validate_call
    def resume_service(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )],
        name: Annotated[
            str,
            Field(strict=True,
                  description="Identifier (i.e. name) for the resource.")],
        if_exists: Annotated[
            Optional[StrictBool],
            Field(
                description=
                "Query parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist."
            )] = None,
        **kwargs
    ) -> Union[SuccessResponse, Future[SuccessResponse]]:  # noqa: E501
        """Resume_service  # noqa: E501.

        Resume a service.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.resume_service(database, var_schema, name, if_exists, async_req=True)
        >>> result = future.result()
        :param database: Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases. (required)
        :type database: str
        :param var_schema: Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database. (required)
        :type var_schema: str
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param if_exists: Query parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist.
        :type if_exists: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: Union[SuccessResponse, Future[SuccessResponse]]
        """
        kwargs['_return_http_data_only'] = True
        return self.resume_service_with_http_info(database, var_schema, name,
                                                  if_exists,
                                                  **kwargs)  # noqa: E501

    @validate_call
    def resume_service_with_http_info(
            self,
            database:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
            var_schema:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )],
            name: Annotated[
                str,
                Field(strict=True,
                      description="Identifier (i.e. name) for the resource.")],
            if_exists:
        Annotated[
            Optional[StrictBool],
            Field(
                description=
                "Query parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist."
            )] = None,
            **kwargs):  # noqa: E501
        """Resume_service  # noqa: E501.

        Resume a service.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.resume_service_with_http_info(database, var_schema, name, if_exists, async_req=True)
        >>> result = future.result()
        :param database: Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases. (required)
        :type database: str
        :param var_schema: Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database. (required)
        :type var_schema: str
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param if_exists: Query parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist.
        :type if_exists: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: tuple(Union[SuccessResponse, Future[SuccessResponse]], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ['database', 'var_schema', 'name', 'if_exists']
        _all_params.extend([
            'async_req', '_return_http_data_only', '_preload_content',
            '_request_timeout', '_request_auth', '_content_type', '_headers'
        ])

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise _APITypeError("Got an unexpected keyword argument '%s'"
                                    " to method resume_service" % _key)
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        if _params['database']:
            _path_params['database'] = _params['database']

        if _params['var_schema']:
            _path_params['schema'] = _params['var_schema']

        if _params['name']:
            _path_params['name'] = _params['name']

        # process the query parameters
        _query_params = []

        if _params.get('if_exists') is not None:  # noqa: E501
            _query_params.append(('ifExists', _params['if_exists']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ExternalOAuth', 'KeyPair',
                          'SnowflakeOAuth']  # noqa: E501

        _response_types_map = {
            '200': "SuccessResponse",
            '202': "SuccessAcceptedResponse",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '404': "ErrorResponse",
            '405': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
            '503': "ErrorResponse",
            '504': "ErrorResponse",
        }

        return self.api_client.call_api(
            self._root,
            '/api/v2/databases/{database}/schemas/{schema}/services/{name}:resume',
            'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get(
                '_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @overload
    def show_service_endpoints(
            self,
            database:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
            var_schema:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )],
            name: Annotated[
                str,
                Field(strict=True,
                      description="Identifier (i.e. name) for the resource.")],
            async_req: Literal[False] = False,
            **kwargs) -> Iterable[ServiceEndpoint]:
        ...

    @overload
    def show_service_endpoints(
            self,
            database:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
            var_schema:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )],
            name: Annotated[
                str,
                Field(strict=True,
                      description="Identifier (i.e. name) for the resource.")],
            async_req: Literal[True] = True,
            **kwargs) -> Future[Iterable[ServiceEndpoint]]:
        ...

    @overload
    def show_service_endpoints(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )],
        name: Annotated[
            str,
            Field(strict=True,
                  description="Identifier (i.e. name) for the resource.")],
        async_req: bool = False,
        **kwargs
    ) -> Union[Iterable[ServiceEndpoint], Future[Iterable[ServiceEndpoint]]]:
        ...

    @validate_call
    def show_service_endpoints(self, database: Annotated[
        str,
        Field(
            strict=True,
            description=
            "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
        )], var_schema: Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )], name: Annotated[
                str,
                Field(strict=True,
                      description="Identifier (i.e. name) for the resource.")],
                               **kwargs
                               ) -> Union[Iterable[ServiceEndpoint], Future[
                                   Iterable[ServiceEndpoint]]]:  # noqa: E501
        """List the endpoints in a service.  # noqa: E501.

        Lists the endpoints in a Snowpark Container Services service (or a job service).  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.show_service_endpoints(database, var_schema, name, async_req=True)
        >>> result = future.result()
        :param database: Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases. (required)
        :type database: str
        :param var_schema: Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database. (required)
        :type var_schema: str
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: Union[Iterable[ServiceEndpoint], Future[Iterable[ServiceEndpoint]]]
        """
        kwargs['_return_http_data_only'] = True
        return self.show_service_endpoints_with_http_info(
            database, var_schema, name, **kwargs)  # noqa: E501

    @validate_call
    def show_service_endpoints_with_http_info(self, database: Annotated[
        str,
        Field(
            strict=True,
            description=
            "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
        )], var_schema: Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )], name: Annotated[
                str,
                Field(strict=True,
                      description="Identifier (i.e. name) for the resource.")],
                                              **kwargs):  # noqa: E501
        """List the endpoints in a service.  # noqa: E501.

        Lists the endpoints in a Snowpark Container Services service (or a job service).  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.show_service_endpoints_with_http_info(database, var_schema, name, async_req=True)
        >>> result = future.result()
        :param database: Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases. (required)
        :type database: str
        :param var_schema: Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database. (required)
        :type var_schema: str
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: tuple(Union[Iterable[ServiceEndpoint], Future[Iterable[ServiceEndpoint]]], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ['database', 'var_schema', 'name']
        _all_params.extend([
            'async_req', '_return_http_data_only', '_preload_content',
            '_request_timeout', '_request_auth', '_content_type', '_headers'
        ])

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise _APITypeError("Got an unexpected keyword argument '%s'"
                                    " to method show_service_endpoints" % _key)
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        if _params['database']:
            _path_params['database'] = _params['database']

        if _params['var_schema']:
            _path_params['schema'] = _params['var_schema']

        if _params['name']:
            _path_params['name'] = _params['name']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ExternalOAuth', 'KeyPair',
                          'SnowflakeOAuth']  # noqa: E501

        _response_types_map = {
            '200': "Iterable[ServiceEndpoint]",
            '202': "SuccessAcceptedResponse",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '404': "ErrorResponse",
            '405': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
            '503': "ErrorResponse",
            '504': "ErrorResponse",
        }

        return self.api_client.call_api(
            self._root,
            '/api/v2/databases/{database}/schemas/{schema}/services/{name}/endpoints',
            'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get(
                '_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @overload
    def suspend_service(
            self,
            database:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
            var_schema:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )],
            name: Annotated[
                str,
                Field(strict=True,
                      description="Identifier (i.e. name) for the resource.")],
            if_exists:
        Annotated[
            Optional[StrictBool],
            Field(
                description=
                "Query parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist."
            )] = None,
            async_req: Literal[False] = False,
            **kwargs) -> SuccessResponse:
        ...

    @overload
    def suspend_service(
            self,
            database:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
            var_schema:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )],
            name: Annotated[
                str,
                Field(strict=True,
                      description="Identifier (i.e. name) for the resource.")],
            if_exists:
        Annotated[
            Optional[StrictBool],
            Field(
                description=
                "Query parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist."
            )] = None,
            async_req: Literal[True] = True,
            **kwargs) -> Future[SuccessResponse]:
        ...

    @overload
    def suspend_service(
            self,
            database:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
            var_schema:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )],
            name: Annotated[
                str,
                Field(strict=True,
                      description="Identifier (i.e. name) for the resource.")],
            if_exists:
        Annotated[
            Optional[StrictBool],
            Field(
                description=
                "Query parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist."
            )] = None,
            async_req: bool = False,
            **kwargs) -> Union[SuccessResponse, Future[SuccessResponse]]:
        ...

    @validate_call
    def suspend_service(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )],
        name: Annotated[
            str,
            Field(strict=True,
                  description="Identifier (i.e. name) for the resource.")],
        if_exists: Annotated[
            Optional[StrictBool],
            Field(
                description=
                "Query parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist."
            )] = None,
        **kwargs
    ) -> Union[SuccessResponse, Future[SuccessResponse]]:  # noqa: E501
        """Suspend_service  # noqa: E501.

        Suspend a service.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.suspend_service(database, var_schema, name, if_exists, async_req=True)
        >>> result = future.result()
        :param database: Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases. (required)
        :type database: str
        :param var_schema: Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database. (required)
        :type var_schema: str
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param if_exists: Query parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist.
        :type if_exists: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: Union[SuccessResponse, Future[SuccessResponse]]
        """
        kwargs['_return_http_data_only'] = True
        return self.suspend_service_with_http_info(database, var_schema, name,
                                                   if_exists,
                                                   **kwargs)  # noqa: E501

    @validate_call
    def suspend_service_with_http_info(
            self,
            database:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
            var_schema:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )],
            name: Annotated[
                str,
                Field(strict=True,
                      description="Identifier (i.e. name) for the resource.")],
            if_exists:
        Annotated[
            Optional[StrictBool],
            Field(
                description=
                "Query parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist."
            )] = None,
            **kwargs):  # noqa: E501
        """Suspend_service  # noqa: E501.

        Suspend a service.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.suspend_service_with_http_info(database, var_schema, name, if_exists, async_req=True)
        >>> result = future.result()
        :param database: Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases. (required)
        :type database: str
        :param var_schema: Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database. (required)
        :type var_schema: str
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param if_exists: Query parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist.
        :type if_exists: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: tuple(Union[SuccessResponse, Future[SuccessResponse]], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ['database', 'var_schema', 'name', 'if_exists']
        _all_params.extend([
            'async_req', '_return_http_data_only', '_preload_content',
            '_request_timeout', '_request_auth', '_content_type', '_headers'
        ])

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise _APITypeError("Got an unexpected keyword argument '%s'"
                                    " to method suspend_service" % _key)
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        if _params['database']:
            _path_params['database'] = _params['database']

        if _params['var_schema']:
            _path_params['schema'] = _params['var_schema']

        if _params['name']:
            _path_params['name'] = _params['name']

        # process the query parameters
        _query_params = []

        if _params.get('if_exists') is not None:  # noqa: E501
            _query_params.append(('ifExists', _params['if_exists']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ExternalOAuth', 'KeyPair',
                          'SnowflakeOAuth']  # noqa: E501

        _response_types_map = {
            '200': "SuccessResponse",
            '202': "SuccessAcceptedResponse",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '404': "ErrorResponse",
            '405': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
            '503': "ErrorResponse",
            '504': "ErrorResponse",
        }

        return self.api_client.call_api(
            self._root,
            '/api/v2/databases/{database}/schemas/{schema}/services/{name}:suspend',
            'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get(
                '_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @overload
    def delete_service(
            self,
            database:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
            var_schema:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )],
            name: Annotated[
                str,
                Field(strict=True,
                      description="Identifier (i.e. name) for the resource.")],
            if_exists:
        Annotated[
            Optional[StrictBool],
            Field(
                description=
                "Query parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist."
            )] = None,
            async_req: Literal[False] = False,
            **kwargs) -> SuccessResponse:
        ...

    @overload
    def delete_service(
            self,
            database:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
            var_schema:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )],
            name: Annotated[
                str,
                Field(strict=True,
                      description="Identifier (i.e. name) for the resource.")],
            if_exists:
        Annotated[
            Optional[StrictBool],
            Field(
                description=
                "Query parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist."
            )] = None,
            async_req: Literal[True] = True,
            **kwargs) -> Future[SuccessResponse]:
        ...

    @overload
    def delete_service(
            self,
            database:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
            var_schema:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )],
            name: Annotated[
                str,
                Field(strict=True,
                      description="Identifier (i.e. name) for the resource.")],
            if_exists:
        Annotated[
            Optional[StrictBool],
            Field(
                description=
                "Query parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist."
            )] = None,
            async_req: bool = False,
            **kwargs) -> Union[SuccessResponse, Future[SuccessResponse]]:
        ...

    @validate_call
    def delete_service(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )],
        name: Annotated[
            str,
            Field(strict=True,
                  description="Identifier (i.e. name) for the resource.")],
        if_exists: Annotated[
            Optional[StrictBool],
            Field(
                description=
                "Query parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist."
            )] = None,
        **kwargs
    ) -> Union[SuccessResponse, Future[SuccessResponse]]:  # noqa: E501
        """Delete a service  # noqa: E501.

        Delete a service with the given name. If ifExists is used, the operation will succeed even if the object does not exist. Otherwise, there will be a failure if the drop is unsuccessful.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.delete_service(database, var_schema, name, if_exists, async_req=True)
        >>> result = future.result()
        :param database: Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases. (required)
        :type database: str
        :param var_schema: Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database. (required)
        :type var_schema: str
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param if_exists: Query parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist.
        :type if_exists: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: Union[SuccessResponse, Future[SuccessResponse]]
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_service_with_http_info(database, var_schema, name,
                                                  if_exists,
                                                  **kwargs)  # noqa: E501

    @validate_call
    def delete_service_with_http_info(
            self,
            database:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
            var_schema:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )],
            name: Annotated[
                str,
                Field(strict=True,
                      description="Identifier (i.e. name) for the resource.")],
            if_exists:
        Annotated[
            Optional[StrictBool],
            Field(
                description=
                "Query parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist."
            )] = None,
            **kwargs):  # noqa: E501
        """Delete a service  # noqa: E501.

        Delete a service with the given name. If ifExists is used, the operation will succeed even if the object does not exist. Otherwise, there will be a failure if the drop is unsuccessful.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.delete_service_with_http_info(database, var_schema, name, if_exists, async_req=True)
        >>> result = future.result()
        :param database: Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases. (required)
        :type database: str
        :param var_schema: Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database. (required)
        :type var_schema: str
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param if_exists: Query parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist.
        :type if_exists: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: tuple(Union[SuccessResponse, Future[SuccessResponse]], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ['database', 'var_schema', 'name', 'if_exists']
        _all_params.extend([
            'async_req', '_return_http_data_only', '_preload_content',
            '_request_timeout', '_request_auth', '_content_type', '_headers'
        ])

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise _APITypeError("Got an unexpected keyword argument '%s'"
                                    " to method delete_service" % _key)
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        if _params['database']:
            _path_params['database'] = _params['database']

        if _params['var_schema']:
            _path_params['schema'] = _params['var_schema']

        if _params['name']:
            _path_params['name'] = _params['name']

        # process the query parameters
        _query_params = []

        if _params.get('if_exists') is not None:  # noqa: E501
            _query_params.append(('ifExists', _params['if_exists']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ExternalOAuth', 'KeyPair',
                          'SnowflakeOAuth']  # noqa: E501

        _response_types_map = {
            '200': "SuccessResponse",
            '202': "SuccessAcceptedResponse",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '404': "ErrorResponse",
            '405': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
            '503': "ErrorResponse",
            '504': "ErrorResponse",
        }

        return self.api_client.call_api(
            self._root,
            '/api/v2/databases/{database}/schemas/{schema}/services/{name}',
            'DELETE',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get(
                '_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
