# coding: utf-8
"""
    Snowflake Services API.

    The Snowflake Services API is a REST API that you can use to access, update, and perform certain actions on Services resource in a Snowflake database.  # noqa: E501

    The version of the OpenAPI document: 0.0.1
    Contact: support@snowflake.com
    Generated by: https://openapi-generator.tech

    Do not edit this file manually.
"""

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from typing import Union

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator

from typing import Any, ClassVar, Dict, List, Optional

from typing_extensions import Annotated


class ServiceContainer(BaseModel):
    """A model object representing the ServiceContainer resource.

    Constructs an object of type ServiceContainer with the provided properties.

    Parameters
    __________
    database_name : str, optional
        A Snowflake object identifier.
    schema_name : str, optional
        A Snowflake object identifier.
    service_name : str, optional
        A Snowflake object identifier.
    service_status : str, optional
        The current status of the service.
    instance_id : str, optional
        ID of the service instance (this is the index of the service instance starting from 0).
    instance_status : str, optional
        The current status of the service instance.
    container_name : str, optional
        Name of the container.
    status : str, optional
        Service container status.
    message : str, optional
        Additional clarification about status.
    image_name : str, optional
        Image name used to create the service container.
    image_digest : str, optional
        The unique and immutable identifier representing the image content.
    restart_count : int, optional
        Number of times Snowflake restarted the service.
    start_time : str, optional
        Date and time when the container started.
    """

    database_name: Optional[Annotated[str, Field(strict=True)]] = None

    schema_name: Optional[Annotated[str, Field(strict=True)]] = None

    service_name: Optional[Annotated[str, Field(strict=True)]] = None

    service_status: Optional[StrictStr] = None

    instance_id: Optional[StrictStr] = None

    instance_status: Optional[StrictStr] = None

    container_name: Optional[StrictStr] = None

    status: Optional[StrictStr] = None

    message: Optional[StrictStr] = None

    image_name: Optional[StrictStr] = None

    image_digest: Optional[StrictStr] = None

    restart_count: Optional[StrictInt] = None

    start_time: Optional[StrictStr] = None

    __properties = [
        "database_name", "schema_name", "service_name", "service_status",
        "instance_id", "instance_status", "container_name", "status",
        "message", "image_name", "image_digest", "restart_count", "start_time"
    ]

    @field_validator('database_name')
    def database_name_validate_regular_expression(cls, v):

        if v is None:
            return v
        if not re.match(r"""^\"([^\"]|\"\")+\"|[a-zA-Z_][a-zA-Z0-9_$]*$""", v):
            raise ValueError(
                r"""must validate the regular expression /^"([^"]|"")+"|[a-zA-Z_][a-zA-Z0-9_$]*$/"""
            )
        return v

    @field_validator('schema_name')
    def schema_name_validate_regular_expression(cls, v):

        if v is None:
            return v
        if not re.match(r"""^\"([^\"]|\"\")+\"|[a-zA-Z_][a-zA-Z0-9_$]*$""", v):
            raise ValueError(
                r"""must validate the regular expression /^"([^"]|"")+"|[a-zA-Z_][a-zA-Z0-9_$]*$/"""
            )
        return v

    @field_validator('service_name')
    def service_name_validate_regular_expression(cls, v):

        if v is None:
            return v
        if not re.match(r"""^\"([^\"]|\"\")+\"|[a-zA-Z_][a-zA-Z0-9_$]*$""", v):
            raise ValueError(
                r"""must validate the regular expression /^"([^"]|"")+"|[a-zA-Z_][a-zA-Z0-9_$]*$/"""
            )
        return v

    class Config:
        populate_by_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ServiceContainer:
        """Create an instance of ServiceContainer from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""

        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({
                "service_status",
                "instance_id",
                "instance_status",
                "container_name",
                "status",
                "message",
                "image_name",
                "image_digest",
                "restart_count",
                "start_time",
            })

        _dict = dict(
            self._iter(to_dict=True,
                       by_alias=True,
                       exclude=exclude_properties,
                       exclude_none=True))

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> ServiceContainer:
        """Create an instance of ServiceContainer from a dict."""

        if obj is None:
            return None

        if type(obj) is not dict:
            return ServiceContainer.parse_obj(obj)

        _obj = ServiceContainer.parse_obj({
            "database_name":
            obj.get("database_name"),
            "schema_name":
            obj.get("schema_name"),
            "service_name":
            obj.get("service_name"),
            "service_status":
            obj.get("service_status"),
            "instance_id":
            obj.get("instance_id"),
            "instance_status":
            obj.get("instance_status"),
            "container_name":
            obj.get("container_name"),
            "status":
            obj.get("status"),
            "message":
            obj.get("message"),
            "image_name":
            obj.get("image_name"),
            "image_digest":
            obj.get("image_digest"),
            "restart_count":
            obj.get("restart_count"),
            "start_time":
            obj.get("start_time"),
        })

        return _obj


from typing import Optional, List, Dict


class ServiceContainerModel():

    def __init__(
        self,  # optional properties
        database_name: Optional[str] = None,
        schema_name: Optional[str] = None,
        service_name: Optional[str] = None,
        service_status: Optional[str] = None,
        instance_id: Optional[str] = None,
        instance_status: Optional[str] = None,
        container_name: Optional[str] = None,
        status: Optional[str] = None,
        message: Optional[str] = None,
        image_name: Optional[str] = None,
        image_digest: Optional[str] = None,
        restart_count: Optional[int] = None,
        start_time: Optional[str] = None,
    ):
        """A model object representing the ServiceContainer resource.

        Constructs an object of type ServiceContainer with the provided properties.

        Parameters
        __________
        database_name : str, optional
            A Snowflake object identifier.
        schema_name : str, optional
            A Snowflake object identifier.
        service_name : str, optional
            A Snowflake object identifier.
        service_status : str, optional
            The current status of the service.
        instance_id : str, optional
            ID of the service instance (this is the index of the service instance starting from 0).
        instance_status : str, optional
            The current status of the service instance.
        container_name : str, optional
            Name of the container.
        status : str, optional
            Service container status.
        message : str, optional
            Additional clarification about status.
        image_name : str, optional
            Image name used to create the service container.
        image_digest : str, optional
            The unique and immutable identifier representing the image content.
        restart_count : int, optional
            Number of times Snowflake restarted the service.
        start_time : str, optional
            Date and time when the container started.
        """

        self.database_name = database_name
        self.schema_name = schema_name
        self.service_name = service_name
        self.service_status = service_status
        self.instance_id = instance_id
        self.instance_status = instance_status
        self.container_name = container_name
        self.status = status
        self.message = message
        self.image_name = image_name
        self.image_digest = image_digest
        self.restart_count = restart_count
        self.start_time = start_time

    __properties = [
        "database_name", "schema_name", "service_name", "service_status",
        "instance_id", "instance_status", "container_name", "status",
        "message", "image_name", "image_digest", "restart_count", "start_time"
    ]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return ServiceContainer(
            database_name=self.database_name,
            schema_name=self.schema_name,
            service_name=self.service_name,
            service_status=self.service_status,
            instance_id=self.instance_id,
            instance_status=self.instance_status,
            container_name=self.container_name,
            status=self.status,
            message=self.message,
            image_name=self.image_name,
            image_digest=self.image_digest,
            restart_count=self.restart_count,
            start_time=self.start_time,
        )

    @classmethod
    def _from_model(cls, model) -> ServiceContainerModel:
        return ServiceContainerModel(
            database_name=model.database_name,
            schema_name=model.schema_name,
            service_name=model.service_name,
            service_status=model.service_status,
            instance_id=model.instance_id,
            instance_status=model.instance_status,
            container_name=model.container_name,
            status=model.status,
            message=model.message,
            image_name=model.image_name,
            image_digest=model.image_digest,
            restart_count=model.restart_count,
            start_time=model.start_time,
        )

    def to_dict(self):
        """Creates a dictionary of the properties from a ServiceContainer.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the ServiceContainer object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> ServiceContainerModel:
        """Creates an instance of ServiceContainer from a dict.

        This method constructs a ServiceContainer object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        ServiceContainer
            A ServiceContainer object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(ServiceContainer.from_dict(obj))


ServiceContainer._model_class = ServiceContainerModel
