# coding: utf-8
"""
    Snowflake Services API.

    The Snowflake Services API is a REST API that you can use to access, update, and perform certain actions on Services resource in a Snowflake database.  # noqa: E501

    The version of the OpenAPI document: 0.0.1
    Contact: support@snowflake.com
    Generated by: https://openapi-generator.tech

    Do not edit this file manually.
"""

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from typing import Union

from snowflake.core.service._generated.models.service_spec import ServiceSpec

from pydantic import ConfigDict, StrictStr

from typing import Any, ClassVar, Dict, List


class ServiceSpecStageFile(ServiceSpec):
    """A model object representing the ServiceSpecStageFile resource.

    Constructs an object of type ServiceSpecStageFile with the provided properties.

    Parameters
    __________
    stage : str
        Specifies the Snowflake internal stage where the specification file is stored; for example, @tutorial_stage.
    spec_file : str
        Specifies the path to the service specification file on the stage; for example, 'some-dir/echo_spec.yaml'.
    """

    stage: StrictStr

    spec_file: StrictStr

    __properties = ["spec_type"]

    class Config:
        populate_by_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ServiceSpecStageFile:
        """Create an instance of ServiceSpecStageFile from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""

        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = dict(
            self._iter(to_dict=True,
                       by_alias=True,
                       exclude=exclude_properties,
                       exclude_none=True))

        _dict['spec_type'] = ServiceSpec.get_child_model_discriminator_value(
            'ServiceSpecStageFile')

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> ServiceSpecStageFile:
        """Create an instance of ServiceSpecStageFile from a dict."""

        if obj is None:
            return None

        if type(obj) is not dict:
            return ServiceSpecStageFile.parse_obj(obj)

        _obj = ServiceSpecStageFile.parse_obj({
            "stage":
            obj.get("stage"),
            "spec_file":
            obj.get("spec_file"),
        })

        return _obj


from typing import Optional, List, Dict

from snowflake.core.service._generated.models.service_spec import ServiceSpec


class ServiceSpecStageFileModel(ServiceSpec):

    def __init__(
        self,
        stage: str,
        spec_file: str,
        # optional properties
    ):
        """A model object representing the ServiceSpecStageFile resource.

        Constructs an object of type ServiceSpecStageFile with the provided properties.

        Parameters
        __________
        stage : str
            Specifies the Snowflake internal stage where the specification file is stored; for example, @tutorial_stage.
        spec_file : str
            Specifies the path to the service specification file on the stage; for example, 'some-dir/echo_spec.yaml'.
        """

        super().__init__()
        self.stage = stage
        self.spec_file = spec_file

    __properties = ["spec_type"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return ServiceSpecStageFile(
            stage=self.stage,
            spec_file=self.spec_file,
        )

    @classmethod
    def _from_model(cls, model) -> ServiceSpecStageFileModel:
        return ServiceSpecStageFileModel(
            stage=model.stage,
            spec_file=model.spec_file,
        )

    def to_dict(self):
        """Creates a dictionary of the properties from a ServiceSpecStageFile.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the ServiceSpecStageFile object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> ServiceSpecStageFileModel:
        """Creates an instance of ServiceSpecStageFile from a dict.

        This method constructs a ServiceSpecStageFile object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        ServiceSpecStageFile
            A ServiceSpecStageFile object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(ServiceSpecStageFile.from_dict(obj))


ServiceSpecStageFile._model_class = ServiceSpecStageFileModel
