# coding: utf-8
"""
    Snowflake Session API.

    The Snowflake Session API is a REST API that you can use to query your current session properties.  # noqa: E501

    The version of the OpenAPI document: 0.0.1
    Contact: support@snowflake.com
    Generated by: https://openapi-generator.tech

    Do not edit this file manually.
"""

from __future__ import absolute_import

import logging
from pydantic import Field, StrictStr
from typing import List, Optional
from typing_extensions import Annotated
from snowflake.core.session._generated.models.current_secondary_roles import CurrentSecondaryRoles
from snowflake.core.session._generated.models.default_result import DefaultResult
from snowflake.core.session._generated.models.named_default import NamedDefault
from snowflake.core.session._generated.models.parameter import Parameter
from snowflake.core.session._generated.models.secondary_roles import SecondaryRoles
from snowflake.core.session._generated.models.success_response import SuccessResponse
from typing import Iterable

from snowflake.core.session._generated.api_client import ApiClient

from concurrent.futures import Future
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Literal, Optional, Tuple, Union, overload
from typing_extensions import Annotated

from snowflake.core._internal.utils import is_running_inside_stored_procedure

from snowflake.core.exceptions import (  # noqa: F401
    _APITypeError, _APIValueError)

logger = logging.getLogger(__name__)


class SessionApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech.

    Do not edit the class manually.
    """

    def __init__(self, root, resource_class, sproc_client):
        self._root = root
        self._resource_name = 'session'
        self._resource_class = resource_class

        if is_running_inside_stored_procedure():
            self._api_client = sproc_client
        else:
            self._api_client = ApiClient.get_default(self._root)

    @property
    def api_client(self):
        return self._api_client

    @overload
    def get_current_secondary_roles(self,
                                    async_req: Literal[False] = False,
                                    **kwargs) -> CurrentSecondaryRoles:
        ...

    @overload
    def get_current_secondary_roles(self,
                                    async_req: Literal[True] = True,
                                    **kwargs) -> Future[CurrentSecondaryRoles]:
        ...

    @overload
    def get_current_secondary_roles(
        self,
        async_req: bool = False,
        **kwargs
    ) -> Union[CurrentSecondaryRoles, Future[CurrentSecondaryRoles]]:
        ...

    @validate_call
    def get_current_secondary_roles(
        self, **kwargs
    ) -> Union[CurrentSecondaryRoles,
               Future[CurrentSecondaryRoles]]:  # noqa: E501
        """Get current session's default role  # noqa: E501.

        Get current session's default role  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.get_current_secondary_roles(async_req=True)
        >>> result = future.result()
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: Union[CurrentSecondaryRoles, Future[CurrentSecondaryRoles]]
        """
        kwargs['_return_http_data_only'] = True
        return self.get_current_secondary_roles_with_http_info(
            **kwargs)  # noqa: E501

    @validate_call
    def get_current_secondary_roles_with_http_info(self,
                                                   **kwargs):  # noqa: E501
        """Get current session's default role  # noqa: E501.

        Get current session's default role  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.get_current_secondary_roles_with_http_info(async_req=True)
        >>> result = future.result()
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: tuple(Union[CurrentSecondaryRoles, Future[CurrentSecondaryRoles]], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = []
        _all_params.extend([
            'async_req', '_return_http_data_only', '_preload_content',
            '_request_timeout', '_request_auth', '_content_type', '_headers'
        ])

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise _APITypeError("Got an unexpected keyword argument '%s'"
                                    " to method get_current_secondary_roles" %
                                    _key)
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ExternalOAuth', 'KeyPair',
                          'SnowflakeOAuth']  # noqa: E501

        _response_types_map = {
            '200': "CurrentSecondaryRoles",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '404': "ErrorResponse",
            '405': "ErrorResponse",
            '408': "ErrorResponse",
            '409': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
            '503': "ErrorResponse",
            '504': "ErrorResponse",
        }

        return self.api_client.call_api(
            self._root,
            '/api/v2/session/secondary-roles',
            'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get(
                '_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @overload
    def get_default_database(self,
                             async_req: Literal[False] = False,
                             **kwargs) -> DefaultResult:
        ...

    @overload
    def get_default_database(self,
                             async_req: Literal[True] = True,
                             **kwargs) -> Future[DefaultResult]:
        ...

    @overload
    def get_default_database(
            self,
            async_req: bool = False,
            **kwargs) -> Union[DefaultResult, Future[DefaultResult]]:
        ...

    @validate_call
    def get_default_database(
            self, **kwargs
    ) -> Union[DefaultResult, Future[DefaultResult]]:  # noqa: E501
        """Get current session's default database  # noqa: E501.

        Get current session's default database  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.get_default_database(async_req=True)
        >>> result = future.result()
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: Union[DefaultResult, Future[DefaultResult]]
        """
        kwargs['_return_http_data_only'] = True
        return self.get_default_database_with_http_info(**kwargs)  # noqa: E501

    @validate_call
    def get_default_database_with_http_info(self, **kwargs):  # noqa: E501
        """Get current session's default database  # noqa: E501.

        Get current session's default database  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.get_default_database_with_http_info(async_req=True)
        >>> result = future.result()
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: tuple(Union[DefaultResult, Future[DefaultResult]], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = []
        _all_params.extend([
            'async_req', '_return_http_data_only', '_preload_content',
            '_request_timeout', '_request_auth', '_content_type', '_headers'
        ])

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise _APITypeError("Got an unexpected keyword argument '%s'"
                                    " to method get_default_database" % _key)
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ExternalOAuth', 'KeyPair',
                          'SnowflakeOAuth']  # noqa: E501

        _response_types_map = {
            '200': "DefaultResult",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '404': "ErrorResponse",
            '405': "ErrorResponse",
            '408': "ErrorResponse",
            '409': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
            '503': "ErrorResponse",
            '504': "ErrorResponse",
        }

        return self.api_client.call_api(
            self._root,
            '/api/v2/session/default-database',
            'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get(
                '_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @overload
    def get_default_role(self,
                         async_req: Literal[False] = False,
                         **kwargs) -> DefaultResult:
        ...

    @overload
    def get_default_role(self,
                         async_req: Literal[True] = True,
                         **kwargs) -> Future[DefaultResult]:
        ...

    @overload
    def get_default_role(
            self,
            async_req: bool = False,
            **kwargs) -> Union[DefaultResult, Future[DefaultResult]]:
        ...

    @validate_call
    def get_default_role(
            self, **kwargs
    ) -> Union[DefaultResult, Future[DefaultResult]]:  # noqa: E501
        """Get current session's default role  # noqa: E501.

        Get current session's default role  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.get_default_role(async_req=True)
        >>> result = future.result()
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: Union[DefaultResult, Future[DefaultResult]]
        """
        kwargs['_return_http_data_only'] = True
        return self.get_default_role_with_http_info(**kwargs)  # noqa: E501

    @validate_call
    def get_default_role_with_http_info(self, **kwargs):  # noqa: E501
        """Get current session's default role  # noqa: E501.

        Get current session's default role  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.get_default_role_with_http_info(async_req=True)
        >>> result = future.result()
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: tuple(Union[DefaultResult, Future[DefaultResult]], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = []
        _all_params.extend([
            'async_req', '_return_http_data_only', '_preload_content',
            '_request_timeout', '_request_auth', '_content_type', '_headers'
        ])

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise _APITypeError("Got an unexpected keyword argument '%s'"
                                    " to method get_default_role" % _key)
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ExternalOAuth', 'KeyPair',
                          'SnowflakeOAuth']  # noqa: E501

        _response_types_map = {
            '200': "DefaultResult",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '404': "ErrorResponse",
            '405': "ErrorResponse",
            '408': "ErrorResponse",
            '409': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
            '503': "ErrorResponse",
            '504': "ErrorResponse",
        }

        return self.api_client.call_api(
            self._root,
            '/api/v2/session/default-role',
            'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get(
                '_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @overload
    def get_default_schema(self,
                           async_req: Literal[False] = False,
                           **kwargs) -> DefaultResult:
        ...

    @overload
    def get_default_schema(self,
                           async_req: Literal[True] = True,
                           **kwargs) -> Future[DefaultResult]:
        ...

    @overload
    def get_default_schema(
            self,
            async_req: bool = False,
            **kwargs) -> Union[DefaultResult, Future[DefaultResult]]:
        ...

    @validate_call
    def get_default_schema(
            self, **kwargs
    ) -> Union[DefaultResult, Future[DefaultResult]]:  # noqa: E501
        """Get current session's default schema  # noqa: E501.

        Get current session's default schema  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.get_default_schema(async_req=True)
        >>> result = future.result()
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: Union[DefaultResult, Future[DefaultResult]]
        """
        kwargs['_return_http_data_only'] = True
        return self.get_default_schema_with_http_info(**kwargs)  # noqa: E501

    @validate_call
    def get_default_schema_with_http_info(self, **kwargs):  # noqa: E501
        """Get current session's default schema  # noqa: E501.

        Get current session's default schema  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.get_default_schema_with_http_info(async_req=True)
        >>> result = future.result()
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: tuple(Union[DefaultResult, Future[DefaultResult]], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = []
        _all_params.extend([
            'async_req', '_return_http_data_only', '_preload_content',
            '_request_timeout', '_request_auth', '_content_type', '_headers'
        ])

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise _APITypeError("Got an unexpected keyword argument '%s'"
                                    " to method get_default_schema" % _key)
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ExternalOAuth', 'KeyPair',
                          'SnowflakeOAuth']  # noqa: E501

        _response_types_map = {
            '200': "DefaultResult",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '404': "ErrorResponse",
            '405': "ErrorResponse",
            '408': "ErrorResponse",
            '409': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
            '503': "ErrorResponse",
            '504': "ErrorResponse",
        }

        return self.api_client.call_api(
            self._root,
            '/api/v2/session/default-schema',
            'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get(
                '_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @overload
    def get_default_warehouse(self,
                              async_req: Literal[False] = False,
                              **kwargs) -> DefaultResult:
        ...

    @overload
    def get_default_warehouse(self,
                              async_req: Literal[True] = True,
                              **kwargs) -> Future[DefaultResult]:
        ...

    @overload
    def get_default_warehouse(
            self,
            async_req: bool = False,
            **kwargs) -> Union[DefaultResult, Future[DefaultResult]]:
        ...

    @validate_call
    def get_default_warehouse(
            self, **kwargs
    ) -> Union[DefaultResult, Future[DefaultResult]]:  # noqa: E501
        """Get current session's default warehouse  # noqa: E501.

        Get current session's default warehouse  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.get_default_warehouse(async_req=True)
        >>> result = future.result()
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: Union[DefaultResult, Future[DefaultResult]]
        """
        kwargs['_return_http_data_only'] = True
        return self.get_default_warehouse_with_http_info(**
                                                         kwargs)  # noqa: E501

    @validate_call
    def get_default_warehouse_with_http_info(self, **kwargs):  # noqa: E501
        """Get current session's default warehouse  # noqa: E501.

        Get current session's default warehouse  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.get_default_warehouse_with_http_info(async_req=True)
        >>> result = future.result()
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: tuple(Union[DefaultResult, Future[DefaultResult]], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = []
        _all_params.extend([
            'async_req', '_return_http_data_only', '_preload_content',
            '_request_timeout', '_request_auth', '_content_type', '_headers'
        ])

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise _APITypeError("Got an unexpected keyword argument '%s'"
                                    " to method get_default_warehouse" % _key)
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ExternalOAuth', 'KeyPair',
                          'SnowflakeOAuth']  # noqa: E501

        _response_types_map = {
            '200': "DefaultResult",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '404': "ErrorResponse",
            '405': "ErrorResponse",
            '408': "ErrorResponse",
            '409': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
            '503': "ErrorResponse",
            '504': "ErrorResponse",
        }

        return self.api_client.call_api(
            self._root,
            '/api/v2/session/default-warehouse',
            'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get(
                '_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @overload
    def get_parameters(
            self,
            like:
        Annotated[
            Optional[StrictStr],
            Field(
                description=
                "Query parameter to filter the command output by resource name. Uses case-insensitive pattern matching, with support for SQL wildcard characters."
            )] = None,
            async_req: Literal[False] = False,
            **kwargs) -> Iterable[Parameter]:
        ...

    @overload
    def get_parameters(
            self,
            like:
        Annotated[
            Optional[StrictStr],
            Field(
                description=
                "Query parameter to filter the command output by resource name. Uses case-insensitive pattern matching, with support for SQL wildcard characters."
            )] = None,
            async_req: Literal[True] = True,
            **kwargs) -> Future[Iterable[Parameter]]:
        ...

    @overload
    def get_parameters(
            self,
            like:
        Annotated[
            Optional[StrictStr],
            Field(
                description=
                "Query parameter to filter the command output by resource name. Uses case-insensitive pattern matching, with support for SQL wildcard characters."
            )] = None,
            async_req: bool = False,
            **kwargs
    ) -> Union[Iterable[Parameter], Future[Iterable[Parameter]]]:
        ...

    @validate_call
    def get_parameters(
        self,
        like: Annotated[
            Optional[StrictStr],
            Field(
                description=
                "Query parameter to filter the command output by resource name. Uses case-insensitive pattern matching, with support for SQL wildcard characters."
            )] = None,
        **kwargs
    ) -> Union[Iterable[Parameter], Future[Iterable[Parameter]]]:  # noqa: E501
        """Gets the effective parameter values for the user's current session.  # noqa: E501.

        Gets the effective parameter values for the user's current session.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.get_parameters(like, async_req=True)
        >>> result = future.result()
        :param like: Query parameter to filter the command output by resource name. Uses case-insensitive pattern matching, with support for SQL wildcard characters.
        :type like: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: Union[Iterable[Parameter], Future[Iterable[Parameter]]]
        """
        kwargs['_return_http_data_only'] = True
        return self.get_parameters_with_http_info(like, **kwargs)  # noqa: E501

    @validate_call
    def get_parameters_with_http_info(
            self,
            like:
        Annotated[
            Optional[StrictStr],
            Field(
                description=
                "Query parameter to filter the command output by resource name. Uses case-insensitive pattern matching, with support for SQL wildcard characters."
            )] = None,
            **kwargs):  # noqa: E501
        """Gets the effective parameter values for the user's current session.  # noqa: E501.

        Gets the effective parameter values for the user's current session.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.get_parameters_with_http_info(like, async_req=True)
        >>> result = future.result()
        :param like: Query parameter to filter the command output by resource name. Uses case-insensitive pattern matching, with support for SQL wildcard characters.
        :type like: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: tuple(Union[Iterable[Parameter], Future[Iterable[Parameter]]], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ['like']
        _all_params.extend([
            'async_req', '_return_http_data_only', '_preload_content',
            '_request_timeout', '_request_auth', '_content_type', '_headers'
        ])

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise _APITypeError("Got an unexpected keyword argument '%s'"
                                    " to method get_parameters" % _key)
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []

        if _params.get('like') is not None:  # noqa: E501
            _query_params.append(('like', _params['like']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ExternalOAuth', 'KeyPair',
                          'SnowflakeOAuth']  # noqa: E501

        _response_types_map = {
            '200': "Iterable[Parameter]",
            '202': "SuccessResponse",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '404': "ErrorResponse",
            '405': "ErrorResponse",
            '408': "ErrorResponse",
            '409': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
            '503': "ErrorResponse",
            '504': "ErrorResponse",
        }

        return self.api_client.call_api(
            self._root,
            '/api/v2/session/parameters/effective',
            'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get(
                '_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @overload
    def set_default_database(self,
                             named_default: NamedDefault,
                             async_req: Literal[False] = False,
                             **kwargs) -> SuccessResponse:
        ...

    @overload
    def set_default_database(self,
                             named_default: NamedDefault,
                             async_req: Literal[True] = True,
                             **kwargs) -> Future[SuccessResponse]:
        ...

    @overload
    def set_default_database(
            self,
            named_default: NamedDefault,
            async_req: bool = False,
            **kwargs) -> Union[SuccessResponse, Future[SuccessResponse]]:
        ...

    @validate_call
    def set_default_database(
        self, named_default: NamedDefault, **kwargs
    ) -> Union[SuccessResponse, Future[SuccessResponse]]:  # noqa: E501
        """Set current session's default database  # noqa: E501.

        Set current session's default database  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.set_default_database(named_default, async_req=True)
        >>> result = future.result()
        :param named_default: (required)
        :type named_default: NamedDefault
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: Union[SuccessResponse, Future[SuccessResponse]]
        """
        kwargs['_return_http_data_only'] = True
        return self.set_default_database_with_http_info(
            named_default, **kwargs)  # noqa: E501

    @validate_call
    def set_default_database_with_http_info(self, named_default: NamedDefault,
                                            **kwargs):  # noqa: E501
        """Set current session's default database  # noqa: E501.

        Set current session's default database  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.set_default_database_with_http_info(named_default, async_req=True)
        >>> result = future.result()
        :param named_default: (required)
        :type named_default: NamedDefault
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: tuple(Union[SuccessResponse, Future[SuccessResponse]], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ['named_default']
        _all_params.extend([
            'async_req', '_return_http_data_only', '_preload_content',
            '_request_timeout', '_request_auth', '_content_type', '_headers'
        ])

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise _APITypeError("Got an unexpected keyword argument '%s'"
                                    " to method set_default_database" % _key)
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        if _params['named_default']:
            _body_params = _params['named_default']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            '_content_type',
            self.api_client.select_header_content_type(['application/json']))
        if _content_types_list:
            _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ExternalOAuth', 'KeyPair',
                          'SnowflakeOAuth']  # noqa: E501

        _response_types_map = {
            '200': "SuccessResponse",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '404': "ErrorResponse",
            '405': "ErrorResponse",
            '408': "ErrorResponse",
            '409': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
            '503': "ErrorResponse",
            '504': "ErrorResponse",
        }

        return self.api_client.call_api(
            self._root,
            '/api/v2/session/default-database',
            'PUT',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get(
                '_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @overload
    def set_default_role(self,
                         named_default: NamedDefault,
                         async_req: Literal[False] = False,
                         **kwargs) -> SuccessResponse:
        ...

    @overload
    def set_default_role(self,
                         named_default: NamedDefault,
                         async_req: Literal[True] = True,
                         **kwargs) -> Future[SuccessResponse]:
        ...

    @overload
    def set_default_role(
            self,
            named_default: NamedDefault,
            async_req: bool = False,
            **kwargs) -> Union[SuccessResponse, Future[SuccessResponse]]:
        ...

    @validate_call
    def set_default_role(
        self, named_default: NamedDefault, **kwargs
    ) -> Union[SuccessResponse, Future[SuccessResponse]]:  # noqa: E501
        """Set current session's default role  # noqa: E501.

        Set current session's default role  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.set_default_role(named_default, async_req=True)
        >>> result = future.result()
        :param named_default: (required)
        :type named_default: NamedDefault
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: Union[SuccessResponse, Future[SuccessResponse]]
        """
        kwargs['_return_http_data_only'] = True
        return self.set_default_role_with_http_info(named_default,
                                                    **kwargs)  # noqa: E501

    @validate_call
    def set_default_role_with_http_info(self, named_default: NamedDefault,
                                        **kwargs):  # noqa: E501
        """Set current session's default role  # noqa: E501.

        Set current session's default role  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.set_default_role_with_http_info(named_default, async_req=True)
        >>> result = future.result()
        :param named_default: (required)
        :type named_default: NamedDefault
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: tuple(Union[SuccessResponse, Future[SuccessResponse]], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ['named_default']
        _all_params.extend([
            'async_req', '_return_http_data_only', '_preload_content',
            '_request_timeout', '_request_auth', '_content_type', '_headers'
        ])

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise _APITypeError("Got an unexpected keyword argument '%s'"
                                    " to method set_default_role" % _key)
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        if _params['named_default']:
            _body_params = _params['named_default']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            '_content_type',
            self.api_client.select_header_content_type(['application/json']))
        if _content_types_list:
            _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ExternalOAuth', 'KeyPair',
                          'SnowflakeOAuth']  # noqa: E501

        _response_types_map = {
            '200': "SuccessResponse",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '404': "ErrorResponse",
            '405': "ErrorResponse",
            '408': "ErrorResponse",
            '409': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
            '503': "ErrorResponse",
            '504': "ErrorResponse",
        }

        return self.api_client.call_api(
            self._root,
            '/api/v2/session/default-role',
            'PUT',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get(
                '_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @overload
    def set_default_schema(self,
                           named_default: NamedDefault,
                           async_req: Literal[False] = False,
                           **kwargs) -> SuccessResponse:
        ...

    @overload
    def set_default_schema(self,
                           named_default: NamedDefault,
                           async_req: Literal[True] = True,
                           **kwargs) -> Future[SuccessResponse]:
        ...

    @overload
    def set_default_schema(
            self,
            named_default: NamedDefault,
            async_req: bool = False,
            **kwargs) -> Union[SuccessResponse, Future[SuccessResponse]]:
        ...

    @validate_call
    def set_default_schema(
        self, named_default: NamedDefault, **kwargs
    ) -> Union[SuccessResponse, Future[SuccessResponse]]:  # noqa: E501
        """Set current session's default schema  # noqa: E501.

        Set current session's default schema  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.set_default_schema(named_default, async_req=True)
        >>> result = future.result()
        :param named_default: (required)
        :type named_default: NamedDefault
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: Union[SuccessResponse, Future[SuccessResponse]]
        """
        kwargs['_return_http_data_only'] = True
        return self.set_default_schema_with_http_info(named_default,
                                                      **kwargs)  # noqa: E501

    @validate_call
    def set_default_schema_with_http_info(self, named_default: NamedDefault,
                                          **kwargs):  # noqa: E501
        """Set current session's default schema  # noqa: E501.

        Set current session's default schema  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.set_default_schema_with_http_info(named_default, async_req=True)
        >>> result = future.result()
        :param named_default: (required)
        :type named_default: NamedDefault
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: tuple(Union[SuccessResponse, Future[SuccessResponse]], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ['named_default']
        _all_params.extend([
            'async_req', '_return_http_data_only', '_preload_content',
            '_request_timeout', '_request_auth', '_content_type', '_headers'
        ])

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise _APITypeError("Got an unexpected keyword argument '%s'"
                                    " to method set_default_schema" % _key)
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        if _params['named_default']:
            _body_params = _params['named_default']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            '_content_type',
            self.api_client.select_header_content_type(['application/json']))
        if _content_types_list:
            _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ExternalOAuth', 'KeyPair',
                          'SnowflakeOAuth']  # noqa: E501

        _response_types_map = {
            '200': "SuccessResponse",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '404': "ErrorResponse",
            '405': "ErrorResponse",
            '408': "ErrorResponse",
            '409': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
            '503': "ErrorResponse",
            '504': "ErrorResponse",
        }

        return self.api_client.call_api(
            self._root,
            '/api/v2/session/default-schema',
            'PUT',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get(
                '_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @overload
    def set_default_warehouse(self,
                              named_default: NamedDefault,
                              async_req: Literal[False] = False,
                              **kwargs) -> SuccessResponse:
        ...

    @overload
    def set_default_warehouse(self,
                              named_default: NamedDefault,
                              async_req: Literal[True] = True,
                              **kwargs) -> Future[SuccessResponse]:
        ...

    @overload
    def set_default_warehouse(
            self,
            named_default: NamedDefault,
            async_req: bool = False,
            **kwargs) -> Union[SuccessResponse, Future[SuccessResponse]]:
        ...

    @validate_call
    def set_default_warehouse(
        self, named_default: NamedDefault, **kwargs
    ) -> Union[SuccessResponse, Future[SuccessResponse]]:  # noqa: E501
        """Set current session's default warehouse  # noqa: E501.

        Set current session's default warehouse  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.set_default_warehouse(named_default, async_req=True)
        >>> result = future.result()
        :param named_default: (required)
        :type named_default: NamedDefault
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: Union[SuccessResponse, Future[SuccessResponse]]
        """
        kwargs['_return_http_data_only'] = True
        return self.set_default_warehouse_with_http_info(
            named_default, **kwargs)  # noqa: E501

    @validate_call
    def set_default_warehouse_with_http_info(self, named_default: NamedDefault,
                                             **kwargs):  # noqa: E501
        """Set current session's default warehouse  # noqa: E501.

        Set current session's default warehouse  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.set_default_warehouse_with_http_info(named_default, async_req=True)
        >>> result = future.result()
        :param named_default: (required)
        :type named_default: NamedDefault
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: tuple(Union[SuccessResponse, Future[SuccessResponse]], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ['named_default']
        _all_params.extend([
            'async_req', '_return_http_data_only', '_preload_content',
            '_request_timeout', '_request_auth', '_content_type', '_headers'
        ])

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise _APITypeError("Got an unexpected keyword argument '%s'"
                                    " to method set_default_warehouse" % _key)
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        if _params['named_default']:
            _body_params = _params['named_default']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            '_content_type',
            self.api_client.select_header_content_type(['application/json']))
        if _content_types_list:
            _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ExternalOAuth', 'KeyPair',
                          'SnowflakeOAuth']  # noqa: E501

        _response_types_map = {
            '200': "SuccessResponse",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '404': "ErrorResponse",
            '405': "ErrorResponse",
            '408': "ErrorResponse",
            '409': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
            '503': "ErrorResponse",
            '504': "ErrorResponse",
        }

        return self.api_client.call_api(
            self._root,
            '/api/v2/session/default-warehouse',
            'PUT',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get(
                '_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @overload
    def use_secondary_role(self,
                           secondary_roles: SecondaryRoles,
                           async_req: Literal[False] = False,
                           **kwargs) -> SuccessResponse:
        ...

    @overload
    def use_secondary_role(self,
                           secondary_roles: SecondaryRoles,
                           async_req: Literal[True] = True,
                           **kwargs) -> Future[SuccessResponse]:
        ...

    @overload
    def use_secondary_role(
            self,
            secondary_roles: SecondaryRoles,
            async_req: bool = False,
            **kwargs) -> Union[SuccessResponse, Future[SuccessResponse]]:
        ...

    @validate_call
    def use_secondary_role(
        self, secondary_roles: SecondaryRoles, **kwargs
    ) -> Union[SuccessResponse, Future[SuccessResponse]]:  # noqa: E501
        """Set or unset current session's secondary role usage  # noqa: E501.

        Enable or disable current session's secondary role usage  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.use_secondary_role(secondary_roles, async_req=True)
        >>> result = future.result()
        :param secondary_roles: (required)
        :type secondary_roles: SecondaryRoles
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: Union[SuccessResponse, Future[SuccessResponse]]
        """
        kwargs['_return_http_data_only'] = True
        return self.use_secondary_role_with_http_info(secondary_roles,
                                                      **kwargs)  # noqa: E501

    @validate_call
    def use_secondary_role_with_http_info(self,
                                          secondary_roles: SecondaryRoles,
                                          **kwargs):  # noqa: E501
        """Set or unset current session's secondary role usage  # noqa: E501.

        Enable or disable current session's secondary role usage  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.use_secondary_role_with_http_info(secondary_roles, async_req=True)
        >>> result = future.result()
        :param secondary_roles: (required)
        :type secondary_roles: SecondaryRoles
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: tuple(Union[SuccessResponse, Future[SuccessResponse]], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ['secondary_roles']
        _all_params.extend([
            'async_req', '_return_http_data_only', '_preload_content',
            '_request_timeout', '_request_auth', '_content_type', '_headers'
        ])

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise _APITypeError("Got an unexpected keyword argument '%s'"
                                    " to method use_secondary_role" % _key)
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        if _params['secondary_roles']:
            _body_params = _params['secondary_roles']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            '_content_type',
            self.api_client.select_header_content_type(['application/json']))
        if _content_types_list:
            _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ExternalOAuth', 'KeyPair',
                          'SnowflakeOAuth']  # noqa: E501

        _response_types_map = {
            '200': "SuccessResponse",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '404': "ErrorResponse",
            '405': "ErrorResponse",
            '408': "ErrorResponse",
            '409': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
            '503': "ErrorResponse",
            '504': "ErrorResponse",
        }

        return self.api_client.call_api(
            self._root,
            '/api/v2/session/secondary-roles',
            'PUT',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get(
                '_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
