# coding: utf-8
"""
    Snowflake Table API.

    The Snowflake Table API is a REST API that you can use to access, update, and perform certain actions on Tables resource in a Snowflake database.  # noqa: E501

    The version of the OpenAPI document: 0.0.1
    Contact: support@snowflake.com
    Generated by: https://openapi-generator.tech

    Do not edit this file manually.
"""

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from typing import Union

from pydantic import BaseModel, ConfigDict, StrictStr

from typing import Any, ClassVar, Dict, List, Optional


class TableLike(BaseModel):
    """A model object representing the TableLike resource.

    Constructs an object of type TableLike with the provided properties.

    Parameters
    __________
    name : str, optional
        Specifies the name for the table, must be unique for the schema in which the table is created
    """

    name: Optional[StrictStr] = None

    __properties = ["name"]

    class Config:
        populate_by_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> TableLike:
        """Create an instance of TableLike from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""

        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = dict(
            self._iter(to_dict=True,
                       by_alias=True,
                       exclude=exclude_properties,
                       exclude_none=True))

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> TableLike:
        """Create an instance of TableLike from a dict."""

        if obj is None:
            return None

        if type(obj) is not dict:
            return TableLike.parse_obj(obj)

        _obj = TableLike.parse_obj({
            "name": obj.get("name"),
        })

        return _obj


from typing import Optional, List, Dict


class TableLikeModel():

    def __init__(
        self,  # optional properties
        name: Optional[str] = None,
    ):
        """A model object representing the TableLike resource.

        Constructs an object of type TableLike with the provided properties.

        Parameters
        __________
        name : str, optional
            Specifies the name for the table, must be unique for the schema in which the table is created
        """

        self.name = name

    __properties = ["name"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return TableLike(name=self.name, )

    @classmethod
    def _from_model(cls, model) -> TableLikeModel:
        return TableLikeModel(name=model.name, )

    def to_dict(self):
        """Creates a dictionary of the properties from a TableLike.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the TableLike object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> TableLikeModel:
        """Creates an instance of TableLike from a dict.

        This method constructs a TableLike object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        TableLike
            A TableLike object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(TableLike.from_dict(obj))


TableLike._model_class = TableLikeModel
