# coding: utf-8
"""
    Snowflake Task API.

    The Snowflake Task API is a REST API that you can use to access, update, and perform certain actions on task resources in a Snowflake database.  # noqa: E501

    The version of the OpenAPI document: 0.0.1
    Contact: support@snowflake.com
    Generated by: https://openapi-generator.tech

    Do not edit this file manually.
"""

from __future__ import absolute_import

import logging
from pydantic import Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import List, Optional
from typing_extensions import Annotated
from snowflake.core.task._generated.models.success_response import SuccessResponse
from snowflake.core.task._generated.models.task import Task
from snowflake.core.task._generated.models.task_run import TaskRun
from typing import Iterable

from snowflake.core.task._generated.api_client import ApiClient

from concurrent.futures import Future
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Literal, Optional, Tuple, Union, overload
from typing_extensions import Annotated

from snowflake.core._internal.utils import is_running_inside_stored_procedure

from snowflake.core.exceptions import (  # noqa: F401
    _APITypeError, _APIValueError)

logger = logging.getLogger(__name__)


class TaskApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech.

    Do not edit the class manually.
    """

    def __init__(self, root, resource_class, sproc_client):
        self._root = root
        self._resource_name = 'task'
        self._resource_class = resource_class

        if is_running_inside_stored_procedure():
            self._api_client = sproc_client
        else:
            self._api_client = ApiClient.get_default(self._root)

    @property
    def api_client(self):
        return self._api_client

    @overload
    def create_or_alter_task(
            self,
            database:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
            var_schema:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )],
            name: Annotated[
                str,
                Field(strict=True,
                      description="Identifier (i.e. name) for the resource.")],
            task: Task,
            async_req: Literal[False] = False,
            **kwargs) -> SuccessResponse:
        ...

    @overload
    def create_or_alter_task(
            self,
            database:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
            var_schema:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )],
            name: Annotated[
                str,
                Field(strict=True,
                      description="Identifier (i.e. name) for the resource.")],
            task: Task,
            async_req: Literal[True] = True,
            **kwargs) -> Future[SuccessResponse]:
        ...

    @overload
    def create_or_alter_task(
            self,
            database:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
            var_schema:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )],
            name: Annotated[
                str,
                Field(strict=True,
                      description="Identifier (i.e. name) for the resource.")],
            task: Task,
            async_req: bool = False,
            **kwargs) -> Union[SuccessResponse, Future[SuccessResponse]]:
        ...

    @validate_call
    def create_or_alter_task(self, database: Annotated[
        str,
        Field(
            strict=True,
            description=
            "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
        )], var_schema: Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )], name: Annotated[
                str,
                Field(strict=True,
                      description="Identifier (i.e. name) for the resource.")],
                             task: Task, **kwargs
                             ) -> Union[SuccessResponse,
                                        Future[SuccessResponse]]:  # noqa: E501
        """Create a (or alter an existing) task  # noqa: E501.

        Create a (or alter an existing) task. Even if the operation is just an alter, the full property set must be provided.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.create_or_alter_task(database, var_schema, name, task, async_req=True)
        >>> result = future.result()
        :param database: Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases. (required)
        :type database: str
        :param var_schema: Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database. (required)
        :type var_schema: str
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param task: (required)
        :type task: Task
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: Union[SuccessResponse, Future[SuccessResponse]]
        """
        kwargs['_return_http_data_only'] = True
        return self.create_or_alter_task_with_http_info(
            database, var_schema, name, task, **kwargs)  # noqa: E501

    @validate_call
    def create_or_alter_task_with_http_info(self, database: Annotated[
        str,
        Field(
            strict=True,
            description=
            "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
        )], var_schema: Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )], name: Annotated[
                str,
                Field(strict=True,
                      description="Identifier (i.e. name) for the resource.")],
                                            task: Task,
                                            **kwargs):  # noqa: E501
        """Create a (or alter an existing) task  # noqa: E501.

        Create a (or alter an existing) task. Even if the operation is just an alter, the full property set must be provided.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.create_or_alter_task_with_http_info(database, var_schema, name, task, async_req=True)
        >>> result = future.result()
        :param database: Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases. (required)
        :type database: str
        :param var_schema: Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database. (required)
        :type var_schema: str
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param task: (required)
        :type task: Task
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: tuple(Union[SuccessResponse, Future[SuccessResponse]], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ['database', 'var_schema', 'name', 'task']
        _all_params.extend([
            'async_req', '_return_http_data_only', '_preload_content',
            '_request_timeout', '_request_auth', '_content_type', '_headers'
        ])

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise _APITypeError("Got an unexpected keyword argument '%s'"
                                    " to method create_or_alter_task" % _key)
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        if _params['database']:
            _path_params['database'] = _params['database']

        if _params['var_schema']:
            _path_params['schema'] = _params['var_schema']

        if _params['name']:
            _path_params['name'] = _params['name']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        if _params['task']:
            _body_params = _params['task']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            '_content_type',
            self.api_client.select_header_content_type(['application/json']))
        if _content_types_list:
            _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ExternalOAuth', 'KeyPair',
                          'SnowflakeOAuth']  # noqa: E501

        _response_types_map = {
            '200': "SuccessResponse",
            '202': "SuccessAcceptedResponse",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '404': "ErrorResponse",
            '405': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
            '503': "ErrorResponse",
            '504': "ErrorResponse",
        }

        return self.api_client.call_api(
            self._root,
            '/api/v2/databases/{database}/schemas/{schema}/tasks/{name}',
            'PUT',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get(
                '_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @overload
    def create_task(
            self,
            database:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
            var_schema:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )],
            task: Task,
            create_mode:
        Annotated[
            Optional[StrictStr],
            Field(
                description=
                "Query parameter allowing support for different modes of resource creation. Possible values include: - `errorIfExists`: Throws an error if you try to create a resource that already exists. - `orReplace`: Automatically replaces the existing resource with the current one. - `ifNotExists`: Creates a new resource when an alter is requested for a non-existent resource."
            )] = None,
            async_req: Literal[False] = False,
            **kwargs) -> SuccessResponse:
        ...

    @overload
    def create_task(
            self,
            database:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
            var_schema:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )],
            task: Task,
            create_mode:
        Annotated[
            Optional[StrictStr],
            Field(
                description=
                "Query parameter allowing support for different modes of resource creation. Possible values include: - `errorIfExists`: Throws an error if you try to create a resource that already exists. - `orReplace`: Automatically replaces the existing resource with the current one. - `ifNotExists`: Creates a new resource when an alter is requested for a non-existent resource."
            )] = None,
            async_req: Literal[True] = True,
            **kwargs) -> Future[SuccessResponse]:
        ...

    @overload
    def create_task(
            self,
            database:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
            var_schema:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )],
            task: Task,
            create_mode:
        Annotated[
            Optional[StrictStr],
            Field(
                description=
                "Query parameter allowing support for different modes of resource creation. Possible values include: - `errorIfExists`: Throws an error if you try to create a resource that already exists. - `orReplace`: Automatically replaces the existing resource with the current one. - `ifNotExists`: Creates a new resource when an alter is requested for a non-existent resource."
            )] = None,
            async_req: bool = False,
            **kwargs) -> Union[SuccessResponse, Future[SuccessResponse]]:
        ...

    @validate_call
    def create_task(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )],
        task: Task,
        create_mode: Annotated[
            Optional[StrictStr],
            Field(
                description=
                "Query parameter allowing support for different modes of resource creation. Possible values include: - `errorIfExists`: Throws an error if you try to create a resource that already exists. - `orReplace`: Automatically replaces the existing resource with the current one. - `ifNotExists`: Creates a new resource when an alter is requested for a non-existent resource."
            )] = None,
        **kwargs
    ) -> Union[SuccessResponse, Future[SuccessResponse]]:  # noqa: E501
        """Create a task  # noqa: E501.

        Create a task, with standard create modifiers as query parameters. See the Task component definition for what is required to be provided in the request body.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.create_task(database, var_schema, task, create_mode, async_req=True)
        >>> result = future.result()
        :param database: Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases. (required)
        :type database: str
        :param var_schema: Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database. (required)
        :type var_schema: str
        :param task: (required)
        :type task: Task
        :param create_mode: Query parameter allowing support for different modes of resource creation. Possible values include: - `errorIfExists`: Throws an error if you try to create a resource that already exists. - `orReplace`: Automatically replaces the existing resource with the current one. - `ifNotExists`: Creates a new resource when an alter is requested for a non-existent resource.
        :type create_mode: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: Union[SuccessResponse, Future[SuccessResponse]]
        """
        kwargs['_return_http_data_only'] = True
        return self.create_task_with_http_info(database, var_schema, task,
                                               create_mode,
                                               **kwargs)  # noqa: E501

    @validate_call
    def create_task_with_http_info(
            self,
            database:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
            var_schema:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )],
            task: Task,
            create_mode:
        Annotated[
            Optional[StrictStr],
            Field(
                description=
                "Query parameter allowing support for different modes of resource creation. Possible values include: - `errorIfExists`: Throws an error if you try to create a resource that already exists. - `orReplace`: Automatically replaces the existing resource with the current one. - `ifNotExists`: Creates a new resource when an alter is requested for a non-existent resource."
            )] = None,
            **kwargs):  # noqa: E501
        """Create a task  # noqa: E501.

        Create a task, with standard create modifiers as query parameters. See the Task component definition for what is required to be provided in the request body.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.create_task_with_http_info(database, var_schema, task, create_mode, async_req=True)
        >>> result = future.result()
        :param database: Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases. (required)
        :type database: str
        :param var_schema: Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database. (required)
        :type var_schema: str
        :param task: (required)
        :type task: Task
        :param create_mode: Query parameter allowing support for different modes of resource creation. Possible values include: - `errorIfExists`: Throws an error if you try to create a resource that already exists. - `orReplace`: Automatically replaces the existing resource with the current one. - `ifNotExists`: Creates a new resource when an alter is requested for a non-existent resource.
        :type create_mode: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: tuple(Union[SuccessResponse, Future[SuccessResponse]], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ['database', 'var_schema', 'task', 'create_mode']
        _all_params.extend([
            'async_req', '_return_http_data_only', '_preload_content',
            '_request_timeout', '_request_auth', '_content_type', '_headers'
        ])

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise _APITypeError("Got an unexpected keyword argument '%s'"
                                    " to method create_task" % _key)
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        if _params['database']:
            _path_params['database'] = _params['database']

        if _params['var_schema']:
            _path_params['schema'] = _params['var_schema']

        # process the query parameters
        _query_params = []

        if _params.get('create_mode') is not None:  # noqa: E501
            _query_params.append(('createMode', _params['create_mode']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        if _params['task']:
            _body_params = _params['task']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            '_content_type',
            self.api_client.select_header_content_type(['application/json']))
        if _content_types_list:
            _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ExternalOAuth', 'KeyPair',
                          'SnowflakeOAuth']  # noqa: E501

        _response_types_map = {
            '200': "SuccessResponse",
            '202': "SuccessAcceptedResponse",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '404': "ErrorResponse",
            '405': "ErrorResponse",
            '408': "ErrorResponse",
            '409': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
            '503': "ErrorResponse",
            '504': "ErrorResponse",
        }

        return self.api_client.call_api(
            self._root,
            '/api/v2/databases/{database}/schemas/{schema}/tasks',
            'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get(
                '_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @overload
    def execute_task(
            self,
            database:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
            var_schema:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )],
            name: Annotated[
                str,
                Field(strict=True,
                      description="Identifier (i.e. name) for the resource.")],
            async_exec: Annotated[
                Optional[StrictBool],
                Field(
                    description=
                    "Asynchronous execution enable/disable. Default is disable."
                )] = None,
            retry_last: Annotated[
                Optional[StrictBool],
                Field(description="Retry the last failed run of the DAG."
                      )] = None,
            async_req: Literal[False] = False,
            **kwargs) -> SuccessResponse:
        ...

    @overload
    def execute_task(
            self,
            database:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
            var_schema:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )],
            name: Annotated[
                str,
                Field(strict=True,
                      description="Identifier (i.e. name) for the resource.")],
            async_exec: Annotated[
                Optional[StrictBool],
                Field(
                    description=
                    "Asynchronous execution enable/disable. Default is disable."
                )] = None,
            retry_last: Annotated[
                Optional[StrictBool],
                Field(description="Retry the last failed run of the DAG."
                      )] = None,
            async_req: Literal[True] = True,
            **kwargs) -> Future[SuccessResponse]:
        ...

    @overload
    def execute_task(
            self,
            database:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
            var_schema:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )],
            name: Annotated[
                str,
                Field(strict=True,
                      description="Identifier (i.e. name) for the resource.")],
            async_exec: Annotated[
                Optional[StrictBool],
                Field(
                    description=
                    "Asynchronous execution enable/disable. Default is disable."
                )] = None,
            retry_last: Annotated[
                Optional[StrictBool],
                Field(description="Retry the last failed run of the DAG."
                      )] = None,
            async_req: bool = False,
            **kwargs) -> Union[SuccessResponse, Future[SuccessResponse]]:
        ...

    @validate_call
    def execute_task(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )],
        name: Annotated[
            str,
            Field(strict=True,
                  description="Identifier (i.e. name) for the resource.")],
        async_exec: Annotated[
            Optional[StrictBool],
            Field(description=
                  "Asynchronous execution enable/disable. Default is disable."
                  )] = None,
        retry_last: Annotated[
            Optional[StrictBool],
            Field(description="Retry the last failed run of the DAG.")] = None,
        **kwargs
    ) -> Union[SuccessResponse, Future[SuccessResponse]]:  # noqa: E501
        """Execute a task object.  # noqa: E501.

        Execute a task -- this is equivalent to EXECUTE IMMEDIATE.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.execute_task(database, var_schema, name, async_exec, retry_last, async_req=True)
        >>> result = future.result()
        :param database: Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases. (required)
        :type database: str
        :param var_schema: Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database. (required)
        :type var_schema: str
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param async_exec: Asynchronous execution enable/disable. Default is disable.
        :type async_exec: bool
        :param retry_last: Retry the last failed run of the DAG.
        :type retry_last: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: Union[SuccessResponse, Future[SuccessResponse]]
        """
        kwargs['_return_http_data_only'] = True
        return self.execute_task_with_http_info(database, var_schema, name,
                                                async_exec, retry_last,
                                                **kwargs)  # noqa: E501

    @validate_call
    def execute_task_with_http_info(
            self,
            database:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
            var_schema:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )],
            name: Annotated[
                str,
                Field(strict=True,
                      description="Identifier (i.e. name) for the resource.")],
            async_exec: Annotated[
                Optional[StrictBool],
                Field(
                    description=
                    "Asynchronous execution enable/disable. Default is disable."
                )] = None,
            retry_last: Annotated[
                Optional[StrictBool],
                Field(description="Retry the last failed run of the DAG."
                      )] = None,
            **kwargs):  # noqa: E501
        """Execute a task object.  # noqa: E501.

        Execute a task -- this is equivalent to EXECUTE IMMEDIATE.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.execute_task_with_http_info(database, var_schema, name, async_exec, retry_last, async_req=True)
        >>> result = future.result()
        :param database: Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases. (required)
        :type database: str
        :param var_schema: Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database. (required)
        :type var_schema: str
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param async_exec: Asynchronous execution enable/disable. Default is disable.
        :type async_exec: bool
        :param retry_last: Retry the last failed run of the DAG.
        :type retry_last: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: tuple(Union[SuccessResponse, Future[SuccessResponse]], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'database', 'var_schema', 'name', 'async_exec', 'retry_last'
        ]
        _all_params.extend([
            'async_req', '_return_http_data_only', '_preload_content',
            '_request_timeout', '_request_auth', '_content_type', '_headers'
        ])

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise _APITypeError("Got an unexpected keyword argument '%s'"
                                    " to method execute_task" % _key)
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        if _params['database']:
            _path_params['database'] = _params['database']

        if _params['var_schema']:
            _path_params['schema'] = _params['var_schema']

        if _params['name']:
            _path_params['name'] = _params['name']

        # process the query parameters
        _query_params = []

        if _params.get('async_exec') is not None:  # noqa: E501
            _query_params.append(('asyncExec', _params['async_exec']))

        if _params.get('retry_last') is not None:  # noqa: E501
            _query_params.append(('retryLast', _params['retry_last']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ExternalOAuth', 'KeyPair',
                          'SnowflakeOAuth']  # noqa: E501

        _response_types_map = {
            '200': "SuccessResponse",
            '202': "SuccessAcceptedResponse",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '404': "ErrorResponse",
            '405': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
            '503': "ErrorResponse",
            '504': "ErrorResponse",
        }

        return self.api_client.call_api(
            self._root,
            '/api/v2/databases/{database}/schemas/{schema}/tasks/{name}:execute',
            'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get(
                '_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @overload
    def fetch_task(
            self,
            database:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
            var_schema:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )],
            name: Annotated[
                str,
                Field(strict=True,
                      description="Identifier (i.e. name) for the resource.")],
            async_req: Literal[False] = False,
            **kwargs) -> Task:
        ...

    @overload
    def fetch_task(
            self,
            database:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
            var_schema:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )],
            name: Annotated[
                str,
                Field(strict=True,
                      description="Identifier (i.e. name) for the resource.")],
            async_req: Literal[True] = True,
            **kwargs) -> Future[Task]:
        ...

    @overload
    def fetch_task(
            self,
            database:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
            var_schema:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )],
            name: Annotated[
                str,
                Field(strict=True,
                      description="Identifier (i.e. name) for the resource.")],
            async_req: bool = False,
            **kwargs) -> Union[Task, Future[Task]]:
        ...

    @validate_call
    def fetch_task(self, database: Annotated[
        str,
        Field(
            strict=True,
            description=
            "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
        )], var_schema: Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )], name: Annotated[
                str,
                Field(strict=True,
                      description="Identifier (i.e. name) for the resource.")],
                   **kwargs) -> Union[Task, Future[Task]]:  # noqa: E501
        """Fetch a task  # noqa: E501.

        Fetch a task using the describe command output.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.fetch_task(database, var_schema, name, async_req=True)
        >>> result = future.result()
        :param database: Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases. (required)
        :type database: str
        :param var_schema: Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database. (required)
        :type var_schema: str
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: Union[Task, Future[Task]]
        """
        kwargs['_return_http_data_only'] = True
        return self.fetch_task_with_http_info(database, var_schema, name,
                                              **kwargs)  # noqa: E501

    @validate_call
    def fetch_task_with_http_info(self, database: Annotated[
        str,
        Field(
            strict=True,
            description=
            "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
        )], var_schema: Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )], name: Annotated[
                str,
                Field(strict=True,
                      description="Identifier (i.e. name) for the resource.")],
                                  **kwargs):  # noqa: E501
        """Fetch a task  # noqa: E501.

        Fetch a task using the describe command output.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.fetch_task_with_http_info(database, var_schema, name, async_req=True)
        >>> result = future.result()
        :param database: Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases. (required)
        :type database: str
        :param var_schema: Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database. (required)
        :type var_schema: str
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: tuple(Union[Task, Future[Task]], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ['database', 'var_schema', 'name']
        _all_params.extend([
            'async_req', '_return_http_data_only', '_preload_content',
            '_request_timeout', '_request_auth', '_content_type', '_headers'
        ])

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise _APITypeError("Got an unexpected keyword argument '%s'"
                                    " to method fetch_task" % _key)
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        if _params['database']:
            _path_params['database'] = _params['database']

        if _params['var_schema']:
            _path_params['schema'] = _params['var_schema']

        if _params['name']:
            _path_params['name'] = _params['name']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ExternalOAuth', 'KeyPair',
                          'SnowflakeOAuth']  # noqa: E501

        _response_types_map = {
            '200': "Task",
            '202': "SuccessAcceptedResponse",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '404': "ErrorResponse",
            '405': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
            '503': "ErrorResponse",
            '504': "ErrorResponse",
        }

        return self.api_client.call_api(
            self._root,
            '/api/v2/databases/{database}/schemas/{schema}/tasks/{name}',
            'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get(
                '_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @overload
    def fetch_task_dependents(
            self,
            database:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
            var_schema:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )],
            name: Annotated[
                str,
                Field(strict=True,
                      description="Identifier (i.e. name) for the resource.")],
            recursive:
        Annotated[
            Optional[StrictBool],
            Field(
                description=
                "Specifies whether to limit the output to include only direct child tasks or to include all recursive child tasks."
            )] = None,
            async_req: Literal[False] = False,
            **kwargs) -> Iterable[Task]:
        ...

    @overload
    def fetch_task_dependents(
            self,
            database:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
            var_schema:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )],
            name: Annotated[
                str,
                Field(strict=True,
                      description="Identifier (i.e. name) for the resource.")],
            recursive:
        Annotated[
            Optional[StrictBool],
            Field(
                description=
                "Specifies whether to limit the output to include only direct child tasks or to include all recursive child tasks."
            )] = None,
            async_req: Literal[True] = True,
            **kwargs) -> Future[Iterable[Task]]:
        ...

    @overload
    def fetch_task_dependents(
            self,
            database:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
            var_schema:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )],
            name: Annotated[
                str,
                Field(strict=True,
                      description="Identifier (i.e. name) for the resource.")],
            recursive:
        Annotated[
            Optional[StrictBool],
            Field(
                description=
                "Specifies whether to limit the output to include only direct child tasks or to include all recursive child tasks."
            )] = None,
            async_req: bool = False,
            **kwargs) -> Union[Iterable[Task], Future[Iterable[Task]]]:
        ...

    @validate_call
    def fetch_task_dependents(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )],
        name: Annotated[
            str,
            Field(strict=True,
                  description="Identifier (i.e. name) for the resource.")],
        recursive: Annotated[
            Optional[StrictBool],
            Field(
                description=
                "Specifies whether to limit the output to include only direct child tasks or to include all recursive child tasks."
            )] = None,
        **kwargs
    ) -> Union[Iterable[Task], Future[Iterable[Task]]]:  # noqa: E501
        """Fetch the dependent tasks of a task  # noqa: E501.

        This operation returns a list of the dependent tasks of the task with identifier {name}.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.fetch_task_dependents(database, var_schema, name, recursive, async_req=True)
        >>> result = future.result()
        :param database: Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases. (required)
        :type database: str
        :param var_schema: Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database. (required)
        :type var_schema: str
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param recursive: Specifies whether to limit the output to include only direct child tasks or to include all recursive child tasks.
        :type recursive: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: Union[Iterable[Task], Future[Iterable[Task]]]
        """
        kwargs['_return_http_data_only'] = True
        return self.fetch_task_dependents_with_http_info(
            database, var_schema, name, recursive, **kwargs)  # noqa: E501

    @validate_call
    def fetch_task_dependents_with_http_info(
            self,
            database:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
            var_schema:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )],
            name: Annotated[
                str,
                Field(strict=True,
                      description="Identifier (i.e. name) for the resource.")],
            recursive:
        Annotated[
            Optional[StrictBool],
            Field(
                description=
                "Specifies whether to limit the output to include only direct child tasks or to include all recursive child tasks."
            )] = None,
            **kwargs):  # noqa: E501
        """Fetch the dependent tasks of a task  # noqa: E501.

        This operation returns a list of the dependent tasks of the task with identifier {name}.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.fetch_task_dependents_with_http_info(database, var_schema, name, recursive, async_req=True)
        >>> result = future.result()
        :param database: Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases. (required)
        :type database: str
        :param var_schema: Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database. (required)
        :type var_schema: str
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param recursive: Specifies whether to limit the output to include only direct child tasks or to include all recursive child tasks.
        :type recursive: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: tuple(Union[Iterable[Task], Future[Iterable[Task]]], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ['database', 'var_schema', 'name', 'recursive']
        _all_params.extend([
            'async_req', '_return_http_data_only', '_preload_content',
            '_request_timeout', '_request_auth', '_content_type', '_headers'
        ])

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise _APITypeError("Got an unexpected keyword argument '%s'"
                                    " to method fetch_task_dependents" % _key)
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        if _params['database']:
            _path_params['database'] = _params['database']

        if _params['var_schema']:
            _path_params['schema'] = _params['var_schema']

        if _params['name']:
            _path_params['name'] = _params['name']

        # process the query parameters
        _query_params = []

        if _params.get('recursive') is not None:  # noqa: E501
            _query_params.append(('recursive', _params['recursive']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ExternalOAuth', 'KeyPair',
                          'SnowflakeOAuth']  # noqa: E501

        _response_types_map = {
            '200': "Iterable[Task]",
            '202': "SuccessAcceptedResponse",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '404': "ErrorResponse",
            '405': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
            '503': "ErrorResponse",
            '504': "ErrorResponse",
        }

        return self.api_client.call_api(
            self._root,
            '/api/v2/databases/{database}/schemas/{schema}/tasks/{name}/dependents',
            'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get(
                '_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @overload
    def get_complete_graphs(
            self,
            database:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
            var_schema:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )],
            name: Annotated[
                str,
                Field(strict=True,
                      description="Identifier (i.e. name) for the resource.")],
            result_limit:
        Annotated[
            Optional[StrictInt],
            Field(
                description=
                "Number of results to return, at most. Default is 1000, valid range is 1 to 10000."
            )] = None,
            error_only:
        Annotated[
            Optional[StrictBool],
            Field(
                description=
                "Whether to only return results for tasks runs that have failed. Default is false."
            )] = None,
            async_req: Literal[False] = False,
            **kwargs) -> Iterable[TaskRun]:
        ...

    @overload
    def get_complete_graphs(
            self,
            database:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
            var_schema:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )],
            name: Annotated[
                str,
                Field(strict=True,
                      description="Identifier (i.e. name) for the resource.")],
            result_limit:
        Annotated[
            Optional[StrictInt],
            Field(
                description=
                "Number of results to return, at most. Default is 1000, valid range is 1 to 10000."
            )] = None,
            error_only:
        Annotated[
            Optional[StrictBool],
            Field(
                description=
                "Whether to only return results for tasks runs that have failed. Default is false."
            )] = None,
            async_req: Literal[True] = True,
            **kwargs) -> Future[Iterable[TaskRun]]:
        ...

    @overload
    def get_complete_graphs(
            self,
            database:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
            var_schema:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )],
            name: Annotated[
                str,
                Field(strict=True,
                      description="Identifier (i.e. name) for the resource.")],
            result_limit:
        Annotated[
            Optional[StrictInt],
            Field(
                description=
                "Number of results to return, at most. Default is 1000, valid range is 1 to 10000."
            )] = None,
            error_only:
        Annotated[
            Optional[StrictBool],
            Field(
                description=
                "Whether to only return results for tasks runs that have failed. Default is false."
            )] = None,
            async_req: bool = False,
            **kwargs) -> Union[Iterable[TaskRun], Future[Iterable[TaskRun]]]:
        ...

    @validate_call
    def get_complete_graphs(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )],
        name: Annotated[
            str,
            Field(strict=True,
                  description="Identifier (i.e. name) for the resource.")],
        result_limit: Annotated[
            Optional[StrictInt],
            Field(
                description=
                "Number of results to return, at most. Default is 1000, valid range is 1 to 10000."
            )] = None,
        error_only: Annotated[
            Optional[StrictBool],
            Field(
                description=
                "Whether to only return results for tasks runs that have failed. Default is false."
            )] = None,
        **kwargs
    ) -> Union[Iterable[TaskRun], Future[Iterable[TaskRun]]]:  # noqa: E501
        """Get the graph runs that are completed for the task.  # noqa: E501.

        This function returns details for graph runs that are completed.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.get_complete_graphs(database, var_schema, name, result_limit, error_only, async_req=True)
        >>> result = future.result()
        :param database: Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases. (required)
        :type database: str
        :param var_schema: Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database. (required)
        :type var_schema: str
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param result_limit: Number of results to return, at most. Default is 1000, valid range is 1 to 10000.
        :type result_limit: int
        :param error_only: Whether to only return results for tasks runs that have failed. Default is false.
        :type error_only: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: Union[Iterable[TaskRun], Future[Iterable[TaskRun]]]
        """
        kwargs['_return_http_data_only'] = True
        return self.get_complete_graphs_with_http_info(database, var_schema,
                                                       name, result_limit,
                                                       error_only,
                                                       **kwargs)  # noqa: E501

    @validate_call
    def get_complete_graphs_with_http_info(
            self,
            database:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
            var_schema:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )],
            name: Annotated[
                str,
                Field(strict=True,
                      description="Identifier (i.e. name) for the resource.")],
            result_limit:
        Annotated[
            Optional[StrictInt],
            Field(
                description=
                "Number of results to return, at most. Default is 1000, valid range is 1 to 10000."
            )] = None,
            error_only:
        Annotated[
            Optional[StrictBool],
            Field(
                description=
                "Whether to only return results for tasks runs that have failed. Default is false."
            )] = None,
            **kwargs):  # noqa: E501
        """Get the graph runs that are completed for the task.  # noqa: E501.

        This function returns details for graph runs that are completed.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.get_complete_graphs_with_http_info(database, var_schema, name, result_limit, error_only, async_req=True)
        >>> result = future.result()
        :param database: Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases. (required)
        :type database: str
        :param var_schema: Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database. (required)
        :type var_schema: str
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param result_limit: Number of results to return, at most. Default is 1000, valid range is 1 to 10000.
        :type result_limit: int
        :param error_only: Whether to only return results for tasks runs that have failed. Default is false.
        :type error_only: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: tuple(Union[Iterable[TaskRun], Future[Iterable[TaskRun]]], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'database', 'var_schema', 'name', 'result_limit', 'error_only'
        ]
        _all_params.extend([
            'async_req', '_return_http_data_only', '_preload_content',
            '_request_timeout', '_request_auth', '_content_type', '_headers'
        ])

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise _APITypeError("Got an unexpected keyword argument '%s'"
                                    " to method get_complete_graphs" % _key)
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        if _params['database']:
            _path_params['database'] = _params['database']

        if _params['var_schema']:
            _path_params['schema'] = _params['var_schema']

        if _params['name']:
            _path_params['name'] = _params['name']

        # process the query parameters
        _query_params = []

        if _params.get('result_limit') is not None:  # noqa: E501
            _query_params.append(('resultLimit', _params['result_limit']))

        if _params.get('error_only') is not None:  # noqa: E501
            _query_params.append(('errorOnly', _params['error_only']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ExternalOAuth', 'KeyPair',
                          'SnowflakeOAuth']  # noqa: E501

        _response_types_map = {
            '200': "Iterable[TaskRun]",
            '202': "SuccessAcceptedResponse",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '404': "ErrorResponse",
            '405': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
            '503': "ErrorResponse",
            '504': "ErrorResponse",
        }

        return self.api_client.call_api(
            self._root,
            '/api/v2/databases/{database}/schemas/{schema}/tasks/{name}/complete-graphs',
            'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get(
                '_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @overload
    def get_complete_graphs_deprecated(
            self,
            database:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
            var_schema:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )],
            name: Annotated[
                str,
                Field(strict=True,
                      description="Identifier (i.e. name) for the resource.")],
            result_limit:
        Annotated[
            Optional[StrictInt],
            Field(
                description=
                "Number of results to return, at most. Default is 1000, valid range is 1 to 10000."
            )] = None,
            error_only:
        Annotated[
            Optional[StrictBool],
            Field(
                description=
                "Whether to only return results for tasks runs that have failed. Default is false."
            )] = None,
            async_req: Literal[False] = False,
            **kwargs) -> Iterable[TaskRun]:
        ...

    @overload
    def get_complete_graphs_deprecated(
            self,
            database:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
            var_schema:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )],
            name: Annotated[
                str,
                Field(strict=True,
                      description="Identifier (i.e. name) for the resource.")],
            result_limit:
        Annotated[
            Optional[StrictInt],
            Field(
                description=
                "Number of results to return, at most. Default is 1000, valid range is 1 to 10000."
            )] = None,
            error_only:
        Annotated[
            Optional[StrictBool],
            Field(
                description=
                "Whether to only return results for tasks runs that have failed. Default is false."
            )] = None,
            async_req: Literal[True] = True,
            **kwargs) -> Future[Iterable[TaskRun]]:
        ...

    @overload
    def get_complete_graphs_deprecated(
            self,
            database:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
            var_schema:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )],
            name: Annotated[
                str,
                Field(strict=True,
                      description="Identifier (i.e. name) for the resource.")],
            result_limit:
        Annotated[
            Optional[StrictInt],
            Field(
                description=
                "Number of results to return, at most. Default is 1000, valid range is 1 to 10000."
            )] = None,
            error_only:
        Annotated[
            Optional[StrictBool],
            Field(
                description=
                "Whether to only return results for tasks runs that have failed. Default is false."
            )] = None,
            async_req: bool = False,
            **kwargs) -> Union[Iterable[TaskRun], Future[Iterable[TaskRun]]]:
        ...

    @validate_call
    def get_complete_graphs_deprecated(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )],
        name: Annotated[
            str,
            Field(strict=True,
                  description="Identifier (i.e. name) for the resource.")],
        result_limit: Annotated[
            Optional[StrictInt],
            Field(
                description=
                "Number of results to return, at most. Default is 1000, valid range is 1 to 10000."
            )] = None,
        error_only: Annotated[
            Optional[StrictBool],
            Field(
                description=
                "Whether to only return results for tasks runs that have failed. Default is false."
            )] = None,
        **kwargs
    ) -> Union[Iterable[TaskRun], Future[Iterable[TaskRun]]]:  # noqa: E501
        """Get the graph runs that are completed for the task.  # noqa: E501.

        This function returns details for graph runs that are completed.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.get_complete_graphs_deprecated(database, var_schema, name, result_limit, error_only, async_req=True)
        >>> result = future.result()
        :param database: Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases. (required)
        :type database: str
        :param var_schema: Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database. (required)
        :type var_schema: str
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param result_limit: Number of results to return, at most. Default is 1000, valid range is 1 to 10000.
        :type result_limit: int
        :param error_only: Whether to only return results for tasks runs that have failed. Default is false.
        :type error_only: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: Union[Iterable[TaskRun], Future[Iterable[TaskRun]]]
        """
        kwargs['_return_http_data_only'] = True
        return self.get_complete_graphs_deprecated_with_http_info(
            database, var_schema, name, result_limit, error_only,
            **kwargs)  # noqa: E501

    @validate_call
    def get_complete_graphs_deprecated_with_http_info(
            self,
            database:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
            var_schema:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )],
            name: Annotated[
                str,
                Field(strict=True,
                      description="Identifier (i.e. name) for the resource.")],
            result_limit:
        Annotated[
            Optional[StrictInt],
            Field(
                description=
                "Number of results to return, at most. Default is 1000, valid range is 1 to 10000."
            )] = None,
            error_only:
        Annotated[
            Optional[StrictBool],
            Field(
                description=
                "Whether to only return results for tasks runs that have failed. Default is false."
            )] = None,
            **kwargs):  # noqa: E501
        """Get the graph runs that are completed for the task.  # noqa: E501.

        This function returns details for graph runs that are completed.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.get_complete_graphs_deprecated_with_http_info(database, var_schema, name, result_limit, error_only, async_req=True)
        >>> result = future.result()
        :param database: Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases. (required)
        :type database: str
        :param var_schema: Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database. (required)
        :type var_schema: str
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param result_limit: Number of results to return, at most. Default is 1000, valid range is 1 to 10000.
        :type result_limit: int
        :param error_only: Whether to only return results for tasks runs that have failed. Default is false.
        :type error_only: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: tuple(Union[Iterable[TaskRun], Future[Iterable[TaskRun]]], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'database', 'var_schema', 'name', 'result_limit', 'error_only'
        ]
        _all_params.extend([
            'async_req', '_return_http_data_only', '_preload_content',
            '_request_timeout', '_request_auth', '_content_type', '_headers'
        ])

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise _APITypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_complete_graphs_deprecated" % _key)
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        if _params['database']:
            _path_params['database'] = _params['database']

        if _params['var_schema']:
            _path_params['schema'] = _params['var_schema']

        if _params['name']:
            _path_params['name'] = _params['name']

        # process the query parameters
        _query_params = []

        if _params.get('result_limit') is not None:  # noqa: E501
            _query_params.append(('resultLimit', _params['result_limit']))

        if _params.get('error_only') is not None:  # noqa: E501
            _query_params.append(('errorOnly', _params['error_only']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ExternalOAuth', 'KeyPair',
                          'SnowflakeOAuth']  # noqa: E501

        _response_types_map = {
            '200': "Iterable[TaskRun]",
            '202': "SuccessAcceptedResponse",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '404': "ErrorResponse",
            '405': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
            '503': "ErrorResponse",
            '504': "ErrorResponse",
        }

        return self.api_client.call_api(
            self._root,
            '/api/v2/databases/{database}/schemas/{schema}/tasks/{name}/complete_graphs',
            'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get(
                '_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @overload
    def get_current_graphs(
            self,
            database:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
            var_schema:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )],
            name: Annotated[
                str,
                Field(strict=True,
                      description="Identifier (i.e. name) for the resource.")],
            result_limit: Optional[StrictInt] = None,
            async_req: Literal[False] = False,
            **kwargs) -> Iterable[TaskRun]:
        ...

    @overload
    def get_current_graphs(
            self,
            database:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
            var_schema:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )],
            name: Annotated[
                str,
                Field(strict=True,
                      description="Identifier (i.e. name) for the resource.")],
            result_limit: Optional[StrictInt] = None,
            async_req: Literal[True] = True,
            **kwargs) -> Future[Iterable[TaskRun]]:
        ...

    @overload
    def get_current_graphs(
            self,
            database:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
            var_schema:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )],
            name: Annotated[
                str,
                Field(strict=True,
                      description="Identifier (i.e. name) for the resource.")],
            result_limit: Optional[StrictInt] = None,
            async_req: bool = False,
            **kwargs) -> Union[Iterable[TaskRun], Future[Iterable[TaskRun]]]:
        ...

    @validate_call
    def get_current_graphs(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )],
        name: Annotated[
            str,
            Field(strict=True,
                  description="Identifier (i.e. name) for the resource.")],
        result_limit: Optional[StrictInt] = None,
        **kwargs
    ) -> Union[Iterable[TaskRun], Future[Iterable[TaskRun]]]:  # noqa: E501
        """Get the graph runs that are executing or scheduled for the task for the next 8 days.  # noqa: E501.

        This function returns details for graph runs that are currently executing or are next scheduled to run within the next 8 days.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.get_current_graphs(database, var_schema, name, result_limit, async_req=True)
        >>> result = future.result()
        :param database: Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases. (required)
        :type database: str
        :param var_schema: Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database. (required)
        :type var_schema: str
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param result_limit:
        :type result_limit: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: Union[Iterable[TaskRun], Future[Iterable[TaskRun]]]
        """
        kwargs['_return_http_data_only'] = True
        return self.get_current_graphs_with_http_info(database, var_schema,
                                                      name, result_limit,
                                                      **kwargs)  # noqa: E501

    @validate_call
    def get_current_graphs_with_http_info(
            self,
            database:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
            var_schema:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )],
            name: Annotated[
                str,
                Field(strict=True,
                      description="Identifier (i.e. name) for the resource.")],
            result_limit: Optional[StrictInt] = None,
            **kwargs):  # noqa: E501
        """Get the graph runs that are executing or scheduled for the task for the next 8 days.  # noqa: E501.

        This function returns details for graph runs that are currently executing or are next scheduled to run within the next 8 days.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.get_current_graphs_with_http_info(database, var_schema, name, result_limit, async_req=True)
        >>> result = future.result()
        :param database: Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases. (required)
        :type database: str
        :param var_schema: Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database. (required)
        :type var_schema: str
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param result_limit:
        :type result_limit: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: tuple(Union[Iterable[TaskRun], Future[Iterable[TaskRun]]], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ['database', 'var_schema', 'name', 'result_limit']
        _all_params.extend([
            'async_req', '_return_http_data_only', '_preload_content',
            '_request_timeout', '_request_auth', '_content_type', '_headers'
        ])

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise _APITypeError("Got an unexpected keyword argument '%s'"
                                    " to method get_current_graphs" % _key)
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        if _params['database']:
            _path_params['database'] = _params['database']

        if _params['var_schema']:
            _path_params['schema'] = _params['var_schema']

        if _params['name']:
            _path_params['name'] = _params['name']

        # process the query parameters
        _query_params = []

        if _params.get('result_limit') is not None:  # noqa: E501
            _query_params.append(('resultLimit', _params['result_limit']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ExternalOAuth', 'KeyPair',
                          'SnowflakeOAuth']  # noqa: E501

        _response_types_map = {
            '200': "Iterable[TaskRun]",
            '202': "SuccessAcceptedResponse",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '404': "ErrorResponse",
            '405': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
            '503': "ErrorResponse",
            '504': "ErrorResponse",
        }

        return self.api_client.call_api(
            self._root,
            '/api/v2/databases/{database}/schemas/{schema}/tasks/{name}/current-graphs',
            'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get(
                '_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @overload
    def get_current_graphs_deprecated(
            self,
            database:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
            var_schema:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )],
            name: Annotated[
                str,
                Field(strict=True,
                      description="Identifier (i.e. name) for the resource.")],
            result_limit: Optional[StrictInt] = None,
            async_req: Literal[False] = False,
            **kwargs) -> Iterable[TaskRun]:
        ...

    @overload
    def get_current_graphs_deprecated(
            self,
            database:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
            var_schema:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )],
            name: Annotated[
                str,
                Field(strict=True,
                      description="Identifier (i.e. name) for the resource.")],
            result_limit: Optional[StrictInt] = None,
            async_req: Literal[True] = True,
            **kwargs) -> Future[Iterable[TaskRun]]:
        ...

    @overload
    def get_current_graphs_deprecated(
            self,
            database:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
            var_schema:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )],
            name: Annotated[
                str,
                Field(strict=True,
                      description="Identifier (i.e. name) for the resource.")],
            result_limit: Optional[StrictInt] = None,
            async_req: bool = False,
            **kwargs) -> Union[Iterable[TaskRun], Future[Iterable[TaskRun]]]:
        ...

    @validate_call
    def get_current_graphs_deprecated(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )],
        name: Annotated[
            str,
            Field(strict=True,
                  description="Identifier (i.e. name) for the resource.")],
        result_limit: Optional[StrictInt] = None,
        **kwargs
    ) -> Union[Iterable[TaskRun], Future[Iterable[TaskRun]]]:  # noqa: E501
        """Get the graph runs that are executing or scheduled for the task for the next 8 days.  # noqa: E501.

        This function returns details for graph runs that are currently executing or are next scheduled to run within the next 8 days.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.get_current_graphs_deprecated(database, var_schema, name, result_limit, async_req=True)
        >>> result = future.result()
        :param database: Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases. (required)
        :type database: str
        :param var_schema: Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database. (required)
        :type var_schema: str
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param result_limit:
        :type result_limit: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: Union[Iterable[TaskRun], Future[Iterable[TaskRun]]]
        """
        kwargs['_return_http_data_only'] = True
        return self.get_current_graphs_deprecated_with_http_info(
            database, var_schema, name, result_limit, **kwargs)  # noqa: E501

    @validate_call
    def get_current_graphs_deprecated_with_http_info(
            self,
            database:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
            var_schema:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )],
            name: Annotated[
                str,
                Field(strict=True,
                      description="Identifier (i.e. name) for the resource.")],
            result_limit: Optional[StrictInt] = None,
            **kwargs):  # noqa: E501
        """Get the graph runs that are executing or scheduled for the task for the next 8 days.  # noqa: E501.

        This function returns details for graph runs that are currently executing or are next scheduled to run within the next 8 days.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.get_current_graphs_deprecated_with_http_info(database, var_schema, name, result_limit, async_req=True)
        >>> result = future.result()
        :param database: Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases. (required)
        :type database: str
        :param var_schema: Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database. (required)
        :type var_schema: str
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param result_limit:
        :type result_limit: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: tuple(Union[Iterable[TaskRun], Future[Iterable[TaskRun]]], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ['database', 'var_schema', 'name', 'result_limit']
        _all_params.extend([
            'async_req', '_return_http_data_only', '_preload_content',
            '_request_timeout', '_request_auth', '_content_type', '_headers'
        ])

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise _APITypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_current_graphs_deprecated" % _key)
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        if _params['database']:
            _path_params['database'] = _params['database']

        if _params['var_schema']:
            _path_params['schema'] = _params['var_schema']

        if _params['name']:
            _path_params['name'] = _params['name']

        # process the query parameters
        _query_params = []

        if _params.get('result_limit') is not None:  # noqa: E501
            _query_params.append(('resultLimit', _params['result_limit']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ExternalOAuth', 'KeyPair',
                          'SnowflakeOAuth']  # noqa: E501

        _response_types_map = {
            '200': "Iterable[TaskRun]",
            '202': "SuccessAcceptedResponse",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '404': "ErrorResponse",
            '405': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
            '503': "ErrorResponse",
            '504': "ErrorResponse",
        }

        return self.api_client.call_api(
            self._root,
            '/api/v2/databases/{database}/schemas/{schema}/tasks/{name}/current_graphs',
            'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get(
                '_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @overload
    def list_tasks(
            self,
            database:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
            var_schema:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )],
            root_only:
        Annotated[
            Optional[StrictBool],
            Field(
                description=
                "Query parameter to filter the command output to return only root resources (resources with no predecessors)."
            )] = None,
            like:
        Annotated[
            Optional[StrictStr],
            Field(
                description=
                "Query parameter to filter the command output by resource name. Uses case-insensitive pattern matching, with support for SQL wildcard characters."
            )] = None,
            starts_with:
        Annotated[
            Optional[StrictStr],
            Field(
                description=
                "Query parameter to filter the command output based on the string of characters that appear at the beginning of the object name. Uses case-sensitive pattern matching."
            )] = None,
            show_limit:
        Annotated[
            Optional[Annotated[int, Field(le=10000, strict=True, ge=1)]],
            Field(
                description=
                "Query parameter to limit the maximum number of rows returned by a command."
            )] = None,
            from_name:
        Annotated[
            Optional[StrictStr],
            Field(
                description=
                "Query parameter to enable fetching rows only following the first row whose object name matches the specified string. Case-sensitive and does not have to be the full name."
            )] = None,
            async_req: Literal[False] = False,
            **kwargs) -> Iterable[Task]:
        ...

    @overload
    def list_tasks(
            self,
            database:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
            var_schema:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )],
            root_only:
        Annotated[
            Optional[StrictBool],
            Field(
                description=
                "Query parameter to filter the command output to return only root resources (resources with no predecessors)."
            )] = None,
            like:
        Annotated[
            Optional[StrictStr],
            Field(
                description=
                "Query parameter to filter the command output by resource name. Uses case-insensitive pattern matching, with support for SQL wildcard characters."
            )] = None,
            starts_with:
        Annotated[
            Optional[StrictStr],
            Field(
                description=
                "Query parameter to filter the command output based on the string of characters that appear at the beginning of the object name. Uses case-sensitive pattern matching."
            )] = None,
            show_limit:
        Annotated[
            Optional[Annotated[int, Field(le=10000, strict=True, ge=1)]],
            Field(
                description=
                "Query parameter to limit the maximum number of rows returned by a command."
            )] = None,
            from_name:
        Annotated[
            Optional[StrictStr],
            Field(
                description=
                "Query parameter to enable fetching rows only following the first row whose object name matches the specified string. Case-sensitive and does not have to be the full name."
            )] = None,
            async_req: Literal[True] = True,
            **kwargs) -> Future[Iterable[Task]]:
        ...

    @overload
    def list_tasks(
            self,
            database:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
            var_schema:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )],
            root_only:
        Annotated[
            Optional[StrictBool],
            Field(
                description=
                "Query parameter to filter the command output to return only root resources (resources with no predecessors)."
            )] = None,
            like:
        Annotated[
            Optional[StrictStr],
            Field(
                description=
                "Query parameter to filter the command output by resource name. Uses case-insensitive pattern matching, with support for SQL wildcard characters."
            )] = None,
            starts_with:
        Annotated[
            Optional[StrictStr],
            Field(
                description=
                "Query parameter to filter the command output based on the string of characters that appear at the beginning of the object name. Uses case-sensitive pattern matching."
            )] = None,
            show_limit:
        Annotated[
            Optional[Annotated[int, Field(le=10000, strict=True, ge=1)]],
            Field(
                description=
                "Query parameter to limit the maximum number of rows returned by a command."
            )] = None,
            from_name:
        Annotated[
            Optional[StrictStr],
            Field(
                description=
                "Query parameter to enable fetching rows only following the first row whose object name matches the specified string. Case-sensitive and does not have to be the full name."
            )] = None,
            async_req: bool = False,
            **kwargs) -> Union[Iterable[Task], Future[Iterable[Task]]]:
        ...

    @validate_call
    def list_tasks(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )],
        root_only: Annotated[
            Optional[StrictBool],
            Field(
                description=
                "Query parameter to filter the command output to return only root resources (resources with no predecessors)."
            )] = None,
        like: Annotated[
            Optional[StrictStr],
            Field(
                description=
                "Query parameter to filter the command output by resource name. Uses case-insensitive pattern matching, with support for SQL wildcard characters."
            )] = None,
        starts_with: Annotated[
            Optional[StrictStr],
            Field(
                description=
                "Query parameter to filter the command output based on the string of characters that appear at the beginning of the object name. Uses case-sensitive pattern matching."
            )] = None,
        show_limit: Annotated[
            Optional[Annotated[int, Field(le=10000, strict=True, ge=1)]],
            Field(
                description=
                "Query parameter to limit the maximum number of rows returned by a command."
            )] = None,
        from_name: Annotated[
            Optional[StrictStr],
            Field(
                description=
                "Query parameter to enable fetching rows only following the first row whose object name matches the specified string. Case-sensitive and does not have to be the full name."
            )] = None,
        **kwargs
    ) -> Union[Iterable[Task], Future[Iterable[Task]]]:  # noqa: E501
        """List tasks  # noqa: E501.

        Lists tasks under the database and schema, with show options as query parameters.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.list_tasks(database, var_schema, root_only, like, starts_with, show_limit, from_name, async_req=True)
        >>> result = future.result()
        :param database: Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases. (required)
        :type database: str
        :param var_schema: Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database. (required)
        :type var_schema: str
        :param root_only: Query parameter to filter the command output to return only root resources (resources with no predecessors).
        :type root_only: bool
        :param like: Query parameter to filter the command output by resource name. Uses case-insensitive pattern matching, with support for SQL wildcard characters.
        :type like: str
        :param starts_with: Query parameter to filter the command output based on the string of characters that appear at the beginning of the object name. Uses case-sensitive pattern matching.
        :type starts_with: str
        :param show_limit: Query parameter to limit the maximum number of rows returned by a command.
        :type show_limit: int
        :param from_name: Query parameter to enable fetching rows only following the first row whose object name matches the specified string. Case-sensitive and does not have to be the full name.
        :type from_name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: Union[Iterable[Task], Future[Iterable[Task]]]
        """
        kwargs['_return_http_data_only'] = True
        return self.list_tasks_with_http_info(database, var_schema, root_only,
                                              like, starts_with, show_limit,
                                              from_name,
                                              **kwargs)  # noqa: E501

    @validate_call
    def list_tasks_with_http_info(
            self,
            database:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
            var_schema:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )],
            root_only:
        Annotated[
            Optional[StrictBool],
            Field(
                description=
                "Query parameter to filter the command output to return only root resources (resources with no predecessors)."
            )] = None,
            like:
        Annotated[
            Optional[StrictStr],
            Field(
                description=
                "Query parameter to filter the command output by resource name. Uses case-insensitive pattern matching, with support for SQL wildcard characters."
            )] = None,
            starts_with:
        Annotated[
            Optional[StrictStr],
            Field(
                description=
                "Query parameter to filter the command output based on the string of characters that appear at the beginning of the object name. Uses case-sensitive pattern matching."
            )] = None,
            show_limit:
        Annotated[
            Optional[Annotated[int, Field(le=10000, strict=True, ge=1)]],
            Field(
                description=
                "Query parameter to limit the maximum number of rows returned by a command."
            )] = None,
            from_name:
        Annotated[
            Optional[StrictStr],
            Field(
                description=
                "Query parameter to enable fetching rows only following the first row whose object name matches the specified string. Case-sensitive and does not have to be the full name."
            )] = None,
            **kwargs):  # noqa: E501
        """List tasks  # noqa: E501.

        Lists tasks under the database and schema, with show options as query parameters.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.list_tasks_with_http_info(database, var_schema, root_only, like, starts_with, show_limit, from_name, async_req=True)
        >>> result = future.result()
        :param database: Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases. (required)
        :type database: str
        :param var_schema: Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database. (required)
        :type var_schema: str
        :param root_only: Query parameter to filter the command output to return only root resources (resources with no predecessors).
        :type root_only: bool
        :param like: Query parameter to filter the command output by resource name. Uses case-insensitive pattern matching, with support for SQL wildcard characters.
        :type like: str
        :param starts_with: Query parameter to filter the command output based on the string of characters that appear at the beginning of the object name. Uses case-sensitive pattern matching.
        :type starts_with: str
        :param show_limit: Query parameter to limit the maximum number of rows returned by a command.
        :type show_limit: int
        :param from_name: Query parameter to enable fetching rows only following the first row whose object name matches the specified string. Case-sensitive and does not have to be the full name.
        :type from_name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: tuple(Union[Iterable[Task], Future[Iterable[Task]]], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'database', 'var_schema', 'root_only', 'like', 'starts_with',
            'show_limit', 'from_name'
        ]
        _all_params.extend([
            'async_req', '_return_http_data_only', '_preload_content',
            '_request_timeout', '_request_auth', '_content_type', '_headers'
        ])

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise _APITypeError("Got an unexpected keyword argument '%s'"
                                    " to method list_tasks" % _key)
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        if _params['database']:
            _path_params['database'] = _params['database']

        if _params['var_schema']:
            _path_params['schema'] = _params['var_schema']

        # process the query parameters
        _query_params = []

        if _params.get('root_only') is not None:  # noqa: E501
            _query_params.append(('rootOnly', _params['root_only']))

        if _params.get('like') is not None:  # noqa: E501
            _query_params.append(('like', _params['like']))

        if _params.get('starts_with') is not None:  # noqa: E501
            _query_params.append(('startsWith', _params['starts_with']))

        if _params.get('show_limit') is not None:  # noqa: E501
            _query_params.append(('showLimit', _params['show_limit']))

        if _params.get('from_name') is not None:  # noqa: E501
            _query_params.append(('fromName', _params['from_name']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ExternalOAuth', 'KeyPair',
                          'SnowflakeOAuth']  # noqa: E501

        _response_types_map = {
            '200': "Iterable[Task]",
            '202': "SuccessAcceptedResponse",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '404': "ErrorResponse",
            '405': "ErrorResponse",
            '408': "ErrorResponse",
            '409': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
            '503': "ErrorResponse",
            '504': "ErrorResponse",
        }

        return self.api_client.call_api(
            self._root,
            '/api/v2/databases/{database}/schemas/{schema}/tasks',
            'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get(
                '_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @overload
    def resume_task(
            self,
            database:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
            var_schema:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )],
            name: Annotated[
                str,
                Field(strict=True,
                      description="Identifier (i.e. name) for the resource.")],
            async_req: Literal[False] = False,
            **kwargs) -> SuccessResponse:
        ...

    @overload
    def resume_task(
            self,
            database:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
            var_schema:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )],
            name: Annotated[
                str,
                Field(strict=True,
                      description="Identifier (i.e. name) for the resource.")],
            async_req: Literal[True] = True,
            **kwargs) -> Future[SuccessResponse]:
        ...

    @overload
    def resume_task(
            self,
            database:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
            var_schema:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )],
            name: Annotated[
                str,
                Field(strict=True,
                      description="Identifier (i.e. name) for the resource.")],
            async_req: bool = False,
            **kwargs) -> Union[SuccessResponse, Future[SuccessResponse]]:
        ...

    @validate_call
    def resume_task(self, database: Annotated[
        str,
        Field(
            strict=True,
            description=
            "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
        )], var_schema: Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )], name: Annotated[
                str,
                Field(strict=True,
                      description="Identifier (i.e. name) for the resource.")],
                    **kwargs) -> Union[SuccessResponse,
                                       Future[SuccessResponse]]:  # noqa: E501
        """Resume a suspended task.  # noqa: E501.

        Resumes a suspended task object. This is equivalento an ALTER TASK ... RESUME.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.resume_task(database, var_schema, name, async_req=True)
        >>> result = future.result()
        :param database: Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases. (required)
        :type database: str
        :param var_schema: Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database. (required)
        :type var_schema: str
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: Union[SuccessResponse, Future[SuccessResponse]]
        """
        kwargs['_return_http_data_only'] = True
        return self.resume_task_with_http_info(database, var_schema, name,
                                               **kwargs)  # noqa: E501

    @validate_call
    def resume_task_with_http_info(self, database: Annotated[
        str,
        Field(
            strict=True,
            description=
            "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
        )], var_schema: Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )], name: Annotated[
                str,
                Field(strict=True,
                      description="Identifier (i.e. name) for the resource.")],
                                   **kwargs):  # noqa: E501
        """Resume a suspended task.  # noqa: E501.

        Resumes a suspended task object. This is equivalento an ALTER TASK ... RESUME.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.resume_task_with_http_info(database, var_schema, name, async_req=True)
        >>> result = future.result()
        :param database: Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases. (required)
        :type database: str
        :param var_schema: Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database. (required)
        :type var_schema: str
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: tuple(Union[SuccessResponse, Future[SuccessResponse]], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ['database', 'var_schema', 'name']
        _all_params.extend([
            'async_req', '_return_http_data_only', '_preload_content',
            '_request_timeout', '_request_auth', '_content_type', '_headers'
        ])

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise _APITypeError("Got an unexpected keyword argument '%s'"
                                    " to method resume_task" % _key)
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        if _params['database']:
            _path_params['database'] = _params['database']

        if _params['var_schema']:
            _path_params['schema'] = _params['var_schema']

        if _params['name']:
            _path_params['name'] = _params['name']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ExternalOAuth', 'KeyPair',
                          'SnowflakeOAuth']  # noqa: E501

        _response_types_map = {
            '200': "SuccessResponse",
            '202': "SuccessAcceptedResponse",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '404': "ErrorResponse",
            '405': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
            '503': "ErrorResponse",
            '504': "ErrorResponse",
        }

        return self.api_client.call_api(
            self._root,
            '/api/v2/databases/{database}/schemas/{schema}/tasks/{name}:resume',
            'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get(
                '_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @overload
    def suspend_task(
            self,
            database:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
            var_schema:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )],
            name: Annotated[
                str,
                Field(strict=True,
                      description="Identifier (i.e. name) for the resource.")],
            async_req: Literal[False] = False,
            **kwargs) -> SuccessResponse:
        ...

    @overload
    def suspend_task(
            self,
            database:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
            var_schema:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )],
            name: Annotated[
                str,
                Field(strict=True,
                      description="Identifier (i.e. name) for the resource.")],
            async_req: Literal[True] = True,
            **kwargs) -> Future[SuccessResponse]:
        ...

    @overload
    def suspend_task(
            self,
            database:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
            var_schema:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )],
            name: Annotated[
                str,
                Field(strict=True,
                      description="Identifier (i.e. name) for the resource.")],
            async_req: bool = False,
            **kwargs) -> Union[SuccessResponse, Future[SuccessResponse]]:
        ...

    @validate_call
    def suspend_task(self, database: Annotated[
        str,
        Field(
            strict=True,
            description=
            "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
        )], var_schema: Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )], name: Annotated[
                str,
                Field(strict=True,
                      description="Identifier (i.e. name) for the resource.")],
                     **kwargs) -> Union[SuccessResponse,
                                        Future[SuccessResponse]]:  # noqa: E501
        """Suspend a running task.  # noqa: E501.

        Suspends a running task. This is equivalent to an ALTER TASK ... SUSPEND.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.suspend_task(database, var_schema, name, async_req=True)
        >>> result = future.result()
        :param database: Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases. (required)
        :type database: str
        :param var_schema: Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database. (required)
        :type var_schema: str
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: Union[SuccessResponse, Future[SuccessResponse]]
        """
        kwargs['_return_http_data_only'] = True
        return self.suspend_task_with_http_info(database, var_schema, name,
                                                **kwargs)  # noqa: E501

    @validate_call
    def suspend_task_with_http_info(self, database: Annotated[
        str,
        Field(
            strict=True,
            description=
            "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
        )], var_schema: Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )], name: Annotated[
                str,
                Field(strict=True,
                      description="Identifier (i.e. name) for the resource.")],
                                    **kwargs):  # noqa: E501
        """Suspend a running task.  # noqa: E501.

        Suspends a running task. This is equivalent to an ALTER TASK ... SUSPEND.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.suspend_task_with_http_info(database, var_schema, name, async_req=True)
        >>> result = future.result()
        :param database: Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases. (required)
        :type database: str
        :param var_schema: Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database. (required)
        :type var_schema: str
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: tuple(Union[SuccessResponse, Future[SuccessResponse]], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ['database', 'var_schema', 'name']
        _all_params.extend([
            'async_req', '_return_http_data_only', '_preload_content',
            '_request_timeout', '_request_auth', '_content_type', '_headers'
        ])

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise _APITypeError("Got an unexpected keyword argument '%s'"
                                    " to method suspend_task" % _key)
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        if _params['database']:
            _path_params['database'] = _params['database']

        if _params['var_schema']:
            _path_params['schema'] = _params['var_schema']

        if _params['name']:
            _path_params['name'] = _params['name']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ExternalOAuth', 'KeyPair',
                          'SnowflakeOAuth']  # noqa: E501

        _response_types_map = {
            '200': "SuccessResponse",
            '202': "SuccessAcceptedResponse",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '404': "ErrorResponse",
            '405': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
            '503': "ErrorResponse",
            '504': "ErrorResponse",
        }

        return self.api_client.call_api(
            self._root,
            '/api/v2/databases/{database}/schemas/{schema}/tasks/{name}:suspend',
            'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get(
                '_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @overload
    def delete_task(
            self,
            database:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
            var_schema:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )],
            name: Annotated[
                str,
                Field(strict=True,
                      description="Identifier (i.e. name) for the resource.")],
            if_exists:
        Annotated[
            Optional[StrictBool],
            Field(
                description=
                "Query parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist."
            )] = None,
            async_req: Literal[False] = False,
            **kwargs) -> SuccessResponse:
        ...

    @overload
    def delete_task(
            self,
            database:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
            var_schema:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )],
            name: Annotated[
                str,
                Field(strict=True,
                      description="Identifier (i.e. name) for the resource.")],
            if_exists:
        Annotated[
            Optional[StrictBool],
            Field(
                description=
                "Query parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist."
            )] = None,
            async_req: Literal[True] = True,
            **kwargs) -> Future[SuccessResponse]:
        ...

    @overload
    def delete_task(
            self,
            database:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
            var_schema:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )],
            name: Annotated[
                str,
                Field(strict=True,
                      description="Identifier (i.e. name) for the resource.")],
            if_exists:
        Annotated[
            Optional[StrictBool],
            Field(
                description=
                "Query parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist."
            )] = None,
            async_req: bool = False,
            **kwargs) -> Union[SuccessResponse, Future[SuccessResponse]]:
        ...

    @validate_call
    def delete_task(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )],
        name: Annotated[
            str,
            Field(strict=True,
                  description="Identifier (i.e. name) for the resource.")],
        if_exists: Annotated[
            Optional[StrictBool],
            Field(
                description=
                "Query parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist."
            )] = None,
        **kwargs
    ) -> Union[SuccessResponse, Future[SuccessResponse]]:  # noqa: E501
        """Delete a task  # noqa: E501.

        Delete a task with the task name. If ifExists is used, the operation will succeed even if the object does not exist. Otherwise, there will be a failure if the drop is unsuccessful.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.delete_task(database, var_schema, name, if_exists, async_req=True)
        >>> result = future.result()
        :param database: Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases. (required)
        :type database: str
        :param var_schema: Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database. (required)
        :type var_schema: str
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param if_exists: Query parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist.
        :type if_exists: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: Union[SuccessResponse, Future[SuccessResponse]]
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_task_with_http_info(database, var_schema, name,
                                               if_exists,
                                               **kwargs)  # noqa: E501

    @validate_call
    def delete_task_with_http_info(
            self,
            database:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
            var_schema:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )],
            name: Annotated[
                str,
                Field(strict=True,
                      description="Identifier (i.e. name) for the resource.")],
            if_exists:
        Annotated[
            Optional[StrictBool],
            Field(
                description=
                "Query parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist."
            )] = None,
            **kwargs):  # noqa: E501
        """Delete a task  # noqa: E501.

        Delete a task with the task name. If ifExists is used, the operation will succeed even if the object does not exist. Otherwise, there will be a failure if the drop is unsuccessful.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.delete_task_with_http_info(database, var_schema, name, if_exists, async_req=True)
        >>> result = future.result()
        :param database: Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases. (required)
        :type database: str
        :param var_schema: Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database. (required)
        :type var_schema: str
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param if_exists: Query parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist.
        :type if_exists: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: tuple(Union[SuccessResponse, Future[SuccessResponse]], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ['database', 'var_schema', 'name', 'if_exists']
        _all_params.extend([
            'async_req', '_return_http_data_only', '_preload_content',
            '_request_timeout', '_request_auth', '_content_type', '_headers'
        ])

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise _APITypeError("Got an unexpected keyword argument '%s'"
                                    " to method delete_task" % _key)
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        if _params['database']:
            _path_params['database'] = _params['database']

        if _params['var_schema']:
            _path_params['schema'] = _params['var_schema']

        if _params['name']:
            _path_params['name'] = _params['name']

        # process the query parameters
        _query_params = []

        if _params.get('if_exists') is not None:  # noqa: E501
            _query_params.append(('ifExists', _params['if_exists']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ExternalOAuth', 'KeyPair',
                          'SnowflakeOAuth']  # noqa: E501

        _response_types_map = {
            '200': "SuccessResponse",
            '202': "SuccessAcceptedResponse",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '404': "ErrorResponse",
            '405': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
            '503': "ErrorResponse",
            '504': "ErrorResponse",
        }

        return self.api_client.call_api(
            self._root,
            '/api/v2/databases/{database}/schemas/{schema}/tasks/{name}',
            'DELETE',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get(
                '_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
