# coding: utf-8
"""
    Snowflake User Defined Function API.

    The Snowflake User Defined Function API is a REST API that you can use to access, update, and perform certain actions on User Defined Function resource in a Snowflake database.  # noqa: E501

    The version of the OpenAPI document: 0.0.1
    Contact: support@snowflake.com
    Generated by: https://openapi-generator.tech

    Do not edit this file manually.
"""

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

import snowflake.core.user_defined_function._generated.models
from snowflake.core.user_defined_function._generated.models import *

from typing import Union

from snowflake.core.user_defined_function._generated.models.function_language import FunctionLanguage

from importlib import import_module

from pydantic import ConfigDict, StrictStr

from typing import Any, ClassVar, Dict, List, Optional, Union


class BaseLanguage(FunctionLanguage):
    """A model object representing the BaseLanguage resource.

    Constructs an object of type BaseLanguage with the provided properties.

    Parameters
    __________
    packages : List[str]
        Packages to include with the function/procedure
    handler : str
        Fully qualified method name including the package and the class

    called_on_null_input : bool, optional
        Decide if the function/procedure can receive null input

    is_volatile : bool, optional
         Specifies the behavior of the UDF when returning results. This Field is deprecated for Procedure.

                    If true, UDF might return different values for different rows, even for the same input.
                    This field is deprecated for Procedure.

                    If false, UDF assumes that the function, when called with the same inputs, will always return the same result.
                    This guarantee is not checked. Specifying IMMUTABLE for a UDF that returns different values for the same input will result in undefined behavior.

    imports : List[str], optional
        List of imports
    """

    packages: List[StrictStr]

    imports: Optional[List[StrictStr]] = None

    handler: StrictStr

    __properties = ["language", "called_on_null_input", "is_volatile"]

    class Config:
        populate_by_name = True
        validate_assignment = True

    # JSON field name that stores the object type
    __discriminator_property_name: ClassVar[str] = 'language'

    # discriminator mappings
    __discriminator_value_class_map: ClassVar[Dict[str, str]] = {
        'JAVA': 'JavaFunction',
        'JAVASCRIPT': 'JavaScriptFunction',
        'PYTHON': 'PythonFunction',
        'SCALA': 'ScalaFunction',
        'SQL': 'SQLFunction'
    }

    @classmethod
    def get_discriminator_value(cls, obj: dict[str, Any]) -> Optional[str]:
        """Returns the discriminator value (object type) of the data."""
        discriminator_value = obj[cls.__discriminator_property_name]
        if discriminator_value:
            return cls.__discriminator_value_class_map.get(discriminator_value)
        else:
            return None

    __discriminator_value_to_type: ClassVar[Dict[str, str]] = {
        'JavaFunction': 'JAVA',
        'JavaScriptFunction': 'JAVASCRIPT',
        'PythonFunction': 'PYTHON',
        'ScalaFunction': 'SCALA',
        'SQLFunction': 'SQL',
    }

    @classmethod
    def get_child_model_discriminator_value(cls, child_model: str) -> str:
        return cls.__discriminator_value_to_type[child_model]

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(
            cls, json_str: str
    ) -> Union[JavaFunction, PythonFunction, ScalaFunction]:
        """Create an instance of BaseLanguage from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""

        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = dict(
            self._iter(to_dict=True,
                       by_alias=True,
                       exclude=exclude_properties,
                       exclude_none=True))

        _dict[
            'language'] = FunctionLanguage.get_child_model_discriminator_value(
                'BaseLanguage')

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(
            cls,
            obj: dict) -> Union[JavaFunction, PythonFunction, ScalaFunction]:
        """Create an instance of BaseLanguage from a dict."""

        # look up the object type based on discriminator mapping
        object_type = cls.get_discriminator_value(obj)
        if object_type:
            klass = getattr(
                snowflake.core.user_defined_function._generated.models,
                object_type)
            return klass.from_dict(obj)
        else:
            raise ValueError(
                "BaseLanguage failed to lookup discriminator value from " +
                json.dumps(obj) + ". Discriminator property name: " +
                cls.__discriminator_property_name + ", mapping: " +
                json.dumps(cls.__discriminator_value_class_map))


from typing import Optional, List, Dict

from snowflake.core.user_defined_function._generated.models.function_language import FunctionLanguage


class BaseLanguageModel(FunctionLanguage):

    def __init__(
        self,
        packages: List[str],
        handler: str,
        # optional properties
        called_on_null_input: Optional[bool] = None,
        is_volatile: Optional[bool] = None,
        imports: Optional[List[str]] = None,
    ):
        """A model object representing the BaseLanguage resource.

        Constructs an object of type BaseLanguage with the provided properties.

        Parameters
        __________
        packages : List[str]
            Packages to include with the function/procedure
        handler : str
            Fully qualified method name including the package and the class

        called_on_null_input : bool, optional
            Decide if the function/procedure can receive null input

        is_volatile : bool, optional
             Specifies the behavior of the UDF when returning results. This Field is deprecated for Procedure.

            If true, UDF might return different values for different rows, even for the same input.
            This field is deprecated for Procedure.

            If false, UDF assumes that the function, when called with the same inputs, will always return the same result.
            This guarantee is not checked. Specifying IMMUTABLE for a UDF that returns different values for the same input will result in undefined behavior.

        imports : List[str], optional
            List of imports
        """

        super().__init__(
            called_on_null_input=called_on_null_input,
            is_volatile=is_volatile,
        )
        self.packages = packages
        self.imports = imports
        self.handler = handler

    __properties = ["language", "called_on_null_input", "is_volatile"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return BaseLanguage(
            called_on_null_input=self.called_on_null_input,
            is_volatile=self.is_volatile,
            packages=self.packages,
            imports=self.imports,
            handler=self.handler,
        )

    @classmethod
    def _from_model(cls, model) -> BaseLanguageModel:
        return model.__class__._model_class._from_model(model)

    def to_dict(self):
        """Creates a dictionary of the properties from a BaseLanguage.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the BaseLanguage object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(
        cls, obj: dict
    ) -> Union[JavaFunctionModel, PythonFunctionModel, ScalaFunctionModel]:
        """Creates an instance of BaseLanguage from a dict.

        This method constructs a BaseLanguage object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        BaseLanguage
            A BaseLanguage object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(BaseLanguage.from_dict(obj))


BaseLanguage._model_class = BaseLanguageModel
