# coding: utf-8
"""
    Snowflake User Defined Function API.

    The Snowflake User Defined Function API is a REST API that you can use to access, update, and perform certain actions on User Defined Function resource in a Snowflake database.  # noqa: E501

    The version of the OpenAPI document: 0.0.1
    Contact: support@snowflake.com
    Generated by: https://openapi-generator.tech

    Do not edit this file manually.
"""

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from typing import Union

from pydantic import BaseModel, ConfigDict, Field, StrictStr

from typing import Any, ClassVar, Dict, List, Optional


class SuccessAcceptedResponse(BaseModel):
    """A model object representing the SuccessAcceptedResponse resource.

    Constructs an object of type SuccessAcceptedResponse with the provided properties.

    Parameters
    __________
    code : str, optional
        Message code returned by the server.
    message : str, optional
        Message returned by the server
    result_handler : str, optional
        Opaque result ID used for checking for request completion through one or more subsequent completion check operations.
    """

    code: Optional[StrictStr] = None

    message: Optional[StrictStr] = None

    result_handler: Optional[StrictStr] = Field(default=None,
                                                alias="resultHandler")

    __properties = ["code", "message", "resultHandler"]

    class Config:
        populate_by_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> SuccessAcceptedResponse:
        """Create an instance of SuccessAcceptedResponse from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""

        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = dict(
            self._iter(to_dict=True,
                       by_alias=True,
                       exclude=exclude_properties,
                       exclude_none=True))

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> SuccessAcceptedResponse:
        """Create an instance of SuccessAcceptedResponse from a dict."""

        if obj is None:
            return None

        if type(obj) is not dict:
            return SuccessAcceptedResponse.parse_obj(obj)

        _obj = SuccessAcceptedResponse.parse_obj({
            "code":
            obj.get("code"),
            "message":
            obj.get("message"),
            "result_handler":
            obj.get("resultHandler"),
        })

        return _obj


from typing import Optional, List, Dict


class SuccessAcceptedResponseModel():

    def __init__(
        self,  # optional properties
        code: Optional[str] = None,
        message: Optional[str] = None,
        result_handler: Optional[str] = None,
    ):
        """A model object representing the SuccessAcceptedResponse resource.

        Constructs an object of type SuccessAcceptedResponse with the provided properties.

        Parameters
        __________
        code : str, optional
            Message code returned by the server.
        message : str, optional
            Message returned by the server
        result_handler : str, optional
            Opaque result ID used for checking for request completion through one or more subsequent completion check operations.
        """

        self.code = code
        self.message = message
        self.result_handler = result_handler

    __properties = ["code", "message", "resultHandler"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return SuccessAcceptedResponse(
            code=self.code,
            message=self.message,
            result_handler=self.result_handler,
        )

    @classmethod
    def _from_model(cls, model) -> SuccessAcceptedResponseModel:
        return SuccessAcceptedResponseModel(
            code=model.code,
            message=model.message,
            result_handler=model.result_handler,
        )

    def to_dict(self):
        """Creates a dictionary of the properties from a SuccessAcceptedResponse.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the SuccessAcceptedResponse object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> SuccessAcceptedResponseModel:
        """Creates an instance of SuccessAcceptedResponse from a dict.

        This method constructs a SuccessAcceptedResponse object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        SuccessAcceptedResponse
            A SuccessAcceptedResponse object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(SuccessAcceptedResponse.from_dict(obj))


SuccessAcceptedResponse._model_class = SuccessAcceptedResponseModel
