# coding: utf-8
"""
    Snowflake View API.

    The Snowflake View API is a REST API that you can use to access, update, and perform certain actions on View resource in a Snowflake database.  # noqa: E501

    The version of the OpenAPI document: 0.0.1
    Contact: support@snowflake.com
    Generated by: https://openapi-generator.tech

    Do not edit this file manually.
"""

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from typing import Union

from pydantic import BaseModel, ConfigDict, StrictStr

from typing import Any, ClassVar, Dict, List, Optional


class ViewColumn(BaseModel):
    """A model object representing the ViewColumn resource.

    Constructs an object of type ViewColumn with the provided properties.

    Parameters
    __________
    name : str
        Column name
    comment : str, optional
        Specifies a comment for the column
    datatype : str, optional
        The data type for the column
    """

    name: StrictStr

    comment: Optional[StrictStr] = None

    datatype: Optional[StrictStr] = None

    __properties = ["name", "comment", "datatype"]

    class Config:
        populate_by_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ViewColumn:
        """Create an instance of ViewColumn from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""

        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({
                "datatype",
            })

        _dict = dict(
            self._iter(to_dict=True,
                       by_alias=True,
                       exclude=exclude_properties,
                       exclude_none=True))

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> ViewColumn:
        """Create an instance of ViewColumn from a dict."""

        if obj is None:
            return None

        if type(obj) is not dict:
            return ViewColumn.parse_obj(obj)

        _obj = ViewColumn.parse_obj({
            "name": obj.get("name"),
            "comment": obj.get("comment"),
            "datatype": obj.get("datatype"),
        })

        return _obj


from typing import Optional, List, Dict


class ViewColumnModel():

    def __init__(
        self,
        name: str,
        # optional properties
        comment: Optional[str] = None,
        datatype: Optional[str] = None,
    ):
        """A model object representing the ViewColumn resource.

        Constructs an object of type ViewColumn with the provided properties.

        Parameters
        __________
        name : str
            Column name
        comment : str, optional
            Specifies a comment for the column
        datatype : str, optional
            The data type for the column
        """

        self.name = name
        self.comment = comment
        self.datatype = datatype

    __properties = ["name", "comment", "datatype"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return ViewColumn(
            name=self.name,
            comment=self.comment,
            datatype=self.datatype,
        )

    @classmethod
    def _from_model(cls, model) -> ViewColumnModel:
        return ViewColumnModel(
            name=model.name,
            comment=model.comment,
            datatype=model.datatype,
        )

    def to_dict(self):
        """Creates a dictionary of the properties from a ViewColumn.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the ViewColumn object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> ViewColumnModel:
        """Creates an instance of ViewColumn from a dict.

        This method constructs a ViewColumn object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        ViewColumn
            A ViewColumn object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(ViewColumn.from_dict(obj))


ViewColumn._model_class = ViewColumnModel
