"use strict";
(self["webpackChunk_anaconda_core"] = self["webpackChunk_anaconda_core"] || []).push([["lib_core_lib_index_js-_68b20"],{

/***/ "../../lib/core/lib/feature_flag.js":
/*!******************************************!*\
  !*** ../../lib/core/lib/feature_flag.js ***!
  \******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createFeatureFlag: () => (/* binding */ createFeatureFlag)
/* harmony export */ });
function createFeatureFlag(client, overrides) {
    return {
        getBool(name, fallback) {
            const override = overrides[name];
            return typeof override === "boolean"
                ? override
                : client.variation(name, fallback);
        },
        getString(name, fallback) {
            const override = overrides[name];
            return typeof override === "string"
                ? override
                : client.variation(name, fallback);
        },
        getObject(name, fallback) {
            const override = overrides[name];
            return typeof override === "object"
                ? override
                : client.variation(name, fallback);
        },
    };
}


/***/ }),

/***/ "../../lib/core/lib/heap.js":
/*!**********************************!*\
  !*** ../../lib/core/lib/heap.js ***!
  \**********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   addEventPropertiesToHeap: () => (/* binding */ addEventPropertiesToHeap),
/* harmony export */   initializeHeap: () => (/* binding */ initializeHeap)
/* harmony export */ });
/* harmony import */ var reactjs_heap__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! reactjs-heap */ "../../node_modules/reactjs-heap/dist/index.es.js");
/* harmony import */ var _launch_darkly__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./launch_darkly */ "../../lib/core/lib/launch_darkly.js");


async function initializeHeap(config, accountDetails) {
    try {
        console.log("initializing heap");
        reactjs_heap__WEBPACK_IMPORTED_MODULE_0__["default"].initialize(config.heap.client_id);
        const ldClient = await (0,_launch_darkly__WEBPACK_IMPORTED_MODULE_1__.getLaunchDarklyClient)(config);
        addEventPropertiesToHeap(ldClient, config.environment);
        const subscriptions = accountDetails.subscriptions
            ?.map((subscription) => subscription.product_code)
            .join(", ") || "free_tier";
        window.heap?.addUserProperties({
            email: accountDetails.user.email,
            subscription: subscriptions,
        });
        return true;
    }
    catch (e) {
        console.log(`failed to initialize heap: ${e}`);
    }
    return false;
}
function addEventPropertiesToHeap(client, environment) {
    // There's no @types for heap's window object unfortunately
    // Also unfortunately, ReactHeap doesn't return the variable, but instead we have to pull it
    // off window instead
    const heap = window.heap;
    if (!heap)
        return false;
    console.log("initializing heap user and event properties", { environment });
    let ffUserID = client.getContext().key;
    if (ffUserID !== "user:unknown-user-id") {
        heap.identify(ffUserID.replace("user:", ""));
    }
    // prepend ff- to the name of all the feature flags to make it easier to find in heap
    const flags = { "ff-initialized": "true" };
    if (environment === "cloud_production" ||
        environment === "local_production") {
        for (const [key, value] of Object.entries(client.allFlags())) {
            flags[`ff-${key}`] = value;
        }
    }
    heap.addUserProperties({ ffUserID });
    heap.clearEventProperties();
    heap.addEventProperties({ ldInitialized: "true", environment, ...flags });
    return true;
}


/***/ }),

/***/ "../../lib/core/lib/index.js":
/*!***********************************!*\
  !*** ../../lib/core/lib/index.js ***!
  \***********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CorePlugin: () => (/* reexport safe */ _plugin__WEBPACK_IMPORTED_MODULE_0__["default"])
/* harmony export */ });
/* harmony import */ var _plugin__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./plugin */ "../../lib/core/lib/plugin.js");




/***/ }),

/***/ "../../lib/core/lib/launch_darkly.js":
/*!*******************************************!*\
  !*** ../../lib/core/lib/launch_darkly.js ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   getLaunchDarklyClient: () => (/* binding */ getLaunchDarklyClient)
/* harmony export */ });
/* harmony import */ var launchdarkly_js_client_sdk__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! launchdarkly-js-client-sdk */ "../../node_modules/launchdarkly-js-client-sdk/dist/ldclient.es.js");
/* harmony import */ var _anaconda_shared__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @anaconda/shared */ "webpack/sharing/consume/default/@anaconda/shared/@anaconda/shared");
/* harmony import */ var _anaconda_shared__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_anaconda_shared__WEBPACK_IMPORTED_MODULE_1__);


async function getLaunchDarklyClient(config) {
    let context;
    try {
        context = await getCloudContext();
    }
    catch (e) {
        context = {
            kind: "user",
            key: `user:${getUserId()}`,
            platform: config.platform,
            environment: config.environment,
            extension_version: config.extension?.version,
        };
    }
    console.log("initializing launch darkly", context);
    const client = launchdarkly_js_client_sdk__WEBPACK_IMPORTED_MODULE_0__.initialize(config.featureFlag.client_id, context);
    await client.waitUntilReady();
    return client;
}
async function getCloudContext() {
    return await _anaconda_shared__WEBPACK_IMPORTED_MODULE_1__.backend
        .backendFetch("aext_core_server/feature_flag/init", {}, {})
        .then((data) => _anaconda_shared__WEBPACK_IMPORTED_MODULE_1__.backend.handleProxyResponse(data));
}
function getUserId() {
    let userId = "unknown-user-id";
    const urlPathName = window.location.pathname;
    const regExpMatch = urlPathName.match(/\/user\/([^/]*)\//i);
    if (regExpMatch && regExpMatch.length > 0) {
        userId = regExpMatch[1];
    }
    return userId;
}


/***/ }),

/***/ "../../lib/core/lib/plugin.js":
/*!************************************!*\
  !*** ../../lib/core/lib/plugin.js ***!
  \************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Plugin)
/* harmony export */ });
/* harmony import */ var _anaconda_shared__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @anaconda/shared */ "webpack/sharing/consume/default/@anaconda/shared/@anaconda/shared");
/* harmony import */ var _anaconda_shared__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_anaconda_shared__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _launch_darkly__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./launch_darkly */ "../../lib/core/lib/launch_darkly.js");
/* harmony import */ var _feature_flag__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./feature_flag */ "../../lib/core/lib/feature_flag.js");
/* harmony import */ var _heap__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./heap */ "../../lib/core/lib/heap.js");




class Plugin {
    #ready;
    constructor() {
        this.#ready = this._getReady();
    }
    activate(app, opts) { }
    ready() {
        return this.#ready;
    }
    async getConfig() {
        return await _anaconda_shared__WEBPACK_IMPORTED_MODULE_0__.backend.backendFetch("aext_core_server/config");
    }
    async getAccountDetails() {
        try {
            return await _anaconda_shared__WEBPACK_IMPORTED_MODULE_0__.backend
                .backendFetch("aext_core_server/account_details", {}, {})
                .then((data) => _anaconda_shared__WEBPACK_IMPORTED_MODULE_0__.backend.handleProxyResponse(data));
        }
        catch (error) {
            return {
                user: null,
                profile: null,
                subscriptions: [],
            };
        }
    }
    async getUserFeatures() {
        try {
            return await _anaconda_shared__WEBPACK_IMPORTED_MODULE_0__.backend
                .backendFetch(`aext_core_server/user/features`, {}, { method: "GET" })
                .then((data) => {
                return data.features_config;
            });
        }
        catch (error) {
            return {
                cloud_notebooks: true,
                ai_navigator: true,
                anaconda_assistant: true,
            };
        }
    }
    async getExtensionVersion() {
        try {
            return await _anaconda_shared__WEBPACK_IMPORTED_MODULE_0__.backend
                .backendFetch(`aext_core_server/extension/version`, {}, { method: "GET" })
                .then((data) => {
                return data["anaconda-toolbox"];
            });
        }
        catch (error) {
            return {
                latest_published_version: null,
                installed_version: null,
            };
        }
    }
    async getHardwareSpecs() {
        try {
            return await _anaconda_shared__WEBPACK_IMPORTED_MODULE_0__.backend
                .backendFetch(`aext_core_server/hardware/specs`, {}, { method: "GET" })
                .then((data) => {
                return data.hardware_specs;
            });
        }
        catch (error) {
            return {
                cpu: {},
                gpu: {
                    is_nvidia: false,
                },
            };
        }
    }
    async ensureAnacondaKeyringIsPopulated() {
        try {
            return await _anaconda_shared__WEBPACK_IMPORTED_MODULE_0__.backend.backendFetch("aext_core_server/api_key", {}, { method: "PUT" });
        }
        catch (error) {
            console.error(`Unable to populate keyring file: ${error}`);
        }
    }
    async _getReady() {
        const config = await this.getConfig();
        const accountDetails = await this.getAccountDetails();
        await this.ensureAnacondaKeyringIsPopulated();
        const userFeatures = await this.getUserFeatures();
        const extensionVersion = await this.getExtensionVersion();
        const hardwareSpecs = await this.getHardwareSpecs();
        const launchDarklyClient = await (0,_launch_darkly__WEBPACK_IMPORTED_MODULE_1__.getLaunchDarklyClient)(config);
        const featureFlag = (0,_feature_flag__WEBPACK_IMPORTED_MODULE_2__.createFeatureFlag)(launchDarklyClient, config.featureFlag.overrides);
        try {
            const analytics = {
                heap: config.environment !== _anaconda_shared__WEBPACK_IMPORTED_MODULE_0__.Environment.local_development
                    ? await (0,_heap__WEBPACK_IMPORTED_MODULE_3__.initializeHeap)(config, accountDetails)
                    : false,
            };
            return {
                featureFlag,
                analytics,
                config,
                accountDetails,
                userFeatures,
                extensionVersion,
                hardwareSpecs,
            };
        }
        catch (err) {
            return {
                featureFlag,
                analytics: {
                    heap: false,
                },
                config,
                accountDetails,
                userFeatures,
                extensionVersion,
                hardwareSpecs,
            };
        }
    }
}


/***/ })

}]);
//# sourceMappingURL=lib_core_lib_index_js-_68b20.718a0764057650505c58.js.map