from typing import Dict, Type
from urllib.parse import urlparse

import tornado
from tornado.routing import _RuleList

from aext_shared.backend_proxy import backend_proxy
from aext_shared.config import SHARED_CONFIG
from aext_shared.handler import BackendHandler, create_rules

config = SHARED_CONFIG


class FetchNotebook(BackendHandler):
    @tornado.web.authenticated
    async def get(self):
        nb_url = self.get_argument("nb_url")

        parsed_nb_url = urlparse(nb_url)
        parsed_cloud_url = urlparse(config["api"]["url"])

        # internal notebooks
        if parsed_nb_url.hostname == parsed_cloud_url.hostname:
            nb_url = parsed_nb_url.path.replace("/api/", "", 1)
            response = await self.anaconda_proxy(nb_url)
        # external notebooks
        else:
            response = await backend_proxy(self.request, nb_url)

        response["remote_data"] = {
            "content": response["remote_data"],
        }
        self.finish(response)


def get_routes(base_url: str) -> _RuleList:
    handlers: Dict[str, Type[BackendHandler]] = {
        "fetch_notebook": FetchNotebook,
    }
    return create_rules(base_url, "aext_notebook_load_server", handlers)
